/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLOrgTreeUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeModel;

public class CSLOrgTreeUI
extends AbstractCSLOrgTreeUI
implements ICSLContextUI {
    ICSLContext ctx = CSLContextHelper.getCSLContext();

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.btnRefresh.setText("");
        this.txtOrgTree.setEditable(false);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.kDScrollPane1.setBorder(LineBorder.createGrayLineBorder());
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            CSLContextHelper.registUIObject(this);
            this.loadFields();
        } else {
            SysUtil.abort();
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    public boolean destroyWindow() {
        CSLContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    private void refresh() throws BOSException {
        this.txtOrgTree.setText(this.ctx.getCurOrgBound().getName());
        try {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setMultiSelect(false);
            TreeModel model = f7.buildTreeModel(OrgViewType.UNIONDEBT, this.ctx.getCurOrgBound(), null);
            this.tree.setModel(model);
            UnionF7Helper.addTreeWillExpandListener((KDTree)this.tree, (OrgTreeInfo)this.ctx.getCurOrgBound(), (UnionF7Helper.UnionF7)f7);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }
}

