/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnalysisFilterParam;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisObjectFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportAnlysisObject;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportAnalysisMainUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AnlysisClientHelper;
import com.kingdee.eas.fi.newrpt.client.designer.io.ExportAction;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSLReportAnalysisMainUI
extends AbstractCSLReportAnalysisMainUI {
    private static final long serialVersionUID = 6134533551764831702L;
    private static final Logger logger = CoreUIObject.getLogger(CSLReportAnalysisMainUI.class);
    public static final String Direct_Filter_Param = "DirectFilterParam";
    private CSLReportAnalysisFilterParam directFilterParam;
    private BOSUuid solutionId = null;
    protected SpreadContext sc;
    private Book book;
    private ICSLReportAnlysisObject iAnlysis;
    protected String reportId;
    private IReport iReport;
    public String RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.initDirectFilterParam();
        this.reportId = this.directFilterParam.getReportId();
        super.onLoad();
        this.setBtnIcon();
        this.executeQuery();
    }

    protected KDTabbedPane getMainTabPane() {
        return this.TabPaneMain;
    }

    protected SpreadContext getSpreadContext() {
        return this.sc;
    }

    protected boolean hasSpreadContext() {
        return this.sc != null;
    }

    protected BOSUuid getSolutionId() {
        return this.solutionId;
    }

    protected void setSolutionId(BOSUuid solutionId) {
        this.solutionId = solutionId;
    }

    private void initDirectFilterParam() {
        if (this.directFilterParam == null) {
            Object filterParam = this.getUIContext().get(Direct_Filter_Param);
            if (filterParam == null) {
                return;
            }
            this.directFilterParam = (CSLReportAnalysisFilterParam)filterParam;
        }
    }

    protected CSLReportAnalysisFilterParam getDirectFilterParam() {
        return this.directFilterParam;
    }

    protected CSLReportAnalysisFilterParam getFilterUIParams() {
        if (this.getDirectFilterParam() != null) {
            return this.getDirectFilterParam();
        }
        return null;
    }

    private Book addAndInitTable(byte[] data) throws EASBizException, BOSException {
        if (this.sc != null) {
            this.TabPaneMain.remove((Component)this.sc);
        }
        Book book = null;
        try {
            book = IOHelper.unpackBook((byte[])data);
            if (book != null) {
                book.setCalculate(false);
            }
        }
        catch (Exception ex) {
            if (book != null) {
                book = null;
            }
            SysUtil.abort();
        }
        if (book != null && book.getSheet(0) != null) {
            this.sc = new SpreadContext();
            this.sc.setBook(book);
            AnlysisClientHelper.setPopMenuVisible(this.sc);
            this.TabPaneMain.add((Component)this.sc, (Object)"Center");
            this.setTablePaneTitle();
        }
        return book;
    }

    protected void setTablePaneTitle() {
    }

    protected int getSheetSize() {
        int sheetSize = 0;
        Component obj = null;
        int in = this.getMainTabPane().getTabCount();
        for (int i = 0; i < in; ++i) {
            obj = this.getMainTabPane().getComponentAt(i);
            if (obj instanceof KDTable) {
                sheetSize = 1;
                continue;
            }
            if (!(obj instanceof KDPanel)) continue;
            KDPanel panel = (KDPanel)obj;
            int jn = panel.getComponentCount();
            for (int j = 0; j < jn; ++j) {
                obj = panel.getComponent(j);
                if (!(obj instanceof KDTable)) continue;
                ++sheetSize;
            }
        }
        return sheetSize;
    }

    protected Object getSheet(int index) {
        Component obj = null;
        KDTable sheet = null;
        obj = this.getMainTabPane().getComponentAt(index);
        if (obj instanceof KDTable) {
            return (KDTable)obj;
        }
        if (obj instanceof KDPanel) {
            KDPanel panel = (KDPanel)obj;
            int n = panel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                obj = panel.getComponent(i);
                if (!(obj instanceof KDTable)) continue;
                sheet = (KDTable)obj;
            }
        }
        return sheet;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        Book book = this.sc.getBook();
        ArrayList<String> formulaList = new ArrayList<String>();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            int colCount = sheet.getMaxColIndex() + 1;
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null || cell.getUserObjectValue("formula") == null) continue;
                    formulaList.add(cell.getUserObjectValue("formula").toString());
                }
            }
        }
        Variant[] variants = this.getReportInterface().calcFormulas(formulaList);
        int index = 0;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            int colCount = sheet.getMaxColIndex() + 1;
            int rowCount = sheet.getMaxRowIndex() + 1;
            sheet.getSheetOption().setCellDisplayMode(0);
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null || cell.getUserObjectValue("formula") == null) continue;
                    cell.setValue(variants[index++]);
                }
            }
        }
        this.setAllYearBudgetPerformPercent(book);
        this.sc.setBook(book);
        this.sc.repaint();
    }

    protected void executeQuery() throws EASBizException, BOSException {
        CSLReportAnalysisFilterParam param = this.getFilterUIParams();
        String reportId = param.getReportId();
        boolean isGetReportData = false;
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            isGetReportData = true;
        }
        byte[] data = this.getAnlysisInterface().getAnlysisBookData(reportId, param, isGetReportData);
        this.book = this.addAndInitTable(data);
        for (int i = this.sc.getBook().getSheetCount() - 1; i >= 0; --i) {
            Range range = this.sc.getBook().getSheet(i).getRange(0, 0);
            if (range == null) continue;
            range.select();
        }
        this.sc.getBook().activeSheet(0);
        this.sc.getSpread().scrollCellVisible(0, 0);
        this.addTableListener();
        this.setAllYearBudgetPerformPercent(this.book);
        this.sc.getSpread().repaint();
    }

    private void addTableListener() {
        this.sc.getSpread().setMouseController(3, (IMouseController)new MyTableMouseController(this.sc));
        this.sc.getBook().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                CSLReportAnalysisMainUI.this.sc.getSpread().scrollCellVisible(0, 0);
            }
        });
    }

    public static boolean isNeedToDelOldWin(UIContext uiContext, String uiName) throws UIException {
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        NewWinMainUI mainUI = ((NewMainFrame)frame).getMainUI();
        IUIObject uiObject = mainUI.getUiManager().findUIObject(uiName, (Map)uiContext, null, OprtState.VIEW);
        if (uiObject != null) {
            uiObject.getUIWindow().close();
            return true;
        }
        return false;
    }

    public ICSLReportAnlysisObject getAnlysisInterface() throws BOSException {
        if (this.iAnlysis == null) {
            this.iAnlysis = CSLReportAnlysisObjectFactory.getRemoteInstance();
        }
        return this.iAnlysis;
    }

    public IReport getReportInterface() throws BOSException {
        if (this.iReport == null) {
            this.iReport = ReportFactory.getRemoteInstance();
        }
        return this.iReport;
    }

    protected Object getSelectSheet() {
        Component obj = null;
        KDTable sheet = null;
        obj = this.getMainTabPane().getSelectedComponent();
        if (obj instanceof KDTable) {
            return (KDTable)obj;
        }
        if (obj instanceof KDPanel) {
            KDPanel panel = (KDPanel)obj;
            int n = panel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                obj = panel.getComponent(i);
                if (!(obj instanceof KDTable)) continue;
                sheet = (KDTable)obj;
                break;
            }
        }
        return sheet;
    }

    @Override
    public void actionSaveAnlysisData_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        ExportAction ea = new ExportAction(this.sc);
        ea.actionPerformed(null);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        if (this.hasSpreadContext()) {
            SpreadContext sc = this.getSpreadContext();
            sc.getPrintManager().print();
        } else {
            Object _obj = this.getSelectSheet();
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = (KDTable)_obj;
            this.preparePrintPage(_table);
            _table.getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        if (this.hasSpreadContext()) {
            SpreadContext sc = this.getSpreadContext();
            sc.getPrintManager().printPreview();
        } else {
            Object _obj = this.getSelectSheet();
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = (KDTable)_obj;
            _table.getDataRequestManager().setDataRequestMode(0);
            this.preparePrintPage(_table);
            _table.getPrintManager().printPreview();
        }
        this.setPrintConfigInfo();
    }

    protected void setPrintConfigInfo() throws Exception {
        if (this.solutionId == null) {
            return;
        }
    }

    protected void loadPrintConfigInfo() throws Exception {
    }

    private void setBtnIcon() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnSaveAnlysisData.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemSaveAnlysisData.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void setAllYearBudgetPerformPercent(Book book) {
        String currencyID = this.directFilterParam.getConvertCurrencyId();
        int precision = this.getPrecOfCurrency(currencyID);
        String RESORCE_LOCATION = "com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource";
        Locale loc = this.getSysLocale();
        String actual = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"Actual", (Locale)loc);
        String allYearBudget = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"AllYearBudget", (Locale)loc);
        String allYearBudgetPerformPercent = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource", (String)"AllYearBudgetPerformPercent", (Locale)loc);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            int colCount = sheet.getMaxColIndex() + 1;
            int rowCount = sheet.getMaxRowIndex() + 1;
            HashMap<String, BigDecimal> valueMapAct = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> valueMapAll = new HashMap<String, BigDecimal>();
            boolean isAct = false;
            boolean isAllYearBudget = false;
            boolean isAllYearBudgetPerformPercent = false;
            sheet.getSheetOption().setCellDisplayMode(0);
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                isAct = false;
                isAllYearBudget = false;
                isAllYearBudgetPerformPercent = false;
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null) continue;
                    if (cell.getValue().toString().equals(actual)) {
                        valueMapAct.clear();
                        isAct = true;
                        continue;
                    }
                    if (isAct) {
                        if (cell.getUserObjectValue("formula") == null) continue;
                        try {
                            valueMapAct.put(rowIndex + "", cell.getValue().toBigDecimal());
                        }
                        catch (SyntaxErrorException e) {
                            logger.error((Object)"cell.getValue().toBigDecimal()_SyntaxErrorException", (Throwable)e);
                        }
                        continue;
                    }
                    if (cell.getValue().toString().equals(allYearBudget)) {
                        valueMapAll.clear();
                        isAllYearBudget = true;
                        continue;
                    }
                    if (isAllYearBudget) {
                        if (cell.getUserObjectValue("formula") == null) continue;
                        try {
                            valueMapAll.put(rowIndex + "", cell.getValue().toBigDecimal());
                        }
                        catch (SyntaxErrorException e) {
                            logger.error((Object)"cell.getValue().toBigDecimal()_SyntaxErrorException", (Throwable)e);
                        }
                        continue;
                    }
                    if (cell.getValue().toString().equals(allYearBudgetPerformPercent)) {
                        isAllYearBudgetPerformPercent = true;
                        continue;
                    }
                    if (!isAllYearBudgetPerformPercent || cell.getUserObjectValue("formula") == null) continue;
                    BigDecimal valueAct = (BigDecimal)valueMapAct.get(rowIndex + "");
                    BigDecimal valueAll = (BigDecimal)valueMapAll.get(rowIndex + "");
                    if (valueAct == null || valueAll == null) continue;
                    if (valueAll.compareTo(new BigDecimal(0)) > 0) {
                        cell.setValue(new Variant((Object)valueAct.divide(valueAll, precision + 2, 4)));
                        continue;
                    }
                    cell.setValue(new Variant((Object)new BigDecimal(0).setScale(precision)));
                }
            }
        }
    }

    private Locale getSysLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return new Locale("L2");
        }
    }

    private int getPrecOfCurrency(String currencyId) {
        ObjectUuidPK pk = new ObjectUuidPK(currencyId);
        CurrencyInfo info = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        }
        catch (BOSException e) {
            logger.error((Object)"getCurrencyInfo_BOSException", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"getCurrencyInfo_EASBizException", (Throwable)e);
        }
        if (info != null) {
            return info.getPrecision();
        }
        return 10;
    }

    protected class PrintConfigInfo
    implements Serializable {
        private static final long serialVersionUID = -3972882578783456011L;
        private byte[] data = null;

        protected PrintConfigInfo() {
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    private class MyTableMouseController
    extends TableMouseController {
        public MyTableMouseController(SpreadContext context) {
            super(context);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            CSLReportAnalysisMainUI.this.sc.getSpread().repaint();
        }
    }
}

