/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.MAGroupEntryCollection;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupOrgFacadeFactory;
import com.kingdee.eas.base.message.client.MAGroupReF7;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLSchemeTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslCltIntoCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslCltIntoFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslCltIntoInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslCltInto;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.SchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SchemeEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLIOUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.DNFFile;
import com.kingdee.eas.fi.gr.cslrpt.util.ExtensionFileFilter;
import com.kingdee.eas.fi.gr.cslrpt.util.FTPUpDown;
import com.kingdee.eas.fi.gr.cslrpt.util.ReceiveFilterCondition;
import com.kingdee.eas.fi.gr.cslrpt.util.UPFFile;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class CSLReportImportUI
extends AbstractCSLReportImportUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLReportImportUI.class);
    private static final String MAPITEM_UPFFILE = "MAPITEM_UPFFILE";
    private static final String MAPITEM_RESULT = "MAPITEM_RESULT";
    private static final String MAPITEM_REPORTLIST = "MAPITEM_REPORTLIST";
    private static final String MAPITEM_RECEIVERLIST = "MAPITEM_RECEIVERLIST";
    public static final String DefaultDirectory = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "gamania";
    private boolean isRefresh = false;
    private String CompanySelectSchemeID = "";
    private String ServerSelectSchemeID = "";
    private ReceiveFilterCondition filterInfo = null;
    private SchemeInfo filePathScheme = null;
    private HashMap filePathAdapterObject = null;
    private ArrayList Model_Companys = new ArrayList();
    private CslCltIntoCollection updateIntoColl = new CslCltIntoCollection();

    public void onLoad() throws Exception {
        super.onLoad();
        this.filterInfo = (ReceiveFilterCondition)this.getUIContext().get("ReceiveFilterCondition");
        this.initialControl();
    }

    @Override
    protected void btnTest_actionPerformed(ActionEvent e) throws Exception {
        super.btnTest_actionPerformed(e);
        HashMap config = this.getServerConfig();
        try {
            new FTPUpDown(config.get("serverAddress").toString(), "", config.get("serverLoginName").toString(), config.get("serverLoginPassword").toString());
            config.clear();
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"342_CSLReportImportUI"));
            SysUtil.abort();
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"343_CSLReportImportUI"));
    }

    @Override
    protected void comboCompanySet_actionPerformed(ActionEvent e) throws Exception {
        super.comboCompanySet_actionPerformed(e);
        this.tblCompany.removeRows();
        this.Model_Companys.clear();
        SchemeInfo scheme = (SchemeInfo)((KDComboBox)e.getSource()).getModel().getSelectedItem();
        if (scheme != null) {
            this.importScheme(this.tblCompany, scheme);
        }
    }

    private void importScheme(KDTable table, SchemeInfo scheme) throws DocumentException, IOException, BOSException, EASBizException {
        Object obj = scheme.getAdapterObject(CSLSchemeTypeEnum.EXPORTCOMPANY);
        if (!(obj instanceof Object[])) {
            SysUtil.abort();
        }
        String str = StringUtils.arrayToString((Object[])((Object[])obj), (String)",");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)str, CompareType.INCLUDE));
        EntityViewInfo entityInfo = new EntityViewInfo();
        entityInfo.setFilter(filter);
        FullOrgUnitCollection companys = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(entityInfo);
        this.bandingOrgUnitToTable(table, companys.toArray());
    }

    @Override
    protected void btnCompanySetSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySetSave_actionPerformed(e);
        String[] ids = this.getSelectCompanyIDList(this.tblCompany);
        if (this.openSchemeEditUI(CSLSchemeTypeEnum.EXPORTCOMPANY, ids, this.CompanySelectSchemeID)) {
            this.refreshCompanyScheme();
        }
    }

    private boolean openSchemeEditUI(CSLSchemeTypeEnum adapterType, Object adapterObject, String selectSchemeID) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Scheme_AdapterType", (Object)adapterType);
        uiContext.put((Object)"Scheme_AdapterObject", adapterObject);
        uiContext.put((Object)"Scheme_SelectSchemeID", (Object)selectSchemeID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SchemeEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        return ((SchemeEditUI)uiWindow.getUIObject()).isSuccess();
    }

    private String[] getSelectCompanyIDList(KDTable table) {
        int tableCount = table.getRowCount();
        if (tableCount < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"344_CSLReportImportUI"));
            SysUtil.abort();
        }
        String[] ids = new String[tableCount];
        IRow iRow = null;
        OrgUnitInfo info = null;
        for (int i = 0; i < tableCount; ++i) {
            iRow = table.getRow(i);
            info = (OrgUnitInfo)iRow.getUserObject();
            ids[i] = info.getId().toString();
        }
        return ids;
    }

    @Override
    protected void btnCompanySetDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySetDelete_actionPerformed(e);
        this.checkSchemeSelect(this.combCompanyScheme);
        this.tblCompany.removeRows();
        this.Model_Companys.clear();
        SchemeInfo selectInfo = (SchemeInfo)this.combCompanyScheme.getSelectedItem();
        SchemeFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(selectInfo.getId()));
        this.combCompanyScheme.removeItem((Object)selectInfo);
    }

    private void checkSchemeSelect(KDComboBox comb) {
        if (comb.getSelectedItem() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"345_CSLReportImportUI"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnCompanyImport_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanyImport_actionPerformed(e);
        Object obj = null;
        obj = this.openCompanyF7();
        if (obj != null && obj instanceof Object[]) {
            this.bandingOrgUnitToTable(this.tblCompany, (OrgUnitInfo[])obj);
        }
    }

    private Object openCompanyF7() {
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setNeedAddOrgRange(false);
        f7.setMultiSelect(true);
        f7.show();
        Object obj = f7.getData();
        if (obj instanceof Object[] && ((Object[])obj).length != 0) {
            return obj;
        }
        return null;
    }

    private void bandingOrgUnitToTable(KDTable table, Object[] obj) throws EASBizException, BOSException {
        table.checkParsed();
        IRow iRow = null;
        for (int i = 0; i < obj.length; ++i) {
            OrgUnitInfo info = (OrgUnitInfo)obj[i];
            iRow = table.addRow();
            iRow.setUserObject((Object)info);
            iRow.getCell("id").setValue((Object)info.getId().toString());
            iRow.getCell("number").setValue((Object)info.getNumber());
            iRow.getCell("name").setValue((Object)info.getName());
            this.Model_Companys.add(info);
        }
    }

    @Override
    protected void btnCompanyDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanyDelete_actionPerformed(e);
        this.deleteSelectRows(this.tblCompany);
    }

    private void deleteSelectRows(KDTable table) {
        this.checkSelected(table);
        ArrayList list = this.getSelectedRows(table);
        Object[] index = list.toArray();
        Arrays.sort(index);
        for (int i = index.length; i > 0; --i) {
            this.deleteCacheModel(table, (Integer)index[i - 1]);
            table.removeRow(((Integer)index[i - 1]).intValue());
        }
    }

    private void deleteCacheModel(KDTable table, int i) {
        if (table == this.tblCompany) {
            this.Model_Companys.remove(table.getRow(i).getUserObject());
        }
    }

    private void checkSelected(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private ArrayList getSelectedRows(KDTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = table.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                Integer tempIndex = new Integer(j);
                if (list.contains(tempIndex)) continue;
                list.add(tempIndex);
            }
        }
        return list;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
        this.updateSchemeInfo();
        SchemeFactory.getRemoteInstance().submit(this.filePathScheme);
        File dir = new File(DefaultDirectory);
        if (dir.exists()) {
            CSLIOUtils.deleteDirectory(dir);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.updateSchemeInfo();
            SchemeFactory.getRemoteInstance().submit(this.filePathScheme);
            File dir = new File(DefaultDirectory);
            if (dir.exists()) {
                CSLIOUtils.deleteDirectory(dir);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return super.checkBeforeWindowClosing();
    }

    private void updateSchemeInfo() throws DocumentException, IOException {
        if (this.filePathAdapterObject == null) {
            this.filePathAdapterObject = new HashMap();
            this.filePathAdapterObject.put("relateUI", this.getMetaDataPK().getFullName());
        }
        this.filePathAdapterObject.put("relatePath", this.txtPath.getText());
        if (this.filePathScheme == null) {
            this.filePathScheme = new SchemeInfo();
            this.filePathScheme.setNumber(this.getMetaDataPK().getFullName());
            this.filePathScheme.setName(this.getMetaDataPK().getFullName());
        }
        this.filePathScheme.setAdapterObject(CSLSchemeTypeEnum.SAVEPATH, this.filePathAdapterObject);
    }

    private void initialControl() throws BOSException, DocumentException, IOException {
        this.btnDownload.setIcon(EASResource.getIcon((String)"imgTbtn_downbill"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        MAGroupReF7 mAGroupReF7 = new MAGroupReF7((IUIObject)this);
        this.prmptMailReceiver.setSelector((KDPromptSelector)mAGroupReF7);
        this.tblCompany.getSelectManager().setSelectMode(10);
        this.checkDownloadBefore.setSelected(false);
        this.btnCompanySchemeSave.setText(null);
        this.btnCompanySchemeDelete.setText(null);
        this.btnCompanySchemeSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnCompanySchemeDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnServerSchemeSave.setText(null);
        this.btnServerSchemeDelete.setText(null);
        this.btnServerSchemeSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnServerSchemeDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.refreshCompanyScheme();
        this.refreshServerScheme();
        this.refreshFilePathScheme();
    }

    private void refreshFilePathScheme() throws BOSException, DocumentException, IOException {
        SchemeCollection filePathSchemes = SchemeFactory.getRemoteInstance().getSchemeCollection("where type = 2 and number = '" + this.getMetaDataPK().getFullName() + "' ");
        Iterator iter = filePathSchemes.iterator();
        while (iter.hasNext()) {
            SchemeInfo element = (SchemeInfo)iter.next();
            HashMap pathMap = (HashMap)element.getAdapterObject(CSLSchemeTypeEnum.SAVEPATH);
            if (pathMap == null || !this.getMetaDataPK().getFullName().equalsIgnoreCase((String)pathMap.get("relateUI"))) continue;
            this.txtPath.setText((String)pathMap.get("relatePath"));
            this.filePathScheme = element;
            this.filePathAdapterObject = pathMap;
            return;
        }
    }

    private void refreshServerScheme() throws BOSException {
        SchemeCollection serverSchemes = SchemeFactory.getRemoteInstance().getSchemeCollection("where type = 3");
        this.combServerScheme.removeAllItems();
        this.combServerScheme.addItems(serverSchemes.toArray());
        this.combServerScheme.addItem(null);
        if (!StringUtils.isEmpty((String)this.ServerSelectSchemeID)) {
            Iterator iter = serverSchemes.iterator();
            while (iter.hasNext()) {
                SchemeInfo element = (SchemeInfo)iter.next();
                if (!this.ServerSelectSchemeID.equals(element.getNumber())) continue;
                this.combServerScheme.getModel().setSelectedItem(element);
                break;
            }
        }
    }

    private void refreshCompanyScheme() throws BOSException {
        SchemeCollection companySchemes = SchemeFactory.getRemoteInstance().getSchemeCollection("where type = 1");
        this.combCompanyScheme.removeAllItems();
        this.combCompanyScheme.addItems(companySchemes.toArray());
        this.combCompanyScheme.addItem(null);
        if (!StringUtils.isEmpty((String)this.CompanySelectSchemeID)) {
            Iterator iter = companySchemes.iterator();
            while (iter.hasNext()) {
                SchemeInfo element = (SchemeInfo)iter.next();
                if (!this.CompanySelectSchemeID.equals(element.getNumber())) continue;
                this.combCompanyScheme.getModel().setSelectedItem(element);
                break;
            }
        }
    }

    @Override
    public void actionDownload_actionPerformed(ActionEvent e) throws Exception {
        super.actionDownload_actionPerformed(e);
        StringBuffer result = this.doDownload(true);
        UIContext utx = new UIContext((Object)this);
        utx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"346_CSLReportImportUI"));
        SimpleNotePad.showMessageByModel(utx, result.toString());
    }

    private StringBuffer doDownload(boolean onlyDownload) throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"347_CSLReportImportUI"));
        HashMap config = this.getServerConfig();
        FTPUpDown ftp = null;
        try {
            ftp = new FTPUpDown(config.get("serverAddress").toString(), "21", config.get("serverLoginName").toString(), config.get("serverLoginPassword").toString());
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"342_CSLReportImportUI"));
            SysUtil.abort();
        }
        File dir = this.getDownloadDir(onlyDownload);
        int i = this.Model_Companys.size();
        String dataCollectNumber = this.filterInfo.getDataCollectType();
        int count = 0;
        int j = 1;
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"25_CSLReportImportUI");
        result.append(MessageFormat.format(msg, i) + "\n\r\n\r");
        for (OrgUnitInfo element : this.Model_Companys) {
            if (!dataCollectNumber.equals("ACTUALDATA")) continue;
            try {
                ftp.downFile(config.get("serverDirectory").toString(), this.getFileNameAu(element.getNumber()), dir.getAbsolutePath());
                result.append(j++ + ": " + element.getName() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"350_CSLReportImportUI") + this.getFileNameAu(element.getNumber()) + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"351_CSLReportImportUI") + "\n\r");
                ++count;
            }
            catch (Exception exc) {
                try {
                    ftp.downFile(config.get("serverDirectory").toString(), this.getFileName(element.getNumber()), dir.getAbsolutePath());
                    result.append(j++ + ": " + element.getName() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"350_CSLReportImportUI") + this.getFileName(element.getNumber()) + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"351_CSLReportImportUI") + "\n\r");
                    ++count;
                }
                catch (Exception ex) {
                    result.append(j++ + ": " + element.getName() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"352_CSLReportImportUI") + this.getFileNameAu(element.getNumber()) + "\n\r");
                }
            }
        }
        String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"26_CSLReportImportUI");
        result.append("\n\r" + MessageFormat.format(strMsg, count) + "\n\r\n\r");
        config.clear();
        return result;
    }

    private String getFileName(String companyNumber) {
        Date rptDate = RPTDate13Util.getPeriodLastDate(this.filterInfo.getYear(), this.filterInfo.getPeriod(), this.filterInfo.getPeriodType());
        return companyNumber + "_" + DateFormat.getDateInstance(2, Locale.CHINA).format(rptDate) + "_" + this.filterInfo.getPeriodType().getName() + "." + "UPF";
    }

    private String getFileNameBg(String companyNumber) {
        Date rptDate = RPTDate13Util.getPeriodLastDate(this.filterInfo.getYear(), this.filterInfo.getPeriod(), this.filterInfo.getPeriodType());
        return companyNumber + "_" + DateFormat.getDateInstance(2, Locale.CHINA).format(rptDate) + "_" + this.filterInfo.getPeriodType().getName() + "_" + "BUDGETDATA." + "UPF";
    }

    private String getFileNameAu(String companyNumber) {
        Date rptDate = RPTDate13Util.getPeriodLastDate(this.filterInfo.getYear(), this.filterInfo.getPeriod(), this.filterInfo.getPeriodType());
        return companyNumber + "_" + DateFormat.getDateInstance(2, Locale.CHINA).format(rptDate) + "_" + this.filterInfo.getPeriodType().getName() + "_" + "ACTUALDATA." + "UPF";
    }

    private File getDownloadDir(boolean onlyDownload) {
        File dir;
        String downoadDir = DefaultDirectory;
        if (onlyDownload) {
            downoadDir = this.txtPath.getText();
        }
        if (!(dir = new File(downoadDir)).exists()) {
            dir.mkdir();
        }
        if (!dir.isDirectory()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"354_CSLReportImportUI"));
            SysUtil.abort();
        }
        return dir;
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        super.actionImport_actionPerformed(e);
        boolean onlyDownload = this.checkDownloadBefore.isSelected();
        StringBuffer result = new StringBuffer();
        if (!onlyDownload) {
            File defaultDir = new File(DefaultDirectory);
            if (defaultDir.exists()) {
                try {
                    CSLIOUtils.deleteDirectory(defaultDir);
                }
                catch (IOException ioe) {
                    logger.debug((Object)(defaultDir + " Can not be Delete"), (Throwable)ioe);
                }
            }
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"797_CSLReportImportUI"));
            long time = System.currentTimeMillis();
            result.append(this.doDownload(onlyDownload));
            logger.info((Object)this.getFormatTime(System.currentTimeMillis() - time));
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"798_CSLReportImportUI"));
        }
        result.append(this.doImport(onlyDownload));
        UIContext utx = new UIContext((Object)this);
        utx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"355_CSLReportImportUI"));
        SimpleNotePad.showMessageByModel(utx, result.toString());
        this.isRefresh = true;
    }

    private StringBuffer doImport(boolean onlyDownload) throws Exception {
        long time = 0L;
        boolean isMail = false;
        HashMap receiver = null;
        int count = 0;
        Object obj = this.prmptMailReceiver.getValue();
        if (obj != null && obj instanceof ArrayList && ((ArrayList)obj).size() != 0) {
            isMail = true;
            receiver = this.getCompanyReceiversMap((ArrayList)obj);
        }
        HashMap map = this.getCompanyUPFMap(onlyDownload);
        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"799_CSLReportImportUI"));
        time = System.currentTimeMillis();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            boolean flag = false;
            for (OrgUnitInfo orgUnit : this.Model_Companys) {
                if (!element.equalsIgnoreCase(orgUnit.getNumber())) continue;
                flag = true;
                break;
            }
            if (!flag) {
                iter.remove();
                continue;
            }
            List elementList = (List)map.get(element);
            count += elementList.size();
            for (int i = 0; i < elementList.size(); ++i) {
                int rs;
                UPFFile upf;
                Map upfMap = (Map)elementList.get(i);
                if (isMail && receiver != null && receiver.containsKey(element)) {
                    upfMap.put(MAPITEM_RECEIVERLIST, receiver.get(element));
                }
                if ((upf = (UPFFile)upfMap.get(MAPITEM_UPFFILE)) == null) continue;
                CslReportCollection reports = upf.getCslReportCollection();
                if (reports == null) {
                    ((StringBuffer)upfMap.get(MAPITEM_RESULT)).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"356_CSLReportImportUI"));
                    upfMap.remove(MAPITEM_UPFFILE);
                    continue;
                }
                ITemplate itemp = TemplateFactory.getRemoteInstance();
                ArrayList<CslReportInfo> list = CollectionUtils.select(Arrays.asList(reports.toArray()), (Predicate)new ReportFilterPredicate(this.filterInfo));
                ArrayList<String> noLastestVersion = new ArrayList<String>();
                ArrayList<CslReportInfo> excludeNoLastVersion = new ArrayList<CslReportInfo>();
                for (CslReportInfo info : list) {
                    BOSUuid id = info.getTemplate().getId();
                    if (id == null) continue;
                    boolean isLastestVersion = true;
                    try {
                        String string = id.toString();
                        isLastestVersion = itemp.isLastestVersion(string, true, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!isLastestVersion) {
                        noLastestVersion.add(info.getName() + "  [" + info.getNumber() + "]");
                        continue;
                    }
                    excludeNoLastVersion.add(info);
                }
                if (noLastestVersion.size() > 0 && (rs = MsgBox.showConfirm3a((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"357_CSLReportImportUI"), (String)CslRptUtil.arrToString(noLastestVersion.toArray(), '\n'))) != 0) {
                    list = excludeNoLastVersion;
                }
                if (list.size() == 0) {
                    ((StringBuffer)upfMap.get(MAPITEM_RESULT)).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"358_CSLReportImportUI"));
                    upfMap.remove(MAPITEM_UPFFILE);
                    continue;
                }
                upfMap.put(MAPITEM_REPORTLIST, list);
                upfMap.remove(MAPITEM_UPFFILE);
            }
        }
        logger.info((Object)this.getFormatTime(System.currentTimeMillis() - time));
        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"800_CSLReportImportUI"));
        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"801_CSLReportImportUI"));
        time = System.currentTimeMillis();
        Map resultMap = CslReportFactory.getRemoteInstance().importCSLReport(map);
        this.updateCslIntoMD5();
        logger.info((Object)this.getFormatTime(System.currentTimeMillis() - time));
        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"802_CSLReportImportUI"));
        StringBuffer resultStr = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"359_CSLReportImportUI"));
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"27_CSLReportImportUI");
        resultStr.append(MessageFormat.format(msg, count) + "\n\r\n\r");
        Collection col = resultMap.values();
        for (StringBuffer element : col) {
            resultStr.append(element);
        }
        return resultStr.append("\n\r");
    }

    private String getDownFilesName(File[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            name.append("'").append(files[i].getName()).append("'").append(",");
        }
        if (name.length() > 1) {
            name.insert(0, "(");
            name.setLength(name.length() - 1);
            name.append(")");
        }
        return name.toString();
    }

    private HashMap getCompanyUPFMap(boolean onlyDownload) throws EASBizException, BOSException {
        HashMap result;
        block8: {
            CslCltIntoCollection cslCltColl;
            RptPeriodTypeEnum periodType;
            int period;
            int year;
            File[] files;
            block7: {
                File dir = this.getDownloadDir(onlyDownload);
                files = dir.listFiles(new ExtensionFileFilter("UPF"));
                if (files == null || files.length == 0) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SELECT_PATH_NOT_DOWNFILE"));
                    SysUtil.abort();
                }
                year = this.filterInfo.getYear();
                period = this.filterInfo.getPeriod();
                periodType = this.filterInfo.getPeriodType();
                String dataCollectNumber = this.filterInfo.getDataCollectType();
                StringBuffer oql = new StringBuffer();
                oql.append(" where year = ").append(year);
                oql.append(" and period = ").append(period);
                oql.append(" and fileName in ").append(this.getDownFilesName(files));
                cslCltColl = CslCltIntoFactory.getRemoteInstance().getCslCltIntoCollection(oql.toString());
                StringBuffer buf = new StringBuffer();
                buf.append("_");
                buf.append(DateFormat.getDateInstance(2, Locale.CHINA).format(RPTDate13Util.getPeriodLastDate(year, period, periodType)));
                buf.append("_");
                buf.append(periodType.getName());
                buf.append("_").append("ACTUALDATA");
                buf.append(".UPF");
                String nameFilter = buf.toString();
                result = new HashMap();
                if (!dataCollectNumber.equals("ACTUALDATA")) break block7;
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"28_CSLReportImportUI");
                for (int i = 0; i < files.length; ++i) {
                    List<HashMap<String, Object>> list;
                    if (!files[i].isFile() || !files[i].getName().endsWith(nameFilter) || !this.isNewUpfFile(files[i], cslCltColl)) continue;
                    int length = files[i].getName().length();
                    String key = UPFFile.getFileNumber(files[i].getName().substring(0, length - 4));
                    HashMap<String, Object> itemMap = new HashMap<String, Object>();
                    itemMap.put(MAPITEM_UPFFILE, new UPFFile(files[i].getAbsolutePath(), DNFFile.getDNF_PASSWORD()));
                    itemMap.put(MAPITEM_RESULT, new StringBuffer(MessageFormat.format(msg, files[i].getName()) + "\n\r"));
                    if (result.containsKey(key)) {
                        list = (List)result.get(key);
                        list.add(itemMap);
                        result.put(key, list);
                        continue;
                    }
                    list = new ArrayList();
                    list.add(itemMap);
                    result.put(key, list);
                }
                StringBuffer buf3 = new StringBuffer();
                buf3.append("_");
                buf3.append(DateFormat.getDateInstance(2, Locale.CHINA).format(RPTDate13Util.getPeriodLastDate(year, period, periodType)));
                buf3.append("_");
                buf3.append(periodType.getName());
                buf3.append(".UPF");
                String nameFilter3 = buf3.toString();
                for (int i = 0; i < files.length; ++i) {
                    List<HashMap<String, Object>> list;
                    if (!files[i].isFile() || !files[i].getName().endsWith(nameFilter3) || !this.isNewUpfFile(files[i], cslCltColl)) continue;
                    int length = files[i].getName().length();
                    HashMap<String, Object> itemMap = new HashMap<String, Object>();
                    String key = UPFFile.getFileNumber(files[i].getName().substring(0, length - 4));
                    itemMap.put(MAPITEM_UPFFILE, new UPFFile(files[i].getAbsolutePath(), DNFFile.getDNF_PASSWORD()));
                    itemMap.put(MAPITEM_RESULT, new StringBuffer(MessageFormat.format(msg, files[i].getName()) + "\n\r"));
                    if (result.containsKey(key)) {
                        list = (List)result.get(key);
                        list.add(itemMap);
                        result.put(key, list);
                        continue;
                    }
                    list = new ArrayList();
                    list.add(itemMap);
                    result.put(key, list);
                }
                break block8;
            }
            Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
            if (!"true".equals(isSupportOtherDS)) break block8;
            StringBuffer buf2 = new StringBuffer();
            buf2.append("_");
            buf2.append(DateFormat.getDateInstance(2, Locale.CHINA).format(RPTDate13Util.getPeriodLastDate(year, period, periodType)));
            buf2.append("_");
            buf2.append(periodType.getName());
            buf2.append("_").append("BUDGETDATA");
            buf2.append(".UPF");
            String nameFilter2 = buf2.toString();
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"28_CSLReportImportUI");
            for (int i = 0; i < files.length; ++i) {
                List<HashMap<String, Object>> list;
                if (!files[i].isFile() || !files[i].getName().endsWith(nameFilter2) || !this.isNewUpfFile(files[i], cslCltColl)) continue;
                int length = files[i].getName().length();
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                String key = UPFFile.getFileNumber(files[i].getName().substring(0, length - 4));
                itemMap.put(MAPITEM_UPFFILE, new UPFFile(files[i].getAbsolutePath(), DNFFile.getDNF_PASSWORD()));
                itemMap.put(MAPITEM_RESULT, new StringBuffer(MessageFormat.format(msg, files[i].getName()) + "\n\r"));
                if (result.containsKey(key)) {
                    list = (List)result.get(key);
                    list.add(itemMap);
                    result.put(key, list);
                    continue;
                }
                list = new ArrayList();
                list.add(itemMap);
                result.put(key, list);
            }
        }
        return result;
    }

    @Override
    protected void btnPath_actionPerformed(ActionEvent e) throws Exception {
        super.btnPath_actionPerformed(e);
        String exportDirPath = this.chooseDirectory();
        this.txtPath.setText(exportDirPath);
    }

    private String chooseDirectory() {
        KDFileChooser cuz = new KDFileChooser();
        cuz.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"364_CSLReportImportUI"));
        cuz.setFileSelectionMode(1);
        String path = null;
        if (cuz.showSaveDialog((Component)((Object)this)) == 0) {
            File file = cuz.getSelectedFile();
            String name = file.getName();
            if (name.matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
                MsgBox.showWarning((String)(name + "\n" + RptUtil.getReportResource((String)"invalidFileName")));
            }
            if (file != null) {
                path = file.getAbsolutePath();
            }
        }
        return path;
    }

    @Override
    protected void btnServerSchemeDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnServerSchemeDelete_actionPerformed(e);
        this.checkSchemeSelect(this.combServerScheme);
        SchemeInfo selectInfo = (SchemeInfo)this.combServerScheme.getSelectedItem();
        SchemeFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(selectInfo.getId()));
        this.combServerScheme.removeItem((Object)selectInfo);
    }

    @Override
    protected void btnServerSchemeSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnServerSchemeSave_actionPerformed(e);
        HashMap config = this.getServerConfig();
        if (this.openSchemeEditUI(CSLSchemeTypeEnum.FTPSERVERCONFIG, config, this.ServerSelectSchemeID)) {
            this.refreshServerScheme();
        }
        config.clear();
    }

    private HashMap getServerConfig() {
        HashMap<String, CharSequence> config = new HashMap<String, CharSequence>();
        if (StringUtils.isEmpty((String)this.txtServerAddress.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"365_CSLReportImportUI"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtLoginName.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"366_CSLReportImportUI"));
            SysUtil.abort();
        }
        char[] pwd = this.pwdText.getPassword();
        StringBuffer sb = new StringBuffer();
        if (pwd != null) {
            int st;
            int len = pwd.length;
            for (st = 0; st < len && pwd[st] <= ' '; ++st) {
            }
            while (st < len && pwd[len - 1] <= ' ') {
                --len;
            }
            for (int i = st; i < len; ++i) {
                sb.append(pwd[i]);
            }
        }
        if (pwd == null || sb.length() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"367_CSLReportImportUI"));
            SysUtil.abort();
        }
        config.put("serverAddress", this.txtServerAddress.getText().trim());
        config.put("serverDirectory", this.txtServerDir.getText().trim());
        config.put("serverLoginName", this.txtLoginName.getText().trim());
        config.put("serverLoginPassword", sb);
        return config;
    }

    private void setServerConfig(HashMap config) {
        if (config == null) {
            this.txtServerAddress.setText(null);
            this.txtServerDir.setText("");
            this.txtLoginName.setText(null);
            this.pwdText.setText(null);
        } else {
            this.txtServerAddress.setText(config.get("serverAddress").toString());
            this.txtServerDir.setText(config.get("serverDirectory").toString());
            this.txtLoginName.setText(config.get("serverLoginName").toString());
            this.pwdText.setText(config.get("serverLoginPassword").toString());
        }
    }

    @Override
    protected void combServerScheme_actionPerformed(ActionEvent e) throws Exception {
        super.combServerScheme_actionPerformed(e);
        Object config = null;
        SchemeInfo scheme = (SchemeInfo)((KDComboBox)e.getSource()).getModel().getSelectedItem();
        if (scheme != null && (config = scheme.getAdapterObject(CSLSchemeTypeEnum.EXPORTCOMPANY)) instanceof HashMap) {
            this.setServerConfig((HashMap)config);
        } else {
            this.setServerConfig(null);
        }
    }

    private HashMap getCompanyReceiversMap(ArrayList list) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        for (MAGroupInfo mAGroupInfo : list) {
            String orgUnitID = MAGroupOrgFacadeFactory.getRemoteInstance().getCompanyOrgUnit(mAGroupInfo.getOrgUnit());
            FullOrgUnitInfo company = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitID));
            ArrayList<String> receivers = new ArrayList<String>();
            MAGroupEntryCollection entries = mAGroupInfo.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                PersonInfo personInfo;
                if (entries.get(i).getPersonnel() == null || (personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(entries.get(i).getPersonnel().getId()))) == null || StringUtils.isEmpty((String)personInfo.getEmail())) continue;
                receivers.add(personInfo.getEmail());
            }
            if (receivers.size() == 0) continue;
            map.put(company.getNumber(), receivers);
        }
        return map;
    }

    public boolean isRefresh() {
        return this.isRefresh;
    }

    private boolean isNewUpfFile(File upfFile, CslCltIntoCollection cslCltColl) {
        CslCltIntoInfo info = this.getCslCltInfo(upfFile, cslCltColl);
        if (info == null) {
            info = new CslCltIntoInfo();
        }
        String fileMD5 = this.getMD5Value(upfFile);
        if (info.getMdfive() != null && fileMD5.equals(info.getMdfive())) {
            return false;
        }
        info.setFileName(upfFile.getName());
        info.setLastIntoTime(new Timestamp(new Date().getTime()));
        info.setMdfive(fileMD5);
        info.setYear(this.filterInfo.getYear());
        info.setPeriod(this.filterInfo.getPeriod());
        this.updateIntoColl.add(info);
        return true;
    }

    private CslCltIntoInfo getCslCltInfo(File upfFile, CslCltIntoCollection cslCltColl) {
        CslCltIntoInfo info = null;
        Iterator it = cslCltColl.iterator();
        while (it.hasNext()) {
            info = (CslCltIntoInfo)it.next();
            if (!info.getFileName().equalsIgnoreCase(upfFile.getName())) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMD5Value(File upfFile) {
        String string;
        block7: {
            InputStream in = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                in = new FileInputStream(upfFile);
                byte[] b = new byte[8192];
                int count = 0;
                while ((count = in.read(b)) > 0) {
                    md.update(b, 0, count);
                }
                string = new BigInteger(md.digest()).toString(16);
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                        in = null;
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return null;
                }
            }
            in.close();
            in = null;
        }
        return string;
    }

    private void updateCslIntoMD5() throws BOSException, EASBizException {
        if (this.updateIntoColl == null || this.updateIntoColl.isEmpty()) {
            return;
        }
        ICslCltInto icci = CslCltIntoFactory.getRemoteInstance();
        for (int i = 0; i < this.updateIntoColl.size(); ++i) {
            CslCltIntoInfo info = this.updateIntoColl.get(i);
            icci.submit(info);
        }
    }

    private String getFormatTime(long time) {
        SimpleDateFormat format = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"803_CSLReportImportUI"));
        format.setLenient(false);
        Date date = new Date(time);
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"804_CSLReportImportUI").concat(format.format(date));
    }

    private class ReportFilterPredicate
    implements Predicate {
        private ReceiveFilterCondition filterInfo;

        public ReportFilterPredicate(ReceiveFilterCondition filter) {
            this.filterInfo = filter;
        }

        public boolean evaluate(Object object) {
            CslReportInfo info;
            boolean satisfies = false;
            if (object instanceof CslReportInfo && (info = (CslReportInfo)object).getPeriod() == this.filterInfo.getPeriod() && info.getPeriodType() == this.filterInfo.getPeriodType() && info.getPeriod() == this.filterInfo.getPeriod()) {
                satisfies = true;
            }
            return satisfies;
        }
    }
}

