/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeProvider;
import com.kingdee.eas.fi.gr.bi.client.OrgUnitTreeSelectors;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportItemQueryFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.DataCollectLabelProvider;
import com.kingdee.eas.fi.gr.cslrpt.client.DataCollectProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class CSLReportItemQueryFilterUI
extends AbstractCSLReportItemQueryFilterUI {
    private String ElimResName = "com.kingdee.eas.fi.gr.cslrpt.CSLReportItemQueryRes";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    public void initUI() throws Exception {
        this.refreshPeriodType();
        this.refreshF7Company();
        this.refreshfetchTypePromp();
        this.refreshCurrency();
        this.refreshdataCollect();
    }

    private void refreshPeriodType() throws EASBizException, BOSException {
        this.listOrgBound.removeAllItems();
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection(new Date());
        this.listOrgBound.addItems(otc.toArray());
        this.listOrgBound.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CSLReportItemQueryFilterUI.this.F7Company.setData(null);
            }
        });
        this.setSpineRange(this.startYear, 1901, 2099);
        this.setSpineRange(this.endYear, 1901, 2099);
        Calendar calendar = Calendar.getInstance();
        this.startYear.setValue((Object)new Integer(calendar.get(1)));
        this.endYear.setValue((Object)new Integer(calendar.get(1)));
        this.listPeriodType.removeAllItems();
        this.listPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptPeriodTypeEnum item = (RptPeriodTypeEnum)e.getItem();
                    CSLReportItemQueryFilterUI.this.setPeriodRange(CSLReportItemQueryFilterUI.this.startPeriod, item.getValue(), (Integer)CSLReportItemQueryFilterUI.this.startYear.getValue());
                    CSLReportItemQueryFilterUI.this.setPeriodRange(CSLReportItemQueryFilterUI.this.endPeriod, item.getValue(), (Integer)CSLReportItemQueryFilterUI.this.endYear.getValue());
                    int[] period = CSLReportItemQueryFilterUI.this.getLastPeriod(item);
                    CSLReportItemQueryFilterUI.this.startYear.setValue((Object)new Integer(period[0]));
                    CSLReportItemQueryFilterUI.this.endYear.setValue((Object)new Integer(period[0]));
                    CSLReportItemQueryFilterUI.this.startPeriod.setValue((Object)new Integer(period[1]));
                    CSLReportItemQueryFilterUI.this.endPeriod.setValue((Object)new Integer(period[1]));
                }
            }
        });
        this.listPeriodType.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.listPeriodType.addItem((Object)RptPeriodTypeEnum.QUARTERLY);
        this.listPeriodType.addItem((Object)RptPeriodTypeEnum.YEARLY);
        this.dataSource.removeAllItems();
        this.dataSource.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        this.dataSource.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
    }

    private void refreshF7Company() {
        this.F7Company.setEditable(false);
        this.F7Company.setSelectAllOnFocus(false);
        this.F7Company.setSelector((KDPromptSelector)new OrgUnitTreeSelectors((IUIObject)this, this.F7Company, (OrgTreeInfo)this.listOrgBound.getSelectedItem(), null){

            @Override
            public OrgTreeInfo getTree() {
                return (OrgTreeInfo)CSLReportItemQueryFilterUI.this.listOrgBound.getSelectedItem();
            }
        });
    }

    private void refreshCurrency() throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("precision"));
        CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection(viewInfo, true);
        this.currency.removeAllItems();
        this.currency.addItems(currencyCollection.toArray());
        CompanyOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        CurrencyInfo bsCurrency = orgUnitInfo.getBaseCurrency();
        for (int j = 0; j < this.currency.getItemCount(); ++j) {
            CurrencyInfo info;
            if (!(this.currency.getItemAt(j) instanceof CurrencyInfo) || !(info = (CurrencyInfo)this.currency.getItemAt(j)).getId().toString().equals(bsCurrency.getId().toString())) continue;
            this.currency.setSelectedIndex(j);
            break;
        }
    }

    private void refreshfetchTypePromp() {
        this.fetchTypePromp.setEditable(false);
        this.fetchTypePromp.setSelectAllOnFocus(false);
        this.fetchTypePromp.setSelector((KDPromptSelector)new SortableChooser(new FetchTypeProvider(){

            @Override
            public List getSelected() {
                return (List)CSLReportItemQueryFilterUI.this.fetchTypePromp.getData();
            }
        }, new FetchTypeLabelProvider(), (IUIObject)this));
    }

    private void refreshdataCollect() {
        this.dataCollect.setEditable(false);
        this.dataCollect.setSelectAllOnFocus(false);
        DataCollectProvider dcProvider = new DataCollectProvider(){

            @Override
            public List getContents() throws Exception {
                DataCollectCollection dcCollection = new DataCollectCollection();
                if (CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getBudgetDC())) {
                    dcCollection.add(DataCollectConstant.getBudgetDC());
                }
                if (CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getActualDC())) {
                    dcCollection.add(DataCollectConstant.getActualDC());
                }
                ArrayList content = new ArrayList(dcCollection.size());
                CslRptUtil.addCollectionToArrayList(content, (IObjectCollection)dcCollection);
                return content;
            }

            @Override
            public List getSelected() {
                return (List)CSLReportItemQueryFilterUI.this.dataCollect.getData();
            }

            @Override
            public void setContents(ArrayList contents) {
            }
        };
        this.dataCollect.setSelector((KDPromptSelector)new SortableChooser(dcProvider, new DataCollectLabelProvider(), (IUIObject)this));
    }

    private int[] getLastPeriod(RptPeriodTypeEnum t) {
        Calendar c = Calendar.getInstance();
        int thismonth = c.get(2);
        do {
            c.add(5, -1);
        } while (c.get(2) == thismonth);
        int[] period = RPTDateUtil.getPeriod(new Date(c.getTimeInMillis()), t);
        return period;
    }

    protected void setPeriodRange(KDSpinner sp, int period_type, int year) {
        int max = 1;
        int min = 1;
        switch (period_type) {
            case 6: {
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 3: {
                max = 12;
                break;
            }
            case 2: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(3, 1);
                } while (cal.get(1) == year);
                max = count;
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(6, 1);
                } while (cal.get(1) == year);
                max = count;
            }
        }
        this.setSpineRange(sp, min, max);
    }

    protected void setSpineRange(KDSpinner sp, int minVal, int maxVal) {
        Integer n2;
        if (sp == null) {
            return;
        }
        SpinnerModel sm = sp.getModel();
        if (!(sm instanceof SpinnerNumberModel)) {
            return;
        }
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        try {
            n2 = new Integer(maxVal);
            nm.setMaximum(n2);
            if (n2 < 0) {
                nm.setValue(n2);
            }
        }
        catch (NumberFormatException n2) {
            // empty catch block
        }
        try {
            n2 = new Integer(minVal);
            nm.setMinimum(n2);
            if (n2 > 0) {
                nm.setValue(n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public HashMap getCondition() {
        HashMap<String, Object> condition = new HashMap<String, Object>(32);
        condition.put("listOrgBound", this.listOrgBound.getSelectedItem());
        condition.put("F7Company", this.F7Company.getData());
        condition.put("listPeriodType", this.listPeriodType.getSelectedItem());
        condition.put("startYear", this.startYear.getValue());
        condition.put("endYear", this.endYear.getValue());
        condition.put("startPeriod", this.startPeriod.getValue());
        condition.put("endPeriod", this.endPeriod.getValue());
        condition.put("startItem", this.startItem.getData() != null ? this.startItem.getData().toString() : this.startItem.getData());
        condition.put("endItem", this.endItem.getData() != null ? this.endItem.getData().toString() : this.endItem.getData());
        condition.put("currency", this.currency.getSelectedItem());
        condition.put("dataCollect", this.dataCollect.getData());
        condition.put("fetchTypePromp", this.fetchTypePromp.getData());
        condition.put("dataSource", this.dataSource.getSelectedItem());
        return condition;
    }

    public boolean verify() {
        if (this.listOrgBound.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"listOrgBound"));
            SysUtil.abort();
            return false;
        }
        if (this.F7Company.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"F7Company"));
            SysUtil.abort();
            return false;
        }
        int companyCount = ((List)this.F7Company.getData()).size();
        if (companyCount > 10) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"companyLimit"));
            SysUtil.abort();
            return false;
        }
        if (this.listPeriodType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"listPeriodType"));
            SysUtil.abort();
            return false;
        }
        if (this.startItem.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"startItem"));
            SysUtil.abort();
            return false;
        }
        if (this.endItem.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"endItem"));
            SysUtil.abort();
            return false;
        }
        if (this.currency.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"currency"));
            SysUtil.abort();
            return false;
        }
        if (this.dataCollect.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"dataCollect"));
            SysUtil.abort();
            return false;
        }
        if (this.fetchTypePromp.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"fetchTypePromp"));
            SysUtil.abort();
            return false;
        }
        if (!this.startYear.getValue().equals(this.endYear.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"checkYear"));
            SysUtil.abort();
            return false;
        }
        if (((Integer)this.startPeriod.getValue()).compareTo((Integer)this.endPeriod.getValue()) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.ElimResName, (String)"checkPeriod"));
            SysUtil.abort();
            return false;
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem0 = new FilterItemInfo("listOrgBound", (Object)new Integer(this.listOrgBound.getSelectedIndex()), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        List companys = (List)this.F7Company.getData();
        String ids = "";
        for (int i = 0; companys != null && i < companys.size(); ++i) {
            String id;
            OrgUnitInfo company = (OrgUnitInfo)companys.get(i);
            if (company == null || (id = company.getId().toString()) == null || id.length() == 0) continue;
            ids = !ids.equals("") ? ids + ",'" + id + "'" : "'" + id + "'";
        }
        ids = ids.trim();
        FilterItemInfo filterItem1 = new FilterItemInfo("F7Company", (Object)ids, CompareType.INCLUDE);
        this.filterInfo.getFilterItems().add(filterItem1);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem2 = new FilterItemInfo("listPeriodType", (Object)new Integer(this.listPeriodType.getSelectedIndex()));
        this.filterInfo.getFilterItems().add(filterItem2);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem3 = new FilterItemInfo("startYear", this.startYear.getValue());
        this.filterInfo.getFilterItems().add(filterItem3);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem4 = new FilterItemInfo("endYear", this.endYear.getValue());
        this.filterInfo.getFilterItems().add(filterItem4);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem5 = new FilterItemInfo("startPeriod", this.startPeriod.getValue());
        this.filterInfo.getFilterItems().add(filterItem5);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem6 = new FilterItemInfo("endPeriod", this.endPeriod.getValue());
        this.filterInfo.getFilterItems().add(filterItem6);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem7 = new FilterItemInfo("startItem", this.startItem.getData() != null ? this.startItem.getData().toString() : this.startItem.getData());
        this.filterInfo.getFilterItems().add(filterItem7);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem8 = new FilterItemInfo("endItem", this.endItem.getData() != null ? this.endItem.getData().toString() : this.endItem.getData());
        this.filterInfo.getFilterItems().add(filterItem8);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem9 = new FilterItemInfo("currency", (Object)new Integer(this.currency.getSelectedIndex()));
        this.filterInfo.getFilterItems().add(filterItem9);
        sbFormula.append(" and #" + formulaIndex++);
        List dataCollects = (List)this.dataCollect.getData();
        String dataCollectids = "";
        for (int i = 0; dataCollects != null && i < dataCollects.size(); ++i) {
            String id;
            DataCollectInfo dataCollect = (DataCollectInfo)dataCollects.get(i);
            if (dataCollect == null || (id = dataCollect.getId().toString()) == null || id.length() == 0) continue;
            dataCollectids = !dataCollectids.equals("") ? dataCollectids + ",'" + id + "'" : "'" + id + "'";
        }
        dataCollectids = dataCollectids.trim();
        FilterItemInfo filterItem10 = new FilterItemInfo("dataCollect", (Object)dataCollectids, CompareType.INCLUDE);
        this.filterInfo.getFilterItems().add(filterItem10);
        sbFormula.append(" and #" + formulaIndex++);
        List fetchTypes = (List)this.fetchTypePromp.getData();
        String fetchTypeids = "";
        for (int i = 0; fetchTypes != null && i < fetchTypes.size(); ++i) {
            String id;
            DataElementInfo fetchType = (DataElementInfo)fetchTypes.get(i);
            if (fetchType == null || (id = fetchType.getId().toString()) == null || id.length() == 0) continue;
            fetchTypeids = !fetchTypeids.equals("") ? fetchTypeids + ",'" + id + "'" : "'" + id + "'";
        }
        fetchTypeids = fetchTypeids.trim();
        FilterItemInfo filterItem11 = new FilterItemInfo("fetchTypePromp", (Object)fetchTypeids, CompareType.INCLUDE);
        this.filterInfo.getFilterItems().add(filterItem11);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem12 = new FilterItemInfo("dataSource", (Object)new Integer(this.dataSource.getSelectedIndex()));
        this.filterInfo.getFilterItems().add(filterItem12);
        sbFormula.append(" and #" + formulaIndex++);
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            this.clearUI();
            FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                int j;
                String ids;
                Integer selectIndex;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("listOrgBound")) {
                    selectIndex = Integer.valueOf(filterItemInfo.getCompareValue().toString());
                    if (selectIndex == null) continue;
                    this.listOrgBound.setSelectedIndex(selectIndex.intValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("F7Company")) {
                    ids = filterItemInfo.getCompareValue().toString().replace('[', '(').replace(']', ')');
                    FullOrgUnitCollection companys = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select * where id in " + ids);
                    ArrayList<FullOrgUnitInfo> companyList = new ArrayList<FullOrgUnitInfo>();
                    for (j = 0; j < companys.size(); ++j) {
                        companyList.add(companys.get(j));
                    }
                    this.F7Company.setData(companyList);
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("listPeriodType")) {
                    this.listPeriodType.setSelectedIndex(Integer.valueOf(String.valueOf(filterItemInfo.getCompareValue())).intValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("startYear")) {
                    this.startYear.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("endYear")) {
                    this.endYear.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("startPeriod")) {
                    this.startPeriod.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("endPeriod")) {
                    this.endPeriod.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("startItem")) {
                    this.startItem.setData(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("endItem")) {
                    this.endItem.setData(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency")) {
                    selectIndex = Integer.valueOf(filterItemInfo.getCompareValue().toString());
                    if (selectIndex == null) continue;
                    this.currency.setSelectedIndex(selectIndex.intValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataCollect")) {
                    ids = filterItemInfo.getCompareValue().toString().replace('[', '(').replace(']', ')');
                    DataCollectCollection dataCollects = DataCollectFactory.getRemoteInstance().getDataCollectCollection("select * where id in" + ids);
                    ArrayList<DataCollectInfo> dataCollectList = new ArrayList<DataCollectInfo>();
                    for (j = 0; j < dataCollects.size(); ++j) {
                        dataCollectList.add(dataCollects.get(j));
                    }
                    this.dataCollect.setData(dataCollectList);
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("fetchTypePromp")) {
                    ids = filterItemInfo.getCompareValue().toString().replace('[', '(').replace(']', ')');
                    DataElementCollection dataElements = DataElementFactory.getRemoteInstance().getDataElementCollection("select * where id in " + ids);
                    ArrayList<DataElementInfo> dataElementList = new ArrayList<DataElementInfo>();
                    for (j = 0; j < dataElements.size(); ++j) {
                        dataElementList.add(dataElements.get(j));
                    }
                    this.fetchTypePromp.setData(dataElementList);
                    continue;
                }
                if (!filterItemInfo.getPropertyName().equalsIgnoreCase("dataSource") || (selectIndex = Integer.valueOf(filterItemInfo.getCompareValue().toString())) == null) continue;
                this.dataSource.setSelectedIndex(selectIndex.intValue());
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    private void clearUI() {
        this.F7Company.setData(null);
        this.startItem.setData(null);
        this.endItem.setData(null);
        this.dataCollect.setData(null);
        this.fetchTypePromp.setData(null);
    }

    public void clear() {
        super.clear();
        try {
            this.initUI();
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.clearUI();
    }

    public String getMainUIName() {
        return null;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        return null;
    }

    public void setCustomCondition(RptParams params) {
    }
}

