/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IRPTDataService;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportItemQueryListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLReportItemQueryFilterUI;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CSLReportItemQueryListUI
extends AbstractCSLReportItemQueryListUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLReportItemQueryListUI.class);
    private String ElimResName = "com.kingdee.eas.fi.gr.cslrpt.CSLReportItemQueryRes";
    CSLReportItemQueryFilterUI conditionPanel = null;
    CommonQueryDialog conditionDialog = null;
    HashMap result;
    private KDComboBox rowCount = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    int index = CSLReportItemQueryListUI.this.kDPane1.getSelectedIndex();
                    CSLReportItemQueryListUI.this.showPanel(index);
                    CSLReportItemQueryListUI.this.initData();
                    CSLReportItemQueryListUI.this.initTable(index);
                }
                catch (Exception exc) {
                    CSLReportItemQueryListUI.this.handUIException(exc);
                }
            }
        });
        this.conditionDialog = this.getConditionDialog();
        if (this.conditionDialog.show()) {
            this.refreshTable();
        } else {
            SysUtil.abort();
        }
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog(){

                public void init() throws UIException {
                    super.init();
                    try {
                        Field field = CommonQueryPanel.class.getDeclaredField("cbDefaultView");
                        field.setAccessible(true);
                        KDCheckBox checkBox = (KDCheckBox)field.get(CSLReportItemQueryListUI.this.conditionDialog.getCommonqueryPanel());
                        checkBox.setEnabled(false);
                        checkBox.setVisible(false);
                    }
                    catch (Exception e2) {
                        ExceptionHandler.handle((Throwable)e2);
                    }
                }
            };
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt", "SumRptQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"29_CSLReportItemQueryListUI");
            this.conditionDialog.setTitle(msg);
            this.conditionDialog.setWidth(400);
            this.conditionDialog.setHeight(380);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.gr.cslrpt.client.CSLReportItemQueryListUI");
        }
        return this.conditionDialog;
    }

    public CSLReportItemQueryFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CSLReportItemQueryFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    public void refreshTable() throws Exception {
        for (int i = 1; i < this.kDPane1.getTabCount(); ++i) {
            this.kDPane1.remove(i);
            --i;
        }
        HashMap conditions = this.conditionPanel.getCondition();
        Field field = CommonQueryPanel.class.getDeclaredField("txtRowCount");
        field.setAccessible(true);
        this.rowCount = (KDComboBox)field.get(this.conditionDialog.getCommonqueryPanel());
        if (this.rowCount != null && this.rowCount.getSelectedIndex() >= 0) {
            conditions.put("rowCount", new Integer(((IntEnum)this.rowCount.getSelectedItem()).getValue()));
        } else {
            conditions.put("rowCount", new Integer(100));
        }
        IRPTDataService dataService = RPTDataServiceFactory.getRemoteInstance();
        this.result = (HashMap)dataService.getDCItemData(conditions);
        int index = 0;
        for (String kDPane1Name : this.result.keySet()) {
            if (index == 0) {
                this.kDPane1.setTitleAt(0, kDPane1Name);
                ++index;
                continue;
            }
            this.kDPane1.addTab(kDPane1Name, (Component)new KDPanel());
        }
        this.kDPane1.setSelectedIndex(0);
        this.showPanel(0);
        this.initData();
        this.initTable(0);
    }

    public void creatTableHead() throws Exception {
        this.setCursorOfWair();
        this.kDMain.checkParsed();
        this.kDMain.removeHeadRows();
        this.kDMain.removeRows();
        this.kDMain.removeColumns();
        HashMap conditions = this.conditionPanel.getCondition();
        List fetchType = (List)conditions.get("fetchTypePromp");
        List dataCollects = (List)conditions.get("dataCollect");
        Iterator fetchTypeitr = fetchType.iterator();
        int[] ColumnWidths = new int[fetchType.size() * dataCollects.size() + 2];
        ColumnWidths[0] = 200;
        ColumnWidths[1] = 200;
        for (int i = 2; i < fetchType.size() * dataCollects.size() + 2; ++i) {
            ColumnWidths[i] = 150;
        }
        String[][] head = new String[1][fetchType.size() * dataCollects.size() + 2];
        head[0][0] = EASResource.getString((String)this.ElimResName, (String)"Period");
        head[0][1] = EASResource.getString((String)this.ElimResName, (String)"Item");
        int hdIndex = 2;
        while (fetchTypeitr.hasNext()) {
            String dataElementName = ((DataElementInfo)fetchTypeitr.next()).getName();
            Iterator dataCollectitr = dataCollects.iterator();
            while (dataCollectitr.hasNext()) {
                String dataCollectName = ((DataCollectInfo)dataCollectitr.next()).getName();
                head[0][hdIndex] = dataCollectName + "(" + dataElementName + ")";
                if (hdIndex >= fetchType.size() * dataCollects.size() + 2) continue;
                ++hdIndex;
            }
        }
        KDTableHeaderModel mm = new KDTableHeaderModel();
        mm.setData(head);
        mm.setColumnWidths(ColumnWidths);
        KDTableUtil.setHeader((KDTableHeaderModel)mm, (KDTable)this.kDMain);
        this.setCursorOfDefault();
    }

    public void showPanel(int index) throws Exception {
        this.kDMain.checkParsed();
        KDPanel panel = (KDPanel)this.kDPane1.getComponentAt(index);
        this.kDLabelContainer2.setBounds(new Rectangle(11, 13, 270, 19));
        panel.add((Component)this.kDLabelContainer2, null);
        this.kDLabelContainer2.setBoundEditor((JComponent)this.kDCurrency);
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(8, 51, 980, 500);
        cons.anchor = 449;
        this.kDMain.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        panel.add((Component)this.kDMain, null);
        panel.setLayout((LayoutManager)new KDLayout());
        panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 1016, 600));
        this.creatTableHead();
    }

    public void initTable(int index) throws Exception {
        this.kDMain.setEnabled(false);
        HashMap conditions = this.conditionPanel.getCondition();
        CurrencyInfo currency = (CurrencyInfo)conditions.get("currency");
        int precision = currency.getPrecision();
        StringBuffer s = new StringBuffer();
        if (precision != 0) {
            s.append("#,##0.");
            for (int i = 0; i < precision; ++i) {
                s.append("#");
            }
        }
        DecimalFormat f = new DecimalFormat(s.toString());
        String title = this.kDPane1.getTitleAt(index);
        List tempData = (List)this.result.get(title);
        if (tempData == null) {
            return;
        }
        for (String[] cellDatas : tempData) {
            if (cellDatas.length != this.kDMain.getColumnCount()) continue;
            IRow row = this.kDMain.addRow();
            for (int i = 0; i < cellDatas.length; ++i) {
                row.getCell(i).setValue((Object)cellDatas[i]);
                if (i <= 1) continue;
                String tempValue = row.getCell(i).getValue().toString();
                boolean isNumber = false;
                try {
                    new BigDecimal(tempValue);
                    isNumber = true;
                }
                catch (Exception e) {
                    isNumber = false;
                }
                if (isNumber) {
                    BigDecimal amount = new BigDecimal(tempValue);
                    amount = amount.setScale(precision, 4);
                    row.getCell(i).setValue((Object)this.cutZeroFromBigdecimal(amount, f));
                    row.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    continue;
                }
                row.getCell(i).setValue((Object)tempValue);
            }
        }
    }

    public void initData() throws Exception {
        HashMap conditions = this.conditionPanel.getCondition();
        CurrencyInfo currency = (CurrencyInfo)conditions.get("currency");
        if (currency != null) {
            this.kDCurrency.setText(currency.getName());
        }
        this.kDCurrency.setEditable(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnExport);
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.conditionDialog = this.getConditionDialog();
        if (this.conditionDialog.show()) {
            this.refreshTable();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshTable();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.kDMain);
        this.kDMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.kDMain);
        this.kDMain.getPrintManager().printPreview();
    }

    protected KDTable getTableForCommon() {
        return this.kDMain;
    }

    private String cutZeroFromBigdecimal(BigDecimal value, DecimalFormat f) {
        if (value == null) {
            return null;
        }
        if (value.compareTo(Variant.zeroBigDecimal) == 0) {
            return "0";
        }
        String thinString = null;
        thinString = f != null ? f.format(value) : value.toString();
        while (thinString.endsWith("0") && thinString.indexOf(".") != -1 || thinString.endsWith(".")) {
            thinString = thinString.substring(0, thinString.length() - 1);
        }
        return thinString;
    }
}

