/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportParametersUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class CSLReportParametersUI
extends AbstractCSLReportParametersUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLReportParametersUI.class);
    private CslReportInfo editData = null;
    private boolean isLock = false;
    private CurrencyCollection currencyCol = null;

    public CSLReportParametersUI() throws Exception {
        this.initUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.editData = (CslReportInfo)this.getUIContext().get("CSLReportInfo");
        this.loadControlData();
    }

    private void loadControlData() {
        this.comboPeriodType.setSelectedItem((Object)this.editData.getPeriodType());
        this.comboYear.setSelectedItem((Object)new Integer(this.editData.getYear()));
        this.comboPeriod.setSelectedItem((Object)new Short(this.editData.getPeriod()));
        this.datePickerRptDate.setValue((Object)this.editData.getReportDate());
        for (CurrencyInfo element : this.currencyCol) {
            if (!this.editData.getCurrency().getNumber().trim().equals(element.getNumber().trim())) continue;
            this.comboCurrency.setSelectedItem((Object)element);
            break;
        }
    }

    private void initUI() throws EASBizException, BOSException {
        this.contRptParam.setContainerType(2);
        this.comboPeriodType.setEnabled(false);
        this.comboYear.setEnabled(false);
        this.comboPeriod.setEnabled(false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(1);
        Integer yearObj = null;
        Integer currentYearObj = null;
        for (int i = year - 1; i <= year + 1; ++i) {
            yearObj = new Integer(i);
            if (i == year) {
                currentYearObj = yearObj;
            }
            this.comboYear.addItem((Object)yearObj);
        }
        this.comboYear.setSelectedItem(currentYearObj);
        ICurrency ic = CurrencyFactory.getRemoteInstance();
        this.currencyCol = ic.getCurrencyCollection(true);
        int n = this.currencyCol.size();
        for (int i = 0; i < n; ++i) {
            this.comboCurrency.addItem((Object)this.currencyCol.get(i));
        }
    }

    @Override
    public void comboPeriodTypePeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.comboPeriod.removeAllItems();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        int type = periodType.getValue();
        ArrayList<Short> items = new ArrayList<Short>();
        int count = 0;
        switch (type) {
            case 1: {
                count = 366;
                break;
            }
            case 3: {
                count = 12;
                break;
            }
            case 4: {
                count = 4;
                break;
            }
            case 5: {
                count = 2;
                break;
            }
            case 6: {
                count = 1;
            }
        }
        for (int i = 1; i <= count; ++i) {
            items.add(new Short((short)i));
        }
        this.comboPeriod.addItems(items.toArray());
        this.refreshTimeInfo(this.datePickerRptDate.getSqlDate());
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.comboYear.setSelectedItem((Object)new Integer(times.get(0).toString()));
        this.comboPeriod.setSelectedItem((Object)new Short(times.get(1).toString()));
        this.isLock = true;
        this.datePickerRptDate.setValue(times.get(2));
        this.isLock = false;
    }

    @Override
    public void datePickerRptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLock) {
            return;
        }
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    @Override
    public void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        this.destroyWindow();
    }

    @Override
    public void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.saveControlData();
        this.getUIWindow().close();
        this.destroyWindow();
    }

    private void saveControlData() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        int year = (Integer)this.comboYear.getSelectedItem();
        short period = (Short)this.comboPeriod.getSelectedItem();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.editData.setCurrency(currency);
        this.editData.setPeriodType(periodType);
        this.editData.setYear(year);
        this.editData.setPeriod(period);
        this.editData.setReportDate(RPTDate13Util.getPeriodLastDate(year, period, periodType));
    }
}

