/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLAnlysisTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnalysisFilterParam;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisObjectFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportAnlysisObject;
import com.kingdee.eas.fi.gr.cslrpt.TrendAnlysisObjectEnum;
import com.kingdee.eas.fi.gr.cslrpt.TrendAnlysisWaysEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportTendencyMainUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AnlysisClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLReportAnlysisDimenFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLReportAnlysisFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.OrgUnitRender;
import com.kingdee.eas.fi.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.io.ExportAction;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class CSLReportTendencyMainUI
extends AbstractCSLReportTendencyMainUI {
    private static final long serialVersionUID = -1777136163693641766L;
    private static final Logger logger = CoreUIObject.getLogger(CSLReportTendencyMainUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource";
    protected IMetaDataPK mainQueryPk = null;
    protected CSLReportAnlysisFilterUI defaultFilterUI = null;
    protected List filterUIList = null;
    protected CustomerParams defaultFilterParam = null;
    private CommonQueryDialog dialog = null;
    private BOSUuid solutionId = null;
    private ICSLReportAnlysisObject iAnlysis;
    private Book book;
    private SpreadContext sc;
    private IReport iReport;
    private IFullOrgUnit iFullOrgUnit;
    private OrgUnitRender render;

    public CSLReportTendencyMainUI() throws Exception {
        this.initMainQueryPk();
        this.initFilterUIs();
    }

    protected void initFilterUIs() throws Exception {
        if (this.filterUIList == null) {
            this.filterUIList = new ArrayList();
        }
        CSLReportAnlysisFilterUI filteUI1 = new CSLReportAnlysisFilterUI((Object)this);
        this.filterUIList.add(filteUI1);
        CSLReportAnlysisDimenFilterUI filteUI2 = new CSLReportAnlysisDimenFilterUI((Object)this);
        this.filterUIList.add(filteUI2);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initMainQueryPk() {
        this.mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");
    }

    public BOSUuid getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(BOSUuid solutionId) {
        this.solutionId = solutionId;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle();
        this.setBtnIcon();
        boolean hasDefaultQuery = this.getDefaultFilterParam();
        if (hasDefaultQuery) {
            this.executeQuery();
            this.loadPrintConfigInfo();
        } else {
            this.dialog = this.getCommonQueryDialog();
            if (this.dialog.show()) {
                CommonQueryPanel queryPanel = this.dialog.getCommonqueryPanel();
                this.solutionId = queryPanel.getCurrentSolution() != null ? queryPanel.getCurrentSolution().getId() : null;
                this.defaultFilterParam = new CustomerParams();
                for (int i = 0; i < this.filterUIList.size(); ++i) {
                    CustomerParams cp = ((CustomerQueryPanel)this.filterUIList.get(i)).getCustomerParams();
                    ((CustomerQueryPanel)this.filterUIList.get(i)).setCustomerParams(cp);
                    this.defaultFilterParam.getCustomerParamsHashMap().putAll(cp.getCustomerParamsHashMap());
                }
                this.executeQuery();
                this.loadPrintConfigInfo();
            } else {
                SysUtil.abort();
            }
        }
    }

    private void setBtnIcon() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected void setUITitle() {
        this.setUITitle(this.resHelper.getString("this.title"));
    }

    protected boolean getDefaultFilterParam() throws Exception {
        int i;
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!iQuery.hasDefaultSolution(this.getQueryMainName(), this.mainQueryPk.getFullName())) {
            return false;
        }
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getQueryMainName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION)) {
            this.solutionId = ds.getId();
            if (this.defaultFilterParam == null) {
                this.defaultFilterParam = new CustomerParams();
            }
            for (i = 0; i < ds.getQueryPanelInfo().size(); ++i) {
                QueryPanelInfo panelInfo = ds.getQueryPanelInfo().get(i);
                CustomerParams cp = new CustomerParams().getCustomerParams(panelInfo.getCustomerParams());
                this.defaultFilterParam.getCustomerParamsHashMap().putAll(cp.getCustomerParamsHashMap());
            }
        }
        if (ds != null && ds.isIsUserDefaultSolu() && ds.getSolutionType() != null && !ds.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION)) {
            for (i = 0; i < this.filterUIList.size(); ++i) {
                Object ui = this.filterUIList.get(i);
                if (ui instanceof CSLReportAnlysisFilterUI) {
                    ((CSLReportAnlysisFilterUI)((Object)ui)).setCustomerParams(this.defaultFilterParam);
                    if (((CSLReportAnlysisFilterUI)((Object)ui)).verify()) continue;
                    return false;
                }
                if (!(ui instanceof CSLReportAnlysisDimenFilterUI)) continue;
                ((CSLReportAnlysisDimenFilterUI)((Object)ui)).setCustomerParams(this.defaultFilterParam);
                if (((CSLReportAnlysisDimenFilterUI)((Object)ui)).verify()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setFilterParam(CustomerParams cp) {
        if (cp == null) {
            return;
        }
    }

    public CustomerParams getFilterParam() {
        return this.defaultFilterParam;
    }

    protected String getQueryMainName() {
        return CSLReportTendencyMainUI.class.getName();
    }

    protected CSLReportAnlysisFilterUI getDefaultFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new CSLReportAnlysisFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.defaultFilterUI;
    }

    public void setDefaultFilterUI(CSLReportAnlysisFilterUI defaultFilterUI) {
        this.defaultFilterUI = defaultFilterUI;
    }

    public List getFilterUIList() {
        return this.filterUIList;
    }

    public void setFilterUIList(List filterUIList) {
        this.filterUIList = filterUIList;
    }

    protected void executeQuery() throws EASBizException, BOSException {
        int i;
        if (this.defaultFilterParam == null) {
            return;
        }
        CSLReportAnalysisFilterParam param = this.convert(this.defaultFilterParam);
        byte[] data = this.getAnlysisInterface().getAnlysisBookData(null, param, true);
        this.book = this.addAndInitTable(data);
        for (i = 0; this.book != null && i < this.book.getSheetCount(); ++i) {
            Sheet sheet = this.book.getSheet(i);
            if (sheet == null) continue;
            this.addOrgUnitByCol(param, 0, sheet);
        }
        for (i = this.sc.getBook().getSheetCount() - 1; i >= 0; --i) {
            Range range = this.sc.getBook().getSheet(i).getRange(0, 0);
            if (range == null) continue;
            range.select();
        }
        this.sc.getBook().activeSheet(0);
        this.sc.getSpread().scrollCellVisible(0, 0);
        this.addTableListener();
        this.sc.getSpread().repaint();
    }

    private CSLReportAnalysisFilterParam convert(CustomerParams cp) throws BOSException {
        int i;
        CSLReportAnalysisFilterParam param = new CSLReportAnalysisFilterParam();
        String treeId = cp.getCustomerParam("treeId");
        param.setOrgTreeId(cp.getCustomerParam("treeId"));
        param.setOrgTreeNumber(cp.getCustomerParam("treeNumber"));
        ArrayList<String> orgNumberList = new ArrayList<String>();
        ArrayList<String> orgNameList = new ArrayList<String>();
        ArrayList<String> orgIDList = new ArrayList<String>();
        String orgNumberS = cp.getCustomerParam("orgNumberS");
        String orgNameS = cp.getCustomerParam("orgNames");
        String orgIDS = cp.getCustomerParam("orgIDS");
        String[] tmp = orgNumberS.split(";");
        String[] tmp1 = orgNameS.split(";");
        String[] tmp2 = orgIDS.split(";");
        for (i = 0; i < tmp.length; ++i) {
            orgNumberList.add(tmp[i]);
            orgNameList.add(tmp1[i]);
            orgIDList.add(tmp2[i]);
        }
        this.initOrgStructColl(param, treeId, orgNumberList);
        if (!tmp2[0].equals(param.getOrgStructColl().get(0).getUnit().getId().toString())) {
            orgNumberList = new ArrayList();
            orgNameList = new ArrayList();
            orgIDList = new ArrayList();
            for (i = tmp.length - 1; i >= 0; --i) {
                orgNumberList.add(tmp[i]);
                orgNameList.add(tmp1[i]);
                orgIDList.add(tmp2[i]);
            }
        }
        param.setOrgNumberList(orgNumberList);
        param.setOrgNameList(orgNameList);
        param.setOrgIdList(orgIDList);
        param.setConvertCurrencyId(cp.getCustomerParam("currencyId"));
        param.setConvertCurrencyNumber(cp.getCustomerParam("currencyNumber"));
        param.setSourceCurrencyId(cp.getCustomerParam("currencyId"));
        param.setSourceCurrencyNumber(cp.getCustomerParam("currencyNumber"));
        param.setTemplateId(cp.getCustomerParam("templateId"));
        param.setTitleCol(cp.getCustomerParam("title_col"));
        param.setAnlysisCol(cp.getCustomerParam("item_col"));
        param.setBeginYear(cp.getInt("begin_year"));
        param.setBeginPeriod(cp.getInt("begin_period"));
        param.setEndYear(cp.getInt("end_year"));
        param.setEndPeriod(cp.getInt("end_period"));
        param.setPeriodType(RptPeriodTypeEnum.getEnum((int)cp.getInt("periodType")));
        param.setSourceType(cp.getCustomerParam("sourceType"));
        param.setDataCollectNumber(cp.getCustomerParam("dataCollectNumber"));
        String anlysisObjectStr = cp.getCustomerParam("wayObjectStr");
        String[] strs = anlysisObjectStr.split(":");
        TrendAnlysisObjectEnum[] obj = new TrendAnlysisObjectEnum[strs.length];
        for (int i2 = 0; i2 < strs.length; ++i2) {
            obj[i2] = TrendAnlysisObjectEnum.getEnum(Integer.parseInt(strs[i2]));
        }
        param.setTrendAnlysisObject(obj);
        param.setAnalysisType(CSLAnlysisTypeEnum.TendencyAnlysis);
        if (obj[0].getValue() == 1 || obj[0].getValue() == 2) {
            param.setTrendAnlysisWay(TrendAnlysisWaysEnum.DingJI);
        } else {
            param.setTrendAnlysisWay(TrendAnlysisWaysEnum.HuanBi);
        }
        return param;
    }

    private void initOrgStructColl(CSLReportAnalysisFilterParam param, String treeId, List orgNumberList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("parent.id"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("level"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        view.getSelector().add(new SelectorItemInfo("unit.number"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeId));
        HashSet orgNumberSet = new HashSet(orgNumberList);
        filter.getFilterItems().add(new FilterItemInfo("unit.number", orgNumberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("longNumber");
        sort.setSortType(SortType.ASCEND);
        view.getSorter().add(sort);
        IOrgStructure iStruct = OrgStructureFactory.getRemoteInstance();
        OrgStructureCollection structColl = iStruct.getOrgStructureCollection(view);
        HashMap<String, String> sourceTypeMap = new HashMap<String, String>();
        for (int i = 0; i < structColl.size(); ++i) {
            if (structColl.get(i).isIsLeaf()) {
                sourceTypeMap.put(structColl.get(i).getUnit().getNumber().toString(), "COMMITREPORT");
                continue;
            }
            sourceTypeMap.put(structColl.get(i).getUnit().getNumber().toString(), "CONSOLIDATION");
        }
        param.setSourceTypeMap(sourceTypeMap);
        this.reformOrgStructColl(structColl);
        param.setOrgStructColl(structColl);
    }

    private void reformOrgStructColl(OrgStructureCollection structColl) {
        for (int i = 0; i < structColl.size(); ++i) {
            structColl.get(i).put("single", (Object)Boolean.TRUE);
        }
        int index = 0;
        while (index < structColl.size() - 1) {
            int i;
            for (i = index + 1; i < structColl.size(); ++i) {
                if (!structColl.get(i).getLongNumber().startsWith(structColl.get(index).getLongNumber() + "!")) {
                    index = i;
                    break;
                }
                structColl.get(index).put("single", (Object)Boolean.FALSE);
                structColl.get(i).put("single", (Object)Boolean.FALSE);
            }
            index = i;
        }
        index = 0;
        while (index < structColl.size() - 1) {
            int i;
            if (structColl.get(index).getBoolean("single")) {
                structColl.get(index).setLevel(0);
                structColl.get(index).setIsLeaf(true);
                ++index;
                continue;
            }
            if (structColl.get(index + 1).getBoolean("single") != structColl.get(index).getBoolean("single") || structColl.get(index + 1).getBoolean("single") == structColl.get(index).getBoolean("single") && !structColl.get(index + 1).getLongNumber().startsWith(structColl.get(index).getLongNumber() + "!")) {
                ++index;
                continue;
            }
            int level = 0;
            boolean curSeries = true;
            boolean lastSeries = true;
            for (i = index + 1; i < structColl.size(); ++i) {
                if (i == index + 1) {
                    if (structColl.get(index + 1).getBoolean("single")) {
                        structColl.get(i - 1).setLevel(level);
                        structColl.get(i - 1).setIsLeaf(true);
                        break;
                    }
                    structColl.get(i - 1).setLevel(level++);
                    structColl.get(i - 1).setIsLeaf(false);
                    lastSeries = curSeries = true;
                    if (i != structColl.size() - 1) continue;
                    structColl.get(i).setLevel(level++);
                    structColl.get(i).setIsLeaf(true);
                    continue;
                }
                if (!structColl.get(i).getLongNumber().startsWith(structColl.get(index).getLongNumber() + "!")) {
                    if (lastSeries) {
                        structColl.get(i - 1).setLevel(level++);
                    } else {
                        structColl.get(i - 1).setLevel(level);
                    }
                    structColl.get(i - 1).setIsLeaf(true);
                    break;
                }
                if (structColl.get(i).getLongNumber().startsWith(structColl.get(i - 1).getLongNumber() + "!")) {
                    if (!lastSeries) {
                        level = 1;
                    }
                    structColl.get(i - 1).setLevel(level++);
                    structColl.get(i - 1).setIsLeaf(false);
                    if (i == structColl.size() - 1) {
                        structColl.get(i).setLevel(level++);
                        structColl.get(i).setIsLeaf(true);
                    }
                    curSeries = true;
                } else {
                    if (lastSeries) {
                        structColl.get(i - 1).setLevel(level);
                        if (i == structColl.size() - 1) {
                            structColl.get(i).setLevel(level);
                        }
                    } else if (structColl.get(i).getLongNumber().split("!").length < structColl.get(i - 1).getLongNumber().split("!").length) {
                        if (structColl.get(i - 1).getLongNumber().split("!").length != structColl.get(i - 2).getLongNumber().split("!").length) {
                            level = 1;
                        }
                        structColl.get(i - 1).setLevel(level);
                        if (i == structColl.size() - 1) {
                            structColl.get(i).setLevel(1);
                        }
                    } else if (structColl.get(i).getLongNumber().split("!").length == structColl.get(i - 1).getLongNumber().split("!").length) {
                        if (structColl.get(i - 1).getLongNumber().split("!").length != structColl.get(i - 2).getLongNumber().split("!").length) {
                            level = 1;
                        }
                        structColl.get(i - 1).setLevel(level);
                        if (i == structColl.size() - 1) {
                            structColl.get(i).setLevel(level);
                        }
                    } else if (structColl.get(i).getLongNumber().split("!").length > structColl.get(i - 1).getLongNumber().split("!").length) {
                        level = 1;
                        structColl.get(i - 1).setLevel(level);
                        if (i == structColl.size() - 1) {
                            structColl.get(i).setLevel(1);
                        }
                    }
                    structColl.get(i - 1).setIsLeaf(true);
                    if (i == structColl.size() - 1) {
                        structColl.get(i).setIsLeaf(true);
                    }
                    curSeries = false;
                }
                if (i <= index + 1) continue;
                lastSeries = curSeries;
            }
            index = i;
        }
    }

    public ICSLReportAnlysisObject getAnlysisInterface() throws BOSException {
        if (this.iAnlysis == null) {
            this.iAnlysis = CSLReportAnlysisObjectFactory.getRemoteInstance();
        }
        return this.iAnlysis;
    }

    private Book addAndInitTable(byte[] data) throws EASBizException, BOSException {
        if (this.sc != null) {
            this.TabPaneMain.remove((Component)this.sc);
        }
        Book book = null;
        try {
            book = IOHelper.unpackBook((byte[])data);
            if (book != null) {
                book.setCalculate(false);
            }
        }
        catch (Exception ex) {
            if (book != null) {
                book = null;
            }
            SysUtil.abort();
        }
        if (book != null && book.getSheet(0) != null) {
            this.sc = new SpreadContext();
            this.sc.setBook(book);
            AnlysisClientHelper.setPopMenuVisible(this.sc);
            this.TabPaneMain.add((Component)this.sc, (Object)"Center");
            this.TabPaneMain.setTitleAt(0, EASResource.getString((String)RESOURCE, (String)"TendencyAnlysisMainTitle"));
        }
        return book;
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new CommonQueryDialog();
        this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.dialog.setEntityViewInfo(new EntityViewInfo());
        this.dialog.setQueryObjectPK(this.mainQueryPk);
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"30_CSLReportPerformAnalysisListUI");
        this.dialog.setTitle(MessageFormat.format(msg, this.resHelper.getString("this.title")));
        this.dialog.setWidth(this.getWidthOfDialog());
        this.dialog.setHeight(this.getHeightOfDialog());
        for (int i = 0; this.filterUIList != null && i < this.filterUIList.size(); ++i) {
            this.dialog.addUserPanel((KDPanel)this.filterUIList.get(i));
        }
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        return this.dialog;
    }

    protected int getWidthOfDialog() {
        return 290;
    }

    protected int getHeightOfDialog() {
        return 280;
    }

    private void addTableListener() {
        this.sc.getSpread().setMouseController(3, (IMouseController)new MyTableMouseController(this.sc));
        this.sc.getBook().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                CSLReportTendencyMainUI.this.sc.getSpread().scrollCellVisible(0, 0);
            }
        });
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.dialog = this.getCommonQueryDialog();
        if (this.dialog.show()) {
            CommonQueryPanel queryPanel = this.dialog.getCommonqueryPanel();
            this.solutionId = queryPanel.getCurrentSolution() != null ? queryPanel.getCurrentSolution().getId() : null;
            this.defaultFilterParam = new CustomerParams();
            for (int i = 0; i < this.filterUIList.size(); ++i) {
                CustomerParams cp = ((CustomerQueryPanel)this.filterUIList.get(i)).getCustomerParams();
                ((CustomerQueryPanel)this.filterUIList.get(i)).setCustomerParams(cp);
                this.defaultFilterParam.getCustomerParamsHashMap().putAll(cp.getCustomerParamsHashMap());
            }
            this.executeQuery();
            this.loadPrintConfigInfo();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.sc == null) {
            return;
        }
        this.executeQuery();
        Book book = this.sc.getBook();
        ArrayList<String> formulaList = new ArrayList<String>();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            int colCount = sheet.getMaxColIndex();
            int rowCount = sheet.getMaxRowIndex();
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null || cell.getUserObjectValue("formula") == null) continue;
                    formulaList.add(cell.getUserObjectValue("formula").toString());
                }
            }
        }
        Variant[] variants = this.getReportInterface().calcFormulas(formulaList);
        int index = 0;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            int colCount = sheet.getMaxColIndex();
            int rowCount = sheet.getMaxRowIndex();
            sheet.getSheetOption().setCellDisplayMode(0);
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null || cell.getUserObjectValue("formula") == null) continue;
                    cell.setValue(variants[index++]);
                }
            }
        }
        this.sc.setBook(book);
        this.sc.repaint();
    }

    public IReport getReportInterface() throws BOSException {
        if (this.iReport == null) {
            this.iReport = ReportFactory.getRemoteInstance();
        }
        return this.iReport;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        ExportAction ea = new ExportAction(this.sc);
        ea.actionPerformed(null);
    }

    protected KDTabbedPane getMainTabPane() {
        return this.TabPaneMain;
    }

    protected Object getSelectSheet() {
        Component obj = null;
        KDTable sheet = null;
        obj = this.getMainTabPane().getSelectedComponent();
        if (obj instanceof KDTable) {
            return (KDTable)obj;
        }
        if (obj instanceof KDPanel) {
            KDPanel panel = (KDPanel)obj;
            int n = panel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                obj = panel.getComponent(i);
                if (!(obj instanceof KDTable)) continue;
                sheet = (KDTable)obj;
                break;
            }
        }
        return sheet;
    }

    protected boolean hasSpreadContext() {
        return this.sc != null;
    }

    protected void setTreeDisplayStyle(Cell cell, NumberExpandInfo expandInfo, Sheet sheet) {
        this.expandTable(cell, expandInfo, sheet);
        this.sc.getSpread().repaint();
    }

    private void expandTable(Cell cell, NumberExpandInfo parentExpandInfo, Sheet sheet) {
        Row childRow = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)parentExpandInfo);
            cell.setValue(Variant.nullVariant);
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int rowIndex = cell.getRow() + 1; rowIndex < rowCount; ++rowIndex) {
                childRow = sheet.getRow(rowIndex, false);
                NumberExpandInfo childExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)childRow.getCell(0, false));
                if (childExpandInfo == null) continue;
                longnumber = childExpandInfo.getLongNumber();
                if (longnumber.startsWith(plongnumber + "!")) {
                    BgNFSHelper.setHided((Row)childRow, (boolean)true);
                    continue;
                }
                break;
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)parentExpandInfo);
            cell.setValue(Variant.nullVariant);
            int rowIndex = cell.getRow();
            int rowCount = sheet.getMaxRowIndex() + 1;
            ++rowIndex;
            while (rowIndex < rowCount) {
                NumberExpandInfo childExpandInfo;
                childRow = sheet.getRow(rowIndex, false);
                if (childRow != null && (childExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)childRow.getCell(0, false))) != null) {
                    longnumber = childExpandInfo.getLongNumber();
                    if (longnumber.startsWith(plongnumber + "!")) {
                        BgNFSHelper.setHided((Row)childRow, (boolean)false);
                    } else if (longnumber.equals(plongnumber)) break;
                }
                ++rowIndex;
            }
        }
    }

    public IFullOrgUnit getFullOrgUnitInterface() throws BOSException {
        if (this.iFullOrgUnit == null) {
            this.iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        }
        return this.iFullOrgUnit;
    }

    private void addOrgUnitByCol(CSLReportAnalysisFilterParam param, int beginRow, Sheet sheet) {
        List orgIdList = param.getOrgIdList();
        int num = orgIdList.size();
        String[] companyIds = new String[num];
        for (int i = 0; i < num; ++i) {
            companyIds[i] = orgIdList.get(i).toString();
        }
        OrgStructureCollection structColl = param.getOrgStructColl();
        if (companyIds != null && companyIds.length != 0) {
            sheet.getColRange(0, 0).setColumnWidth(200);
            if (companyIds.length > 1) {
                this.render = new OrgUnitRender();
                this.sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)new UserCellDisplayProvider());
                UserCellDisplayProvider.addRenderProvider((IRenderProvider)this.render);
            }
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int i = 0; i < structColl.size(); ++i) {
                for (int rowIndex = beginRow; rowIndex < rowCount; ++rowIndex) {
                    this.addExpandInfo(sheet.getCell(rowIndex, 0, true), structColl.get(i), sheet);
                }
            }
        }
    }

    protected void addExpandInfo(Cell cell, OrgStructureInfo struct, Sheet sheet) {
        if (cell == null || cell.getUserObjectValue("orgNumber") == null || !cell.getUserObjectValue("orgNumber").toString().equals(struct.getUnit().getNumber())) {
            return;
        }
        if (cell.getUserObjectValue("orgNumber").toString().equals(struct.getUnit().getNumber()) && struct.getBoolean("single")) {
            cell.setValue(new Variant((Object)struct.getUnit().getName()));
            return;
        }
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(struct.getUnit().getId().toString());
        expandInfo.setName(struct.getUnit().getName());
        expandInfo.setNumber(struct.getUnit().getNumber());
        expandInfo.setLongNumber(struct.getLongNumber());
        expandInfo.setLevel(struct.getLevel());
        expandInfo.setExpandStatus(struct.getLevel() != 0);
        expandInfo.setLeaf(struct.isIsLeaf());
        BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)expandInfo);
        cell.setValue(Variant.nullVariant);
        if (struct.getLevel() != 0) {
            BgNFSHelper.setHided((Row)sheet.getRow(cell.getRow(), true), (boolean)true);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        if (this.hasSpreadContext()) {
            this.sc.getPrintManager().print();
        } else {
            Object _obj = this.getSelectSheet();
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = (KDTable)_obj;
            this.preparePrintPage(_table);
            _table.getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        if (this.hasSpreadContext()) {
            this.sc.getPrintManager().printPreview();
        } else {
            Object _obj = this.getSelectSheet();
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = (KDTable)_obj;
            _table.getDataRequestManager().setDataRequestMode(0);
            this.preparePrintPage(_table);
            _table.getPrintManager().printPreview();
        }
        this.setPrintConfigInfo();
    }

    protected void setPrintConfigInfo() throws Exception {
        if (this.solutionId == null) {
            return;
        }
    }

    protected void loadPrintConfigInfo() throws Exception {
    }

    protected class PrintConfigInfo
    implements Serializable {
        private static final long serialVersionUID = -3972882578783456011L;
        private byte[] data = null;

        protected PrintConfigInfo() {
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    private class MyTableMouseController
    extends TableMouseController {
        public MyTableMouseController(SpreadContext context) {
            super(context);
        }

        public void mouseClicked(MouseEvent e) {
            Sheet activeSheet = CSLReportTendencyMainUI.this.sc.getBook().getActiveSheet();
            Cell cell = activeSheet.getActiveCell();
            if (CSLReportTendencyMainUI.this.render != null && cell != null) {
                OrgUnitRender.NumberExpendRender numRender = (OrgUnitRender.NumberExpendRender)CSLReportTendencyMainUI.this.render.getRender(cell, -1);
                if (numRender == null) {
                    return;
                }
                NumberExpandInfo numberExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)cell);
                if (numberExpandInfo != null && numRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                    CSLReportTendencyMainUI.this.setTreeDisplayStyle(cell, numberExpandInfo, activeSheet);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            CSLReportTendencyMainUI.this.sc.getSpread().repaint();
        }
    }
}

