/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ArchiveFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslParamBox;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReduceRpcFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICslParam;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLSysContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextManager;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLSysParamanager;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CSLSysContextUI
extends AbstractCSLSysContextUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLSysContextUI.class);
    private static final String CSLSYSCONTEXTUI_INFO_NOFINDORGBOUND = "Msg_NoFindOrgBound";
    private static final String CSLSYSCONTEXTUI_INFO_NOFINDORGGROUP = "Msg_NoFindOrgGroup";
    private static final String CSLSYSCONTEXTUI_INFO_ISCLOSECSLUIS = "IsCloseCSLUIs";
    private static final String CSLSYSCONTEXTUI_INFO_NOAMDCPERMISSION = "No_AMDC_Permission";
    private static final String CSLSYSCONTEXTUI_INFO_NOBGDCPERMISSION = "No_BGDC_Permission";
    private static int invokeNum = 1;
    private CSLContext ctx = null;
    private CSLContextManager manager = null;
    private DataCollectCollection coll = null;
    private Date curLastDate = null;
    private boolean orgTreeListener = true;
    private boolean isMergeByFiscalPeriod = false;
    private boolean isSupportOtherDS = false;
    private boolean isSupport13Period = false;
    private Map orgTreeNumber_Periods = null;
    private DataCollectInfo acDataCollect = null;
    private boolean isFirstShow = true;
    private Map initInfoMap = null;
    private Map mergeModeMap = null;
    Map unitsMap = null;

    public CSLSysContextUI() throws Exception {
        this.jbInit();
        this.ctx = CSLContext.getInstance();
        this.manager = CSLContextManager.getInstance();
        this.curLastDate = CslRptUIUtil.getLastPeriodDate(this.ctx.getCurReportDate());
    }

    public boolean destroyWindow() {
        if (this.orgTreeNumber_Periods != null) {
            this.orgTreeNumber_Periods.clear();
        }
        return super.destroyWindow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private DataCollectCollection getDataCollection() throws BOSException {
        if (this.coll == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"ACTUALDATA"));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"BUDGETDATA"));
            filter.setMaskString("#0 or #1");
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("*"));
            SorterItemInfo sortinfo = new SorterItemInfo("number");
            sortinfo.setSortType(SortType.ASCEND);
            view.getSorter().add(sortinfo);
            this.coll = DataCollectFactory.getRemoteInstance().getDataCollectCollection(view);
        }
        return this.coll;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CslRptUIUtil.setSpineRange(this.spCurPeriod, 0, 365);
        if (!this.ctx.isInitialized()) {
            MainFrameCallBack.addPropertyChangeListener((String)"ReLogin", (PropertyChangeListener)this.manager);
            this.manager.addObserver(CSLSysParamanager.getInstance());
        }
        this.rptDate.setValue((Object)CslRptUIUtil.getLastPeriodDate(this.ctx.getCurReportDate()), false);
        this.kDCheckBox1.setSelected(this.ctx.isQueryBudget());
        DataCollectCollection coll = (DataCollectCollection)((Object)this.getInitInfoMap().get("dataCollectColl"));
        for (int i = 0; coll != null && i < coll.size(); ++i) {
            this.comboDataCollect.addItem((Object)coll.get(i));
            if (!"ACTUALDATA".equals(coll.get(i).getNumber())) continue;
            this.comboDataCollect.setSelectedItem((Object)coll.get(i));
            this.acDataCollect = coll.get(i);
        }
        if (!this.isSupportOtherDS) {
            this.comboDataCollect.setEnabled(false);
            this.comboDataCollect.setVisible(false);
            this.kDLabelContainer8.setVisible(false);
            this.kDCheckBox1.setVisible(false);
            this.setBounds(new Rectangle(290, 235));
            this.kDLabelContainer4.setBounds(10, 10, 270, 19);
            this.kDLabelContainer3.setBounds(10, 32, 270, 19);
            this.kDLabelContainer5.setBounds(10, 54, 270, 19);
            this.kDLabelContainer6.setBounds(10, 76, 270, 19);
            this.kDLabelContainer1.setBounds(10, 98, 270, 19);
            this.kDLabelContainer2.setBounds(10, 120, 270, 19);
            this.kDLabelContainer7.setBounds(10, 142, 270, 19);
            this.kDSeparator1.setBounds(0, 199, 291, 19);
            this.cmdOK.setBounds(128, 209, 73, 21);
            this.cmdCancel.setBounds(207, 209, 73, 21);
        } else {
            this.kDCheckBox1.setVisible(true);
            this.comboDataCollect.setEnabled(true);
            this.comboDataCollect.setVisible(true);
            this.kDLabelContainer8.setVisible(true);
            this.setBounds(new Rectangle(290, 260));
            this.kDLabelContainer4.setBounds(10, 32, 270, 19);
            this.kDLabelContainer3.setBounds(10, 54, 270, 19);
            this.kDLabelContainer5.setBounds(10, 76, 270, 19);
            this.kDLabelContainer6.setBounds(10, 98, 270, 19);
            this.kDLabelContainer1.setBounds(10, 120, 270, 19);
            this.kDLabelContainer2.setBounds(10, 142, 270, 19);
            this.kDLabelContainer7.setBounds(10, 164, 270, 19);
            this.kDLabelContainer8.setBounds(10, 186, 270, 19);
            this.kDSeparator1.setBounds(0, 221, 291, 19);
            this.cmdOK.setBounds(128, 231, 73, 21);
            this.cmdCancel.setBounds(207, 231, 73, 21);
        }
        this.initMergeByFiscalPeriodUI();
        this.refresh();
        this.CSLContextToUI();
        this.unionVersion();
        this.F7Company.setEditable(false);
        this.comboDataCollect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSLSysContextUI.this.refresh13Period();
            }
        });
        Thread td = new Thread(){

            @Override
            public void run() {
                CSLParamUtil.initCslParamCatch();
            }
        };
        td.start();
    }

    private Map getInitInfoMap() {
        try {
            if (this.initInfoMap == null) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("userId", this.getUserId());
                paramMap.put("isQueryBudget", new Boolean(this.kDCheckBox1.isSelected()));
                paramMap.put("periodType", this.listPeriodType.getSelectedItem() == null || this.listPeriodType.getSelectedItem().equals("") ? RptPeriodTypeEnum.MONTHLY : this.listPeriodType.getSelectedItem());
                paramMap.put("rptDate", this.rptDate.getValue());
                paramMap.put("FilterProfitCenterOrgTree", Boolean.TRUE);
                this.initInfoMap = CslReduceRpcFacadeFactory.getRemoteInstance().getCslSysContextUIInfo(paramMap);
                CslParamBox cslParamBox = (CslParamBox)this.initInfoMap.get("cslParamBox");
                this.isMergeByFiscalPeriod = cslParamBox.isMergeByFiscalPeriod();
                this.isSupportOtherDS = cslParamBox.isSupportOtherDS();
                this.isSupport13Period = cslParamBox.isSupport13Period();
                this.coll = (DataCollectCollection)((Object)this.initInfoMap.get("dataCollectColl"));
                this.initInfoMap.putAll(paramMap);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        return this.initInfoMap;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cmdCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void cmdOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.check()) {
            DataElementProvider.refresh();
            boolean isCancel = this.closeCSLUIs();
            this.getUIWindow().close();
            if (!isCancel) {
                HashMap logDatas = new HashMap();
                this.setLogDatas(logDatas);
            }
        }
    }

    public void setLogDatas(HashMap logDatas) throws BOSException {
        logDatas.put("FItemName", "csl_sysContext_change");
        logDatas.put("FID", this.getID());
        logDatas.put("FUserID", this.getUserId());
        logDatas.put("FUserName", this.getUserName());
        logDatas.put("FClientIP", this.getClientIp());
        logDatas.put("FClientName", this.getClientName());
        logDatas.put("FOccurTime", new Timestamp(System.currentTimeMillis()));
        logDatas.put("FEntityAlias_L2", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"392_CSLSysContextUI"));
        logDatas.put("FEntityAlias_L3", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"393_CSLSysContextUI"));
        logDatas.put("FInstanceNo", this.getInstanceNO());
        logDatas.put("FCompanyName_L2", this.getCurrOrgUnit());
        logDatas.put("FCompanyName_L3", this.getCurrOrgUnit());
        AppLogFactory.getRemoteInstance().writeLog(logDatas);
    }

    private String getID() {
        AppLogInfo appLogInfo = new AppLogInfo();
        String id = BOSUuid.create((BOSObjectType)appLogInfo.getBOSType()).toString();
        return id;
    }

    private String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    private String getUserName() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getNumber();
    }

    private String getClientIp() {
        String obj = SysContext.getSysContext().getClientIP();
        return obj == null ? "" : obj.toString();
    }

    private String getClientName() {
        String obj = SysContext.getSysContext().getClientName();
        return obj == null ? "" : obj.toString();
    }

    public String getInstanceNO() throws BOSException {
        String CurOrgBound = null;
        if (CSLContextHelper.getCSLContext() != null && CSLContextHelper.getCSLContext().getCurOrgBound() != null) {
            CurOrgBound = CSLContextHelper.getCSLContext().getCurOrgBound().getName();
        }
        String retValue = CurOrgBound;
        return retValue;
    }

    private String getCurrOrgUnit() {
        String obj = SysContext.getSysContext().getCurrentOrgUnit().getName();
        return obj == null ? "" : obj.toString();
    }

    @Override
    protected void listOrgBound_actionPerformed(ActionEvent e) throws Exception {
        if (!this.orgTreeListener) {
            return;
        }
        this.refreshCompany();
        OrgTreeInfo orgTree = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
        if (this.isMergeByFiscalPeriod()) {
            RptPeriodTypeEnum p;
            if (orgTree != null && this.orgTreeNumber_Periods != null) {
                FiscalPeriodHelper.setYearSpineRange((PeriodCollection)this.orgTreeNumber_Periods.get(orgTree.getNumber()), this.spCurYear, true, true);
            }
            if ((p = (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem()) == null) {
                return;
            }
            List times = RPTDateUtil.getRptPeriod(this.curLastDate, p);
            this.spCurYear.setValue((Object)new Integer(times.get(0).toString()));
            this.refreshYear(false);
        } else if (this.listOrgBound.getSelectedItem() != null) {
            orgTree = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
            if (this.mergeModeMap == null) {
                this.mergeModeMap = new HashMap(4);
            }
            String key = orgTree.getId().toString();
            String text = null;
            if (this.mergeModeMap.containsKey(key)) {
                text = this.mergeModeMap.get(key).toString();
            } else {
                text = CslRptUtil.getMergeMode(orgTree).getAlias();
                this.mergeModeMap.put(key, text);
            }
            this.txtMergeMode.setText(text);
        } else {
            this.txtMergeMode.setText(null);
        }
    }

    @Override
    protected void listPeriodType_actionPerformed(ActionEvent e) throws Exception {
        if (this.isMergeByFiscalPeriod) {
            this.refreshMergeByFiscalPeriodUI();
        }
        if (this.isMergeByFiscalPeriod()) {
            this.refreshOrgBound();
        } else {
            this.refreshTimeInfo(this.rptDate.getSqlDate());
            this.refresh13Period();
        }
    }

    @Override
    protected void rptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.rptDate.getValue() != null && this.rptDate.getValue() instanceof Date) {
            if (!this.isMergeByFiscalPeriod()) {
                this.refreshTimeInfo((Date)this.rptDate.getValue());
                this.refreshOrgBound();
                this.refreshCompany();
                this.refresh13Period();
            } else {
                boolean isListener = this.orgTreeListener;
                this.orgTreeListener = false;
                if (!this.setCurVersionOrgTreeByRptDate()) {
                    this.orgTreeListener = isListener;
                    this.F7Company.setEnabled(false);
                    this.F7Company.setData(null);
                    return;
                }
                this.orgTreeListener = isListener;
                this.refreshCompany();
            }
            if (this.listOrgBound.getSelectedItem() != null) {
                OrgTreeInfo orgTree = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
                if (this.mergeModeMap != null && this.mergeModeMap.containsKey(orgTree.getId().toString())) {
                    this.txtMergeMode.setText(this.mergeModeMap.get(orgTree.getId().toString()).toString());
                } else {
                    this.txtMergeMode.setText(CslRptUtil.getMergeMode(orgTree).getAlias());
                }
            } else {
                this.txtMergeMode.setText(null);
            }
        }
    }

    private void setCSLContext(CSLContext c) throws EASBizException, BOSException {
        if (this.listOrgBound.getSelectedItem() == null || this.F7Company.getValue() == null) {
            return;
        }
        c.setCurOrgBound((OrgTreeInfo)this.listOrgBound.getSelectedItem());
        c.setCurOrgGroup(OrgClientUtils.getPromptValue((KDBizPromptBox)this.F7Company));
        c.setCurRptPeriodType((RptPeriodTypeEnum)this.listPeriodType.getSelectedItem());
        c.setCurRptYear(Integer.parseInt(this.spCurYear.getValue().toString()));
        c.setCurRptPeriod(Integer.parseInt(this.spCurPeriod.getValue().toString()));
        boolean published = ArchiveFactory.getRemoteInstance().isPublised(c.getCurOrgBound().getId().toString(), c.getCurOrgGroup().getId().toString(), c.getCurRptYear(), c.getCurRptPeriod(), c.getCurRptPeriodType().getValue());
        c.setCurPublishedStatus(published);
        try {
            c.setCurReportDate(this.rptDate.getSqlDate());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        ICslParam icp = CslParamFactory.getRemoteInstance();
        boolean updatedTemplate = icp.isUpdatedTemplate();
        if (!updatedTemplate) {
            try {
                icp.updateDynaTemplate();
                updatedTemplate = icp.setUpdatedTemplate();
            }
            catch (EASBizException e) {
                updatedTemplate = false;
            }
            catch (BOSException e) {
                updatedTemplate = false;
            }
        }
        icp.updateOffsetSheet();
        c.setUpdatedTemplate(updatedTemplate);
        c.setCurDataCollect((DataCollectInfo)this.comboDataCollect.getSelectedItem());
        c.setQueryBudget(this.kDCheckBox1.isSelected());
    }

    private boolean isChanged() throws EASBizException, BOSException {
        if (!this.ctx.isInitialized()) {
            return true;
        }
        CSLContext cslContext = null;
        try {
            cslContext = (CSLContext)this.ctx.clone();
        }
        catch (CloneNotSupportedException e) {
            super.handUIException((Throwable)e);
        }
        this.setCSLContext(cslContext);
        return !this.ctx.equals(cslContext);
    }

    private void CSLContextToUI() {
        try {
            this.kDCheckBox1.setSelected(this.ctx.isQueryBudget());
            if (this.ctx.getCurReportDate() == null) {
                if (!this.isMergeByFiscalPeriod()) {
                    this.rptDate.setValue((Object)CslRptUIUtil.getLastPeriodDate(this.ctx.getCurReportDate()));
                    if (!this.ctx.isInitialized()) {
                        return;
                    }
                    int period = this.ctx.getCurRptPeriod();
                    int year = this.ctx.getCurRptYear();
                    if (period == 1) {
                        period = 12;
                        --year;
                    } else {
                        --period;
                    }
                    this.spCurYear.setValue((Object)new Integer(year));
                    this.spCurPeriod.setValue((Object)new Integer(period));
                    this.listPeriodType.setSelectedItem((Object)this.ctx.getCurRptPeriodType());
                    this.listOrgBound.setSelectedItem((Object)this.ctx.getCurOrgBound());
                    this.F7Company.setData((Object)this.ctx.getCurOrgGroup());
                }
            } else if (this.isMergeByFiscalPeriod()) {
                this.listPeriodType.setSelectedItem((Object)this.ctx.getCurRptPeriodType());
                this.setOrgTree(this.ctx.getCurOrgBound());
                this.spCurYear.setValue((Object)new Integer(this.ctx.getCurRptYear()));
                this.refreshYear(false);
                this.spCurPeriod.setValue((Object)new Integer(this.ctx.getCurRptPeriod()));
                this.rptDate.setValue((Object)this.ctx.getCurReportDate());
                this.F7Company.setData((Object)this.ctx.getCurOrgGroup());
            } else {
                this.listPeriodType.setSelectedItem((Object)this.ctx.getCurRptPeriodType());
                this.rptDate.setValue((Object)this.ctx.getCurReportDate());
                this.spCurYear.setValue((Object)new Integer(this.ctx.getCurRptYear()));
                this.spCurPeriod.setValue((Object)new Integer(this.ctx.getCurRptPeriod()));
                this.listOrgBound.setSelectedItem((Object)this.ctx.getCurOrgBound());
                this.F7Company.setData((Object)this.ctx.getCurOrgGroup());
            }
            if (this.ctx.getCurDataCollect() != null) {
                this.comboDataCollect.setSelectedItem((Object)this.ctx.getCurDataCollect());
            } else if (this.acDataCollect != null) {
                this.comboDataCollect.setSelectedItem((Object)this.acDataCollect);
            }
            RptPeriodTypeEnum rptPeriodTypeEnum = (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem();
            int periodType = rptPeriodTypeEnum == null ? 0 : rptPeriodTypeEnum.getValue();
            DataCollectInfo dc = (DataCollectInfo)this.comboDataCollect.getSelectedItem();
            if (3 == periodType && dc != null && dc.getNumber().equals("BUDGETDATA")) {
                this.spCurPeriod.setEnabled(false);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
    }

    private void UIToCSLContext() throws EASBizException, BOSException {
        this.setCSLContext(this.ctx);
    }

    private boolean check() throws Exception {
        if (this.listOrgBound.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)CSLSYSCONTEXTUI_INFO_NOFINDORGBOUND));
            return false;
        }
        if (this.F7Company.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)CSLSYSCONTEXTUI_INFO_NOFINDORGGROUP));
            return false;
        }
        this.refresh13PeriodElim();
        return true;
    }

    private boolean closeCSLUIs() throws BOSException, EASBizException {
        DataCollectInfo dc;
        String userId;
        boolean isCancel = false;
        if (this.isSupportOtherDS && !CSLPermissionUtil.hasDataCollectPermission(null, userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString(), dc = (DataCollectInfo)this.comboDataCollect.getSelectedItem(), this.isSupportOtherDS)) {
            String msg1 = null;
            if (dc.getNumber().equals("ACTUALDATA")) {
                msg1 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)CSLSYSCONTEXTUI_INFO_NOAMDCPERMISSION);
            } else if (dc.getNumber().equals("BUDGETDATA")) {
                msg1 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)CSLSYSCONTEXTUI_INFO_NOBGDCPERMISSION);
            }
            MsgBox.showError((Component)((Object)this), (String)msg1);
            SysUtil.abort();
        }
        if (this.isChanged()) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)CSLSYSCONTEXTUI_INFO_ISCLOSECSLUIS)) == 0) {
                this.UIToCSLContext();
                this.setUIContext();
                this.manager.notifyCTXChanged();
                isCancel = false;
            } else {
                isCancel = true;
            }
        }
        return isCancel;
    }

    private void jbInit() throws Exception {
        this.spCurYear.setEnabled(false);
        this.spCurPeriod.setEnabled(false);
        this.rptDate.setSupportedEmpty(false);
    }

    private void refresh() throws EASBizException, BOSException {
        this.refreshPeriodType();
        if (!this.isMergeByFiscalPeriod()) {
            this.refreshOrgBound();
            this.refreshCompany();
        }
    }

    private void refreshCompany() {
        Logger testLog = Logger.getLogger(CSLSysContextUI.class);
        testLog.info((Object)("[UY]START=" + invokeNum++));
        testLog.info((Object)"[UY].~");
        OrgTreeInfo orgTreeInfo = null;
        if (this.listOrgBound.getSelectedItem() != null) {
            FullOrgUnitInfo oldOrgUnitInfo;
            UnionF7Helper.UnionF7 f7;
            boolean notOld = true;
            orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
            UnionF7Helper.UnionF7 oldf7 = (UnionF7Helper.UnionF7)this.F7Company.getSelector();
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                f7 = UnionF7Helper.getUnionF7((IUIObject)this, (int)2);
                f7.setTreeID(orgTreeInfo.getId().toString());
            } else {
                f7 = oldf7;
                notOld = false;
            }
            if (notOld) {
                String unitsSql = "";
                try {
                    unitsSql = UnionF7Helper.getUnionSQLByUserPKAndTreePK((IObjectPK)CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), (IObjectPK)CslRptUtil.getPK((IObjectValue)orgTreeInfo));
                    f7.filterUnitSql(unitsSql);
                    this.unitsMap = this.getFullOrgUnitCollection(unitsSql);
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
            }
            if (null != (oldOrgUnitInfo = (FullOrgUnitInfo)this.F7Company.getValue()) && null != this.unitsMap && !this.unitsMap.isEmpty()) {
                FullOrgUnitInfo newOrgUnitInfo = (FullOrgUnitInfo)this.unitsMap.get(oldOrgUnitInfo.getNumber().toString());
                if (null != newOrgUnitInfo) {
                    this.F7Company.setValue((Object)newOrgUnitInfo);
                } else {
                    this.F7Company.setValue(null);
                }
            }
            this.F7Company.setSelector((KDPromptSelector)f7);
            this.F7Company.setEnabled(true);
        } else {
            this.F7Company.setValue(null);
            this.F7Company.setEnabled(false);
        }
    }

    private Map getFullOrgUnitCollection(String unitsSql) throws BOSException {
        if (null == unitsSql || unitsSql.length() == 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        try {
            filterInfo.mergeFilter(new FilterInfo(" id in (" + unitsSql + ")"), "AND");
            viewInfo.setFilter(filterInfo);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(viewInfo);
        int iSize = fullOrgUnitCollection.size();
        HashMap<String, FullOrgUnitInfo> newMap = null;
        if (null != fullOrgUnitCollection && iSize > 0) {
            FullOrgUnitInfo orgUnitInfo = null;
            newMap = new HashMap<String, FullOrgUnitInfo>(iSize);
            for (int i = 0; i < iSize; ++i) {
                orgUnitInfo = fullOrgUnitCollection.get(i);
                newMap.put(orgUnitInfo.getNumber(), orgUnitInfo);
            }
        }
        return newMap;
    }

    private OrgTreeCollection getOrgTreeCollection() throws EASBizException, BOSException {
        OrgTreeCollection otc = null;
        boolean isFilterProfitOrg = false;
        if (this.isMergeByFiscalPeriod()) {
            if (this.listPeriodType.getSelectedItem() != null && this.listPeriodType.getSelectedItem().equals(this.getInitInfoMap().get("periodType"))) {
                otc = (OrgTreeCollection)this.getInitInfoMap().get("orgTreeCollection");
            } else {
                otc = CslRptUIUtil.getOrgTreeCollection();
                isFilterProfitOrg = true;
            }
        } else {
            Boolean isSelected = new Boolean(this.kDCheckBox1.isSelected());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd");
            Date sdate = (Date)this.rptDate.getValue();
            Date mdate = (Date)this.getInitInfoMap().get("rptDate");
            if (isSelected.equals(this.getInitInfoMap().get("isQueryBudget")) && dateFormat.format(sdate).equals(dateFormat.format(mdate))) {
                otc = (OrgTreeCollection)this.getInitInfoMap().get("orgTreeCollection");
            } else if (this.kDCheckBox1.isSelected()) {
                otc = CslRptUIUtil.getHistoryOrgTreeCollection((Date)this.rptDate.getValue());
            } else {
                otc = CslRptUtil.getAllUnionTreesOrderByNumber(null, this.getUserId(), (Date)this.rptDate.getValue());
                isFilterProfitOrg = true;
            }
        }
        if (isFilterProfitOrg && otc != null && !otc.isEmpty()) {
            otc = CslRptUtil.getOrgTreeCollectionFilterProfitOrg(null, otc);
        }
        return otc;
    }

    private void refreshOrgBound() throws EASBizException, BOSException {
        OrgTreeCollection otc = this.getOrgTreeCollection();
        ArrayList<String> tmpOrgTree = new ArrayList<String>();
        OrgTreeInfo tree = null;
        OrgTreeInfo info = null;
        HashMap<String, OrgTreeInfo> id_orgTree = new HashMap<String, OrgTreeInfo>();
        if (otc == null) {
            return;
        }
        for (int i = otc.size() - 1; i >= 0; --i) {
            tree = otc.get(i);
            id_orgTree.put(tree.getId().toString(), tree);
        }
        if (otc == null) {
            return;
        }
        ArrayList<String> orgTreeNumbers = new ArrayList<String>();
        ArrayList orgTreeList = new ArrayList();
        for (int i = 0; i < otc.size(); ++i) {
            info = otc.get(i);
            if (info.isIsHide()) {
                otc.remove(info);
                --i;
                continue;
            }
            if (!this.isMergeByFiscalPeriod()) continue;
            if (tmpOrgTree.contains(info.getNumber()) || UnionVersionStatusEnum.UNSTART.equals((Object)info.getStatus())) {
                otc.remove(info);
                --i;
                continue;
            }
            tmpOrgTree.add(info.getNumber());
            orgTreeList.add(id_orgTree.get(info.getId().toString()));
            if (orgTreeNumbers.contains(info.getNumber())) continue;
            orgTreeNumbers.add(info.getNumber());
        }
        if (otc == null) {
            return;
        }
        OrgTreeInfo select = (OrgTreeInfo)this.listOrgBound.getModel().getSelectedItem();
        CSLSysContextUI.setKDComboBoxFireListener(this.listOrgBound, false, false);
        this.listOrgBound.removeAllItems();
        if (this.isMergeByFiscalPeriod()) {
            if (orgTreeNumbers.size() > 0) {
                this.orgTreeNumber_Periods = FiscalPeriodHelper.getPeriodCollectionsByOrgTreeNumbers(null, orgTreeNumbers);
            }
            this.listOrgBound.addItems(orgTreeList.toArray());
        } else {
            this.listOrgBound.addItems(otc.toArray());
        }
        if (select != null && !this.isMergeByFiscalPeriod()) {
            for (OrgTreeInfo element : otc) {
                if (!select.getNumber().equals(element.getNumber())) continue;
                this.listOrgBound.getModel().setSelectedItem(element);
                break;
            }
        }
        CSLSysContextUI.setKDComboBoxFireListener(this.listOrgBound, true, true);
        if (this.listOrgBound.getSelectedItem() == null) {
            this.refreshTimeInfo(this.curLastDate);
        }
    }

    private void refreshPeriodType() {
        Iterator itor = RptPeriodTypeEnum.iterator();
        CSLSysContextUI.setKDComboBoxFireListener(this.listPeriodType, false, false);
        RptPeriodTypeEnum curItem = null;
        this.listPeriodType.removeAllItems();
        while (itor.hasNext()) {
            curItem = (RptPeriodTypeEnum)itor.next();
            this.listPeriodType.addItem((Object)curItem);
        }
        if (this.listPeriodType.getItemCount() != 0) {
            this.listPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        }
        CSLSysContextUI.setKDComboBoxFireListener(this.listPeriodType, true, true);
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.spCurYear.setValue((Object)new Integer(times.get(0).toString()));
        this.spCurPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.rptDate.setValue(times.get(2));
    }

    private void setUIContext() throws BOSException {
        SysContext.getSysContext().setCurrentOrgUnit(OrgType.UnionDebt, this.ctx.getCurOrgGroup());
        IContextManager imanager = ContextManagerFactory.getRemoteInstance();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(OrgType.UnionDebt, this.ctx.getCurOrgGroup());
        map.put("KEY_ORGTREE_INFO", this.ctx.getCurOrgBound());
        map.put("KEY_DATACOLLECT_NUMBER", this.ctx.getCurDataCollect().getNumber());
        imanager.setContext(map);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.isFirstShow) {
            this.getUIWindow().close();
        }
    }

    @Override
    protected void kDCheckBox1_itemStateChanged(ItemEvent e) throws Exception {
        super.kDCheckBox1_itemStateChanged(e);
        this.refreshOrgBound();
        this.refreshCompany();
        this.refreshDataCollect();
        this.refresh13Period();
    }

    private void refreshDataCollect() throws BOSException {
        boolean isSelected = this.kDCheckBox1.isSelected();
        this.coll = this.getDataCollection();
        Object sel = this.comboDataCollect.getSelectedItem();
        this.comboDataCollect.removeAllItems();
        for (int i = 0; this.coll != null && i < this.coll.size(); ++i) {
            DataCollectInfo obj = this.coll.get(i);
            if (isSelected && (!isSelected || !obj.getNumber().equals("BUDGETDATA"))) continue;
            this.comboDataCollect.addItem((Object)obj);
        }
        this.comboDataCollect.setSelectedItem(sel);
    }

    private void unionVersion() throws Exception {
        boolean isUnionVersion = true;
        if (this.ctx != null && this.ctx.getCurOrgBound() != null) {
            String curOrgBound = this.ctx.getCurOrgBound().getId().toString();
            for (int i = 0; i < this.listOrgBound.getItemCount(); ++i) {
                if (!curOrgBound.equals(((OrgTreeInfo)this.listOrgBound.getItemAt(i)).getId().toString())) continue;
                isUnionVersion = false;
                break;
            }
            if (isUnionVersion) {
                CSLContext.getInstance().destroyContext();
                CSLContextManager.getInstance().notifyCTXChanged();
                this.CSLContextToUI();
            }
        }
    }

    private void refresh13Period() {
        if (this.isSupport13Period) {
            RptPeriodTypeEnum rptPeriodTypeEnum;
            int periodType = 0;
            periodType = "".equals(this.listPeriodType.getSelectedItem()) || this.listPeriodType.getSelectedItem() == null ? 0 : ((rptPeriodTypeEnum = (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem()) == null ? 0 : rptPeriodTypeEnum.getValue());
            DataCollectInfo dc = (DataCollectInfo)this.comboDataCollect.getSelectedItem();
            if (3 == periodType && RPTDateUtil.isYearLastPeriod((Date)this.rptDate.getValue(), RptPeriodTypeEnum.MONTHLY)) {
                if (dc != null && dc.getNumber().equals("ACTUALDATA")) {
                    this.spCurPeriod.setEnabled(true);
                    CslRptUIUtil.setSpineRange(this.spCurPeriod, 12, 13);
                } else {
                    SpinnerModel sm = this.spCurPeriod.getModel();
                    if (!(sm instanceof SpinnerNumberModel)) {
                        return;
                    }
                    SpinnerNumberModel nm = (SpinnerNumberModel)sm;
                    if (nm.getValue() != null && (Integer)nm.getValue() == 13) {
                        nm.setValue(new Integer(12));
                    }
                    this.spCurPeriod.setEnabled(false);
                    CslRptUIUtil.setSpineRange(this.spCurPeriod, 0, 365);
                }
            } else {
                this.spCurPeriod.setEnabled(false);
                CslRptUIUtil.setSpineRange(this.spCurPeriod, 0, 365);
            }
        }
    }

    private void refresh13PeriodElim() throws Exception {
        int elimMethod;
        int periodType;
        RptPeriodTypeEnum rptPeriodTypeEnum = (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem();
        int n = periodType = rptPeriodTypeEnum == null ? 0 : rptPeriodTypeEnum.getValue();
        if (3 == periodType && Integer.parseInt(this.spCurPeriod.getValue().toString()) == 13 && ((elimMethod = this.getElimMethod((OrgTreeInfo)this.listOrgBound.getModel().getSelectedItem())) == 1 || elimMethod == 2)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"13periodNoSupport"));
            SysUtil.abort();
            return;
        }
    }

    private int getElimMethod(OrgTreeInfo orgTree) throws Exception {
        if (orgTree == null) {
            return 0;
        }
        String v = null;
        HashMap values = ParamManager.getParamHashMap((HashMap)CSLSysParamanager.getSysParamKeys(orgTree));
        if (values != null && values.containsKey("GR_CSL_ELIMMETHOD_001")) {
            v = (String)values.get("GR_CSL_ELIMMETHOD_001");
        }
        try {
            if (v != null) {
                return new Integer(v);
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void refreshYear(boolean fireListener) {
        try {
            if (this.isMergeByFiscalPeriod()) {
                RptPeriodTypeEnum p;
                OrgTreeInfo orgTree = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
                if (orgTree != null && this.orgTreeNumber_Periods != null) {
                    FiscalPeriodHelper.setPeriodSpineRange((PeriodCollection)this.orgTreeNumber_Periods.get(orgTree.getNumber()), Integer.parseInt(this.spCurYear.getValue().toString()), (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem(), this.spCurPeriod, true, this.isMergeByFiscalPeriod, true);
                }
                if ((p = (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem()) == null) {
                    return;
                }
                List times = RPTDateUtil.getRptPeriod(this.curLastDate, p);
                this.spCurPeriod.setValue((Object)new Integer(times.get(1).toString()), fireListener);
                this.refreshPeriod();
            }
        }
        catch (Exception ex) {
            MsgBox.showError((String)ex.getMessage());
            SysUtil.abort();
        }
    }

    private void refreshPeriod() {
        try {
            if (this.isMergeByFiscalPeriod()) {
                Date curRptDate = null;
                OrgTreeInfo orgTree = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
                PeriodCollection periods = null;
                if (orgTree != null && this.orgTreeNumber_Periods != null) {
                    periods = (PeriodCollection)this.orgTreeNumber_Periods.get(orgTree.getNumber());
                }
                if ((curRptDate = FiscalPeriodHelper.getRptDate(periods, Integer.parseInt(this.spCurYear.getValue().toString()), Integer.parseInt(this.spCurPeriod.getValue().toString()), (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem(), this.isMergeByFiscalPeriod)) != null) {
                    this.rptDate.setValue((Object)curRptDate, false);
                    this.rptDate_dataChanged(null);
                }
            }
        }
        catch (Exception ex) {
            MsgBox.showError((String)ex.getMessage());
            SysUtil.abort();
        }
    }

    private boolean setCurVersionOrgTreeByRptDate() throws Exception {
        OrgTreeInfo orgTree = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
        if (orgTree == null) {
            return false;
        }
        String orgTreeNumber = orgTree.getNumber();
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection((Date)this.rptDate.getValue());
        if (otc == null) {
            return false;
        }
        if (otc != null && !otc.isEmpty()) {
            otc = CslRptUtil.getOrgTreeCollectionFilterProfitOrg(null, otc);
        }
        OrgTreeInfo tmpOrgTree = null;
        int index = 0;
        for (int i = 0; i < otc.size(); ++i) {
            tmpOrgTree = otc.get(i);
            if (!tmpOrgTree.getNumber().equals(orgTreeNumber)) continue;
            if (!orgTree.getId().equals((Object)tmpOrgTree.getId())) {
                index = this.listOrgBound.getSelectedIndex();
                if (index < 0) {
                    index = 0;
                }
                this.listOrgBound.removeItem((Object)orgTree);
                this.listOrgBound.insertItemAt((Object)tmpOrgTree, index);
                this.listOrgBound.setSelectedItem((Object)tmpOrgTree);
            }
            return true;
        }
        return false;
    }

    private void refreshMergeByFiscalPeriodUI() {
        this.kDLabelContainer8.setVisible(false);
        this.kDCheckBox1.setVisible(false);
        RptPeriodTypeEnum p = RptPeriodTypeEnum.MONTHLY;
        if (this.listPeriodType.getSelectedItem() != null && this.listPeriodType.getSelectedItem() instanceof RptPeriodTypeEnum) {
            p = (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem();
        }
        if (this.isMergeByFiscalPeriod()) {
            this.kDLabelContainer4.setLocation(this.kDLabelContainer4.getX(), 10);
            this.kDLabelContainer1.setLocation(this.kDLabelContainer1.getX(), 32);
            this.kDLabelContainer5.setLocation(this.kDLabelContainer5.getX(), 54);
            this.kDLabelContainer6.setLocation(this.kDLabelContainer6.getX(), 76);
            this.kDLabelContainer3.setLocation(this.kDLabelContainer3.getX(), 98);
            this.kDLabelContainer2.setLocation(this.kDLabelContainer2.getX(), 120);
            this.kDLabelContainer7.setLocation(this.kDLabelContainer7.getX(), 142);
            this.kDSeparator1.setLocation(this.kDSeparator1.getX(), 164);
            this.cmdOK.setLocation(this.cmdOK.getX(), 174);
            this.cmdCancel.setLocation(this.cmdCancel.getX(), 174);
            this.rptDate.setEnabled(false);
            this.spCurYear.setEnabled(true);
            this.spCurPeriod.setEnabled(true);
            this.spCurYear.setRequired(true);
            this.spCurYear.setEditable(true);
            this.spCurPeriod.setRequired(true);
            this.spCurPeriod.setEditable(true);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.spCurPeriod, p, true, true);
        } else {
            this.kDLabelContainer4.setLocation(this.kDLabelContainer4.getX(), 10);
            this.kDLabelContainer3.setLocation(this.kDLabelContainer3.getX(), 32);
            this.kDLabelContainer5.setLocation(this.kDLabelContainer5.getX(), 54);
            this.kDLabelContainer6.setLocation(this.kDLabelContainer6.getX(), 76);
            this.kDLabelContainer1.setLocation(this.kDLabelContainer1.getX(), 98);
            this.kDLabelContainer2.setLocation(this.kDLabelContainer2.getX(), 120);
            this.kDLabelContainer7.setLocation(this.kDLabelContainer7.getX(), 142);
            this.kDSeparator1.setLocation(this.kDSeparator1.getX(), 164);
            this.cmdOK.setLocation(this.cmdOK.getX(), 174);
            this.cmdCancel.setLocation(this.cmdCancel.getX(), 174);
            this.rptDate.setEnabled(true);
            this.spCurYear.setEnabled(false);
            this.spCurPeriod.setEnabled(false);
            this.spCurYear.setEditable(false);
            this.spCurPeriod.setEditable(false);
            CslRptUIUtil.setSpineRange(this.spCurPeriod, 0, 365, true, true);
        }
        CslRptUIUtil.setSpineRange(this.spCurYear, 1900, 2999, true, true);
    }

    private void setOrgTree(OrgTreeInfo orgTree) {
        if (orgTree == null || orgTree.getNumber() == null) {
            return;
        }
        OrgTreeInfo tmpOrgTree = null;
        for (int i = 0; i < this.listOrgBound.getItemCount(); ++i) {
            tmpOrgTree = (OrgTreeInfo)this.listOrgBound.getItemAt(i);
            if (!tmpOrgTree.getNumber().equals(orgTree.getNumber()) || tmpOrgTree.getId().equals((Object)orgTree.getId())) continue;
            this.listOrgBound.removeItem((Object)tmpOrgTree);
            this.listOrgBound.insertItemAt((Object)orgTree, i);
            this.listOrgBound.setSelectedItem((Object)orgTree);
            return;
        }
        this.listOrgBound.setSelectedItem((Object)orgTree);
    }

    private boolean isMergeByFiscalPeriod() {
        RptPeriodTypeEnum p = RptPeriodTypeEnum.MONTHLY;
        if (this.listPeriodType.getSelectedItem() != null && this.listPeriodType.getSelectedItem() instanceof RptPeriodTypeEnum) {
            p = (RptPeriodTypeEnum)this.listPeriodType.getSelectedItem();
        }
        return this.isMergeByFiscalPeriod && !p.equals((Object)RptPeriodTypeEnum.DAILY) && !p.equals((Object)RptPeriodTypeEnum.WEEKLY);
    }

    private void initMergeByFiscalPeriodUI() {
        if (this.isMergeByFiscalPeriod) {
            this.setBounds(new Rectangle(290, 208));
            this.refreshMergeByFiscalPeriodUI();
        }
    }

    protected void initListener() {
        super.initListener();
        this.spCurYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CSLSysContextUI.this.refreshYear(false);
                if (!CSLSysContextUI.this.isMergeByFiscalPeriod()) {
                    CSLSysContextUI.this.refreshPeriod();
                }
            }
        });
        this.spCurPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CSLSysContextUI.this.refreshPeriod();
            }
        });
    }

    private static final void setKDComboBoxFireListener(KDComboBox comboBox, boolean isFireListener, boolean executeFireListener) {
        if (comboBox == null) {
            return;
        }
        try {
            Field field = comboBox.getClass().getDeclaredField("firelistener");
            NewRptUtil.makeAccessible((Field)field);
            field.set(comboBox, isFireListener);
        }
        catch (SecurityException e) {
            logger.error((Object)"setKDComboBoxFireListener_SecurityException", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"setKDComboBoxFireListener_IllegalArgumentException", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            logger.error((Object)"setKDComboBoxFireListener_NoSuchFieldException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"setKDComboBoxFireListener_IllegalAccessException", (Throwable)e);
        }
        if (executeFireListener) {
            comboBox.contentsChanged(null);
        }
    }
}

