/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLSysParamException;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextManager;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public final class CSLSysParamanager
implements Observer,
Serializable {
    private static final String CSLSYSCONTEXTUI_INFO_NOFINDORGBOUND = "NoFindOrgBound";
    public static final String CSLSYSPARAM_INFO_BASECURRENCY = "GR_CSL_BASECRY_001";
    public static final String CSLSYSPARAM_INFO_RATETABLE = "GR_CSL_CRYRATE_002";
    public static final String CSLSYSPARAM_INFO_ISUPTFORMATOFTEMPLET = "GR_CSL_TEMPMODE_003";
    public static final String CSLSYSPARAM_INFO_MERGETYPE = "GR_CSL_MERGETYPE_004";
    public static final String CSLSYSPARAM_INFO_ALLOW_UNDETAILITEM = "GR_CSL_DETAILITEM_005";
    public static final String CSLSYSPARAM_INFO_ELIMMETHOD = "GR_CSL_ELIMMETHOD_001";
    private static CSLSysParamanager sysParams = new CSLSysParamanager();
    private Map values = null;
    private static transient IParamControl iParamControl = null;
    private transient OrgTreeInfo orgBound = null;

    private CSLSysParamanager() {
    }

    public static CSLSysParamanager getInstance() {
        return sysParams;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof CSLContextManager && this.isRefresh()) {
            this.refreshParams();
        }
    }

    public boolean refreshParams() {
        boolean isTrue = false;
        try {
            if (this.orgBound != null && CSLSysParamanager.getSysParamKeys(this.orgBound) != null) {
                this.values = ParamManager.getParamHashMap((HashMap)CSLSysParamanager.getSysParamKeys(this.orgBound));
            }
            if (this.values != null && this.values.size() != 0) {
                isTrue = true;
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return isTrue;
    }

    public static HashMap getSysParamKeys(OrgTreeInfo orgTree) {
        if (orgTree == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(orgTree.getId());
        HashMap<String, ObjectUuidPK> keys = new HashMap<String, ObjectUuidPK>();
        keys.put(CSLSYSPARAM_INFO_BASECURRENCY, pk);
        keys.put(CSLSYSPARAM_INFO_RATETABLE, pk);
        keys.put(CSLSYSPARAM_INFO_ISUPTFORMATOFTEMPLET, pk);
        keys.put(CSLSYSPARAM_INFO_MERGETYPE, pk);
        keys.put(CSLSYSPARAM_INFO_ALLOW_UNDETAILITEM, pk);
        keys.put(CSLSYSPARAM_INFO_ELIMMETHOD, pk);
        return keys;
    }

    public static Map getSysParamValues(OrgTreeInfo orgTree) throws EASBizException, BOSException {
        HashMap vs = null;
        if (orgTree != null && CSLSysParamanager.getSysParamKeys(orgTree) != null) {
            vs = ParamManager.getParamHashMap((HashMap)CSLSysParamanager.getSysParamKeys(orgTree));
        }
        return vs;
    }

    public static String getSysParamValue(OrgTreeInfo orgTree, String keyString) throws EASBizException, BOSException {
        String v = null;
        ObjectUuidPK pk = new ObjectUuidPK(orgTree.getId());
        v = ParamManager.getParamValue((IObjectPK)pk, (String)keyString);
        return v;
    }

    public String getBaseCurrency() throws EASBizException {
        return this.getSysParamValue(CSLSYSPARAM_INFO_BASECURRENCY).toString();
    }

    public String getCurrencyRateTable() throws EASBizException {
        return this.getSysParamValue(CSLSYSPARAM_INFO_RATETABLE).toString();
    }

    public boolean getIsUptFormatOfTemplet() throws EASBizException {
        String v = this.getSysParamValue(CSLSYSPARAM_INFO_ISUPTFORMATOFTEMPLET).toString();
        return v.equalsIgnoreCase("true");
    }

    public int getMergeType() throws EASBizException {
        String v = this.getSysParamValue(CSLSYSPARAM_INFO_MERGETYPE).toString();
        return v.equalsIgnoreCase("0") ? 0 : 1;
    }

    public int getElimMethod() throws EASBizException {
        String v = this.getSysParamValue(CSLSYSPARAM_INFO_ELIMMETHOD).toString();
        if (v.equalsIgnoreCase("1")) {
            return 1;
        }
        if (v.equalsIgnoreCase("2")) {
            return 2;
        }
        if (v.equalsIgnoreCase("3")) {
            return 3;
        }
        if (v.equalsIgnoreCase("4")) {
            return 4;
        }
        return 0;
    }

    public boolean getIsAllowUnDetailItem() throws EASBizException {
        try {
            String v = this.getSysParamValue(CSLSYSPARAM_INFO_ALLOW_UNDETAILITEM).toString();
            return v.equalsIgnoreCase("true");
        }
        catch (CSLSysParamException e) {
            return false;
        }
    }

    private Object getSysParamValue(String keyString) throws EASBizException, CSLSysParamException {
        Object v = null;
        if (this.values == null || this.values.size() == 0) {
            this.refreshParams();
        }
        if (this.values == null || this.values.size() == 0) {
            throw new CSLSysParamException(CSLSysParamException.CONFIGCONTEXTFIRST);
        }
        if (this.values != null && this.values.size() != 0 && this.values.containsKey(keyString)) {
            v = this.values.get(keyString);
        }
        if (v == null) {
            NumericExceptionSubItem e = new NumericExceptionSubItem(CSLSysParamException.NOTSETSYSPARAMITEM.getCode(), CSLSysParamException.NOTSETSYSPARAMITEM.getName() + keyString);
            throw new CSLSysParamException(e, new Object[]{"Name"});
        }
        return v;
    }

    private boolean isRefresh() {
        boolean isRefresh = false;
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        OrgTreeInfo curOrgBound = null;
        try {
            curOrgBound = ctx.getCurOrgBound();
        }
        catch (BOSException e) {
            return false;
        }
        if (curOrgBound != null) {
            if (this.orgBound == null) {
                isRefresh = true;
            } else if (!this.orgBound.getId().toString().equals(curOrgBound.getId().toString())) {
                isRefresh = true;
            }
        }
        if (isRefresh) {
            this.orgBound = curOrgBound;
        }
        return isRefresh;
    }
}

