/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLTemplateExportUI;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class CSLTemplateExportUI
extends AbstractCSLTemplateExportUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLTemplateExportUI.class);
    private static final int PackEntry_OrgUnit = 0;
    private static final int PackEntry_Templates = 1;
    private static final int PackEntry_Currencys = 2;
    private static final int PackEntry_Companys = 3;
    private Boolean select = true;
    private Boolean unSelect = false;

    public void onLoad() throws Exception {
        super.onLoad();
        super.setDataObject("cSLTemplateQuery", (IObjectValue)new EntityViewInfo());
        super.setDataObject("currencyDefaultF7Query", (IObjectValue)new EntityViewInfo());
        this.initTree();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    protected void orgTree_valueChanged(TreeSelectionEvent e) throws Exception {
        if (e.getOldLeadSelectionPath() != null && 0 == MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"415_CSLTemplateExportUI"))) {
            this.packOneExport();
        }
        this.tablelTemplate.removeRows();
        this.tableCurrency.removeRows();
    }

    private ArrayList packOneExport() {
        ArrayList<Object> result = new ArrayList<Object>(4);
        result.add(0, this.getSelectOrgUnit(this.orgTree));
        result.add(1, this.getSelectTemplates());
        result.add(2, this.getSelectCurrencys());
        result.add(3, this.getSelectRelatedCompany());
        return result;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private void initTree() throws EASBizException, BOSException {
        DefaultTreeModel model = null;
        try {
            model = (DefaultTreeModel)NewOrgUtils.getTreeModel((OrgViewType)OrgViewType.COMPANY, (String)"00000000-0000-0000-0000-0000000000024F2827FD", (String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString(), null, null);
            DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)model.getRoot();
            model.setAsksAllowsChildren(true);
            this.orgTree.setModel((TreeModel)model);
            this.orgTree.setSelectionNode(rootNode);
            this.orgTree.getSelectionModel().setSelectionMode(2);
            this.orgTree.expandAllNodes(true, (TreeNode)rootNode);
            this.orgTree.setShowCheckBox(true);
            this.companyTree.setModel((TreeModel)model);
            this.companyTree.setSelectionNode(rootNode);
            this.companyTree.getSelectionModel().setSelectionMode(2);
            this.companyTree.expandAllNodes(true, (TreeNode)rootNode);
            this.companyTree.setShowCheckBox(true);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tablelTemplate.getRowCount(); ++i) {
            this.tablelTemplate.getRow(i).getCell(1).setValue((Object)this.select);
        }
    }

    public void btnSelectNo_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tablelTemplate.getRowCount(); ++i) {
            this.tablelTemplate.getRow(i).getCell(1).setValue((Object)this.unSelect);
        }
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        if ("CSLTemplateQuery".equalsIgnoreCase(queryPK.getName())) {
            int index = 1;
            FullOrgUnitInfo orgUnit = null;
            orgUnit = this.getSelectOrgUnit(this.orgTree);
            if (orgUnit != null) {
                try {
                    exec.setParameter(index, (Object)orgUnit.getId().toString());
                }
                catch (BOSException e) {
                    logger.error((Object)"getQueryExecutor_BOSException", (Throwable)e);
                }
            } else {
                return null;
            }
        }
        return exec;
    }

    private FullOrgUnitInfo getSelectOrgUnit(KDTree tree) {
        DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        if (currentNode == null) {
            return null;
        }
        Object orgStructure = currentNode.getUserObject();
        if (orgStructure == null || !(orgStructure instanceof OrgStructureInfo)) {
            return null;
        }
        FullOrgUnitInfo orgUnit = ((OrgStructureInfo)orgStructure).getUnit();
        if (orgUnit == null) {
            return null;
        }
        return orgUnit;
    }

    @Override
    public void actionExportKDT_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportKDT_actionPerformed(e);
        FullOrgUnitInfo orgUnitInfo = this.getSelectOrgUnit(this.orgTree);
        if (orgUnitInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"416_CSLTemplateExportUI"));
        }
        this.chooseDirectory(orgUnitInfo);
    }

    private String chooseDirectory(FullOrgUnitInfo orgUnit) {
        KDFileChooser cuz = new KDFileChooser();
        cuz.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"417_CSLTemplateExportUI"));
        cuz.setFileSelectionMode(1);
        String path = null;
        if (cuz.showSaveDialog((Component)((Object)this)) == 0) {
            File file = cuz.getSelectedFile();
            String name = file.getName();
            if (name.matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
                MsgBox.showWarning((String)(name + "\n" + RptUtil.getReportResource((String)"invalidFileName")));
            }
            if (file != null) {
                path = file.getAbsolutePath() + "\\" + orgUnit.getName().trim() + ".kdt";
            }
        }
        return path;
    }

    private TemplateCollection getSelectTemplates() {
        int templateCount = this.tablelTemplate.getRowCount();
        TemplateCollection templateCol = new TemplateCollection();
        TemplateInfo info = new TemplateInfo();
        for (int i = 0; i < templateCount; ++i) {
            IRow curRow = this.tablelTemplate.getRow(i);
            boolean isSelected = (Boolean)curRow.getCell(1).getValue();
            if (!isSelected) continue;
            info = (TemplateInfo)info.clone();
            info.setId(BOSUuid.read((String)curRow.getCell(0).getValue().toString()));
            info.setVersionNumber(curRow.getCell(2).getValue().toString());
            info.setName(curRow.getCell(1).getValue().toString());
            info.setName(curRow.getCell(1).getValue().toString());
            info.setName(curRow.getCell(1).getValue().toString());
            info.setName(curRow.getCell(1).getValue().toString());
            templateCol.add(info);
        }
        return templateCol;
    }

    private CurrencyCollection getSelectCurrencys() {
        int currencyCount = this.tableCurrency.getRowCount();
        CurrencyCollection currencyCol = new CurrencyCollection();
        CurrencyInfo info = new CurrencyInfo();
        for (int i = 0; i < currencyCount; ++i) {
            IRow curRow = this.tableCurrency.getRow(i);
            boolean isSelected = (Boolean)curRow.getCell(1).getValue();
            if (!isSelected) continue;
            info = (CurrencyInfo)info.clone();
            info.setName(curRow.getCell(1).getValue().toString());
            info.setName(curRow.getCell(1).getValue().toString());
            info.setName(curRow.getCell(1).getValue().toString());
            info.setName(curRow.getCell(1).getValue().toString());
            currencyCol.add(info);
        }
        return currencyCol;
    }

    private OrgUnitCollection getSelectRelatedCompany() {
        int templateCount = this.tablelTemplate.getRowCount();
        this.companyTree.getSelectionPaths();
        ((DefaultKingdeeTreeNode)this.companyTree.getLastSelectedPathComponent()).getCheckedValue();
        OrgUnitCollection companys = new OrgUnitCollection();
        OrgUnitInfo info = new OrgUnitInfo();
        for (int i = 0; i < templateCount; ++i) {
            IRow curRow = this.tablelTemplate.getRow(i);
            boolean isSelected = (Boolean)curRow.getCell(1).getValue();
            if (!isSelected) continue;
            info = (OrgUnitInfo)info.clone();
            info.setId(BOSUuid.read((String)curRow.getCell(0).getValue().toString()));
            companys.add(info);
        }
        return companys;
    }
}

