/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.message.client.MAGroupReF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLSchemeTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.SchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLUploadConfigUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SchemeEditUI;
import com.kingdee.eas.fi.gr.cslrpt.util.FTPUpDown;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class CSLUploadConfigUI
extends AbstractCSLUploadConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLUploadConfigUI.class);
    private String ServerSelectSchemeID = "";
    private SchemeInfo filePathScheme = null;
    private HashMap filePathAdapterObject = null;
    private HashMap ExportConfigMap = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.ExportConfigMap = (HashMap)this.getUIContext().get("ExportConfig");
        this.initialControl();
        this.refreshServerScheme();
        this.refreshFilePathScheme();
    }

    private void initialControl() throws BOSException {
        MAGroupReF7 mAGroupReF7 = new MAGroupReF7((IUIObject)this);
        this.prmptMailReceiver.setSelector((KDPromptSelector)mAGroupReF7);
        this.btnSaveConfig.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSchemeSave.setText(null);
        this.btnSchemeDelete.setText(null);
        this.btnSchemeSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSchemeDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
    }

    private void refreshServerScheme() throws BOSException {
        SchemeCollection serverSchemes = SchemeFactory.getRemoteInstance().getSchemeCollection("where type = 3");
        this.combServerScheme.removeAllItems();
        this.combServerScheme.addItems(serverSchemes.toArray());
        this.combServerScheme.addItem(null);
        if (!StringUtils.isEmpty((String)this.ServerSelectSchemeID)) {
            Iterator iter = serverSchemes.iterator();
            while (iter.hasNext()) {
                SchemeInfo element = (SchemeInfo)iter.next();
                if (!this.ServerSelectSchemeID.equals(element.getNumber())) continue;
                this.combServerScheme.getModel().setSelectedItem(element);
                break;
            }
        }
    }

    private void refreshFilePathScheme() throws BOSException, DocumentException, IOException {
        SchemeCollection filePathSchemes = SchemeFactory.getRemoteInstance().getSchemeCollection("where type = 2 and number = '" + this.getMetaDataPK().getFullName() + "' ");
        Iterator iter = filePathSchemes.iterator();
        while (iter.hasNext()) {
            SchemeInfo element = (SchemeInfo)iter.next();
            HashMap pathMap = (HashMap)element.getAdapterObject(CSLSchemeTypeEnum.SAVEPATH);
            if (pathMap == null || !this.getMetaDataPK().getFullName().equalsIgnoreCase((String)pathMap.get("relateUI"))) continue;
            this.txtPath.setText((String)pathMap.get("relatePath"));
            this.filePathScheme = element;
            this.filePathAdapterObject = pathMap;
            return;
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
        this.updateSchemeInfo();
        SchemeFactory.getRemoteInstance().submit(this.filePathScheme);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.updateSchemeInfo();
            SchemeFactory.getRemoteInstance().submit(this.filePathScheme);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return super.checkBeforeWindowClosing();
    }

    private void updateSchemeInfo() throws DocumentException, IOException {
        if (this.filePathAdapterObject == null) {
            this.filePathAdapterObject = new HashMap();
            this.filePathAdapterObject.put("relateUI", this.getMetaDataPK().getFullName());
        }
        this.filePathAdapterObject.put("relatePath", this.txtPath.getText());
        if (this.filePathScheme == null) {
            this.filePathScheme = new SchemeInfo();
            this.filePathScheme.setNumber(this.getMetaDataPK().getFullName());
            this.filePathScheme.setName(this.getMetaDataPK().getFullName());
        }
        this.filePathScheme.setAdapterObject(CSLSchemeTypeEnum.SAVEPATH, this.filePathAdapterObject);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    protected void combServerScheme_actionPerformed(ActionEvent e) throws Exception {
        super.combServerScheme_actionPerformed(e);
        Object config = null;
        SchemeInfo scheme = (SchemeInfo)((KDComboBox)e.getSource()).getModel().getSelectedItem();
        if (scheme != null && (config = scheme.getAdapterObject(CSLSchemeTypeEnum.EXPORTCOMPANY)) instanceof HashMap) {
            this.setServerConfig((HashMap)config);
        } else {
            this.setServerConfig(null);
        }
    }

    private HashMap getServerConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)this.txtServerAddress.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"365_CSLReportImportUI"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtLoginName.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"366_CSLReportImportUI"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtLoginPassword.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"367_CSLReportImportUI"));
            SysUtil.abort();
        }
        config.put("serverAddress", this.txtServerAddress.getText().trim());
        config.put("serverDirectory", this.txtServerDir.getText().trim());
        config.put("serverLoginName", this.txtLoginName.getText().trim());
        config.put("serverLoginPassword", this.txtLoginPassword.getText().trim());
        config.put("EXPORTCONFIG_FTP_FROMLOCAL", this.checkFTPIsFromLocal.isSelected() ? "TRUE" : "FALSE");
        config.put("EXPORTCONFIG_MAIL_CHECK", this.checkMail.isSelected() ? "TRUE" : "FALSE");
        config.put("EXPORTCONFIG_MAIL_FROMLOCAL", this.checkMailIsFromLocal.isSelected() ? "TRUE" : "FALSE");
        return config;
    }

    private void setServerConfig(HashMap config) {
        if (config == null) {
            this.txtServerAddress.setText(null);
            this.txtServerDir.setText("");
            this.txtLoginName.setText(null);
            this.txtLoginPassword.setText(null);
            this.checkFTPIsFromLocal.setSelected(false);
            this.checkMail.setSelected(false);
            this.checkMailIsFromLocal.setSelected(false);
        } else {
            this.txtServerAddress.setText(config.get("serverAddress").toString());
            this.txtServerDir.setText(config.get("serverDirectory").toString());
            this.txtLoginName.setText(config.get("serverLoginName").toString());
            this.txtLoginPassword.setText(config.get("serverLoginPassword").toString());
            this.checkFTPIsFromLocal.setSelected("TRUE".equals(config.get("EXPORTCONFIG_FTP_FROMLOCAL")));
            this.checkMail.setSelected("TRUE".equals(config.get("EXPORTCONFIG_MAIL_CHECK")));
            this.checkMailIsFromLocal.setSelected("TRUE".equals(config.get("EXPORTCONFIG_MAIL_FROMLOCAL")));
        }
    }

    private void checkSchemeSelect(KDComboBox comb) {
        if (comb.getSelectedItem() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"345_CSLReportImportUI"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnSchemeDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnSchemeDelete_actionPerformed(e);
        this.checkSchemeSelect(this.combServerScheme);
        SchemeInfo selectInfo = (SchemeInfo)this.combServerScheme.getSelectedItem();
        SchemeFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(selectInfo.getId()));
        this.combServerScheme.removeItem((Object)selectInfo);
    }

    @Override
    protected void btnSchemeSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnSchemeSave_actionPerformed(e);
        HashMap config = this.getServerConfig();
        if (this.combServerScheme.getModel().getSelectedItem() != null) {
            SchemeInfo info = (SchemeInfo)this.combServerScheme.getModel().getSelectedItem();
            info.setAdapterObject(CSLSchemeTypeEnum.FTPSERVERCONFIG, config);
            SchemeFactory.getRemoteInstance().submit(info);
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"420_CSLUploadConfigUI"));
            this.showMessage();
            return;
        }
        if (this.openSchemeEditUI(CSLSchemeTypeEnum.FTPSERVERCONFIG, config, this.ServerSelectSchemeID)) {
            this.refreshServerScheme();
        }
    }

    private boolean openSchemeEditUI(CSLSchemeTypeEnum adapterType, Object adapterObject, String selectSchemeID) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Scheme_AdapterType", (Object)adapterType);
        uiContext.put((Object)"Scheme_AdapterObject", adapterObject);
        uiContext.put((Object)"Scheme_SelectSchemeID", (Object)selectSchemeID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SchemeEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        return ((SchemeEditUI)uiWindow.getUIObject()).isSuccess();
    }

    @Override
    protected void btnChoosePath_actionPerformed(ActionEvent e) throws Exception {
        super.btnChoosePath_actionPerformed(e);
        String exportDirPath = this.chooseDirectory();
        this.txtPath.setText(exportDirPath);
    }

    private String chooseDirectory() {
        KDFileChooser cuz = new KDFileChooser();
        cuz.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"364_CSLReportImportUI"));
        cuz.setFileSelectionMode(1);
        String path = null;
        if (cuz.showSaveDialog((Component)((Object)this)) == 0) {
            File file = cuz.getSelectedFile();
            String name = file.getName();
            if (name.matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
                MsgBox.showWarning((String)(name + "\n" + RptUtil.getReportResource((String)"invalidFileName")));
            }
            if (file != null) {
                path = file.getAbsolutePath();
            }
        }
        return path;
    }

    @Override
    protected void btnTestTest_actionPerformed(ActionEvent e) throws Exception {
        super.btnTestTest_actionPerformed(e);
        HashMap config = this.getServerConfig();
        try {
            new FTPUpDown(config.get("serverAddress").toString(), "", config.get("serverLoginName").toString(), config.get("serverLoginPassword").toString());
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"342_CSLReportImportUI"));
            SysUtil.abort();
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"343_CSLReportImportUI"));
    }

    @Override
    public void actionSaveConfig_actionPerformed(ActionEvent e) throws Exception {
        super.actionSaveConfig_actionPerformed(e);
        this.saveBeforeCheck();
        this.installConfig();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"421_CSLUploadConfigUI"));
    }

    private void installConfig() {
        this.ExportConfigMap.put("ExportConfig_ItemFile_Path", this.txtPath.getText());
        this.ExportConfigMap.put("ExportConfig_ItemFTP_ServerIP", this.txtServerAddress.getText());
        this.ExportConfigMap.put("ExportConfig_ItemFTP_ServerDIR", this.txtServerDir.getText());
        this.ExportConfigMap.put("ExportConfig_ItemFTP_LoginName", this.txtLoginName.getText());
        this.ExportConfigMap.put("ExportConfig_ItemFTP_Password", this.txtLoginPassword.getText());
        this.ExportConfigMap.put("ExportConfig_ItemFTP_IsFromLocal", this.checkFTPIsFromLocal.isSelected());
        this.ExportConfigMap.put("ExportConfig_ItemMail_IsFromLocal", this.checkMailIsFromLocal.isSelected());
        this.ExportConfigMap.put("ExportConfig_ItemMail_CHECK", this.checkMail.isSelected());
        this.ExportConfigMap.put("ExportConfig_ITemMail_MailGroup", this.prmptMailReceiver.getData());
    }

    private void saveBeforeCheck() {
        if (!StringUtils.isEmpty((String)this.txtPath.getText())) {
            File file = new File(this.txtPath.getText());
            this.ExportConfigMap.put("ExportConfig_ItemFile_Path", this.txtPath.getText());
            if (!file.exists()) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"422_CSLUploadConfigUI"));
                SysUtil.abort();
            }
        }
        if ((this.checkFTPIsFromLocal.isSelected() || this.checkMailIsFromLocal.isSelected()) && StringUtils.isEmpty((String)this.txtPath.getText())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"423_CSLUploadConfigUI"));
            SysUtil.abort();
        }
        Object obj = this.prmptMailReceiver.getValue();
        if (this.checkMail.isSelected() && (obj == null || obj instanceof ArrayList && ((ArrayList)obj).size() == 0)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"424_CSLUploadConfigUI"));
            SysUtil.abort();
        }
    }
}

