/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCaliAdjustRptListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CaliAdjustAfterRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CaliAdjustRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ViewAdjRptOldVersionListUI;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class CaliAdjustRptListUI
extends AbstractCaliAdjustRptListUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(CaliAdjustRptListUI.class);
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private OrgUnitInfo company = null;
    private OrgTreeInfo orgBound = null;
    private CommonQueryDialog commqueryDialog = null;
    GroupRptFilterUI conditionPanel = null;
    private Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
    private FilterInfo currentFilter = null;

    public String getReportUIName() {
        return ReportProcessUI.class.getName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.menuItemOldVersion.setEnabled(true);
        this.menuItemOldVersion.setIcon(EASResource.getIcon((String)"imgTbtn_seequestionnaire"));
    }

    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.company = this.ctx.getCurOrgGroup();
        this.orgBound = this.ctx.getCurOrgBound();
        this.initTree(this.company);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getViewManager().setFreezeView(0, 4);
        this.menuSwitch.setVisible(false);
        this.menuItemParamManage.setVisible(false);
        if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
            this.rptArchive();
        }
        if ("true".equals(this.isSupportOtherDS)) {
            this.tblMain.getColumn("datacollect").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("datacollect").getStyleAttributes().setHided(true);
        }
        this.initWorkButton();
        this.mainQueryPK = this.initQueryBudget();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, (CoreUI)this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (CslRptUtil.isQueryBudget() == 1) {
            return HisCslReportFactory.getRemoteInstance();
        }
        return CslReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return CaliAdjustRptEditUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getSelectors());
    }

    protected CslReportInfo getReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return (CslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    private void doRefresh(IUIWindow uiWindow, ActionEvent e) {
        final CoreUI editUI = (CoreUI)uiWindow.getUIObject();
        final ActionEvent fe = e;
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                try {
                    if ("TRUE".equals(editUI.getUIContext().get("isSaved"))) {
                        CaliAdjustRptListUI.this.refresh(fe);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo selectedCompany = this.getSelectedCompany();
        if (selectedCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CompanyNull"));
            SysUtil.abort();
        }
        BOSUuid pk = selectedCompany.getId();
        IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        iOrgUnit.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        TreeModel model = this.treeCompany.getModel();
        DefaultKingdeeTreeNode n = (DefaultKingdeeTreeNode)model.getRoot();
        ArrayList lst = new ArrayList();
        this.getOrgTree(n, lst);
        uiContext.put((Object)"CSL_ORGS", lst);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow newWindow = uiFactory.create(this.getEditUIName(), (Map)uiContext, null);
        this.doRefresh(newWindow, e);
        newWindow.show();
    }

    private void getOrgTree(DefaultKingdeeTreeNode node, List lst) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            lst.add(child.getUserObject());
            this.getOrgTree(child, lst);
        }
    }

    protected void rptArchive() {
        this.btnAddNew.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.menuItemExportData.setEnabled(false);
        this.menuItemImportData.setEnabled(false);
        this.menuItemPublishReport.setEnabled(false);
        this.menuItemRemove.setEnabled(false);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        try {
            this.getBizInterface().getValue((IObjectPK)pk, selectors);
        }
        catch (Exception ex) {
            this.refresh(e);
            throw ex;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"isCaliAdjustRpt", (Object)Boolean.TRUE);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(CslRptUtil.isQueryBudget()));
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow newWindow = factory.create(this.getProcessUIName(), (Map)uiContext, null, OprtState.VIEW);
        this.doRefresh(newWindow, e);
        newWindow.show();
    }

    private String getProcessUIName() {
        return CaliAdjustAfterRptProcessUI.class.getName();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(CslRptUtil.isQueryBudget()));
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getProcessUIName(), (Map)uiContext, null, OprtState.EDIT);
        curUIWindow.show();
    }

    private void buildTreeFilter() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent();
        OrgUnitInfo obj = OrgClientUtils.getOrgUnitFromTreeNode((DefaultKingdeeTreeNode)treeNode);
        FilterInfo filterInfo = this.mainQuery.getFilter();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        FilterItemCollection col = filterInfo.getFilterItems();
        StringBuffer maskString = new StringBuffer();
        if (!StringUtils.isEmpty((String)filterInfo.getMaskString())) {
            maskString.append("(" + filterInfo.getMaskString() + ") ");
        }
        int filterParamsIndex = filterInfo.getFilterItems().size();
        try {
            if (this.ctx.isQueryBudget()) {
                col.add(new FilterItemInfo("orgTree.id", (Object)this.ctx.getCurOrgBound().getId().toString(), CompareType.EQUALS));
                maskString.append("#" + filterParamsIndex++);
            }
            col.add(new FilterItemInfo("year", (Object)new Integer(this.ctx.getCurRptYear()), CompareType.EQUALS));
            if (!StringUtils.isEmpty((String)maskString.toString())) {
                maskString.append(" and ");
            }
            maskString.append(" #" + filterParamsIndex++);
            col.add(new FilterItemInfo("period", (Object)new Integer(this.ctx.getCurRptPeriod()), CompareType.EQUALS));
            maskString.append(" and #" + filterParamsIndex++);
            col.add(new FilterItemInfo("periodType", (Object)new Integer(this.ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS));
            maskString.append(" and #" + filterParamsIndex++);
            if ("true".equals(this.isSupportOtherDS)) {
                FilterItemInfo filterItem4 = new FilterItemInfo("dataCollect.number", (Object)this.ctx.getCurDataCollect().getNumber(), CompareType.EQUALS);
                col.add(filterItem4);
                maskString.append(" and #" + filterParamsIndex++);
            } else {
                FilterItemInfo filterItem5 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
                col.add(filterItem5);
                maskString.append(" and #" + filterParamsIndex++);
            }
            if (obj != null && obj instanceof OrgUnitInfo) {
                OrgUnitInfo orgUnit = obj;
                col.add(new FilterItemInfo("orgUnit.id", (Object)orgUnit.getId().toString()));
                maskString.append(" and #" + filterParamsIndex++);
            }
            if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
                this.rptArchive();
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
            SysUtil.abort();
        }
        filterInfo.setMaskString(maskString.toString());
        this.mainQuery.setFilter(filterInfo);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (e.getSource() == this.btnAddNew || e.getSource() == this.menuItemAddNew) {
            OrgUnitInfo selectedCompany = this.getSelectedCompany();
            if (selectedCompany == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CompanyNull"));
                SysUtil.abort();
            }
            uiContext.put((Object)"company", (Object)selectedCompany);
        }
    }

    private OrgUnitInfo getSelectedCompany() {
        OrgUnitInfo selectedCompany = null;
        if (this.treeCompany.getSelectionCount() > 0) {
            OrgUnitInfo obj;
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent();
            selectedCompany = obj = OrgClientUtils.getOrgUnitFromTreeNode((DefaultKingdeeTreeNode)treeNode);
        }
        return selectedCompany;
    }

    private void initTree(OrgUnitInfo currCompany) {
        try {
            this.viewCompany.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setTreeID(this.orgBound.getId().toString());
            f7.setRootUnitID(currCompany.getId().toString());
            f7.setMultiSelect(false);
            TreeModel model = f7.buildTreeModel(OrgViewType.UNIONDEBT, this.orgBound, null);
            this.treeCompany.setModel(model);
            this.treeCompany.setSelectionRow(0);
            MergeModeEnum mergeType = CslRptUtil.getMergeMode(this.orgBound);
            if (MergeModeEnum.ORDINAL.equals((Object)mergeType)) {
                f7.filterUnitSql(UnionF7Helper.getMergeModeOrgUnitIDSql((String)this.orgBound.getId().toString(), (String)this.company.getId().toString(), (MergeModeEnum)mergeType));
            }
            UnionF7Helper.addTreeWillExpandListener((KDTree)this.treeCompany, (OrgTreeInfo)this.orgBound, (UnionF7Helper.UnionF7)f7);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public GroupRptFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new GroupRptFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        this.mainQueryPK = this.initQueryBudget();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = CaliAdjustRptListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.commqueryDialog == null) {
                this.commqueryDialog = this.initCommonQueryDialog();
                this.commqueryDialog.setProcessor((IProcessor)new CommonQueryProcessor(){

                    public void process() throws Exception {
                        String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                        if (fieldProperty.equalsIgnoreCase("sourceType")) {
                            KDComboBox cmbxSourceType = (KDComboBox)this.get("CURRENT_EDITOR");
                            for (int i = cmbxSourceType.getItemCount() - 1; i > 0; --i) {
                                RptSrcTypeEnum rptSrcType = (RptSrcTypeEnum)cmbxSourceType.getItemAt(i);
                                if (rptSrcType.getValue() == 1 || rptSrcType.getValue() == 2 || rptSrcType.getValue() == 3 || rptSrcType.getValue() == 10 || rptSrcType.getValue() == 11 || rptSrcType.getValue() == 12) continue;
                                cmbxSourceType.removeItemAt(i);
                            }
                        }
                    }
                });
                CslRptUIUtil.standardFilterUI(this.commqueryDialog, this);
            }
            if (this.commqueryDialog.show()) {
                this.doQuery(this.commqueryDialog);
                this.mainQuery = this.commqueryDialog.getEntityViewInfoResult();
                this.buildTreeFilter();
                this.tblMain.removeRows();
            } else {
                SysUtil.abort();
            }
        } else if (this.mainQuery != null && this.currentFilter == null) {
            this.currentFilter = this.mainQuery.getFilter();
        }
        String dateTime = CslRptUIUtil.getNationalTimeFormatString();
        if (dateTime != null) {
            this.tblMain.getColumn("year").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("period").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(dateTime);
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(dateTime);
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(dateTime);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    private void processNodeIcon(DefaultKingdeeTreeNode node) {
        FullOrgUnitInfo orgUnit;
        if (node == null) {
            return;
        }
        boolean isGroup = false;
        Object orgStructure = node.getUserObject();
        if (orgStructure != null && (orgUnit = ((OrgStructureInfo)orgStructure).getUnit()) != null) {
            isGroup = orgUnit.isIsGrouping();
        }
        if (!node.isLeaf() || isGroup) {
            node.setAllowsChildren(true);
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.processNodeIcon((DefaultKingdeeTreeNode)node.getChildAt(i));
            }
        } else {
            node.setAllowsChildren(false);
        }
    }

    @Override
    protected void treeCompany_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeCompany_valueChanged(e);
        if (this.commqueryDialog != null) {
            EntityViewInfo info = this.commqueryDialog.getEntityViewInfoResult();
            if (info == null) {
                info = new EntityViewInfo();
                info.setFilter(new FilterInfo());
            }
            this.mainQuery = info;
        } else {
            this.mainQuery = new EntityViewInfo();
            if (this.currentFilter != null) {
                this.mainQuery.setFilter((FilterInfo)this.currentFilter.clone());
            } else {
                this.mainQuery.setFilter(new FilterInfo());
            }
        }
        this.buildTreeFilter();
        this.execQuery();
    }

    @Override
    public void actionOldVersion_actionPerformed(ActionEvent e) throws Exception {
        String reportId = this.getSelectedKeyValue();
        if (reportId == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"CompanyRptList_Dialog_RptSelect"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)reportId);
            IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ViewAdjRptOldVersionListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            curUIWindow.show();
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    private MetaDataPK initQueryBudget() {
        MetaDataPK mdPK = null;
        try {
            if (CSLContextHelper.getCSLContext().isQueryBudget()) {
                mdPK = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt", "HisCaliAdjustAfterRptQuery");
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionAddNew.setVisible(false);
                this.actionEdit.setVisible(false);
                this.actionRemove.setVisible(false);
                this.menuEdit.setEnabled(false);
                this.menuEdit.setVisible(false);
                this.actionOldVersion.setEnabled(false);
                this.actionOldVersion.setVisible(false);
            } else {
                mdPK = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt", "CaliAdjustAfterRptQuery");
            }
        }
        catch (BOSException e) {
            logger.error((Object)"isQueryBudget()_BOSException", (Throwable)e);
        }
        return mdPK;
    }

    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
        this.initQueryBudget();
    }
}

