/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustMode;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCaliCopyHisDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class CaliCopyHisDataFilterUI
extends AbstractCaliCopyHisDataFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CaliCopyHisDataFilterUI.class);
    private String selectAll = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private ICurrency iCurrency = null;
    private IAdjustMode iAdjustMode = null;
    private ICSLContext ctx = null;

    public CaliCopyHisDataFilterUI() throws Exception {
        this.init();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void init() throws Exception {
        this.ctx = CSLContextHelper.getCSLContext();
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        for (int i = 1; i <= 6; ++i) {
            this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.getEnum((int)i));
        }
        this.cbxPeriodType.setSelectedItem((Object)this.ctx.getCurRptPeriodType());
        this.spYear.setEnabled(false);
        this.spPeriod.setEnabled(false);
        this.repDate.setValue((Object)this.ctx.getCurReportDate());
        this.cbxAdjustMode.addItem((Object)this.selectAll);
        this.cbxAdjustMode.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        AdjustModeCollection adjustModeCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            if (this.iAdjustMode == null) {
                this.iAdjustMode = AdjustModeFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(true);
            adjustModeCollection = this.iAdjustMode.getAdjustModeCollection(viewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            this.cbxCurrency.addItem((Object)this.selectAll);
            this.cbxSourceCurrency.addItem((Object)this.selectAll);
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cbxCurrency.addItem((Object)currencyCollection.get(i));
                this.cbxSourceCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
        if (adjustModeCollection != null && adjustModeCollection.size() > 0) {
            for (int i = 0; i < adjustModeCollection.size(); ++i) {
                this.cbxAdjustMode.addItem((Object)adjustModeCollection.get(i));
            }
        }
        try {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setMultiSelect(false);
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            this.bizPrmtCompany.setSelector((KDPromptSelector)f7);
            this.bizPrmtCompany.setEditable(true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.txtDebitFrom.setSupportedEmpty(true);
        this.txtDebitTo.setSupportedEmpty(true);
        this.txtCreditFrom.setSupportedEmpty(true);
        this.txtCreditTo.setSupportedEmpty(true);
    }

    public FilterInfo getFilterInfo() {
        StringBuffer sbFormula;
        int formulaIndex;
        block28: {
            FilterItemInfo filterItemCurrency;
            if (this.filterInfo == null) {
                this.filterInfo = new FilterInfo();
            } else {
                this.filterInfo.getFilterItems().clear();
            }
            formulaIndex = 0;
            sbFormula = new StringBuffer();
            try {
                FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.number", (Object)this.ctx.getCurOrgBound().getNumber(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItem0);
                sbFormula.append(" #" + formulaIndex++);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
            if (this.cbxPeriodType.getSelectedItem() != null) {
                Integer periodType = new Integer(((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue());
                FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)periodType, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterPeriodType);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.repDate.getValue() != null) {
                Date reportDate = (Date)this.repDate.getValue();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(reportDate);
                calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                Timestamp date = new Timestamp(calendar.getTimeInMillis());
                FilterItemInfo filterDate = new FilterItemInfo("date", (Object)date, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterDate);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.spYear.getValue() != null) {
                FilterItemInfo filterYear = new FilterItemInfo("year", (Object)((Integer)this.spYear.getValue()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterYear);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.spPeriod.getValue() != null) {
                FilterItemInfo filterPeriod = new FilterItemInfo("period", (Object)((Integer)this.spPeriod.getValue()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterPeriod);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.cbxAdjustMode.getSelectedItem() != null && !this.cbxAdjustMode.getSelectedItem().equals(this.selectAll)) {
                String adjustModeId = ((AdjustModeInfo)this.cbxAdjustMode.getSelectedItem()).getId().toString();
                FilterItemInfo filterItemAdjustMode = new FilterItemInfo("adjustMode.id", (Object)adjustModeId, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemAdjustMode);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
                filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemCurrency);
                sbFormula.append(" and #" + formulaIndex++);
            } else if (this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
                filterItemCurrency = new FilterItemInfo("currency.id", (Object)this.selectAll, CompareType.NOTEQUALS);
                this.filterInfo.getFilterItems().add(filterItemCurrency);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.cbxSourceCurrency.getSelectedItem() != null && !this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
                filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.cbxSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemCurrency);
                sbFormula.append(" and #" + formulaIndex++);
            } else if (this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
                filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)this.selectAll, CompareType.NOTEQUALS);
                this.filterInfo.getFilterItems().add(filterItemCurrency);
                sbFormula.append(" and #" + formulaIndex++);
            }
            try {
                String number;
                OrgUnitInfo uif;
                if (this.bizPrmtCompany.getData() != null) {
                    uif = (OrgUnitInfo)this.bizPrmtCompany.getData();
                    number = uif.getNumber();
                    FilterItemInfo filterItemCompany = new FilterItemInfo("orgUnit.number", (Object)number, CompareType.EQUALS);
                    this.filterInfo.getFilterItems().add(filterItemCompany);
                    sbFormula.append("  and  #" + formulaIndex++);
                    break block28;
                }
                uif = this.ctx.getCurOrgGroup();
                number = CslRptUIUtil.getCompanyStructureNumber(this.ctx.getCurOrgBound(), uif);
                this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)(number + "!%"), CompareType.LIKE));
                this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)number, CompareType.EQUALS));
                int mergeMode = 1;
                try {
                    mergeMode = CslRptUtil.getMergeMode(this.ctx.getCurOrgBound()).getValue();
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                if (1 == mergeMode) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)(number + "!%!%"), CompareType.NOTLIKE));
                    sbFormula.append(" and (#" + formulaIndex++ + " or #" + formulaIndex++ + ")  and #" + formulaIndex++);
                } else {
                    sbFormula.append(" and (#" + formulaIndex++ + " or #" + formulaIndex++ + ") ");
                }
            }
            catch (BOSException e2) {
                this.handUIException(e2);
            }
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        FilterItemInfo citeByLater = new FilterItemInfo("isCitedByLater", (Object)new Integer(1), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(citeByLater);
        sbFormula.append(" and #" + formulaIndex++);
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        try {
            this.cbxPeriodType.setSelectedItem((Object)this.ctx.getCurRptPeriodType());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        this.cbxAdjustMode.setSelectedItem((Object)this.selectAll);
        this.bizPrmtCompany.setData(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.txtDebitFrom.setValue(null);
        this.txtDebitTo.setValue(null);
        this.txtCreditFrom.setValue(null);
        this.txtCreditTo.setValue(null);
        this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    @Override
    protected void cbxPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTimeInfo(this.repDate.getSqlDate());
    }

    @Override
    protected void repDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private void setPeriodForJT13(List times) throws BOSException {
        String dataCollectNumber;
        DataCollectInfo dataCollect = this.ctx.getCurDataCollect();
        String string = dataCollectNumber = dataCollect != null ? dataCollect.getNumber() : "ACTUALDATA";
        if (dataCollectNumber.equals("ACTUALDATA")) {
            CslRptUtil.setPeriodForJT13(times, (Date)this.repDate.getValue(), (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem(), this.spPeriod, this.ctx.getCurRptPeriod());
        } else {
            this.spPeriod.setEnabled(false);
            this.spPeriod.setValue((Object)new Integer(times.get(1).toString()));
            CslRptUIUtil.setSpineRange(this.spPeriod, 0, 365);
        }
    }

    private void refreshTimeInfo(Date newDate) throws BOSException {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.spYear.setValue((Object)new Integer(times.get(0).toString()));
        this.setPeriodForJT13(times);
        this.repDate.setValue(times.get(2));
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block2: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            CurrencyInfo currencyInfo;
            String currencyId;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                Integer periodType = (Integer)filterItemInfo.getCompareValue();
                for (int j = 0; j < this.cbxPeriodType.getItemCount(); ++j) {
                    if (((RptPeriodTypeEnum)this.cbxPeriodType.getItemAt(j)).getValue() != periodType.intValue()) continue;
                    this.cbxPeriodType.setSelectedIndex(j);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("date")) {
                Date time = (Date)filterItemInfo.getCompareValue();
                this.repDate.setValue((Object)new Date(time.getTime()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                this.spYear.setValue((Object)((Integer)filterItemInfo.getCompareValue()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                this.spPeriod.setValue((Object)((Integer)filterItemInfo.getCompareValue()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("adjustMode.id")) {
                String adjustModeId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxAdjustMode.getItemCount(); ++j) {
                    AdjustModeInfo adjustModeInfo = (AdjustModeInfo)this.cbxAdjustMode.getItemAt(j);
                    if (!adjustModeInfo.getId().toString().equals(adjustModeId)) continue;
                    this.cbxAdjustMode.setSelectedIndex(j);
                    continue block2;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                if (currencyId.equals(this.selectAll)) {
                    this.cbxCurrency.setSelectedItem((Object)this.selectAll);
                    continue;
                }
                for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block2;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceCurrency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                if (currencyId.equals(this.selectAll)) {
                    this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
                    continue;
                }
                for (int j = 1; j < this.cbxSourceCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxSourceCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxSourceCurrency.setSelectedIndex(j);
                    continue block2;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgUnit.id")) {
                String companyId = (String)filterItemInfo.getCompareValue();
                try {
                    OrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    this.bizPrmtCompany.setData((Object)companyInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtNumberFrom.setText(number);
                    continue;
                }
                this.txtNumberTo.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.debit")) {
                BigDecimal debit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtDebitFrom.setValue((Object)debit);
                    continue;
                }
                this.txtDebitTo.setValue((Object)debit);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("entries.credit")) continue;
            BigDecimal credit = new BigDecimal(filterItemInfo.getCompareValue().toString());
            if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                this.txtCreditFrom.setValue((Object)credit);
                continue;
            }
            this.txtCreditTo.setValue((Object)credit);
        }
    }
}

