/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IRPTDataService;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ReportStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCheckSchemeUpdateUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class CheckSchemeUpdateUI
extends AbstractCheckSchemeUpdateUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckSchemeUpdateUI.class);
    boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);

    public void onLoad() throws Exception {
        super.onLoad();
        this.refreshContainer();
        this.txtPeriodType.setText(this.getUIContext().get("periodType").toString());
        this.refreshTimeInfo(this.pkReportDate.getSqlDate());
        this.txtDescription.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"schemeUpdateDescription"));
    }

    private void refreshContainer() {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.getUIContext().get("periodType");
        int moveSize_y = -29;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, periodTypeEnum)) {
            this.contReportDate.setVisible(false);
            this.spnYear.setEnabled(true);
            this.spnPeriod.setEnabled(true);
            CslRptUIUtil.moveContainerLocation((JComponent)this.contYear, 0, moveSize_y);
            CslRptUIUtil.moveContainerLocation((JComponent)this.contPeriod, 0, moveSize_y);
            CslRptUIUtil.moveContainerLocation((JComponent)this.contReportStatus, 0, moveSize_y);
            CslRptUIUtil.moveContainerLocation((JComponent)this.txtDescription, 0, moveSize_y);
            CslRptUIUtil.setSpineRange(this.spnYear, FiscalPeriodHelper.YearSpineRange[0], FiscalPeriodHelper.YearSpineRange[1]);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.spnPeriod, periodTypeEnum);
        } else {
            this.spnYear.setEnabled(false);
            this.spnPeriod.setEnabled(false);
            this.contReportDate.setVisible(true);
            CslRptUIUtil.setSpineRange(this.spnYear, 1900, 9999);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.spnPeriod, periodTypeEnum);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.getUIContext().get("periodType");
        List times = RPTDateUtil.getRptPeriod(newDate, periodTypeEnum);
        this.spnYear.setValue(times.get(0));
        this.spnPeriod.setValue(times.get(1));
        this.pkReportDate.setValue(times.get(2));
        if (periodTypeEnum != null && 3 == periodTypeEnum.getValue() && RPTDateUtil.isYearLastPeriod((Date)this.pkReportDate.getValue(), RptPeriodTypeEnum.MONTHLY)) {
            this.spnPeriod.setEnabled(true);
            CslRptUIUtil.setSpineRange(this.spnPeriod, 12, 13);
        } else {
            this.spnPeriod.setEnabled(false);
            CslRptUIUtil.setSpineRange(this.spnPeriod, 0, 366);
        }
    }

    @Override
    protected void pkReportDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        String period = this.spnPeriod.getValue().toString();
        String year = this.spnYear.getValue().toString();
        ReportStatusEnum status = (ReportStatusEnum)((Object)this.comboReportStatus.getSelectedItem());
        String templateId = this.getUIContext().get("id").toString();
        String group = this.getUIContext().get("group").toString();
        IRPTDataService RptService = RPTDataServiceFactory.getRemoteInstance();
        RptService.checkSchemeUpdate(templateId, group, period, year, status);
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }
}

