/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCompanyRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptParaMgrStartergy;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptMenuStrategy;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReportProcess;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptMessage;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptParaMgrStartergy;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CompanyRptEditUI
extends AbstractCompanyRptEditUI
implements IReportProcess {
    private static final Logger logger = CoreUIObject.getLogger(CompanyRptEditUI.class);
    IUIWindow reportUI = null;
    private boolean isLock = false;
    FilterInfo currentFilter = null;
    public static final int BATCHSAVE_REPEAT_CSLRPT = 1;
    public static final int BATCHSAVE_REPEAT_RPT = 4;
    public static final int BATCHSAVE_FAILED = 2;
    public static final int BATCHSAVE_SUCCEED = 3;

    protected IObjectValue createNewData() {
        CslReportInfo info = new CslReportInfo();
        info.setSourceType(RptSrcTypeEnum.NORMAL);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    private List getSelectedTemplateIdList() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<Object> list = new ArrayList<Object>();
        if (selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                ICell cell;
                int rowIndex = selectRows[i];
                IRow row = this.tblMain.getRow(rowIndex);
                if (row == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)CslRptUtil.getString("SumRptEditUI.Msg_SelectRow"));
                    SysUtil.abort();
                }
                if ((cell = row.getCell("id")) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)CslRptUtil.getString("SumRptEditUI.Msg_SelectRow"));
                    SysUtil.abort();
                }
                list.add(cell.getValue());
            }
        }
        return list;
    }

    private int addNewEditData(TemplateInfo template) throws Exception {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        int year = (Integer)this.comboYear.getSelectedItem();
        short period = (Short)this.comboPeriod.getSelectedItem();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        int templateType = template.getTemplateType().getValue();
        int reportType = -1;
        switch (templateType) {
            case 1: {
                reportType = 1;
                break;
            }
            case 3: {
                reportType = 2;
                break;
            }
            case 4: {
                reportType = 4;
                break;
            }
            case 5: {
                reportType = 3;
                break;
            }
            case 6: {
                reportType = 1;
                break;
            }
            case 10: {
                reportType = 10;
                break;
            }
            case 11: {
                reportType = 11;
                break;
            }
            case 12: {
                reportType = 12;
                break;
            }
            case 13: {
                reportType = 12;
                break;
            }
            case 15: {
                reportType = 13;
            }
        }
        String dataCollectNumber = CSLContextHelper.getCSLContext().getCurDataCollect() == null ? "ACTUALDATA" : CSLContextHelper.getCSLContext().getCurDataCollect().getNumber();
        String existId = this.verifyGroupReport("", company.getId().toString(), periodType.getValue(), year, period, currency.getId().toString(), template.getId().toString(), reportType, dataCollectNumber);
        if (existId != null) {
            CslReportInfo info = this.getReportInfo(existId);
            if (info.isIsCommitReport()) {
                return 4;
            }
            return 1;
        }
        try {
            this.editData = (CslReportInfo)this.createNewData();
            this.editData.setYear(year);
            this.editData.setPeriod(period);
            this.editData.setTemplate(template);
            this.editData.setDynaRptType(template.getDynaRptType());
            RptSheetParamCollection rptSheetParamCollection = template.getSheetParam();
            if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
                for (int j = 0; j < rptSheetParamCollection.size(); ++j) {
                    rptSheetParamCollection.get(j).setRelaType(ReportTypeEnum.REPORT);
                    rptSheetParamCollection.get(j).setStatus(1);
                }
            }
            this.editData.getSheetParam().addCollection(rptSheetParamCollection);
            this.editData.setBook(RptUtilForClient.LockBookExpTank((Book)template.getBook()));
            if (template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT)) {
                this.editData.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
            } else if (template.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT)) {
                this.editData.setSourceType(RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
            } else {
                this.editData.setSourceType(RptSrcTypeEnum.NORMAL);
            }
            this.editData.setCompany(company);
            this.editData.setOrgUnit(company.castToFullOrgUnitInfo());
            this.editData.setCurrency(currency);
            this.editData.setName(template.getName());
            this.editData.setNumber(template.getNumber() + "_" + year + "_" + period);
            this.editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            this.editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            this.editData.setPeriodType(periodType);
            this.editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
            this.editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
            this.editData.setReportDate(RPTDate13Util.getPeriodLastDate(year, period, periodType));
            IObjectPK pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
            this.editData.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (ServerException exc) {
            logger.error((Object)"addNewEditData_ServerException", (Throwable)((Object)exc));
            if (ServerException.EXISTS_SAME_RPT.getCode().equals(exc.getSubCode())) {
                return 1;
            }
            template.setString("ERROR_MSG", exc.getMessage());
            return 2;
        }
        catch (Exception exc) {
            logger.error((Object)"addNewEditData_Exception", (Throwable)exc);
            template.setString("ERROR_MSG", exc.getMessage());
            return 2;
        }
        return 3;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.batchAddReport(this.getSelectedTemplateIdList());
        this.setSaved(true);
    }

    private void batchAddReport(final List list) throws Exception {
        int size = list.size();
        if (size == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"526_GroupRptEditUI"));
            return;
        }
        ProgressDialog dialog = ProgressDialog.createProgressDialog((Component)((Object)this), (boolean)true);
        boolean canCanCel = list.size() > 1;
        dialog.run(canCanCel, true, new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                int size = list.size();
                ArrayList<TemplateInfo> successLst = new ArrayList<TemplateInfo>();
                ArrayList<TemplateInfo> cslRptRepeatLst = new ArrayList<TemplateInfo>();
                ArrayList<TemplateInfo> rptRepeatLst = new ArrayList<TemplateInfo>();
                ArrayList<TemplateInfo> failedLst = new ArrayList<TemplateInfo>();
                try {
                    monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"329_CompanyRptEditUI"), size);
                    monitor.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"330_CompanyRptEditUI"));
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"23_CompanyRptEditUI");
                    for (int i = 0; i < size && !monitor.isCanceled(); ++i) {
                        monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"331_CompanyRptEditUI"));
                        TemplateInfo template = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)list.get(i).toString())), CompanyRptEditUI.this.getSelectors());
                        monitor.subTaskBegin(MessageFormat.format(msg, template.getName()));
                        int ret = CompanyRptEditUI.this.addNewEditData(template);
                        if (ret == 1) {
                            cslRptRepeatLst.add(template);
                        } else if (ret == 4) {
                            rptRepeatLst.add(template);
                        } else if (ret == 2) {
                            failedLst.add(template);
                        } else {
                            successLst.add(template);
                        }
                        monitor.worked(1);
                    }
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"333_CompanyRptEditUI"));
                    CslRptUIUtil.displayResult((Object)CompanyRptEditUI.this, successLst, cslRptRepeatLst, rptRepeatLst, failedLst, ((CurrencyInfo)CompanyRptEditUI.this.comboCurrency.getSelectedItem()).getName());
                }
                catch (Exception e) {
                    logger.error((Object)"batchAddReport_Exception", (Throwable)e);
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("reportDate"));
        return sic;
    }

    protected String getSelectedTemplateID() {
        Object keyValue;
        int rowIndex;
        IRow row;
        ICell cell;
        boolean tmpSelected = false;
        String selectedKeyValue = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (cell = (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())).getCell("id")) != null && (keyValue = cell.getValue()) != null) {
            selectedKeyValue = keyValue.toString();
            tmpSelected = true;
        }
        if (!tmpSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)CslRptUtil.getString("SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return selectedKeyValue;
    }

    public String getReportUIName() {
        return GroupRptProcessUI.class.getName();
    }

    @Override
    protected void comboPeriodType_actionPerformed(ActionEvent e) throws Exception {
        super.comboPeriodType_actionPerformed(e);
        this.comboPeriod.removeAllItems();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (periodType == null) {
            return;
        }
        int type = periodType.getValue();
        ArrayList<Short> items = new ArrayList<Short>();
        int count = 0;
        switch (type) {
            case 1: {
                count = 366;
                break;
            }
            case 3: {
                count = 12;
                break;
            }
            case 4: {
                count = 4;
                break;
            }
            case 5: {
                count = 2;
                break;
            }
            case 6: {
                count = 1;
                break;
            }
            case 2: {
                count = 53;
            }
        }
        for (int i = 1; i <= count; ++i) {
            items.add(new Short((short)i));
        }
        this.comboPeriod.addItems(items.toArray());
        this.refreshTimeInfo(this.datePickerRptDate.getSqlDate());
        this.filterQuery();
    }

    public RptStrategyManager getRptStrategyManager() {
        RptStrategyManager rptStrategyManager = new RptStrategyManager();
        GroupRptMenuStrategy cslMenu = new GroupRptMenuStrategy();
        cslMenu.setReportBaseInfo(this.editData);
        rptStrategyManager.setCslParamStartegy(true);
        rptStrategyManager.setRptMenuStartegy((RptMenuStrategy)cslMenu);
        CslRptParaMgrStartergy para = new CslRptParaMgrStartergy();
        rptStrategyManager.setRptParaMgrStartergy((RptParaMgrStartergy)para);
        return rptStrategyManager;
    }

    private void openReportUI() throws Exception {
        IUIWindow window;
        String reportID = (String)this.getUIContext().get("ID");
        this.setCurrentReport(this.getReportInfo(reportID));
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"ID", (Object)reportID);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"Source", (Object)"Company");
        uiContext.put((Object)"superParent", this.getUIContext().get("superParent"));
        this.reportUI = window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getReportUIName(), (Map)uiContext, null, this.getOprtState());
        window.getUIObject().setUITitle(CslRptUIUtil.getUITitle((VirtualSheetParamInfo)this.editData, this.getOprtState()));
        window.show();
    }

    private void setCurrentReport(CslReportInfo report) {
        this.editData = report;
    }

    private CslReportInfo getCurrentReport() {
        return this.editData;
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getRptSelectors());
    }

    private SelectorItemCollection getRptSelectors() {
        SelectorItemCollection sic = this.getSelectors();
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("isCommitReport"));
        return sic;
    }

    public void onLoad() throws Exception {
        String format;
        super.onLoad();
        if (this.getUIContext().get("OpenReport") != null) {
            this.openReportUI();
        } else {
            this.tblMain.checkParsed();
            this.initUI();
        }
        this.setUITitle(this.getUITitle() + " " + CslRptUtil.getString("AddNew"));
        this.tblMain.setColumnMoveable(true);
        CurrencyInfo natureCurrency = RptUtilForClient.getCurrenctCurrencyFromDatabase();
        if (natureCurrency != null) {
            for (int i = 0; i < this.comboCurrency.getItemCount(); ++i) {
                if (!((CurrencyInfo)this.comboCurrency.getItemAt(i)).getId().toString().equals(natureCurrency.getId().toString())) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
        if ((format = CslRptUIUtil.getNationalTimeFormatString()) != null) {
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(format);
        }
    }

    private void filterQuery() throws Exception {
        FilterInfo filter;
        FilterItemCollection fic;
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        int periodType = ((RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem()).getValue();
        if (this.currentFilter == null) {
            this.currentFilter = new FilterInfo();
        }
        if (this.queryCompanyRptTemplateQuery == null) {
            this.queryCompanyRptTemplateQuery = new EntityViewInfo();
        }
        if ((fic = (filter = (FilterInfo)this.currentFilter.clone()).getFilterItems()) == null) {
            fic = new FilterItemCollection();
        }
        StringBuffer maskString = new StringBuffer();
        int index = fic.size();
        if (filter.getMaskString() != null) {
            maskString.append("(" + filter.getMaskString() + ")");
        }
        fic.add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("periodType", (Object)new Integer(periodType), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        String ms = maskString.toString();
        if (ms.startsWith(" and ")) {
            ms = ms.substring(" and ".length());
        }
        filter.setMaskString(ms);
        FilterInfo dataPermissionFilter = CslRptUtil.getDataPermissionFilter(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(orgUnitId), "csl_indirpttmp_view");
        if (dataPermissionFilter != null) {
            filter.mergeFilter(dataPermissionFilter, "AND");
        }
        this.queryCompanyRptTemplateQuery.setFilter(filter);
        this.tblMain.removeRows();
    }

    private void initUI() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company;
        this.menuItemAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.datePickerRptDate.setValue((Object)CslRptUIUtil.getLastPeriodDate(new Date()));
        this.comboYear.setEnabled(false);
        this.comboPeriod.setEnabled(false);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        CurrencyCollection collection = CslRptUIUtil.getCurrencyCollection();
        if (collection != null) {
            this.comboCurrency.addItems(collection.toArray());
        }
        if ((company = SysContext.getSysContext().getCurrentFIUnit()) != null && company.getBaseCurrency() != null && this.getOprtState().equals("ADDNEW")) {
            this.comboCurrency.setSelectedItem((Object)company.getBaseCurrency());
        } else if (super.getOprtState() == OprtState.EDIT) {
            CurrencyInfo o = null;
            String id = this.editData.getCurrency().getId().toString();
            int j = this.comboCurrency.getItemCount();
            for (int i = 0; i < j; ++i) {
                o = (CurrencyInfo)this.comboCurrency.getItemAt(i);
                if (!o.getId().toString().equalsIgnoreCase(id)) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public boolean isModify() {
        return false;
    }

    public void setData(byte[] data) {
        this.getCurrentReport().setZipData(data);
    }

    public byte[] getData() {
        return this.getCurrentReport().getZipData();
    }

    public VirtualSheetParamInfo save() throws Exception {
        IObjectPK pk = ((ICslReport)this.getBizInterface()).submit((CoreBaseInfo)this.getCurrentReport());
        this.setOprtState(OprtState.EDIT);
        CslReportInfo info = (CslReportInfo)this.getBizInterface().getValue(pk, this.getSelectorsAfterSave());
        this.editData.setAuditedStatus(info.getAuditedStatus());
        this.editData.setLastUpdateTime(info.getLastUpdateTime());
        this.editData.getSheetParam().clear();
        this.editData.getSheetParam().addCollection(info.getSheetParam());
        this.editData.getPostils().clear();
        this.editData.getPostils().addCollection(info.getPostils());
        return this.getCurrentReport();
    }

    private SelectorItemCollection getSelectorsAfterSave() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        return sic;
    }

    public boolean getIsCacl() {
        return false;
    }

    public boolean getIsAudited() {
        if (this.getCurrentReport() != null) {
            return this.getCurrentReport().getAuditedStatus().getValue() != 1;
        }
        return false;
    }

    public Object getSheetparam(String sheetId) {
        RptSheetParamCollection params = this.getCurrentReport().getSheetParam();
        if (params != null && params.size() > 0) {
            int paramsSize = params.size();
            for (int i = 0; i < paramsSize; ++i) {
                if (!params.get(i).getSheetID().trim().equals(sheetId)) continue;
                return params.get(i);
            }
        }
        return null;
    }

    public Object getSheetparam() {
        return this.getCurrentReport().getSheetParam();
    }

    public RptSheetParamInfo processCreat(String sheetId) {
        RptSheetParamInfo newSheetParam = new RptSheetParamInfo();
        newSheetParam.setSheetID(sheetId);
        newSheetParam.setCurrency(this.getCurrentReport().getCurrency());
        newSheetParam.setRelaType(ReportTypeEnum.CSLREPORT);
        newSheetParam.setStartYear(0);
        newSheetParam.setEndYear(0);
        newSheetParam.setStartPeriod(0);
        newSheetParam.setEndPeriod(0);
        newSheetParam.setReportClass(CSLReportGroupEnum.COMMON);
        newSheetParam.setStatus(1);
        newSheetParam.setReport((VirtualSheetParamInfo)this.getCurrentReport());
        return newSheetParam;
    }

    public IObjectValue getEditDataObject() {
        return this.getCurrentReport();
    }

    public Object getView(String arg0) throws Exception {
        ObjectStringPK pk = new ObjectStringPK();
        pk.setKeyValue("id", (Object)this.getCurrentReport().getId().toString());
        CslReportInfo reportView = ((ICslReport)this.getBizInterface()).getCslReportInfo((IObjectPK)pk);
        ReportProcessUI reportProcessUI = new ReportProcessUI();
        RptTablePane viewPane = reportProcessUI.loadReportContent(reportView.getKDF(), true);
        return viewPane;
    }

    public void switchReport(String reportId) {
    }

    public RptMessage checkCreatSheet(List rptSheets) {
        return null;
    }

    public void submitWorkFlow() throws Exception {
    }

    public PostilCollection getRptPostilColl() {
        for (int i = 0; i < this.editData.getPostils().size(); ++i) {
            if (this.editData.getPostils().get(i).getPostilType().getValue() == 1) continue;
            this.editData.getPostils().removeObject(i);
            --i;
        }
        return this.editData.getPostils();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionSubmit_actionPerformed(null);
            this.destroyWindow();
        }
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.comboYear.removeAllItems();
        this.comboYear.addItem((Object)new Integer(times.get(0).toString()));
        this.comboPeriod.removeAllItems();
        this.comboPeriod.addItem((Object)new Short(times.get(1).toString()));
        this.isLock = true;
        this.datePickerRptDate.setValue(times.get(2));
        this.isLock = false;
    }

    @Override
    protected void datePickerRptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLock) {
            return;
        }
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private String verifyGroupReport(String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateID, int reportType, String dataCollectNumber) throws Exception {
        String reportId = null;
        if (super.getOprtState() == OprtState.EDIT) {
            reportId = this.editData.getId().toString();
        }
        String rptId = CslRptUIUtil.getReportByOldVersionTmp2(treeID, companyID, periodType, year, period, currencyID, templateID, reportType, reportId, dataCollectNumber);
        return rptId;
    }
}

