/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCompanyRptListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CompanyRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GenerateNextYearInitDataUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MaintainYearInitDataUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.client.ReportUpgradeUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUIController;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import org.apache.log4j.Logger;

public class CompanyRptListUI
extends AbstractCompanyRptListUI {
    private static final Logger logger = CoreUIObject.getLogger(CompanyRptListUI.class);
    private List canMaintainReportIDList = null;
    private List canGenReportIDList = null;
    private static final long serialVersionUID = 5417554113393202342L;
    CommonQueryDialog conditionDialog = null;

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            if (this.btnView.isVisible() && this.btnView.isEnabled() && this.tblMain.getRowCount() != 0 && this.tblMain.getSelectManager().size() != 0) {
                this.actionView_actionPerformed(new ActionEvent(this.btnView, 0, "Double Clicked"));
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    private void doRefresh(IUIWindow uiWindow, ActionEvent e) {
        final EditUI editUI = (EditUI)uiWindow.getUIObject();
        final ActionEvent fe = e;
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                try {
                    if (editUI.isSaved()) {
                        CompanyRptListUI.this.refresh(fe);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsOUSealUp();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        IUIWindow newWindow = null;
        ((ListUIController)super.getUIController()).actionAddNew();
        newWindow = ((ListUIController)super.getUIController()).getNavigator().getUIWindow();
        Window win = SwingUtilities.getWindowAncestor((Component)newWindow.getUIObject());
        if (!win.isActive() && win instanceof JFrame && ((JFrame)win).getExtendedState() == 1) {
            ((JFrame)win).setExtendedState(0);
        }
        this.doRefresh(newWindow, e);
        this.setPreSelecteRow();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Source", (Object)"Company");
        uiContext.put((Object)"superParent", (Object)this);
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"canResize", (Object)"true");
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(GroupRptProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.requestObjectLock(this.getObjectUpdateId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("sourceType"));
        CslReportInfo report = this.getReportInfo(super.getSelectedKeyValue(), sic);
        if (report != null && report.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AUDITTED_REPORT_CANNOT_MODIFY"));
            return;
        }
        if (report != null && report.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptIsGroupCommited"));
            return;
        }
        if (report != null && report.getCommittedStatus() == CommittedStatusEnum.COMMITTED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CAN_NOT_MODIFY_COMMITTED_REPORT"));
            return;
        }
        if (report != null && report.getPublishedStatus().getValue() == 2) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptIsPublished"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"Source", (Object)"Company");
        uiContext.put((Object)"superParent", (Object)this);
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(GroupRptProcessUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
        this.tblMain.removeRows();
    }

    protected CslReportInfo getReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return (CslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String format;
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = CompanyRptListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.conditionDialog == null) {
                this.conditionDialog = this.initCommonQueryDialog();
                this.conditionDialog.setProcessor((IProcessor)new CommonQueryProcessor(){

                    public void process() throws Exception {
                        String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                        if (fieldProperty.equalsIgnoreCase("sourceType")) {
                            KDComboBox cmbxSourceType = (KDComboBox)this.get("CURRENT_EDITOR");
                            for (int i = cmbxSourceType.getItemCount() - 1; i > 0; --i) {
                                RptSrcTypeEnum rptSrcType = (RptSrcTypeEnum)cmbxSourceType.getItemAt(i);
                                if (rptSrcType.getValue() == 1 || rptSrcType.getValue() == 10 || rptSrcType.getValue() == 13) continue;
                                cmbxSourceType.removeItemAt(i);
                            }
                        }
                    }
                });
                CslRptUIUtil.standardFilterUI(this.conditionDialog, this);
            }
            if (this.conditionDialog.show()) {
                this.doQuery(this.conditionDialog);
                this.mainQuery = this.conditionDialog.getEntityViewInfoResult();
                this.tblMain.removeRows();
            } else {
                SysUtil.abort();
            }
        }
        if ((format = CslRptUIUtil.getNationalTimeFormatString()) != null) {
            this.tblMain.getColumn("year").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("period").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("commitTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("receiveTime").getStyleAttributes().setNumberFormat(format);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = null;
        try {
            FilterInfo info = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("orgUnit.id", (Object)SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            info.setMaskString(" #0 ");
            info.getFilterItems().add(filterItemInfo);
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(info);
            } else if (!viewInfo.getFilter().getFilterItems().contains(filterItemInfo)) {
                if (viewInfo.getFilter().getFilterItems().size() < 1) {
                    viewInfo.setFilter(info);
                } else {
                    viewInfo.getFilter().mergeFilter(info, "AND");
                }
            }
            exec = super.getQueryExecutor(queryPK, viewInfo);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        return exec;
    }

    protected String getEditUIName() {
        return CompanyRptEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mainQuery.setIngorePreOrders(true);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getViewManager().setFreezeView(0, 7);
        this.menuItemCslRptImport.setVisible(false);
        this.actionFileCsRptImport.setEnabled(false);
        this.MenuItemAttachment.setEnabled(true);
        this.MenuItemAttachment.setVisible(true);
        this.btnBatchCommit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionBatchCommit.setEnabled(true);
        this.btnBatchAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionBatchAudit.setEnabled(true);
        this.maintainYearInitDataKDMenu.setVisible(true);
        this.maintainYearInitDataKDMenu.setEnabled(true);
        this.maintainYearInitDataKDMenuItem.setVisible(true);
        this.maintainYearInitDataKDMenuItem.setEnabled(true);
        this.generateYearInitDataKDMenuItem.setVisible(true);
        this.generateYearInitDataKDMenuItem.setEnabled(true);
        EntityViewInfo entityView = this.getMainQuery();
        SorterItemInfo sort = new SorterItemInfo("reportDate");
        sort.setSortType(SortType.DESCEND);
        entityView.getSorter().add(sort);
        this.mainQuery = entityView;
        this.execQuery();
        ReportUpgradeUI.registerBackDoorAction((KDPanel)this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ReportUpgradeUI.upgrade((List)CompanyRptListUI.this.getSelectedIdValues(), (ICoreBase)CompanyRptListUI.this.getBizInterface(), (Object)((Object)CompanyRptListUI.this));
                }
                catch (Exception e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent event) {
                int keyCode = event.getKeyCode();
                if (keyCode == 122 && event.isControlDown() && event.isShiftDown()) {
                    CslRptUtil cslrpt = new CslRptUtil();
                    cslrpt.exportReportByKDS(CompanyRptListUI.this.exportReoprtByKDS());
                }
            }

            @Override
            public void keyPressed(KeyEvent event) {
            }

            @Override
            public void keyTyped(KeyEvent event) {
            }
        });
    }

    private Map exportReoprtByKDS() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            String selectId = this.getSelectedKeyValue();
            ICslReport iReport = (ICslReport)this.getBizInterface();
            CslReportInfo reportInfo = iReport.getCslReportInfo("select * where id = '" + selectId + "'");
            byte[] repPackData = reportInfo.getZipData();
            params.put("ids", this.getSelectIds());
            params.put("selectId", selectId);
            params.put("repPackData", repPackData);
        }
        catch (Exception e) {
            logger.error((Object)"exportReoprtByKDS_Exception", (Throwable)e);
        }
        return params;
    }

    private ArrayList getSelectIds() throws Exception {
        int selectRowCount = this.tblMain.getSelectManager().size();
        KDTSelectBlock selectBlock = null;
        ArrayList<Object> selectIds = new ArrayList<Object>();
        for (int i = 0; i < selectRowCount; ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                String id = this.tblMain.getRow(j).getCell("id").getValue().toString();
                if (id == null) continue;
                selectIds.add(this.tblMain.getRow(j).getCell("id").getValue());
            }
        }
        return selectIds;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public void actionFileCsRptImport_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CslRptImportUI.class.getName(), (Map)new UIContext((Object)this), null, OprtState.VIEW);
        window.show();
    }

    @Override
    public void actionBatchCommit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        CslRptUIUtil.batchCommit(this, list);
    }

    @Override
    public void actionBatchAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        CslRptUIUtil.batchAudit(this, this.tblMain, list);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String boID = this.getSelectedKeyValue();
        boolean isEdit = true;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("sourceType"));
        CslReportInfo report = this.getReportInfo(boID, sic);
        AuditedStatusEnum auditStatus = report.getAuditedStatus();
        if (auditStatus.getValue() == 2) {
            isEdit = false;
        }
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        acm.showAttachmentListUIByBoID(boID, (Object)this, isEdit);
    }

    @Override
    protected void maintainYearInitDataKDMenu_menuSelected(MenuEvent e) throws Exception {
        ArrayList reportIDList = this.getSelectedIdValues();
        this.canMaintainReportIDList = new ArrayList();
        this.canGenReportIDList = new ArrayList();
        Iterator reportIDIt = reportIDList.iterator();
        CslReportInfo clsReportInfo = null;
        while (reportIDIt.hasNext()) {
            String reportID = (String)reportIDIt.next();
            clsReportInfo = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectUuidPK(reportID));
            if (clsReportInfo == null) continue;
            this.canMaintainReportIDList.add(reportID);
            if (!RPTDateUtil.isYearLastPeriod(clsReportInfo.getReportDate(), clsReportInfo.getPeriodType())) continue;
            this.canGenReportIDList.add(reportID);
        }
        if (this.canMaintainReportIDList.size() <= 0) {
            this.maintainYearInitDataKDMenuItem.setEnabled(false);
        } else {
            this.maintainYearInitDataKDMenuItem.setEnabled(true);
        }
        if (this.canGenReportIDList.size() <= 0) {
            this.generateYearInitDataKDMenuItem.setEnabled(false);
        } else {
            this.generateYearInitDataKDMenuItem.setEnabled(true);
        }
        super.maintainYearInitDataKDMenu_menuSelected(e);
    }

    @Override
    protected void maintainYearInitDataKDMenuItem_actionPerformed(ActionEvent e) throws Exception {
        super.maintainYearInitDataKDMenuItem_actionPerformed(e);
        if (this.canMaintainReportIDList != null && this.canMaintainReportIDList.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ReportIDList", (Object)this.canMaintainReportIDList);
            uiContext.put((Object)"CompanyDisplayName", (Object)SysContext.getSysContext().getCurrentOrgUnit().getName());
            uiContext.put((Object)"ParentUI", (Object)this);
            uiContext.put((Object)"RptSourceType", (Object)new Integer(7));
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MaintainYearInitDataUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            window.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"CompanyRptList_Dialog_RptSelect"));
        }
    }

    @Override
    protected void generateYearInitDataKDMenuItem_actionPerformed(ActionEvent e) throws Exception {
        super.generateYearInitDataKDMenuItem_actionPerformed(e);
        if (this.canGenReportIDList != null && this.canGenReportIDList.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ReportIDList", (Object)this.canGenReportIDList);
            uiContext.put((Object)"CompanyDisplayName", (Object)SysContext.getSysContext().getCurrentOrgUnit().getName());
            if (this.canGenReportIDList.size() == 1) {
                CslReportInfo clsReportInfo = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectUuidPK((String)this.canGenReportIDList.get(0)));
                uiContext.put((Object)"Year", (Object)String.valueOf(clsReportInfo.getYear()));
                uiContext.put((Object)"Period", (Object)String.valueOf(clsReportInfo.getPeriod()));
                clsReportInfo = null;
            }
            uiContext.put((Object)"ParentUI", (Object)this);
            uiContext.put((Object)"RptSourceType", (Object)new Integer(7));
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GenerateNextYearInitDataUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            window.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"CompanyRptList_Dialog_RptSelect"));
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"name"};
        return locateNames;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }
}

