/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationMode;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractConvtEliminationFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConvtEliminationFilterUI
extends AbstractConvtEliminationFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ConvtEliminationFilterUI.class);
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private String whichOpen = null;
    private IDataElement iDataElement = null;
    private boolean isMergeByFiscalPeriod = false;
    private boolean isFromEliminationForPCListUI = false;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    public ConvtEliminationFilterUI() throws Exception {
        this.isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(null);
        this.whichOpen = "ALL";
    }

    public ConvtEliminationFilterUI(String openSource) throws Exception {
        this.whichOpen = openSource;
    }

    public ConvtEliminationFilterUI(String openSource, Map uiContext) throws Exception {
        this.whichOpen = openSource;
        this.getUIContext().putAll(uiContext);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init(this.whichOpen);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void init(String openSource) throws BOSException {
        if (this.getUIContext().get("isFromEliminationForPCListUI") != null) {
            this.isFromEliminationForPCListUI = true;
        }
        this.isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(null);
        this.whichOpen = openSource;
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.cbxElimType.addItem((Object)this.selectAll);
        this.cbxElimType.setSelectedItem((Object)this.selectAll);
        this.cbxElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.cbxElimType.addItem((Object)ElimTypeEnum.exchange);
        this.cbxElimType.addItem((Object)ElimTypeEnum.General);
        this.cbxElimType.addItem((Object)ElimTypeEnum.MAIN_INVEST);
        this.cbxElimType.addItem((Object)ElimTypeEnum.HK_COST);
        CslClientHelper.initDataElementCombox(this.cbxDataElement, false, false, true);
        if (this.whichOpen.equals("Hand")) {
            this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.General);
            this.cbxElimType.setEnabled(false);
            this.cbxDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("Auto")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.removeItem((Object)ElimTypeEnum.General);
            this.cbxDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("All")) {
            this.cbxElimType.setSelectedIndex(0);
            this.cbxElimType.setEnabled(true);
            this.cbxDataElement.setEnabled(true);
        }
        this.cbxCurrency.addItem((Object)this.selectAll);
        this.cbxCurrency.setSelectedIndex(0);
        this.cbxSourceCurrency.addItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cbxCurrency.addItem((Object)currencyCollection.get(i));
                this.cbxSourceCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.bizPrmtItemFrom.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemFrom.setEditFormat("$number$");
        this.bizPrmtItemFrom.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemFrom.setEditable(true);
        this.bizPrmtItemFrom.setCommitFormat("$number$");
        this.bizPrmtItemTo.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemTo.setEditFormat("$number$");
        this.bizPrmtItemTo.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemTo.setEditable(true);
        this.bizPrmtItemTo.setCommitFormat("$number$");
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitFrom.setSupportedEmpty(true);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtDebitTo.setSupportedEmpty(true);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditFrom.setSupportedEmpty(true);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.txtCreditTo.setSupportedEmpty(true);
        this.cmbxAuditStatus.addItem((Object)this.selectAll);
        this.cmbxAuditStatus.addItems(CheckedStatusEnum.getEnumList().toArray());
        this.comboElimMode.addItem((Object)this.selectAll);
        IEliminationMode iElimMode = EliminationModeFactory.getRemoteInstance();
        EntityViewInfo elimMode = new EntityViewInfo();
        elimMode.getSelector().add(new SelectorItemInfo("id"));
        elimMode.getSelector().add(new SelectorItemInfo("number"));
        elimMode.getSelector().add(new SelectorItemInfo("name"));
        EliminationModeCollection collection = iElimMode.getEliminationModeCollection(elimMode);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                this.comboElimMode.addItem((Object)collection.get(i));
            }
        }
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItemCurrency;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        try {
            FilterItemInfo filterItem5;
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)this.getCSLContext().getCurOrgBound().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(this.getCSLContext().getCurRptPeriodType().getValue()), CompareType.EQUALS);
            FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(this.getCSLContext().getCurRptYear()), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(this.getCSLContext().getCurRptPeriod()), CompareType.EQUALS);
            OrgUnitInfo uif = this.getCSLContext().getCurOrgGroup();
            String number = CslRptUIUtil.getCompanyStructureNumber(this.getCSLContext().getCurOrgBound(), uif);
            FilterItemInfo filterItem4 = new FilterItemInfo("structure.longNumber", (Object)number, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem0);
            this.filterInfo.getFilterItems().add(filterItem1);
            this.filterInfo.getFilterItems().add(filterItem2);
            this.filterInfo.getFilterItems().add(filterItem3);
            this.filterInfo.getFilterItems().add(filterItem4);
            if (this.whichOpen.equals("Auto")) {
                filterItem5 = new FilterItemInfo("elimType", (Object)new Integer(2), CompareType.NOTEQUALS);
                this.filterInfo.getFilterItems().add(filterItem5);
            } else if (this.whichOpen.equals("Hand")) {
                filterItem5 = new FilterItemInfo("elimType", (Object)new Integer(2), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItem5);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        StringBuffer sbFormula = new StringBuffer();
        if (this.whichOpen.equals("Auto") || this.whichOpen.equals("Hand")) {
            sbFormula.append(" ( #0 ) and ( #1 ) and ( #2 ) and ( #3 ) and (#4) and (#5)");
        } else {
            sbFormula.append(" ( #0 ) and ( #1 ) and ( #2 ) and ( #3 ) and (#4) ");
        }
        if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            ++formulaIndex;
        }
        if (this.cbxSourceCurrency.getSelectedItem() != null && !this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.cbxSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            ++formulaIndex;
        }
        if (this.cbxElimType.getSelectedItem() != null && !this.cbxElimType.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterElimType = new FilterItemInfo("elimType", (Object)new Integer(((ElimTypeEnum)((Object)this.cbxElimType.getSelectedItem())).getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterElimType);
            ++formulaIndex;
        }
        if (this.cbxDataElement.getSelectedItem() != null && !this.cbxDataElement.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterDataElement = new FilterItemInfo("entries.dataElement", (Object)new Integer(((DataElementInfo)this.cbxDataElement.getSelectedItem()).getInterSeq()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterDataElement);
            ++formulaIndex;
        }
        if (this.bizPrmtItemFrom.getData() != null) {
            String itemNumberFrom = ((RPTItemInfo)this.bizPrmtItemFrom.getData()).getNumber();
            FilterItemInfo filterItemFrom = new FilterItemInfo("item.number", (Object)itemNumberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemFrom);
            ++formulaIndex;
        }
        if (this.bizPrmtItemTo.getData() != null) {
            String itemNumberTo = ((RPTItemInfo)this.bizPrmtItemTo.getData()).getNumber();
            FilterItemInfo filterItemTo = new FilterItemInfo("item.number", (Object)itemNumberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            ++formulaIndex;
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberFrom);
            ++formulaIndex;
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberTo);
            ++formulaIndex;
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitFrom);
            ++formulaIndex;
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitTo);
            ++formulaIndex;
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditFrom);
            ++formulaIndex;
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditTo);
            ++formulaIndex;
        }
        for (int i = 0; i < formulaIndex; ++i) {
            if (this.whichOpen.equals("Auto") || this.whichOpen.equals("Hand")) {
                sbFormula.append(" and (#" + (i + 6) + ")");
                continue;
            }
            sbFormula.append(" and (#" + (i + 5) + ")");
        }
        formulaIndex = this.filterInfo.getFilterItems().size();
        if (this.cmbxAuditStatus.getSelectedIndex() > 0) {
            CheckedStatusEnum auditStatus = (CheckedStatusEnum)this.cmbxAuditStatus.getSelectedItem();
            FilterItemInfo item = new FilterItemInfo("CheckedStatus", (Object)new Integer(auditStatus.getValue()));
            this.filterInfo.getFilterItems().add(item);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)this.txtCreator.getText())) {
            FilterItemInfo item = new FilterItemInfo("creator.name", (Object)("%" + this.txtCreator.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(item);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)this.txtAuditor.getText())) {
            FilterItemInfo item = new FilterItemInfo("auditor.name", (Object)("%" + this.txtAuditor.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(item);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboElimMode.getSelectedItem() != null && !this.comboElimMode.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterModeInfo = new FilterItemInfo("eliminationMode.id", (Object)((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterModeInfo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        try {
            FilterItemInfo filterItem = new FilterItemInfo("dataCollect.number", (Object)this.getCSLContext().getCurDataCollect().getNumber(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
        if (this.whichOpen.equals("Hand")) {
            this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.General);
            this.cbxElimType.setEnabled(false);
            this.cbxDataElement.setSelectedItem((Object)this.selectAll);
            this.cbxDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("Auto")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.setEnabled(true);
            this.cbxDataElement.setSelectedItem((Object)this.selectAll);
            this.cbxDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("All")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.setEnabled(true);
            this.cbxDataElement.setSelectedItem((Object)this.selectAll);
            this.cbxDataElement.setEnabled(true);
        }
        this.bizPrmtItemFrom.setData(null);
        this.bizPrmtItemTo.setData(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.txtDebitFrom.setValue(null);
        this.txtDebitTo.setValue(null);
        this.txtCreditFrom.setValue(null);
        this.txtCreditTo.setValue(null);
        this.cmbxAuditStatus.setSelectedIndex(0);
        this.txtCreator.setText(null);
        this.txtAuditor.setText(null);
        this.comboElimMode.setSelectedItem((Object)this.selectAll);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block5: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            CurrencyInfo currencyInfo;
            String currencyId;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("elimType")) {
                this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.getEnum(Integer.parseInt(filterItemInfo.getCompareValue().toString())));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.dataElement")) {
                try {
                    this.iDataElement = DataElementFactory.getRemoteInstance();
                    this.cbxDataElement.setSelectedItem((Object)this.iDataElement.getDataElementByInterSeq((Integer)filterItemInfo.getCompareValue()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"getDataElementByInterSeq_EASBizException", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getDataElementByInterSeq_BOSException", (Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block5;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceCurrency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxSourceCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxSourceCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxSourceCurrency.setSelectedIndex(j);
                    continue block5;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("item.number")) {
                String itemNumber = (String)filterItemInfo.getCompareValue();
                try {
                    RPTItemInfo rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo("select number, name where number = '" + itemNumber + "'");
                    if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                        this.bizPrmtItemFrom.setData((Object)rptItemInfo);
                        continue;
                    }
                    this.bizPrmtItemTo.setData((Object)rptItemInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtNumberFrom.setText(number);
                    continue;
                }
                this.txtNumberTo.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.debit")) {
                BigDecimal debit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtDebitFrom.setValue((Object)debit);
                    continue;
                }
                this.txtDebitTo.setValue((Object)debit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.credit")) {
                BigDecimal credit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtCreditFrom.setValue((Object)credit);
                    continue;
                }
                this.txtCreditTo.setValue((Object)credit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("CheckedStatus")) {
                Integer auditStatus = (Integer)filterItemInfo.getCompareValue();
                if (auditStatus == 1) {
                    this.cmbxAuditStatus.setSelectedIndex(1);
                    continue;
                }
                this.cmbxAuditStatus.setSelectedIndex(2);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("creator.name")) {
                String creator = (String)filterItemInfo.getCompareValue();
                this.txtCreator.setText(creator.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("auditor.name")) {
                String auditor = (String)filterItemInfo.getCompareValue();
                this.txtAuditor.setText(auditor.replaceAll("%", ""));
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("eliminationMode.id")) continue;
            String eliminationModeId = (String)filterItemInfo.getCompareValue();
            for (int j = 1; j < this.comboElimMode.getItemCount(); ++j) {
                EliminationModeInfo elimMode = (EliminationModeInfo)this.comboElimMode.getItemAt(j);
                if (!eliminationModeId.equals(elimMode.getId().toString())) continue;
                this.comboElimMode.setSelectedIndex(j);
                continue block5;
            }
        }
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

