/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalYearPeriodDateTmp;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustMode;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCopyHisDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CopyHisDataFilterUI
extends AbstractCopyHisDataFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CopyHisDataFilterUI.class);
    private String selectAll = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private ICurrency iCurrency = null;
    private IAdjustMode iAdjustMode = null;
    FiscalYearPeriodDateTmp fiscalRefCtrl;
    private boolean isDisplayAdjustRPTMByOrg = false;
    private MergeModeEnum mergeType = MergeModeEnum.ORDINAL;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    public void onLoad() throws Exception {
        this.initCSLContext();
        this.isDisplayAdjustRPTMByOrg = CslRptUtil.isDisplayAdjustRPTMByOrg(null);
        this.mergeType = CslRptUtil.getMergeMode(this.getCSLContext().getCurOrgBound());
        this.init();
        this.initListeners();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void init() throws Exception {
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        for (int i = 1; i <= 6; ++i) {
            this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.getEnum((int)i));
        }
        this.cbxPeriodType.setSelectedItem((Object)this.getCSLContext().getCurRptPeriodType(), false);
        this.initTimeCtrlValAndStatusByContextAndPrePeriod(true);
        this.cbxAdjustMode.addItem((Object)this.selectAll);
        this.cbxAdjustMode.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        AdjustModeCollection adjustModeCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            if (this.iAdjustMode == null) {
                this.iAdjustMode = AdjustModeFactory.getRemoteInstance();
            }
            CslGradeManageUtil.filterAdjustModeGradeManage(null, (EntityViewInfo)viewInfo, null);
            currencyCollection = this.iCurrency.getCurrencyCollection(true);
            adjustModeCollection = this.iAdjustMode.getAdjustModeCollection(viewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            this.cbxCurrency.addItem((Object)this.selectAll);
            this.cbxSourceCurrency.addItem((Object)this.selectAll);
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cbxCurrency.addItem((Object)currencyCollection.get(i));
                this.cbxSourceCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxAuditStatus.addItem((Object)this.selectAll);
        this.cbxAuditStatus.addItems(CheckedStatusEnum.getEnumList().toArray());
        if (adjustModeCollection != null && adjustModeCollection.size() > 0) {
            for (int i = 0; i < adjustModeCollection.size(); ++i) {
                this.cbxAdjustMode.addItem((Object)adjustModeCollection.get(i));
            }
        }
        try {
            this.bizPrmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.NewUnionTreeQuery");
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("unit.id"));
            view.getSelector().add(new SelectorItemInfo("unit.number"));
            view.getSelector().add(new SelectorItemInfo("unit.name"));
            view.setFilter(new FilterInfo());
            FilterItemCollection filterItems = view.getFilter().getFilterItems();
            filterItems.add(new FilterItemInfo("tree.id", (Object)this.getCSLContext().getCurOrgBound().getId().toString()));
            filterItems.add(new FilterItemInfo("longNumber", (Object)(this.getCSLContext().getCurOrgGroup().getLongNumber() + "%"), CompareType.LIKE));
            this.bizPrmtCompany.setEntityViewInfo(view);
            this.bizPrmtCompany.getQueryAgent().setSelectorCollection(view.getSelector());
            this.bizPrmtCompany.setEditFormat("$number$");
            this.bizPrmtCompany.setDisplayFormat("$name$");
            this.bizPrmtCompany.setCommitFormat("$unit.number$");
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.getCSLContext().getCurOrgGroup().getId().toString());
            f7.setTreeID(this.getCSLContext().getCurOrgBound().getId().toString());
            if (this.isDisplayAdjustRPTMByOrg) {
                f7.filterUnitSql(UnionF7Helper.getQueryOrgUnitIDSql((String)this.getCSLContext().getCurOrgBound().getId().toString(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
            }
            if (MergeModeEnum.ORDINAL.equals((Object)this.mergeType)) {
                f7.filterUnitSql(UnionF7Helper.getMergeModeOrgUnitIDSqlForConvt((String)this.getCSLContext().getCurOrgBound().getId().toString(), (String)this.getCSLContext().getCurOrgGroup().getId().toString(), (MergeModeEnum)this.mergeType));
            }
            f7.setMultiSelect(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            f7.setCtrlUnitPK(this.getCSLContext().getCurOrgBound().getCU());
            f7.setShowSub(true);
            this.bizPrmtCompany.setSelector((KDPromptSelector)f7);
            this.bizPrmtCompany.setEditable(true);
            if (this.getUIContext().get("company") != null) {
                this.bizPrmtCompany.setEditable(false);
                this.bizPrmtCompany.setEnabled(false);
                this.bizPrmtCompany.setValue(this.getUIContext().get("company"));
            }
            if (this.getUIContext().get("OrgUnit") != null) {
                this.bizPrmtCompany.setEditable(false);
                this.bizPrmtCompany.setEnabled(false);
                this.bizPrmtCompany.setValue(this.getUIContext().get("OrgUnit"));
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.txtDebitFrom.setSupportedEmpty(true);
        this.txtDebitTo.setSupportedEmpty(true);
        this.txtCreditFrom.setSupportedEmpty(true);
        this.txtCreditTo.setSupportedEmpty(true);
        this.repDate.setSupportedEmpty(false);
    }

    private void initListeners() {
        this.bizPrmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CopyHisDataFilterUI.this.handleCompanyChange();
            }
        });
    }

    private void handleCompanyChange() {
        Object data = this.bizPrmtCompany.getData();
        if (data instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnit = (OrgUnitInfo)data;
            if (!orgUnit.isIsGrouping()) {
                this.bizPrmtCompany.setData((Object)orgUnit.castToFullOrgUnitInfo());
            }
        } else if (data instanceof OrgStructureInfo) {
            this.bizPrmtCompany.setData((Object)((OrgStructureInfo)data).getUnit());
        } else {
            this.bizPrmtCompany.setData(null);
        }
    }

    private void initTimeCtrlValAndStatusByContextAndPrePeriod(boolean isAddListener) throws BOSException, EASBizException {
        if (this.fiscalRefCtrl == null) {
            this.fiscalRefCtrl = new FiscalYearPeriodDateTmp(this.getCSLContext().getCurOrgBound(), this.cbxPeriodType, this.repDate, this.spYear, this.spPeriod);
        }
        this.fiscalRefCtrl.initTimeCtrlValAndStatusByContextAndPrePeriod(this.getCSLContext(), (CoreUIObject)this, null, true, isAddListener);
        this.refreshTimeInfo(this.repDate.getSqlDate());
    }

    public FilterInfo getFilterInfo() {
        Set orgNumbers;
        StringBuffer sbFormula;
        int formulaIndex;
        block36: {
            FilterItemInfo filterItemCurrency;
            if (this.filterInfo == null) {
                this.filterInfo = new FilterInfo();
            } else {
                this.filterInfo.getFilterItems().clear();
            }
            formulaIndex = 0;
            sbFormula = new StringBuffer();
            try {
                FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.number", (Object)this.getCSLContext().getCurOrgBound().getNumber(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItem0);
                sbFormula.append(" #" + formulaIndex++);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
            if (this.cbxPeriodType.getSelectedItem() != null) {
                Integer periodType = new Integer(((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue());
                FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)periodType, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterPeriodType);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.spYear.getValue() != null) {
                FilterItemInfo filterYear = new FilterItemInfo("year", (Object)((Integer)this.spYear.getValue()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterYear);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.spPeriod.getValue() != null) {
                FilterItemInfo filterPeriod = new FilterItemInfo("period", (Object)((Integer)this.spPeriod.getValue()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterPeriod);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.cbxAdjustMode.getSelectedItem() != null && !this.cbxAdjustMode.getSelectedItem().equals(this.selectAll)) {
                String adjustModeId = ((AdjustModeInfo)this.cbxAdjustMode.getSelectedItem()).getId().toString();
                FilterItemInfo filterItemAdjustMode = new FilterItemInfo("adjustMode.id", (Object)adjustModeId, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemAdjustMode);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
                filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemCurrency);
                sbFormula.append(" and #" + formulaIndex++);
            } else if (this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
                filterItemCurrency = new FilterItemInfo("currency.id", (Object)this.selectAll, CompareType.NOTEQUALS);
                this.filterInfo.getFilterItems().add(filterItemCurrency);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.cbxSourceCurrency.getSelectedItem() != null && !this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
                filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.cbxSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemCurrency);
                sbFormula.append(" and #" + formulaIndex++);
            } else if (this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
                filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)this.selectAll, CompareType.NOTEQUALS);
                this.filterInfo.getFilterItems().add(filterItemCurrency);
                sbFormula.append(" and #" + formulaIndex++);
            }
            OrgUnitInfo uif = null;
            try {
                if (this.bizPrmtCompany.getData() != null) {
                    if (this.bizPrmtCompany.getData() instanceof OrgUnitInfo) {
                        uif = (OrgUnitInfo)this.bizPrmtCompany.getData();
                    } else {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"340_CopyHisDataFilterUI"));
                        SysUtil.abort();
                    }
                    String number = uif.getNumber();
                    FilterItemInfo filterItemCompany = new FilterItemInfo("orgUnit.number", (Object)number, CompareType.EQUALS);
                    this.filterInfo.getFilterItems().add(filterItemCompany);
                    sbFormula.append("  and  #" + formulaIndex++);
                    break block36;
                }
                OrgTreeInfo newOrgTree = this.getCSLContext().getCurOrgBound();
                uif = this.getCSLContext().getCurOrgGroup();
                String number = CslRptUIUtil.getCompanyStructureNumber(newOrgTree, uif);
                Date date = (Date)this.repDate.getValue();
                long time = date.getTime();
                Timestamp timeStamp = new Timestamp(time);
                String orgTreeNumber = newOrgTree.getNumber();
                OrgTreeInfo orgTree = this.getOrgTree(orgTreeNumber, timeStamp);
                if (orgTree != null) {
                    String orgTreeId = orgTree.getId().toString();
                    String orgUnitNumber = uif.getNumber();
                    boolean isUnion = uif.isIsUnion();
                    number = this.getOrgUnitLongNumber(orgTreeId, orgUnitNumber, isUnion);
                }
                this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)(number + "!%"), CompareType.LIKE));
                this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)number, CompareType.EQUALS));
                int mergeMode = 1;
                try {
                    mergeMode = CslRptUtil.getMergeMode(this.getCSLContext().getCurOrgBound()).getValue();
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                if (1 == mergeMode) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)(number + "!%!%"), CompareType.NOTLIKE));
                    sbFormula.append(" and (#" + formulaIndex++ + " or #" + formulaIndex++ + ")  and #" + formulaIndex++);
                } else {
                    sbFormula.append(" and (#" + formulaIndex++ + " or #" + formulaIndex++ + ") ");
                }
            }
            catch (Exception e2) {
                this.handUIException(e2);
            }
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cbxAuditStatus.getSelectedItem() != null && !this.cbxAuditStatus.getSelectedItem().equals(this.selectAll)) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("CheckedStatus", (Object)new Integer(this.cbxAuditStatus.getSelectedIndex())));
            sbFormula.append(" and #" + formulaIndex++);
        }
        FilterItemInfo citeByLater = new FilterItemInfo("isCitedByLater", (Object)new Integer(1), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(citeByLater);
        sbFormula.append(" and #" + formulaIndex++);
        if (null != this.txtCustomNumber.getText() && this.txtCustomNumber.getText().length() > 0) {
            String customNumber = this.txtCustomNumber.getText();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("customNumber", (Object)customNumber));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.isDisplayAdjustRPTMByOrg && (orgNumbers = (Set)this.getUIContext().get("orgNumbers")) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.Number", (Object)orgNumbers, CompareType.INCLUDE));
            sbFormula.append("  and  #" + formulaIndex++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        try {
            if (this.isDisplayAdjustRPTMByOrg) {
                StringBuffer sql = new StringBuffer();
                sql.append(" orgUnit.number in( ");
                sql.append(UnionF7Helper.getQueryOrgUnitNumberSql((String)this.getCSLContext().getCurOrgBound().getId().toString(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
                sql.append(")");
                FilterInfo orgRangeFilter = new FilterInfo(sql.toString());
                this.filterInfo.mergeFilter(orgRangeFilter, "and");
            }
        }
        catch (Exception e) {
            logger.error((Object)"filter org permission error.", (Throwable)e);
            this.handUIException(e);
        }
        return this.filterInfo;
    }

    private OrgTreeInfo getOrgTree(String orgTreeNumber, Timestamp timeStamp) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgTreeNumber, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)8, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.NOTEQUALS));
        view.setFilter(filter);
        OrgTreeCollection orgTreeColl = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(view);
        if (orgTreeColl != null && !orgTreeColl.isEmpty()) {
            Iterator it = orgTreeColl.iterator();
            Timestamp startDate = null;
            Timestamp endDate = null;
            while (it.hasNext()) {
                OrgTreeInfo orgTree = (OrgTreeInfo)it.next();
                if (orgTree.isIsHide()) continue;
                startDate = orgTree.getStartDate();
                endDate = orgTree.getEndDate();
                if (startDate == null || timeStamp.compareTo((Date)startDate) < 0 || endDate != null && (endDate == null || ((Date)endDate).compareTo(timeStamp) < 0)) continue;
                return orgTree;
            }
        }
        return null;
    }

    private String getOrgUnitLongNumber(String orgTreeId, String orgUnitNumber, boolean isUnion) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.number", (Object)orgUnitNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.isUnion", (Object)(isUnion ? 1 : 0), CompareType.EQUALS));
        view.setFilter(filter);
        OrgStructureCollection orgStructures = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view);
        if (orgStructures != null && !orgStructures.isEmpty()) {
            return orgStructures.get(0).getLongNumber();
        }
        return null;
    }

    private void clearUI() {
        if (this.cbxAuditStatus.getItemCount() != 0) {
            this.cbxAuditStatus.setSelectedIndex(0);
        }
        try {
            this.cbxPeriodType.setSelectedItem((Object)this.getCSLContext().getCurRptPeriodType());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        this.cbxAdjustMode.setSelectedItem((Object)this.selectAll);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.txtDebitFrom.setValue(null);
        this.txtDebitTo.setValue(null);
        this.txtCreditFrom.setValue(null);
        this.txtCreditTo.setValue(null);
        this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
        try {
            this.initTimeCtrlValAndStatusByContextAndPrePeriod(false);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void clear() {
        super.clear();
        this.clearUI();
        if (this.getUIContext().get("company") != null) {
            this.bizPrmtCompany.setData((Object)SysContext.getSysContext().getCurrentOrgUnit());
        } else if (this.getUIContext().get("OrgUnit") != null) {
            this.bizPrmtCompany.setValue(this.getUIContext().get("OrgUnit"));
        } else {
            this.bizPrmtCompany.setData(null);
        }
    }

    @Override
    protected void cbxPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTimeInfo(this.repDate.getSqlDate());
    }

    @Override
    protected void repDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private void refreshTimeInfo(Date newDate) throws BOSException {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (periodType == null || newDate == null || this.fiscalRefCtrl == null) {
            return;
        }
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod()) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, periodType);
        newDate = (Date)times.get(2);
        this.repDate.setValue((Object)newDate);
        this.spYear.setValue((Object)new Integer(times.get(0).toString()));
        if (this.spPeriod.getValue() != null) {
            Integer Period = (Integer)this.spPeriod.getValue();
            if (!(this.fiscalRefCtrl.isSupport13Period() && RPTDateUtil.isYearLastPeriod(newDate, RptPeriodTypeEnum.MONTHLY) && RptPeriodTypeEnum.MONTHLY.equals((Object)periodType) && Period == 13)) {
                this.spPeriod.setValue((Object)new Integer(times.get(1).toString()));
            }
        }
        this.spPeriod.setEnabled(false);
        CslRptUtil.refresh13PeriodInCsl(periodType, this.getCSLContext().getCurDataCollect().getNumber(), newDate, this.spPeriod, this.getCSLContext().getCurRptPeriod(), this.fiscalRefCtrl.isSupport13Period());
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block0: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            CurrencyInfo currencyInfo;
            int j;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                Integer periodType = (Integer)filterItemInfo.getCompareValue();
                for (j = 0; j < this.cbxPeriodType.getItemCount(); ++j) {
                    if (((RptPeriodTypeEnum)this.cbxPeriodType.getItemAt(j)).getValue() != periodType.intValue()) continue;
                    this.cbxPeriodType.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("date")) {
                Date time = (Date)filterItemInfo.getCompareValue();
                this.repDate.setValue((Object)new Date(time.getTime()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                this.spYear.setValue((Object)((Integer)filterItemInfo.getCompareValue()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                this.spPeriod.setValue((Object)((Integer)filterItemInfo.getCompareValue()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("adjustMode.id")) {
                String adjustModeId = (String)filterItemInfo.getCompareValue();
                for (j = 1; j < this.cbxAdjustMode.getItemCount(); ++j) {
                    AdjustModeInfo adjustModeInfo = (AdjustModeInfo)this.cbxAdjustMode.getItemAt(j);
                    if (!adjustModeInfo.getId().toString().equals(adjustModeId)) continue;
                    this.cbxAdjustMode.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                String currencyId = (String)filterItemInfo.getCompareValue();
                if (currencyId.equals(this.selectAll)) {
                    this.cbxCurrency.setSelectedItem((Object)this.selectAll);
                    continue;
                }
                for (j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceCurrency.id")) {
                String currencyId = (String)filterItemInfo.getCompareValue();
                if (currencyId.equals(this.selectAll)) {
                    this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
                    continue;
                }
                for (j = 1; j < this.cbxSourceCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxSourceCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxSourceCurrency.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtNumberFrom.setText(number);
                    continue;
                }
                this.txtNumberTo.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("CheckedStatus")) {
                int checkedStatus = (Integer)filterItemInfo.getCompareValue();
                if (checkedStatus <= 0) continue;
                this.cbxAuditStatus.setSelectedIndex(checkedStatus);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.debit")) {
                BigDecimal debit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtDebitFrom.setValue((Object)debit);
                    continue;
                }
                this.txtDebitTo.setValue((Object)debit);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("entries.credit")) continue;
            BigDecimal credit = new BigDecimal(filterItemInfo.getCompareValue().toString());
            if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                this.txtCreditFrom.setValue((Object)credit);
                continue;
            }
            this.txtCreditTo.setValue((Object)credit);
        }
        if (this.spYear.getValue() != null && this.spPeriod.getValue() != null) {
            this.repDate.setValue((Object)RPTDateUtil.getPeriodLastDate((Integer)this.spYear.getValue(), (Integer)this.spPeriod.getValue(), (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()));
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String companyId = this.getcompanyId();
        if (companyId != null) {
            cp.addCustomerParam("companyId", companyId);
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            this.bizPrmtCompany.setData(null);
            return;
        }
        String companyId = cp.getCustomerParam("companyId");
        this.setCompanyInfo(companyId);
    }

    private String getcompanyId() {
        Object companyInfo = this.bizPrmtCompany.getData();
        String companyId = null;
        if (companyInfo != null) {
            companyId = ((OrgUnitInfo)companyInfo).getId().toString();
        }
        return companyId;
    }

    private void setCompanyInfo(Object companyId) {
        if (companyId == null) {
            return;
        }
        String id = (String)companyId;
        try {
            OrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            this.bizPrmtCompany.setData((Object)companyInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if ((ICSLContext)this.getUIContext().get("companyCtx") != null) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("companyCtx");
        } else if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

