/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLResource;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gl.RptBaseFactory;
import com.kingdee.eas.fi.gl.common.RptUIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslBaseMainUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseConditionUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class CslBaseMainUI
extends AbstractCslBaseMainUI
implements KDTDataRequestListener {
    private static final Logger logger = CoreUIObject.getLogger(CslBaseMainUI.class);
    private String tempTableName;
    private IMetaDataPK mdk = null;
    protected CommonQueryDialog queryDialog = new CommonQueryDialog();
    protected RptUIContext cc = null;
    private int printTopMargin = 300;
    protected RptProperties pp = null;
    protected boolean isFirstDefaultQuery = true;
    boolean hasLicence = false;
    ExtVarProvider evp = new ExtVarProvider(){

        public Variant requestVarData(String varName) {
            return CslBaseMainUI.this.requestPrintVariant(varName);
        }
    };

    protected void invokeUIMethod(String methodName, Object[] params, Class[] paramTypes) {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        new UIMethodInvokeThread(methodName, params, paramTypes, this, win).invoke();
    }

    protected void invokeUIMethod(String methodName) {
        this.invokeUIMethod(methodName, null, null);
    }

    protected boolean isCombineSystem() {
        Map map = this.getUIContext();
        String o = (String)map.get("UIClassParam");
        if (o != null && (o.equalsIgnoreCase("InterQuery") || o.equalsIgnoreCase("ExchQuery") || o.equalsIgnoreCase("InterCheck") || o.equalsIgnoreCase("ExchCheck"))) {
            return true;
        }
        return o == null || !o.equalsIgnoreCase("InterCompanyQuery") && !o.equalsIgnoreCase("ExchCompanyQuery") && !o.equalsIgnoreCase("InterProfitQuery") && !o.equalsIgnoreCase("ExchProfitQuery") && !o.equalsIgnoreCase("InterCompanyCheck") && !o.equalsIgnoreCase("ExchCompanyCheck") && !o.equalsIgnoreCase("InterProfitCheck") && !o.equalsIgnoreCase("ExchProfitCheck");
    }

    public void onLoad() throws Exception {
        Map context;
        Object obj = null;
        if (!this.isCombineSystem()) {
            obj = this.getUIContext().get("checkLicense");
            this.getUIContext().put("checkLicense", "false");
            this.hasLicence = CslRptUIUtil.requestLicense(this.getUIContext(), this, OrgViewType.COMPANY.equals((Object)this.getOrgViewType()) ? "RPT" : "PRPT", ((Object)((Object)this)).getClass().getName());
        }
        this.checkPermission();
        super.onLoad();
        if (obj != null) {
            this.getUIContext().put("checkLicense", obj);
        }
        if (Boolean.TRUE.equals((context = this.getUIContext()).get("JoinQuery"))) {
            this.cc = (RptUIContext)context.get("UIReportContext");
        } else {
            this.cc = new RptUIContext(this.getInitRemoteInstance());
            if (!this.showQueryDialog()) {
                this.close();
            }
            this.isFirstDefaultQuery = false;
        }
    }

    protected OrgViewType getOrgViewType() {
        return OrgViewType.COMPANY;
    }

    public IRptBase getInitRemoteInstance() throws BOSException {
        return RptBaseFactory.getRemoteInstance();
    }

    public void close() {
        SysUtil.abort();
    }

    public void setUIReportContext(RptUIContext cc) {
        this.cc = cc;
    }

    public RptUIContext getUIReportContext() {
        return this.cc;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getResourceString(String key) {
        return GLResource.getResourceString((String)key);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (!this.existPrintableTable()) {
            return;
        }
        this.getPrintTable().removeRows();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showQueryDialog();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (!this.existPrintableTable()) {
            return;
        }
        this.preparePrintPage(this.getPrintTable());
        this.getPrintTable().getPrintManager().setBodyTopMargin(300.0f);
        this.getPrintTable().getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (!this.existPrintableTable()) {
            return;
        }
        this.preparePrintPage(this.getPrintTable());
        this.getPrintTable().getPrintManager().setBodyTopMargin(300.0f);
        this.getPrintTable().getPrintManager().printPreview();
    }

    private boolean existPrintableTable() {
        return this.getPrintTable() != null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_filter"));
        this.actionPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected void setQueryMetaDataPK(IMetaDataPK mdk) {
        this.mdk = mdk;
    }

    protected IMetaDataPK getQueryMetaDataPK() {
        if (this.mdk != null) {
            return this.mdk;
        }
        MetaDataPK mpk = null;
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        try {
            mpk = ctx.isQueryBudget() ? new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt", "RPTItemQuery") : new MetaDataPK("com.kingdee.eas.fi.gl.app", "GLReportBalanceListQuery");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return mpk;
    }

    public boolean showQueryDialog() {
        try {
            CslBaseConditionUI rbqp;
            CslBaseConditionUI userPanel = this.getQueryDialogUserPanel();
            if (this.isFirstDefaultQuery) {
                Dimension dd = userPanel.getSize();
                this.queryDialog.setWidth(dd.width);
                this.queryDialog.setHeight(dd.height);
                userPanel.setUIContext(this.cc, this.pp);
                userPanel.loadFields();
                this.queryDialog.removeUserPanel((KDPanel)userPanel);
                this.queryDialog.addUserPanel((KDPanel)userPanel);
                this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
                this.queryDialog.setTitle(userPanel.getUITitle());
                this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
                this.queryDialog.setShowFilter(false);
                this.queryDialog.setShowSorter(false);
                this.queryDialog.setParentUIClassName(userPanel.getMetaDataPK().getFullName());
            }
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = this.getQueryMetaDataPK().getFullName();
            ICSLContext ctx = CSLContextHelper.getCSLContext();
            if (ctx.isQueryBudget()) {
                queryName = "com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery";
            }
            QuerySolutionInfo solution = null;
            if (this.isFirstDefaultQuery) {
                solution = iQuery.getDefaultSolution(userPanel.getMetaDataPK().getFullName(), queryName);
                if ("com.kingdee.eas.fi.gr.cslrpt.client.MInterAndExchCheckageFilterUI".equals(userPanel.getMetaDataPK().getFullName()) && solution != null && solution.getSolutionType().getValue() == "10") {
                    this.isFirstDefaultQuery = false;
                    IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
                    iQuerySolution.saveDefaultSolution(solution.getId().toString(), solution.getParentUIName(), queryName, solution.getRowCount(), false);
                }
            }
            if (this.isFirstDefaultQuery && solution != null) {
                if (solution.getQueryPanelInfo().get(0) != null) {
                    String filterString = solution.getQueryPanelInfo().get(0).getFilterInfo();
                    if (!StringUtils.isEmpty((String)filterString)) {
                        EntityViewInfo view = new EntityViewInfo();
                        view.setFilter(filterString);
                        userPanel.loadData(view);
                    } else {
                        CustomerParams cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
                        if (cp != null) {
                            userPanel.setCustomerParams(cp);
                        }
                    }
                    RptProperties rp = userPanel.getCustomCondition();
                    Object newCondition = this.afterQueryConditionChange(rp);
                    this.query(newCondition);
                    return true;
                }
                if (this.queryDialog.show()) {
                    rbqp = (CslBaseConditionUI)this.queryDialog.getUserPanel(0);
                    Object newCondition = this.afterQueryConditionChange(rbqp.getCustomCondition());
                    this.query(newCondition);
                    return true;
                }
                this.isFirstDefaultQuery = false;
            } else if (this.queryDialog.show()) {
                rbqp = (CslBaseConditionUI)this.queryDialog.getUserPanel(0);
                Object newCondition = this.afterQueryConditionChange(rbqp.getCustomCondition());
                this.query(newCondition);
                return true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return false;
    }

    protected void disposeUIWindow() {
        if (this.tempTableName != null) {
            try {
                RptBaseFactory.getRemoteInstance().dropTable(this.tempTableName);
            }
            catch (BOSException e) {
                logger.error((Object)"disposeUIWindow_BOSException", (Throwable)e);
            }
        }
        if (this.hasLicence) {
            CslRptUIUtil.releaseLicense(OrgViewType.COMPANY.equals((Object)this.getOrgViewType()) ? "RPT" : "PRPT", ((Object)((Object)this)).getClass().getName());
        }
        super.disposeUIWindow();
    }

    public void setTempTableName(String tempTableName) {
        this.tempTableName = tempTableName;
    }

    public String getTempTableName() {
        return this.tempTableName;
    }

    protected String getResourceNameForPrint() {
        return "com.kingdee.eas.fi.gl.ReportPrintTitle";
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        return this.evp;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        this.printTopMargin = 160 + this.appendHeadRow(header);
    }

    private Variant requestPrintVariant(String varName) {
        String varValue = null;
        if (varName.equals("CompanyName")) {
            varValue = this.getUIReportContext().getCompany().getName();
        } else if (varName.equals("User")) {
            varValue = SysContext.getSysContext().getUserName();
        }
        if (varValue != null) {
            Variant v = new Variant();
            v.setObject((Object)varValue);
            return v;
        }
        return this.getPrintVariant(varName);
    }

    public String getPeriodTitle(int periodYearStart, int periodNumberStart, int periodYearEnd, int periodNumberEnd) {
        String resxName = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";
        String strYear = EASResource.getString((String)resxName, (String)"NIAN");
        String strNumber = EASResource.getString((String)resxName, (String)"DI");
        String strPeriod = EASResource.getString((String)resxName, (String)"QI");
        String strSeparator = EASResource.getString((String)resxName, (String)"SEPARATOR");
        StringBuffer title = new StringBuffer();
        if (periodYearStart == periodYearEnd && periodNumberStart == periodNumberEnd) {
            title.append(periodYearStart).append(strYear).append(strNumber).append(periodNumberStart).append(strPeriod);
        } else {
            title.append(periodYearStart).append(strYear).append(strNumber).append(periodNumberStart).append(strPeriod).append(strSeparator).append(periodYearEnd).append(strYear).append(strNumber).append(periodNumberEnd).append(strPeriod);
        }
        return title.toString();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        throw new RuntimeException("Not implements error!");
    }

    protected abstract KDTable getPrintTable();

    protected abstract Variant getPrintVariant(String var1);

    protected int appendHeadRow(HeadFootModel header) {
        return 0;
    }

    public void setPrecision(int iCurrencyPrecision, IRow row, int rowIndex) {
        BigDecimal amount = null;
        amount = (BigDecimal)row.getCell(rowIndex).getValue();
        if (amount == null || amount.compareTo(BigDecimal.valueOf(0L)) == 0) {
            row.getCell(rowIndex).setValue(null);
        } else {
            amount = amount.setScale(iCurrencyPrecision, 4);
            row.getCell(rowIndex).setValue((Object)amount);
            row.getCell(rowIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public void setPrecision(int iCurrencyPrecision, IRow row, String colName) {
        BigDecimal amount = null;
        amount = (BigDecimal)row.getCell(colName).getValue();
        if (amount == null || amount.compareTo(BigDecimal.valueOf(0L)) == 0) {
            row.getCell(colName).setValue(null);
        } else {
            amount = amount.setScale(iCurrencyPrecision, 4);
            row.getCell(colName).setValue((Object)amount);
            row.getCell(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void checkPermission() throws EASBizException, BOSException {
    }

    public abstract void query(Object var1) throws Exception;

    public abstract CslBaseConditionUI getQueryDialogUserPanel();

    public Object afterQueryConditionChange(Object condition) throws Exception {
        return condition;
    }

    public int getMaxRowCount() {
        return this.queryDialog.getMaxReturnRowCount();
    }

    public void showBarMessage(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    protected int getInterExchPage() {
        int pageCount = 1500;
        try {
            String pageCountStr = CslRptUtil.getCslParamToString(null, "KEY_CSLPARAM_INTEREXCH_PAGECOUNT");
            if (pageCountStr != null) {
                pageCount = Integer.valueOf(pageCountStr);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            pageCount = 1500;
        }
        return pageCount;
    }

    protected class UIMethodInvokeThread
    extends Thread {
        Window window = null;
        CoreUI ui = null;
        String method = null;
        Object[] params = null;
        Class[] paramTypes = null;

        public UIMethodInvokeThread(String method, Object[] params, Class[] paramTypes, CoreUI ui, Window win) {
            this.method = method;
            this.params = params;
            this.paramTypes = paramTypes;
            this.ui = ui;
            this.window = win;
        }

        public void invoke() {
            this.start();
        }

        @Override
        public void run() {
            try {
                this.setCursorOfWair();
                this.ui.setEnabled(false);
                Method mm = this.ui.getClass().getMethod(this.method, this.paramTypes);
                mm.invoke((Object)this.ui, this.params);
            }
            catch (Exception e) {
                logger.error((Object)"UIMethodInvokeThread_Exception", (Throwable)e);
            }
            finally {
                this.ui.setEnabled(true);
                this.setCursorOfDefault();
                this.ui.invalidate();
                this.ui.repaint();
            }
        }

        public void setCursorOfWair() {
            this.window.setCursor(Cursor.getPredefinedCursor(3));
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CslBaseMainUI.this.lockUIAndAction();
                        CslBaseMainUI.this.getMainStatusBar().getProgressBar().setIndeterminate(true);
                    }
                });
            }
        }

        public void setCursorOfDefault() {
            if (this.window != null) {
                this.window.setCursor(Cursor.getDefaultCursor());
                this.window = null;
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CslBaseMainUI.this.unLockUIAndAction();
                            CslBaseMainUI.this.getMainStatusBar().getProgressBar().setIndeterminate(false);
                        }
                    });
                }
            }
        }
    }
}

