/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IRPTDataService;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslRptGroupCommitUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;

public class CslRptGroupCommitUI
extends AbstractCslRptGroupCommitUI
implements ICSLContextUI {
    private ICurrency iCurrency = null;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private String resName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
    private OrgTreeInfo orgTreeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private Boolean select = true;
    private Boolean unSelect = false;

    public boolean destroyWindow() {
        CSLContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CSLContextHelper.registUIObject(this);
        this.initUI();
        this.initData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectCompany.setIcon(EASResource.getIcon((String)"imgTbtn_selectcompany"));
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_unsubmit"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        super.actionCheck_actionPerformed(e);
        ArrayList<String> currencys = new ArrayList<String>();
        ArrayList<String> companys = new ArrayList<String>();
        if (this.tblCompany.getRowCount() == 0) {
            String resName1 = "Select_OrgUnit";
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName1));
            return;
        }
        for (int i = 0; i < this.tblCompany.getRowCount(); ++i) {
            row = this.tblCompany.getRow(i);
            companys.add(((OrgUnitInfo)row.getCell(3).getValue()).getId().toString());
        }
        for (int i = 0; i < this.tblCurrency.getRowCount(); ++i) {
            row = this.tblCurrency.getRow(i);
            boolean isSelect = (Boolean)row.getCell(1).getValue();
            if (!isSelect) continue;
            currencys.add(((CurrencyInfo)row.getCell(4).getValue()).getId().toString());
        }
        if (currencys.size() == 0) {
            String resName2 = "Select_Currency";
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName2));
            return;
        }
        IRPTDataService dataService = RPTDataServiceFactory.getRemoteInstance();
        if (this.getUIContext().get("isUnCommit") == null) {
            try {
                dataService.groupCommit(this.ctx, companys, currencys);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"CommitOK"));
            }
            catch (Exception ee) {
                this.handUIException(ee);
                return;
            }
        }
        try {
            Map result = dataService.unGroupCommit(this.ctx, companys, currencys);
            if (result == null || result.size() == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"UnCommitOK"));
            } else {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"String", (Object)result.get("report").toString());
                uiContext.put((Object)"Title", (Object)CslRptUtil.getString("CslRptUncommitResultTitle"));
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getResultUIName(), (Map)uiContext, null);
                uiWindow.show();
            }
        }
        catch (Exception ee) {
            this.handUIException(ee);
            return;
        }
        this.destroyWindow();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        super.actionClear_actionPerformed(e);
        if (this.tabPaneTotal.getSelectedIndex() == 1) {
            for (int i = 0; i < this.tblCurrency.getRowCount(); ++i) {
                IRow row = this.tblCurrency.getRow(i);
                row.getCell(1).setValue((Object)this.unSelect);
            }
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        if (this.tabPaneTotal.getSelectedIndex() == 1) {
            for (int i = 0; i < this.tblCurrency.getRowCount(); ++i) {
                IRow row = this.tblCurrency.getRow(i);
                row.getCell(1).setValue((Object)this.select);
            }
        }
    }

    @Override
    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectCompany_actionPerformed(e);
        OrgTreeInfo infos = this.orgTreeInfo;
        int selectMode = 3;
        Object[] orgArray = CslRptUIUtil.showOrgUnitSubTree((IUIObject)this, infos, this.orgUnitInfo, selectMode, true);
        if (orgArray == null) {
            return;
        }
        this.tblCompany.removeRows();
        int count = orgArray.length;
        for (int i = 0; i < count; ++i) {
            OrgUnitInfo company = (OrgUnitInfo)orgArray[i];
            IRow row = this.tblCompany.addRow();
            row.getCell(0).setValue((Object)company.getId());
            row.getCell(1).setValue((Object)company.getNumber());
            row.getCell(2).setValue((Object)company.getName());
            row.getCell(3).setValue((Object)company);
        }
    }

    private CurrencyCollection getCurrencyCollection() throws EASBizException, BOSException {
        if (this.iCurrency == null) {
            this.iCurrency = CurrencyFactory.getRemoteInstance();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        return this.iCurrency.getCurrencyCollection(viewInfo, true);
    }

    private String getResultUIName() {
        return SimpleNotePad.class.getName();
    }

    private void addCurrencyToTable(CurrencyCollection currencys, KDTable table) {
        table.removeRows();
        if (currencys != null) {
            int count = currencys.size();
            for (int i = 0; i < count; ++i) {
                CurrencyInfo currency = currencys.get(i);
                IRow r = table.addRow();
                r.getCell(0).setValue((Object)currency.getId());
                r.getCell(1).setValue((Object)this.unSelect);
                r.getCell(2).setValue((Object)currency.getNumber());
                r.getCell(3).setValue((Object)currency.getName());
                r.getCell(4).setValue((Object)currency);
            }
        }
    }

    private void initData() throws EASBizException, BOSException {
        this.orgTreeInfo = this.ctx.getCurOrgBound();
        this.orgUnitInfo = this.ctx.getCurOrgGroup();
        this.addCurrencyToTable(this.getCurrencyCollection(), this.tblCurrency);
    }

    private void initUI() {
        this.tblCompany.checkParsed();
        this.tblCurrency.checkParsed();
        this.btnCheck.setEnabled(true);
        this.btnClear.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnSelectCompany.setEnabled(true);
        if (this.getUIContext().get("isUnCommit") != null) {
            this.btnCheck.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"BtnText_UnSummit"));
        }
    }
}

