/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IRPTDataService;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslRptItemDataListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptItemDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class CslRptItemDataListUI
extends AbstractCslRptItemDataListUI
implements ICSLContextUI {
    private static final Logger logger = Logger.getLogger(CslRptItemDataListUI.class);
    CommonQueryDialog conditionDialog = null;
    CslRptItemDataFilterUI conditionPanel = null;
    ICSLContext cslCtx = CSLContextHelper.getCSLContext();
    ItemDataCondition condition = null;
    HashMap extCondition = null;
    private boolean isFirstDefaultQuery = true;
    protected EntityViewInfo ev;
    boolean isFirstLoad = true;
    private boolean isSupportOtherDS;
    private boolean isMergeByFiscalPeriod;
    private boolean isSupport13Period;
    private boolean isParamadjustSeparate;
    private Map mapCurrency = new HashMap();

    public CslRptItemDataListUI() throws Exception {
        boolean[] values = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_SupportOtherDS", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period", "GR_CSL_AdjustSeparate"});
        this.isSupportOtherDS = values[0];
        this.isMergeByFiscalPeriod = values[1];
        this.isSupport13Period = values[2];
        this.isParamadjustSeparate = values[3];
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"SumRptQuery");
            ICSLContext ctx = CSLContextHelper.getCSLContext();
            if (ctx.isQueryBudget()) {
                mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
            }
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CslRptItem_FilterUI_Title"));
            this.conditionDialog.setWidth(540);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.gr.cslrpt.client.CslRptItemDataListUI");
        }
        return this.conditionDialog;
    }

    public CslRptItemDataFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CslRptItemDataFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.kdtItemDatas.checkParsed();
        this.kdtItemDatas.getSelectManager().setSelectMode(2);
        this.kdtItemDatas.getStyleAttributes().setLocked(true);
        this.kdtItemDatas.removeRows();
        if (this.isSupportOtherDS) {
            this.kdtItemDatas.getColumn("dataCollect").getStyleAttributes().setHided(false);
        } else {
            this.kdtItemDatas.getColumn("dataCollect").getStyleAttributes().setHided(true);
        }
        this.initData();
        this.popFilterDialog();
    }

    protected void popFilterDialog() throws Exception {
        this.conditionDialog = this.getConditionDialog();
        String queryName = "com.kingdee.eas.fi.gr.cslrpt.SumRptQuery";
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        if (ctx.isQueryBudget()) {
            queryName = "com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery";
        }
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        String currUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        QuerySolutionInfo solution = null;
        if (this.isFirstDefaultQuery) {
            solution = QuerySolutionFacadeFactory.getRemoteInstance().getDefaultSolution(this.getMetaDataPK().getFullName(), queryName, companyID, currUserID);
        }
        if (this.isFirstDefaultQuery && solution != null) {
            this.isFirstDefaultQuery = false;
            if (solution.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION) || solution.getName().equals(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonQueryPanel", (String)"sysDefaultRule"))) {
                this.ev = new EntityViewInfo();
                this.ev.setFilter(this.getDefaultFilterForQuery());
            } else {
                this.ev = (EntityViewInfo)QuerySolutionFacadeFactory.getRemoteInstance().getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName, companyID, currUserID);
            }
            if (this.ev == null) {
                this.ev = new EntityViewInfo();
            }
            if (this.ev.getFilter() == null) {
                this.ev.setFilter(new FilterInfo());
            }
            this.conditionPanel.onLoad();
            this.conditionPanel.loadData(this.ev);
            this.conditionPanel.verify();
            this.queryData(true);
        } else {
            if (this.isFirstDefaultQuery) {
                this.isFirstDefaultQuery = false;
            }
            if (this.conditionDialog.show()) {
                this.queryData(false);
            } else {
                SysUtil.abort();
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.cslCtx.getCurReportDate());
        Timestamp startTime = new Timestamp(calendar.getTimeInMillis());
        FilterItemInfo filterStartDate = new FilterItemInfo("lastUpdateTime", (Object)startTime, CompareType.GREATER_EQUALS);
        filterInfo.getFilterItems().add(filterStartDate);
        FilterItemInfo filterEndDate = new FilterItemInfo("lastUpdateTime", (Object)startTime, CompareType.LESS_EQUALS);
        filterInfo.getFilterItems().add(filterEndDate);
        FilterItemInfo filterItemLevel = new FilterItemInfo("itemLevel", (Object)new Integer(1));
        filterInfo.getFilterItems().add(filterItemLevel);
        FilterItemInfo filterItemLevelTo = new FilterItemInfo("itemLevelTo", (Object)new Integer(1));
        filterInfo.getFilterItems().add(filterItemLevelTo);
        FilterItemInfo filterType = new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterType);
        FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()));
        filterInfo.getFilterItems().add(filterPeriodType);
        FilterItemInfo filterAdjust = new FilterItemInfo("isAdjusted", (Object)new Integer(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterAdjust);
        FilterItemInfo filterShowNull = new FilterItemInfo("showNull", (Object)new Integer(0), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterShowNull);
        FilterItemInfo filterShowSum = new FilterItemInfo("showSum", (Object)new Integer(0), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterShowSum);
        FilterItemInfo filterShowFreeze = new FilterItemInfo("isShowFreezeItem", (Object)new Integer(0), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterShowFreeze);
        filterShowFreeze = new FilterItemInfo("defaultOrgBound", (Object)"defaultOrgBound", CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterShowFreeze);
        return filterInfo;
    }

    protected KDTable getTableForCommon() {
        return this.kdtItemDatas;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        this.popFilterDialog();
    }

    private void queryData(boolean refresh) throws BOSException, EASBizException {
        if (!refresh || this.ev == null) {
            this.ev = this.conditionDialog.getEntityViewInfoResult();
        }
        HashMap result = this.constructCondition(this.ev);
        this.condition = (ItemDataCondition)result.get("condition");
        this.extCondition = (HashMap)result.get("extCondition");
        if (this.condition != null && this.extCondition != null) {
            if (this.condition.getRptPeriodType() != -1) {
                this.txtPeriodType.setText(RptPeriodTypeEnum.getEnum((int)this.condition.getRptPeriodType()).getAlias());
            } else {
                this.txtPeriodType.setText(CslRptUtil.getString("CslRptItemDataNameAll"));
            }
            this.txtPeriodType.setEnabled(false);
            if (this.extCondition.get("currencyName") != null) {
                String currencyName = (String)this.extCondition.get("currencyName");
                this.txtCurrency.setText(currencyName);
                this.txtCurrency.setEnabled(false);
            }
            this.extCondition.put("maxReturnRowCount", new Integer(this.conditionDialog.getMaxReturnRowCount()));
            this.refreshTable(this.condition, this.extCondition);
        }
    }

    protected void refreshTable(ItemDataCondition condition, HashMap extCondition) throws EASBizException, BOSException {
        ArrayList obj;
        long counter = System.currentTimeMillis();
        if (!this.isFirstLoad) {
            super.setMessageText(CslRptUtil.getString("CslRptItemDataQuerying"));
            super.showMessage();
        }
        ArrayList result = null;
        IRPTDataService dataService = RPTDataServiceFactory.getRemoteInstance();
        extCondition.put("KEY_ORGUNIT_INFO", this.cslCtx.getCurOrgGroup());
        condition.setQueryHisBudget(this.cslCtx.isQueryBudget());
        condition.setAdjustSeparate(this.isParamadjustSeparate);
        result = obj = dataService.getItemData(condition, extCondition);
        this.loadTable(result);
        if (!this.isFirstLoad) {
            this.showFinalCaclMessage(counter);
        }
        this.isFirstLoad = false;
    }

    private HashMap constructCondition(EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        ItemDataCondition condition = new ItemDataCondition();
        condition.setOrgTreeNumber(this.cslCtx.getCurOrgBound().getNumber());
        condition.setCommitStatus(3);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        int periodType = -1;
        Date startDate = this.cslCtx.getCurReportDate();
        Date endDate = this.cslCtx.getCurReportDate();
        Integer type = new Integer(0);
        boolean isShowNull = false;
        boolean isShowSum = false;
        String currencyName = "";
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgUnit")) {
                String companyID = (String)filterItemInfo.getCompareValue();
                ArrayList<String> companys = new ArrayList<String>();
                companys.add(companyID);
                condition.setOrgUnit(companys);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("defaultOrgBound")) {
                ArrayList orgUnitList = CslRptUtil.getCslOrgs(null, this.cslCtx.getCurOrgBound(), this.cslCtx.getCurOrgGroup());
                orgUnitList.add(this.cslCtx.getCurOrgGroup().getId().toString());
                condition.setOrgUnit(orgUnitList);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("reportClass")) {
                String reportClassID = (String)filterItemInfo.getCompareValue();
                condition.setReportClass(reportClassID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currencyName")) {
                currencyName = (String)filterItemInfo.getCompareValue();
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency")) {
                String currencyID = (String)filterItemInfo.getCompareValue();
                condition.setCurrency(currencyID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("targetCurrency")) {
                String targetCurrencyID = (String)filterItemInfo.getCompareValue();
                condition.setTargetCurrency(targetCurrencyID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("item")) {
                String itemID = (String)filterItemInfo.getCompareValue();
                condition.setItemNumberStart(itemID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemTo")) {
                String itemID = (String)filterItemInfo.getCompareValue();
                condition.setItemNumberEnd(itemID);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemLevel")) {
                Integer level = (Integer)filterItemInfo.getCompareValue();
                condition.setItemNumberLevelStart(level);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemLevelTo")) {
                Integer levelTo = (Integer)filterItemInfo.getCompareValue();
                condition.setItemNumberLevelEnd(levelTo);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isAdjusted")) {
                Integer adjust = (Integer)filterItemInfo.getCompareValue();
                condition.setIsAdjusted(adjust == 1);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataSrc")) {
                Integer dataSrc = (Integer)filterItemInfo.getCompareValue();
                condition.setDataSource(dataSrc);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataElement")) {
                Integer dataElement = (Integer)filterItemInfo.getCompareValue();
                condition.setDataElement(dataElement);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("valueType")) {
                Integer valueType = (Integer)filterItemInfo.getCompareValue();
                condition.setValueType(valueType);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                periodType = (Integer)filterItemInfo.getCompareValue();
                condition.setRptPeriodType(periodType);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("lastUpdateTime")) {
                Timestamp time = (Timestamp)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    startDate = new Date(time.getTime());
                    continue;
                }
                endDate = new Date(time.getTime());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("showNull")) {
                isShowNull = filterItemInfo.getCompareValue() instanceof Boolean ? (Boolean)filterItemInfo.getCompareValue() : (Integer)filterItemInfo.getCompareValue() == 1;
                condition.setIsAllowAmountZero(isShowNull);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("showSum")) {
                if (filterItemInfo.getCompareValue() instanceof Boolean) {
                    isShowSum = (Boolean)filterItemInfo.getCompareValue();
                    continue;
                }
                isShowSum = (Integer)filterItemInfo.getCompareValue() == 1;
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("type")) {
                type = (Integer)filterItemInfo.getCompareValue();
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("isShowFreezeItem")) continue;
            boolean isShowFreezeItem = false;
            isShowFreezeItem = filterItemInfo.getCompareValue() instanceof Boolean ? (Boolean)filterItemInfo.getCompareValue() : (Integer)filterItemInfo.getCompareValue() == 1;
            condition.setIsShowFreezeItem(isShowFreezeItem);
        }
        if (periodType != -1) {
            if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
                try {
                    condition.setRptYearStart(this.cslCtx.getCurRptYear());
                    condition.setRptPeriodStart(this.cslCtx.getCurRptPeriod());
                    condition.setRptYearEnd(this.cslCtx.getCurRptYear());
                    condition.setRptPeriodEnd(this.cslCtx.getCurRptPeriod());
                }
                catch (BOSException e) {
                    logger.error((Object)"FiscalPeriodCondition", (Throwable)e);
                }
            } else {
                int[] yearAndPeriodStart = RPTDateUtil.getPeriod(startDate, RptPeriodTypeEnum.getEnum((int)periodType));
                int[] yearAndPeriodEnd = RPTDateUtil.getPeriod(endDate, RptPeriodTypeEnum.getEnum((int)periodType));
                condition.setRptYearStart(yearAndPeriodStart[0]);
                condition.setRptPeriodStart(yearAndPeriodStart[1]);
                condition.setRptYearEnd(yearAndPeriodEnd[0]);
                condition.setRptPeriodEnd(yearAndPeriodEnd[1]);
            }
        } else {
            condition.setStartDate(startDate);
            condition.setEndDate(endDate);
        }
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        HashMap<String, Object> extCondition = new HashMap<String, Object>();
        extCondition.put("isShowSum", isShowSum);
        extCondition.put("dataType", type);
        if (!currencyName.equals("")) {
            extCondition.put("currencyName", currencyName);
        } else {
            extCondition.put("currencyName", CslRptUtil.getString("CslRptItemDataNameAll"));
        }
        if (this.isSupportOtherDS) {
            condition.setDataCollectNumber(this.cslCtx.getCurDataCollect().getNumber());
        } else {
            condition.setDataCollectNumber("ACTUALDATA");
        }
        if (this.isSupport13Period) {
            if (periodType == 3 && startDate != null && endDate != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(startDate);
                int startMonth = calendar.get(2) + 1;
                int startYear = calendar.get(1);
                calendar.setTime(endDate);
                int endMonth = calendar.get(2) + 1;
                int endYear = calendar.get(1);
                int curPeiod = this.cslCtx.getCurRptPeriod();
                Date curReportDate = this.cslCtx.getCurReportDate();
                calendar.setTime(curReportDate);
                int cslCtxMonth = calendar.get(2) + 1;
                if (cslCtxMonth == 12) {
                    if (startYear == endYear && startMonth == 12 && endMonth == 12) {
                        extCondition.put("period", new Integer(curPeiod));
                    } else if (startDate.compareTo(endDate) <= 0 && (startMonth == 12 || endMonth == 12 || startYear < endYear)) {
                        if (curPeiod == 13) {
                            extCondition.put("query13Period", "Y");
                            extCondition.put("query12Period", "N");
                        } else {
                            extCondition.put("query13Period", "N");
                            extCondition.put("query12Period", "Y");
                        }
                    } else {
                        extCondition.put("query13Period", "N");
                        extCondition.put("query12Period", "N");
                    }
                } else if (startDate.compareTo(endDate) <= 0 && (startMonth == 12 || endMonth == 12 || startYear < endYear)) {
                    extCondition.put("query13Period", "Y");
                    extCondition.put("query12Period", "Y");
                } else {
                    extCondition.put("query13Period", "N");
                    extCondition.put("query12Period", "N");
                }
            }
            extCondition.put("isItemData", "Y");
        } else {
            extCondition.put("isItemData", "N");
            if (periodType == 3 && startDate != null && endDate != null) {
                extCondition.put("query13Period", "N");
            }
        }
        result.put("condition", condition);
        result.put("extCondition", extCondition);
        return result;
    }

    private void initData() throws BOSException {
        OrgTreeInfo orgBound = this.cslCtx.getCurOrgBound();
        this.txtOrgTree.setText(orgBound.getName());
        this.txtOrgTree.setEnabled(false);
        this.txtPeriodType.setText(this.cslCtx.getCurRptPeriodType().getAlias());
        this.txtPeriodType.setEnabled(false);
        this.txtCurrency.setEnabled(false);
    }

    private void loadTable(ArrayList rs) {
        this.kdtItemDatas.setRefresh(false);
        this.kdtItemDatas.removeRows();
        String[] colNames = new String[]{"company.number", "company.name", "item.number", "item.name", "currency.number", "currency.name", "targcurrency.number", "targcurrency.name", "year", "period", "description", "debit", "credit", "itempara", "datatype", "dataCollect", "itemtype", "itempostil"};
        if (rs != null && rs.size() > 0) {
            int iSize = rs.size();
            for (int i = 0; i < iSize; ++i) {
                Object[] row = (Object[])rs.get(i);
                IRow tmpRow = this.kdtItemDatas.addRow();
                for (int j = 0; j < colNames.length; ++j) {
                    Object tmpObj = row[j];
                    if (tmpObj == null) continue;
                    tmpRow.getCell(colNames[j]).setValue(tmpObj);
                }
                tmpRow.getCell(colNames[11]).getStyleAttributes().setNumberFormat("#,##0.00");
                tmpRow.getCell(colNames[12]).getStyleAttributes().setNumberFormat("#,##0.00");
                if (!row[14].equals(ValueTypeEnum.MONEY.getAlias())) continue;
                String currNumber = row[6].toString();
                String formatStr = this.getFormatString(currNumber);
                tmpRow.getCell(colNames[11]).getStyleAttributes().setNumberFormat(formatStr);
                tmpRow.getCell(colNames[12]).getStyleAttributes().setNumberFormat(formatStr);
            }
        }
        this.kdtItemDatas.setRefresh(true);
        this.kdtItemDatas.repaint();
    }

    private String getFormatString(String currNumber) {
        CurrencyInfo info = null;
        int precision = 2;
        if (this.mapCurrency.containsKey(currNumber)) {
            return (String)this.mapCurrency.get(currNumber);
        }
        try {
            info = (CurrencyInfo)CurrencyFactory.getRemoteInstance().getValue(" where number = '" + currNumber + "'");
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (info != null) {
            precision = info.getPrecision();
        }
        String numberFmt = CslRptUIUtil.getNumberFtm(precision);
        this.mapCurrency.put(currNumber, numberFmt);
        return numberFmt;
    }

    private void showFinalCaclMessage(long startTime) {
        long counter = System.currentTimeMillis() - startTime;
        BigDecimal time = new BigDecimal(String.valueOf((double)counter / 1000.0)).setScale(2, 4);
        super.setMessageText(CslRptUtil.getStringWithFormat("CslRptItemDataQueryOK", new Object[]{time.toString()}));
        super.showMessage();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.condition == null) {
            return;
        }
        this.refreshTable(this.condition, this.extCondition);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtItemDatas);
        this.kdtItemDatas.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtItemDatas);
        this.kdtItemDatas.getPrintManager().printPreview();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected boolean isCanCopyPaste() {
        return false;
    }
}

