/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassCollection;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslRptItemF7UI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class CslRptItemF7UI
extends AbstractCslRptItemF7UI {
    private static final Logger logger = CoreUIObject.getLogger(CslRptItemF7UI.class);
    private boolean isCanceled = false;
    private RPTItemInfo rptItemInfo = null;
    private int selectRow = -1;

    public CslRptItemF7UI() throws Exception {
        this.initData();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.queryRPTItemQuery == null) {
            this.queryRPTItemQuery = new EntityViewInfo();
            FilterInfo fltrInfo = new FilterInfo();
            fltrInfo.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
            fltrInfo.setMaskString("#0");
            this.queryRPTItemQuery.setFilter(fltrInfo);
        }
        String companyId = null;
        if (this.getUIContext().containsKey("companyId")) {
            companyId = (String)this.getUIContext().get("companyId");
        }
        CslGradeManageUtil.filterRptItemGradeManage((EntityViewInfo)this.queryRPTItemQuery, companyId);
        this.kdtQueryRPTItemQuery.setEditable(false);
        this.initListeners();
    }

    private void initListeners() {
        this.kdtQueryRPTItemQuery.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                CslRptItemF7UI.this.tableRowSelected(e);
            }
        });
        this.kdtQueryRPTItemQuery.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    CslRptItemF7UI.this.selectRow = e.getRowIndex();
                    CslRptItemF7UI.this.doSelected();
                }
            }
        });
        this.cbxItemType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CslRptItemF7UI.this.queryConditionChange();
            }
        });
        this.chbxShowFreezedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CslRptItemF7UI.this.queryConditionChange();
            }
        });
    }

    private void tableRowSelected(KDTSelectEvent e) {
        this.selectRow = e.getSelectBlock().getBeginRow();
    }

    private void queryConditionChange() {
        FilterInfo fltrInfo = new FilterInfo();
        if (!this.chbxShowFreezedItem.isSelected()) {
            fltrInfo.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
        }
        if (this.cbxItemType.getSelectedIndex() > 0) {
            String rptItemTypeName = this.cbxItemType.getSelectedItem().toString();
            fltrInfo.getFilterItems().add(new FilterItemInfo("reportClass", (Object)rptItemTypeName));
        }
        StringBuffer sbMask = new StringBuffer();
        if (fltrInfo.getFilterItems().size() > 0) {
            sbMask.append(" (#0) ");
            for (int i = 1; i < fltrInfo.getFilterItems().size(); ++i) {
                sbMask.append(" and (#" + i + ") ");
            }
        }
        fltrInfo.setMaskString(sbMask.toString());
        this.queryRPTItemQuery.setFilter(fltrInfo);
        String companyId = null;
        if (this.getUIContext().containsKey("companyId")) {
            companyId = (String)this.getUIContext().get("companyId");
        }
        try {
            CslGradeManageUtil.filterRptItemGradeManage((EntityViewInfo)this.queryRPTItemQuery, companyId);
        }
        catch (Exception e) {
            logger.error((Object)"CslGradeManageUtil.filterRptItemGradeManage error", (Throwable)e);
            SysUtil.abort();
        }
        this.kdtQueryRPTItemQuery.removeRows();
    }

    private void initData() throws BOSException {
        logger.debug((Object)"init report item type data.");
        this.cbxItemType.addItem((Object)"");
        ReportClassCollection reportClassCollection = ReportClassFactory.getRemoteInstance().getReportClassCollection();
        for (int i = 0; i < reportClassCollection.size(); ++i) {
            ReportClassInfo reportClassInfo = reportClassCollection.get(i);
            this.cbxItemType.addItem((Object)reportClassInfo.getName());
        }
    }

    public void doSelected() {
        logger.debug((Object)("select row is:" + this.selectRow));
        IRow row = this.kdtQueryRPTItemQuery.getRow(this.selectRow);
        if (row != null) {
            String id = row.getCell("id").getValue().toString();
            try {
                this.rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (EASBizException e1) {
                logger.error((Object)"RPTItemInfoEASBizException", (Throwable)e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"RPTItemInfoBosException", (Throwable)e1);
            }
            this.isCanceled = false;
            this.getUIWindow().close();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.doSelected();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.rptItemInfo = null;
        this.kdtQueryRPTItemQuery.getSelectManager().getSelectMode();
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public RPTItemInfo getReturnValue() {
        return this.rptItemInfo;
    }

    public boolean isCancel() {
        return this.isCanceled;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

