/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ArchiveFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.IArchive;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslRptUnArchiveUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextManager;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import org.apache.log4j.Logger;

public class CslRptUnArchiveUI
extends AbstractCslRptUnArchiveUI
implements ICSLContextUI {
    private static final Logger logger = Logger.getLogger(CslRptUnArchiveUI.class);
    private OrgTreeInfo orgTreeInfo = null;
    private String treeNumber = null;
    private IArchive iArchive = null;
    private Uuid uuid = null;
    ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String requestId = null;

    public CslRptUnArchiveUI() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.getUIContext().put("checkLicense", "true");
            this.checkLicense();
            this.actionConfirm_actionPerformed(null);
        }
        SysUtil.abort();
    }

    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            CSLContextHelper.registUIObject(this);
            this.init();
            this.requestId = this.ctx.getCurOrgBound().getId().toString();
            this.spYear.setEnabled(false);
            this.spPeriod.setEnabled(false);
        } else {
            SysUtil.abort();
        }
        this.initWorkButton();
        if (CSLContextHelper.getCSLContext().isQueryBudget()) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("budgetHisQueryNotAllow"));
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectOrgUnit.setIcon(EASResource.getIcon((String)"imgTbtn_selectcompany"));
    }

    private void init() {
        this.initOrgTree();
        this.initPeriodType();
    }

    private void initOrgTree() {
        try {
            if (this.ctx.getCurOrgBound() == null) {
                throw new InterCheckException(InterCheckException.HAVE_NO_ORGTREE);
            }
            this.cbxOrgTree.addItem((Object)this.ctx.getCurOrgBound());
            this.treeNumber = this.ctx.getCurOrgBound().getNumber();
            this.cbxOrgTree.setEnabled(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initPeriodType() {
        this.cbxPeriodType.removeAllItems();
        this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.DAILY);
        this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.WEEKLY);
        this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.QUARTERLY);
        this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.SEMIYEARLY);
        this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.YEARLY);
        this.cbxPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
    }

    protected void prepareMutexParameter(ActionEvent e, MutexParameter param) {
        if (this.cbxOrgTree != null && this.cbxOrgTree.getSelectedItem() != null) {
            OrgTreeInfo orgBound = (OrgTreeInfo)this.cbxOrgTree.getSelectedItem();
            param.setOrgUnitID(orgBound.getId());
        }
    }

    @Override
    protected void cbxPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTimeInfo();
    }

    @Override
    protected void dpkDate_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTimeInfo();
    }

    private void refreshTimeInfo() throws EASBizException, BOSException {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        if (this.dpkDate.getSqlDate() == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(this.dpkDate.getSqlDate(), p);
        this.spYear.setValue((Object)new Integer(times.get(0).toString()));
        this.setPeriodForJT13(times);
        this.dpkDate.setValue(times.get(2));
        if (this.treeNumber != null) {
            String number = this.treeNumber;
            String id = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(number, this.dpkDate.getTimestamp());
            this.orgTreeInfo = StringUtils.isEmpty((String)id) ? null : OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectStringPK(id));
            this.cbxOrgTree.removeAllItems();
            this.cbxOrgTree.addItem((Object)this.orgTreeInfo);
        }
    }

    private void setPeriodForJT13(List times) throws BOSException {
        CslRptUtil.setPeriodForJT13(times, (Date)this.dpkDate.getValue(), (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem(), this.spPeriod, this.ctx.getCurRptPeriod());
        DataCollectInfo dataCollect = this.ctx.getCurDataCollect();
        CslRptUtil.refresh13PeriodDataCollect((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem(), dataCollect != null ? dataCollect.getNumber() : "ACTUALDATA", (Date)this.dpkDate.getValue(), this.spPeriod);
    }

    @Override
    protected void cbxOrgTree_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbxOrgTree.getSelectedItem() != null) {
            this.orgTreeInfo = (OrgTreeInfo)this.cbxOrgTree.getSelectedItem();
            this.tblOrgUnit.removeRows();
            this.btnSelectOrgUnit.setEnabled(true);
        } else {
            this.btnSelectOrgUnit.setEnabled(false);
        }
    }

    private boolean requestCheckControlLock() {
        this.uuid = Uuid.create();
        IMutexServiceControl imc = MutexServiceControlFactory.getRemoteInstance();
        MutexParameter param = new MutexParameter();
        param.setRequestId(this.uuid);
        param.setDcName(SysContext.getSysContext().getDcName());
        param.setActionName(((Object)((Object)this.actionConfirm)).toString());
        param.setMutexName(this.requestId);
        param.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        boolean ret = false;
        try {
            ret = imc.requestMutex(param);
        }
        catch (Exception e) {
            logger.error((Object)"requestCheckControlLockException", (Throwable)e);
            ret = false;
        }
        return ret;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        orgUnitIds.add(ctx.getCurOrgGroup().getId().toString());
        IContextManager imanager = ContextManagerFactory.getRemoteInstance();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(OrgType.UnionDebt, ctx.getCurOrgGroup());
        map.put("KEY_ORGTREE_INFO", ctx.getCurOrgBound());
        map.put("KEY_DATACOLLECT_NUMBER", ctx.getCurDataCollect().getNumber());
        imanager.setContext(map);
        if (this.iArchive == null) {
            this.iArchive = ArchiveFactory.getRemoteInstance();
        }
        this.iArchive.unArchive(ctx.getCurOrgBound().getId().toString(), ctx.getCurRptPeriodType().getValue(), ctx.getCurRptYear(), ctx.getCurRptPeriod(), orgUnitIds);
        MsgBox.showInfo((Component)((Object)this), (String)CslRptUtil.getString("Msg_UnArchive_Success"));
        this.changeContext(ctx.getCurOrgBound().getId().toString(), ctx.getCurRptYear(), ctx.getCurRptPeriod(), ctx.getCurRptPeriodType().getValue(), orgUnitIds);
        this.destroyWindow();
    }

    private void changeContext(String orgTreeId, int year, int period, int periodType, ArrayList orgUnitIds) throws BOSException {
        CSLContext context = (CSLContext)CSLContextHelper.getCSLContext();
        boolean changed = true;
        if (!context.getCurOrgBound().getId().toString().equals(orgTreeId)) {
            changed = false;
        }
        String curOrgUnitId = context.getCurOrgGroup().getId().toString();
        for (int i = 0; i < orgUnitIds.size(); ++i) {
            String orgUnitId = (String)orgUnitIds.get(i);
            if (curOrgUnitId.equals(orgUnitId)) continue;
            changed = false;
        }
        if (context.getCurRptYear() != year) {
            changed = false;
        }
        if (context.getCurRptPeriod() != period) {
            changed = false;
        }
        if (context.getCurRptPeriodType().getValue() != periodType) {
            changed = false;
        }
        if (changed) {
            context.setCurPublishedStatus(false);
            CSLContextManager.getInstance().notifyCTXChanged();
        }
    }

    private void releaseCheckControlLock() {
        IMutexServiceControl imc = MutexServiceControlFactory.getRemoteInstance();
        imc.releaseMutex(this.uuid);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionSelectOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectOrgUnit_actionPerformed(e);
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 2);
        f7.setMultiSelect(true);
        f7.setTreeID(this.orgTreeInfo.getId().toString());
        f7.setCtrlUnitPK(this.orgTreeInfo.getCU());
        f7.show();
        OrgUnitInfo[] orgArray = (OrgUnitInfo[])f7.getData();
        if (orgArray == null) {
            return;
        }
        this.tblOrgUnit.removeRows();
        this.tblOrgUnit.getSelectManager().setSelectMode(2);
        for (OrgUnitInfo company : orgArray) {
            IRow row = this.tblOrgUnit.addRow();
            row.getCell(0).setValue((Object)company.getId());
            row.getCell(1).setValue((Object)company.getNumber());
            row.getCell(2).setValue((Object)company.getName());
            row.getCell(3).setValue((Object)company);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }
}

