/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptKey;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslTplKey;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleCacheContainer;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.awt.Color;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CslRptXlsImporter {
    private Map idxCreate = null;
    private Map idxSheet = null;
    private Map idxFile = null;
    private Map idxTemplate = null;
    private Map idxSheetTpl = null;
    private SimpleCacheContainer cacheCompany = null;
    private SimpleCacheContainer cacheCurrency = null;
    private SimpleCacheContainer cacheTemplate = null;
    private Map idxMatch = null;
    private Map idxMatchRev = null;
    private Map idxRptKey = null;
    private List listCompanyIds = null;
    private TreeNodeStateChangeListener listenerSource = null;
    private TreeNodeStateChangeListener listenerDest = null;
    private TreeSelectionListener listenerSource2 = null;
    private TreeSelectionListener listenerDest2 = null;
    private boolean isMultiMode = false;
    private File dir = null;
    private KDTree treeSource = null;
    private KDTree treeDest = null;
    private List listSuccess = null;
    private List listFailure = null;
    private static final Logger logger = Logger.getLogger(CslRptXlsImporter.class);

    CslRptXlsImporter(File dir, KDTree treeSource, KDTree treeDest, boolean isMultiMode) {
        if (dir == null) {
            throw new RuntimeException("dir cannot be null");
        }
        if (treeSource == null) {
            throw new RuntimeException("treeSource cannot be null");
        }
        if (treeDest == null) {
            throw new RuntimeException("treeDest cannot be null");
        }
        this.dir = dir;
        this.treeSource = treeSource;
        this.treeDest = treeDest;
        this.isMultiMode = isMultiMode;
        this.idxCreate = new HashMap();
        this.idxSheet = new HashMap();
        this.idxFile = new HashMap();
        this.idxTemplate = new HashMap();
        this.idxSheetTpl = new HashMap();
        this.cacheCurrency = new SimpleCacheContainer(10);
        this.idxMatch = new HashMap();
        this.idxMatchRev = new HashMap();
        this.idxRptKey = new HashMap();
        this.listCompanyIds = new ArrayList();
        this.cacheCompany = new SimpleCacheContainer(10);
        this.listSuccess = new ArrayList();
        this.listFailure = new ArrayList();
        this.cacheTemplate = new SimpleCacheContainer(5);
    }

    private void parseDir() throws BOSException {
        if (this.dir == null) {
            throw new RuntimeException("dir must be created first");
        }
        if (this.treeSource == null) {
            throw new RuntimeException("treeSource must be created first");
        }
        EventListener[] listeners = this.treeSource.getListeners(TreeNodeStateChangeListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            this.treeSource.removeTreeNodeStateChangeListener((TreeNodeStateChangeListener)listeners[i]);
        }
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().toLowerCase(Locale.getDefault()).endsWith(".xls");
            }
        };
        File file12 = null;
        File file22 = null;
        File file32 = null;
        File file42 = null;
        File file52 = null;
        DefaultKingdeeTreeNode node1 = null;
        DefaultKingdeeTreeNode node2 = null;
        DefaultKingdeeTreeNode node3 = null;
        DefaultKingdeeTreeNode node4 = null;
        DefaultKingdeeTreeNode node5 = null;
        String companyNumber = null;
        CompanyOrgUnitInfo company = null;
        RptPeriodTypeEnum periodType = null;
        int year = -1;
        int period = -1;
        String currencyNumber = null;
        CurrencyInfo currency = null;
        CslRptKey rptKey = null;
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeSource.getModel().getRoot();
        for (File file12 : this.dir.listFiles(dirFilter)) {
            companyNumber = file12.getName();
            company = this.getCompany(file12.getName());
            if (company == null || !this.checkRights(company.getId().toString())) continue;
            this.listCompanyIds.add(company.getId().toString());
            node1 = new DefaultKingdeeTreeNode((Object)file12.getName());
            this.treeSource.insertNodeInto((MutableTreeNode)node1, (MutableTreeNode)rootNode, rootNode.getChildCount());
            for (File file22 : file12.listFiles(dirFilter)) {
                periodType = this.getPeriodType(file22.getName());
                if (periodType == null) continue;
                node2 = new DefaultKingdeeTreeNode((Object)file22.getName());
                this.treeSource.insertNodeInto((MutableTreeNode)node2, (MutableTreeNode)node1, node1.getChildCount());
                for (File file32 : file22.listFiles(dirFilter)) {
                    int[] yearAndPeriod = this.getYearAndPeriod(periodType, file32.getName());
                    if (yearAndPeriod == null || yearAndPeriod.length != 2 || (year = yearAndPeriod[0]) <= 0 || (period = yearAndPeriod[1]) <= 0) continue;
                    node3 = new DefaultKingdeeTreeNode((Object)file32.getName());
                    this.treeSource.insertNodeInto((MutableTreeNode)node3, (MutableTreeNode)node2, node2.getChildCount());
                    for (File file42 : file32.listFiles(dirFilter)) {
                        currencyNumber = file42.getName();
                        currency = this.getCurrency(currencyNumber);
                        if (currency == null) continue;
                        node4 = new DefaultKingdeeTreeNode((Object)file42.getName());
                        this.treeSource.insertNodeInto((MutableTreeNode)node4, (MutableTreeNode)node3, node3.getChildCount());
                        for (File file52 : file42.listFiles(fileFilter)) {
                            node5 = new DefaultKingdeeTreeNode((Object)file52.getName());
                            this.treeSource.insertNodeInto((MutableTreeNode)node5, (MutableTreeNode)node4, node4.getChildCount());
                            HashMap<String, Object> property = new HashMap<String, Object>();
                            property.put("KEY_XLS_COMPANY_NUMBER", file12.getName());
                            rptKey = CslRptKey.getInstance(companyNumber, periodType, new Integer(year), new Integer(period), currencyNumber);
                            property.put("KEY_XLS_CSLRPTKEY", rptKey);
                            property.put("KEY_XLS_NODE", node5);
                            this.idxFile.put(file52.getAbsolutePath(), property);
                        }
                    }
                }
            }
        }
        if (this.listCompanyIds.size() == 0) {
            node1 = new DefaultKingdeeTreeNode((Object)CslRptUtil.getString("CslRptImportCannotFindCompany"));
            node1.setTextColor(Color.GRAY);
            node1.setCheckBoxVisible(false);
            this.treeSource.insertNodeInto((MutableTreeNode)node1, (MutableTreeNode)rootNode, 0);
        }
    }

    private void parseSheet() {
        if (this.treeSource == null) {
            throw new RuntimeException("treeSource must be created first");
        }
        if (this.idxFile == null) {
            throw new RuntimeException("idxFile must be created first");
        }
        String filename2 = null;
        File file = null;
        String[] sheetnameArray = null;
        String sheetname = null;
        DefaultKingdeeTreeNode nodeFile = null;
        DefaultKingdeeTreeNode nodeSheet = null;
        Map propertyFile = null;
        HashMap<String, String> propertySheet = null;
        for (String filename2 : this.idxFile.keySet()) {
            if (filename2 == null || (nodeFile = (DefaultKingdeeTreeNode)(propertyFile = (Map)this.idxFile.get(filename2)).get("KEY_XLS_NODE")) == null) continue;
            file = new File(filename2);
            sheetnameArray = this.getSheetsName(file);
            for (int i = 0; i < sheetnameArray.length; ++i) {
                sheetname = sheetnameArray[i];
                nodeSheet = new DefaultKingdeeTreeNode((Object)sheetname);
                this.treeSource.insertNodeInto((MutableTreeNode)nodeSheet, (MutableTreeNode)nodeFile, nodeFile.getChildCount());
                propertySheet = new HashMap<String, String>();
                propertySheet.put("KEY_XLS_SHEET", sheetname);
                propertySheet.put("KEY_XLS_FILE", filename2);
                propertySheet.put("KEY_XLS_CSLRPTKEY", (String)propertyFile.get("KEY_XLS_CSLRPTKEY"));
                this.idxSheet.put(nodeSheet, propertySheet);
            }
        }
    }

    private String[] getSheetsName(File file) {
        KDSBook book = POIXlsReader.parse((String)file.getAbsolutePath());
        if (book == null) {
            return null;
        }
        KDSSheet sheet = null;
        int count = book.getSheetCount();
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            sheet = book.getSheet((Object)new Integer(i));
            names[i] = sheet.getName();
        }
        sheet = null;
        book = null;
        return names;
    }

    private CompanyOrgUnitInfo getCompany(String number) throws BOSException {
        if (number == null || number.length() == 0) {
            throw new RuntimeException("number is null");
        }
        if (this.cacheCompany.containsKey(number)) {
            return (CompanyOrgUnitInfo)this.cacheCompany.get(number);
        }
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        CompanyOrgUnitCollection collection = ic.getCompanyOrgUnitCollection(view);
        if (collection.size() <= 0) {
            return null;
        }
        if (collection.size() > 1) {
            throw new BOSException("duplicate company with number '" + number + "'");
        }
        CompanyOrgUnitInfo info = collection.get(0);
        this.cacheCompany.put(number, info);
        return info;
    }

    private boolean checkRights(String companyId) throws BOSException {
        if (companyId == null || companyId.length() == 0) {
            return false;
        }
        if (!this.isMultiMode) {
            return companyId.equals(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        }
        return true;
    }

    private TemplateInfo getTemplate(String id) throws EASBizException, BOSException {
        if (id == null || id.length() == 0) {
            throw new RuntimeException("id is null");
        }
        if (this.cacheTemplate.containsKey(id)) {
            return (TemplateInfo)this.cacheTemplate.get(id);
        }
        TemplateInfo info = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        this.cacheTemplate.put(id, info);
        return info;
    }

    private CurrencyInfo getCurrency(String number) throws BOSException {
        if (number == null || number.length() == 0) {
            throw new RuntimeException("number is null");
        }
        if (this.cacheCurrency.containsKey(number)) {
            return (CurrencyInfo)this.cacheCurrency.get(number);
        }
        ICurrency ic = CurrencyFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        CurrencyCollection collection = ic.getCurrencyCollection(view);
        if (collection.size() <= 0) {
            return null;
        }
        if (collection.size() > 1) {
            throw new BOSException("duplicate currency with number '" + number + "'");
        }
        CurrencyInfo info = collection.get(0);
        this.cacheCurrency.put(number, info);
        return info;
    }

    private RptPeriodTypeEnum getPeriodType(String periodType) {
        if (periodType == null) {
            return null;
        }
        Iterator iterator = RptPeriodTypeEnum.getEnumList().iterator();
        RptPeriodTypeEnum type = null;
        while (iterator.hasNext()) {
            type = (RptPeriodTypeEnum)iterator.next();
            if (!type.getAlias().equals(periodType)) continue;
            return type;
        }
        type = RptPeriodTypeEnum.getEnum((String)periodType);
        if (type != null) {
            return type;
        }
        return null;
    }

    private int[] getYearAndPeriod(RptPeriodTypeEnum periodType, String dateString) {
        if (dateString == null || !dateString.matches("\\d{8}")) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int year = Integer.parseInt(dateString.substring(0, 4));
        int month = Integer.parseInt(dateString.substring(4, 6));
        int day = Integer.parseInt(dateString.substring(6, 8));
        calendar.set(year, month - 1, day);
        List list = RPTDateUtil.getRptPeriod(calendar.getTime(), periodType);
        if (list == null) {
            return null;
        }
        logger.debug((Object)("<" + dateString + " --> " + list + ">"));
        return new int[]{(Integer)list.get(0), (Integer)list.get(1)};
    }

    public void refreshSource() throws Exception {
        if (this.treeSource == null) {
            throw new RuntimeException("treeSource must be created first");
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSource.getModel().getRoot();
        this.treeSource.removeAllChildrenFromParent((MutableTreeNode)root);
        root.setText(CslRptUtil.getString("CslRptImportData"));
        root.setTextColor(Color.BLACK);
        ((KingdeeTreeUI)this.treeSource.getUI()).resetSize();
        this.parseDir();
        this.parseSheet();
        this.treeSource.expandAllNodes(true, (TreeNode)root);
        this.treeSource.setShowCheckBox(true);
        if (this.listenerSource == null && ((TreeNodeStateChangeListener[])this.treeSource.getListeners(TreeNodeStateChangeListener.class)).length == 0) {
            this.listenerSource = new TreeNodeStateChangeListener(){

                public void nodeStateChange(TreeNodeStateChangeEvent event) {
                    CslRptXlsImporter.this.nodeStateChangedSource(event);
                }
            };
            this.treeSource.addTreeNodeStateChangeListener(this.listenerSource);
        }
        if (this.listenerSource2 == null && ((TreeSelectionListener[])this.treeSource.getListeners(TreeSelectionListener.class)).length == 0) {
            this.listenerSource2 = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    CslRptXlsImporter.this.nodeSelectedSource(e);
                }
            };
            this.treeSource.addTreeSelectionListener(this.listenerSource2);
        }
    }

    public void nodeStateChangedSource(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        if (!node.isChecked()) {
            if (this.idxMatch.containsKey(node)) {
                DefaultKingdeeTreeNode nodeDest = (DefaultKingdeeTreeNode)this.idxMatch.get(node);
                if (nodeDest == null) {
                    return;
                }
                Set setRev = (Set)this.idxMatchRev.get(nodeDest);
                setRev.remove(node);
                this.idxMatch.remove(node);
                Map property = (Map)this.idxSheet.get(node);
                CslRptKey rptKey = (CslRptKey)property.get("KEY_XLS_CSLRPTKEY");
                String sheetname = (String)property.get("KEY_XLS_SHEET");
                ((Set)this.idxRptKey.get(rptKey)).remove(sheetname);
                if (setRev.size() == 0) {
                    nodeDest.setChecked(false);
                    nodeDest.syncChecked();
                    this.treeDest.updateUI();
                }
            }
        } else {
            Map property = (Map)this.idxSheet.get(node);
            String sheetname = (String)property.get("KEY_XLS_SHEET");
            CslRptKey rptKey = (CslRptKey)property.get("KEY_XLS_CSLRPTKEY");
            Iterator iterator = this.idxMatch.keySet().iterator();
            Map property2 = null;
            DefaultKingdeeTreeNode nodeNext = null;
            DefaultKingdeeTreeNode nodeDest = null;
            while (iterator.hasNext()) {
                nodeNext = (DefaultKingdeeTreeNode)iterator.next();
                nodeDest = (DefaultKingdeeTreeNode)this.idxMatch.get(nodeNext);
                property2 = (Map)this.idxSheet.get(nodeNext);
                if (!sheetname.equals(property2.get("KEY_XLS_SHEET")) || !rptKey.equals(property2.get("KEY_XLS_CSLRPTKEY"))) continue;
                nodeNext.setChecked(false);
                nodeNext.syncChecked();
                this.treeSource.updateUI();
                Set setRev = (Set)this.idxMatchRev.get(nodeDest);
                setRev.remove(nodeNext);
                this.idxMatch.remove(nodeNext);
                break;
            }
            this.matchDest(node);
        }
    }

    public void nodeStateChangedDest(TreeNodeStateChangeEvent event) {
        event.getNode();
    }

    public void match() {
        DefaultKingdeeTreeNode nodeXls2 = null;
        for (DefaultKingdeeTreeNode nodeXls2 : this.idxSheet.keySet()) {
            if (this.matchDest(nodeXls2)) continue;
            nodeXls2.setCheckBoxVisible(false);
            nodeXls2.setTextColor(Color.GRAY);
            nodeXls2.setText(nodeXls2.getText() + CslRptUtil.getString("CslRptImportNoMatchedRecord"));
        }
        DefaultKingdeeTreeNode nodeTpl2 = null;
        for (DefaultKingdeeTreeNode nodeTpl2 : this.idxSheetTpl.keySet()) {
            if (this.idxMatchRev.containsKey(nodeTpl2)) continue;
            nodeTpl2.setCheckBoxVisible(false);
            nodeTpl2.setTextColor(Color.GRAY);
            nodeTpl2.setText(nodeTpl2.getText() + CslRptUtil.getString("CslRptImportNoMatchedRecord"));
        }
        this.generateIdxCreate();
    }

    private boolean matchDest(DefaultKingdeeTreeNode nodeXls) {
        Set set;
        Map propertyTpl = null;
        DefaultKingdeeTreeNode nodeTpl2 = null;
        CslTplKey tplKey = null;
        Set sourceNodeSet = null;
        CslRptKey rptKey = null;
        String sheetname = null;
        Map propertyXls = null;
        propertyXls = (Map)this.idxSheet.get(nodeXls);
        rptKey = (CslRptKey)propertyXls.get("KEY_XLS_CSLRPTKEY");
        sheetname = (String)propertyXls.get("KEY_XLS_SHEET");
        if (this.idxRptKey.containsKey(rptKey) && (set = (Set)this.idxRptKey.get(rptKey)).contains(sheetname)) {
            return true;
        }
        for (DefaultKingdeeTreeNode nodeTpl2 : this.idxSheetTpl.keySet()) {
            propertyTpl = (Map)this.idxSheetTpl.get(nodeTpl2);
            tplKey = (CslTplKey)propertyTpl.get("KEY_XLS_CSLTPLKEY");
            if (!sheetname.equals(propertyTpl.get("KEY_XLS_SHEET")) || !tplKey.equalsRpt(rptKey)) continue;
            this.idxMatch.put(nodeXls, nodeTpl2);
            if (!this.idxMatchRev.containsKey(nodeTpl2)) {
                this.idxMatchRev.put(nodeTpl2, new HashSet());
            }
            sourceNodeSet = (Set)this.idxMatchRev.get(nodeTpl2);
            sourceNodeSet.add(nodeXls);
            if (!this.idxRptKey.containsKey(rptKey)) {
                this.idxRptKey.put(rptKey, new HashSet());
            }
            ((Set)this.idxRptKey.get(rptKey)).add(sheetname);
            propertyXls.put("KEY_TPL_ID", propertyTpl.get("KEY_TPL_ID"));
            nodeXls.setChecked(true);
            nodeXls.syncChecked();
            nodeTpl2.setChecked(true);
            nodeTpl2.syncChecked();
            return true;
        }
        return false;
    }

    public void refreshDestination() throws Exception {
        if (this.treeDest == null) {
            throw new RuntimeException("treeDest must be created first");
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeDest.getModel().getRoot();
        this.treeDest.removeAllChildrenFromParent((MutableTreeNode)root);
        root.setText(CslRptUtil.getString("CommitReport"));
        root.setTextColor(Color.BLACK);
        ((KingdeeTreeUI)this.treeDest.getUI()).resetSize();
        this.parseTemplate();
        this.treeDest.expandAllNodes(true, (TreeNode)root);
        this.treeDest.setShowCheckBox(true);
        if (this.listenerDest == null && ((TreeNodeStateChangeListener[])this.treeDest.getListeners(TreeNodeStateChangeListener.class)).length == 0) {
            this.listenerDest = new TreeNodeStateChangeListener(){

                public void nodeStateChange(TreeNodeStateChangeEvent event) {
                    CslRptXlsImporter.this.nodeStateChangedDest(event);
                }
            };
            this.treeDest.addTreeNodeStateChangeListener(this.listenerDest);
        }
        if (this.listenerDest2 == null && ((TreeSelectionListener[])this.treeDest.getListeners(TreeSelectionListener.class)).length == 0) {
            this.listenerDest2 = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    CslRptXlsImporter.this.nodeSelectedDest(e);
                }
            };
            this.treeDest.addTreeSelectionListener(this.listenerDest2);
        }
    }

    public void nodeSelectedDest(TreeSelectionEvent e) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
        if (this.idxMatchRev.containsKey(node)) {
            ArrayList<TreePath> listPath = new ArrayList<TreePath>();
            Set sourceSet = (Set)this.idxMatchRev.get(node);
            for (DefaultKingdeeTreeNode nodeSource : sourceSet) {
                listPath.add(new TreePath(nodeSource.getPath()));
            }
            int n = listPath.size();
            if (n > 0) {
                TreePath[] paths = new TreePath[n];
                Object[] objArray = listPath.toArray();
                for (int i = 0; i < n; ++i) {
                    paths[i] = (TreePath)objArray[i];
                }
                this.treeSource.setSelectionPaths(paths);
                return;
            }
        }
        this.treeSource.setSelectionNode(null);
    }

    public void nodeSelectedSource(TreeSelectionEvent e) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
        if (this.idxMatch.containsKey(node)) {
            DefaultKingdeeTreeNode nodeDest = (DefaultKingdeeTreeNode)this.idxMatch.get(node);
            if (nodeDest != null) {
                this.treeSource.setSelectionNode(nodeDest);
            }
            return;
        }
        this.treeSource.setSelectionNode(null);
    }

    private void parseTemplate() throws EASBizException, BOSException {
        if (this.treeDest == null) {
            throw new RuntimeException("treeDest must be created first");
        }
        EventListener[] listeners = this.treeDest.getListeners(TreeNodeStateChangeListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            this.treeDest.removeTreeNodeStateChangeListener((TreeNodeStateChangeListener)listeners[i]);
        }
        List list = this.getTemplatesDispensed();
        if (list == null || list.size() == 0) {
            return;
        }
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeDest.getModel().getRoot();
        Map row = null;
        HashMap<String, Object> property1 = null;
        HashMap<String, Object> property2 = null;
        HashMap<String, Object> property3 = null;
        HashMap<String, DefaultKingdeeTreeNode> property4 = null;
        HashMap<String, Object> property = null;
        DefaultKingdeeTreeNode node1 = null;
        DefaultKingdeeTreeNode node2 = null;
        DefaultKingdeeTreeNode node3 = null;
        DefaultKingdeeTreeNode node4 = null;
        String companyNumber = null;
        RptPeriodTypeEnum periodType = null;
        String templateNumber = null;
        String sheetname = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            row = (Map)list.get(i);
            companyNumber = (String)row.get("KEY_XLS_COMPANY_NUMBER");
            periodType = RptPeriodTypeEnum.getEnum((int)((Integer)row.get("KEY_XLS_PERIODTYPE")));
            templateNumber = (String)row.get("KEY_TPL_NUMBER");
            sheetname = (String)row.get("KEY_XLS_SHEET");
            property1 = (HashMap<String, Object>)this.idxTemplate.get(companyNumber);
            if (property1 == null) {
                property1 = new HashMap<String, Object>();
                this.idxTemplate.put(companyNumber, property1);
                node1 = new DefaultKingdeeTreeNode((Object)("(" + companyNumber + ")" + (String)row.get("KEY_XLS_COMPANY_NAME")));
                this.treeDest.insertNodeInto((MutableTreeNode)node1, (MutableTreeNode)rootNode, rootNode.getChildCount());
                property1.put("KEY_XLS_NODE", node1);
            } else {
                node1 = (DefaultKingdeeTreeNode)property1.get("KEY_XLS_NODE");
            }
            property2 = (HashMap<String, Object>)property1.get(periodType);
            if (property2 == null) {
                property2 = new HashMap<String, Object>();
                property1.put((String)periodType, property2);
                node2 = new DefaultKingdeeTreeNode((Object)periodType.getAlias());
                this.treeDest.insertNodeInto((MutableTreeNode)node2, (MutableTreeNode)node1, node1.getChildCount());
                property2.put("KEY_XLS_NODE", node2);
            } else {
                node2 = (DefaultKingdeeTreeNode)property2.get("KEY_XLS_NODE");
            }
            property3 = (HashMap<String, Object>)property2.get(templateNumber);
            if (property3 == null) {
                property3 = new HashMap<String, Object>();
                property2.put(templateNumber, property3);
                node3 = new DefaultKingdeeTreeNode(row.get("KEY_TPL_NAME"));
                this.treeDest.insertNodeInto((MutableTreeNode)node3, (MutableTreeNode)node2, node2.getChildCount());
                property3.put("KEY_XLS_NODE", node3);
            } else {
                node3 = (DefaultKingdeeTreeNode)property3.get("KEY_XLS_NODE");
            }
            property4 = (HashMap<String, DefaultKingdeeTreeNode>)property3.get(sheetname);
            if (property4 == null) {
                property4 = new HashMap<String, DefaultKingdeeTreeNode>();
                property3.put(sheetname, property4);
                node4 = new DefaultKingdeeTreeNode((Object)sheetname);
                this.treeDest.insertNodeInto((MutableTreeNode)node4, (MutableTreeNode)node3, node3.getChildCount());
                property4.put("KEY_XLS_NODE", node4);
            } else {
                node4 = (DefaultKingdeeTreeNode)property4.get("KEY_XLS_NODE");
            }
            property = new HashMap<String, Object>();
            property.put("KEY_XLS_SHEET", sheetname);
            property.put("KEY_XLS_CSLTPLKEY", CslTplKey.getInstance(companyNumber, periodType));
            property.put("KEY_TPL_ID", row.get("KEY_TPL_ID"));
            this.idxSheetTpl.put(node4, property);
        }
    }

    private List getTemplatesDispensed() throws EASBizException, BOSException {
        ITempletDispense it = TempletDispenseFactory.getRemoteInstance();
        List list = it.getTemplatesDispensed(this.listCompanyIds);
        return list;
    }

    public void executeImport() throws EASBizException, BOSException, KDFException, Exception {
        if (this.idxCreate == null || this.idxCreate.size() == 0) {
            throw new RuntimeException("Must generate idxCreate first!");
        }
        this.listSuccess.clear();
        this.listFailure.clear();
        CslTplKey tplKey2 = null;
        CslRptKey rptKey2 = null;
        String tplId2 = null;
        Map tplMap = null;
        Map rptMap = null;
        List nodeList = null;
        Iterator tplIter = null;
        Iterator rptIter = null;
        for (CslTplKey tplKey2 : this.idxCreate.keySet()) {
            tplMap = (Map)this.idxCreate.get(tplKey2);
            for (String tplId2 : tplMap.keySet()) {
                rptMap = (Map)tplMap.get(tplId2);
                for (CslRptKey rptKey2 : rptMap.keySet()) {
                    nodeList = (List)rptMap.get(rptKey2);
                    this.createReport0(tplId2, rptKey2, nodeList);
                }
            }
        }
    }

    public String getStat() {
        Object[] textArray;
        int i;
        StringBuffer result = new StringBuffer();
        String seperator = "------------------------------------------------------------\r\n";
        int countSuccess = this.listSuccess.size();
        int countFailure = this.listFailure.size();
        Object[] param = new Object[]{new Integer(countSuccess), new Integer(countFailure)};
        result.append(CslRptUtil.getStringWithFormatCR("CslRptImportReport", param));
        if (countSuccess > 0) {
            result.append(CslRptUtil.getStringWithCR("CslRptImportHint")).append(seperator);
        }
        Map row = null;
        CslRptKey rptKey = null;
        String companyName = null;
        String companyNumber = null;
        String rptName = null;
        String currencyName = null;
        for (i = 0; i < countSuccess; ++i) {
            row = (Map)this.listSuccess.get(i);
            rptKey = (CslRptKey)row.get("KEY_XLS_CSLRPTKEY");
            companyName = (String)row.get("KEY_XLS_COMPANY_NAME");
            companyNumber = (String)row.get("KEY_XLS_COMPANY_NUMBER");
            rptName = (String)row.get("KEY_TEMPLATE");
            currencyName = (String)row.get("KEY_XLS_CURRENCY");
            textArray = new Object[]{companyName, companyNumber, rptName, rptKey.getPeriodType().getAlias(), rptKey.getYear(), rptKey.getPeriod(), currencyName};
            result.append(CslRptUtil.getStringWithFormatCR("CslRptImportReportInfo", textArray));
        }
        if (countFailure > 0) {
            result.append(CslRptUtil.getStringWithCR("CslRptImportFail")).append(seperator);
        }
        for (i = 0; i < countFailure; ++i) {
            row = (Map)this.listFailure.get(i);
            rptKey = (CslRptKey)row.get("KEY_XLS_CSLRPTKEY");
            companyName = (String)row.get("KEY_XLS_COMPANY_NAME");
            companyNumber = (String)row.get("KEY_XLS_COMPANY_NUMBER");
            rptName = (String)row.get("KEY_TEMPLATE");
            currencyName = (String)row.get("KEY_XLS_CURRENCY");
            textArray = new Object[]{companyName, companyNumber, rptName, rptKey.getPeriodType().getAlias(), rptKey.getYear(), rptKey.getPeriod(), currencyName};
            result.append(CslRptUtil.getStringWithFormatCR("CslRptImportReportInfo", textArray)).append("\r\n");
        }
        return result.toString();
    }

    private IObjectPK createReport0(String tplId, CslRptKey rptKey, List listNode) throws KDFException, EASBizException, BOSException, Exception {
        if (listNode == null || listNode.size() == 0) {
            throw new RuntimeException("listNode is empty");
        }
        TemplateInfo template = this.getTemplate(tplId);
        RptPeriodTypeEnum periodType = rptKey.getPeriodType();
        CurrencyInfo currency = this.getCurrency(rptKey.getCurrencyNumber());
        int year = rptKey.getYear();
        int period = rptKey.getPeriod();
        CompanyOrgUnitInfo company = this.getCompany(rptKey.getCompanyNumber());
        boolean successful = true;
        IObjectPK pk = null;
        ITempletDispense it = TempletDispenseFactory.getRemoteInstance();
        if (it.getReportByTmpVersion(null, company.getId().toString(), currency.getId().toString(), template.getId().toString(), 1, periodType.getValue(), year, period, null, "ACTUALDATA") != null) {
            successful = false;
        }
        if (successful) {
            CslReportInfo info = new CslReportInfo();
            info.setYear(year);
            info.setPeriod((short)period);
            info.setTemplate(template);
            RptSheetParamCollection rptSheetParamCollection = template.getSheetParam();
            if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
                for (int j = 0; j < rptSheetParamCollection.size(); ++j) {
                    rptSheetParamCollection.get(j).setRelaType(ReportTypeEnum.REPORT);
                    rptSheetParamCollection.get(j).setStatus(1);
                }
            }
            info.getSheetParam().addCollection(rptSheetParamCollection);
            info.setZipData(template.getZipData());
            info.setSourceType(RptSrcTypeEnum.NORMAL);
            info.setCompany(company);
            info.setOrgUnit(company.castToFullOrgUnitInfo());
            info.setCurrency(currency);
            info.setSourceCurrency(currency);
            info.setName(template.getName());
            info.setNumber("001");
            info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            info.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            info.setPeriodType(periodType);
            info.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
            info.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
            info.setReportDate(RPTDate13Util.getPeriodLastDate(rptKey.getYear(), rptKey.getPeriod(), periodType));
            this.createReport1(info, listNode);
            try {
                pk = CslReportFactory.getRemoteInstance().submit((CoreBaseInfo)info);
            }
            catch (ServerException e) {
                successful = false;
            }
        }
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("KEY_XLS_CSLRPTKEY", rptKey);
        row.put("KEY_TEMPLATE", template.getName());
        row.put("KEY_XLS_COMPANY_NAME", company.getName());
        row.put("KEY_XLS_COMPANY_NUMBER", company.getNumber());
        row.put("KEY_XLS_CURRENCY", currency.getName());
        if (successful) {
            this.listSuccess.add(row);
        } else {
            this.listFailure.add(row);
        }
        return pk;
    }

    private void createReport1(CslReportInfo info, List listNode) throws Exception {
        if (listNode == null || listNode.size() == 0) {
            throw new RuntimeException("listNode is empty");
        }
        Book book = info.getBook();
        DefaultKingdeeTreeNode node = null;
        Map sheetMap = null;
        String sheetname = null;
        String filename = null;
        Sheet sheet = null;
        int n = listNode.size();
        for (int i = 0; i < n; ++i) {
            node = (DefaultKingdeeTreeNode)listNode.get(i);
            if (!this.idxSheet.containsKey(node)) {
                throw new RuntimeException("node " + node + "is not in index");
            }
            sheetMap = (Map)this.idxSheet.get(node);
            sheetname = (String)sheetMap.get("KEY_XLS_SHEET");
            filename = (String)sheetMap.get("KEY_XLS_FILE");
            sheet = book.getSheetByID(this.getSheetID((VirtualSheetParamInfo)info, sheetname));
            if (sheet == null) {
                throw new RuntimeException("cannot find a sheet named " + sheetname);
            }
            boolean isElimination = false;
            RptSheetParamCollection params = info.getSheetParam();
            RptSheetParamInfo param = null;
            int m = params.size();
            for (int j = 0; j < m; ++j) {
                param = params.get(i);
                if (!param.getSheetName().equals(sheetname) || CSLReportGroupEnum.COMMON.equals((Object)param.getReportClass())) continue;
                isElimination = true;
                break;
            }
            this.createReport2(sheet, filename, sheetname, isElimination);
        }
        info.setBook(book);
    }

    private String getSheetID(VirtualSheetParamInfo info, String sheetname) {
        if (info == null || info.getSheetParam() == null || sheetname == null) {
            throw new RuntimeException("param is null");
        }
        RptSheetParamCollection collection = info.getSheetParam();
        RptSheetParamInfo paramInfo = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            paramInfo = collection.get(i);
            if (!sheetname.equals(paramInfo.getSheetName())) continue;
            return paramInfo.getSheetID();
        }
        return null;
    }

    private void createReport2(Sheet sheet, String filename, String sheetname, boolean isElimination) {
        if (sheet == null) {
            throw new RuntimeException("sheet is null");
        }
        KDSBook book = POIXlsReader.parse((String)filename);
        if (book == null) {
            throw new RuntimeException("cannot find file named [" + filename + "] ");
        }
        KDSSheet kdssheet = book.getSheet((Object)sheetname);
        if (kdssheet == null) {
            throw new RuntimeException("cannot find sheet named [" + sheetname + "] in " + filename);
        }
        int method = 1;
        if (isElimination) {
            method = 2;
        }
        CslRptUIUtil.copyData(kdssheet, sheet, method, false);
    }

    private void generateIdxCreate() {
        if (this.idxMatchRev == null || this.idxMatchRev.size() == 0) {
            return;
        }
        if (this.idxSheet == null || this.idxSheet.size() == 0) {
            return;
        }
        if (this.idxSheetTpl == null || this.idxSheetTpl.size() == 0) {
            return;
        }
        DefaultKingdeeTreeNode nodeDest2 = null;
        DefaultKingdeeTreeNode nodeSource2 = null;
        Set nodeNames = null;
        CslTplKey keyTpl = null;
        CslRptKey keyRpt = null;
        String tplId = null;
        Map mapTpl = null;
        Map mapRpt = null;
        Map mapTplKey = null;
        Map mapTplId = null;
        List listRptKey = null;
        for (DefaultKingdeeTreeNode nodeDest2 : this.idxMatchRev.keySet()) {
            mapTpl = (Map)this.idxSheetTpl.get(nodeDest2);
            keyTpl = (CslTplKey)mapTpl.get("KEY_XLS_CSLTPLKEY");
            tplId = (String)mapTpl.get("KEY_TPL_ID");
            if (!this.idxCreate.containsKey(keyTpl)) {
                this.idxCreate.put(keyTpl, new HashMap());
            }
            if (!(mapTplKey = (Map)this.idxCreate.get(keyTpl)).containsKey(tplId)) {
                mapTplKey.put(tplId, new HashMap());
            }
            mapTplId = (Map)mapTplKey.get(tplId);
            nodeNames = (Set)this.idxMatchRev.get(nodeDest2);
            if (nodeNames == null || nodeNames.size() == 0) continue;
            for (DefaultKingdeeTreeNode nodeSource2 : nodeNames) {
                mapRpt = (Map)this.idxSheet.get(nodeSource2);
                keyRpt = (CslRptKey)mapRpt.get("KEY_XLS_CSLRPTKEY");
                if (!mapTplId.containsKey(keyRpt)) {
                    mapTplId.put(keyRpt, new ArrayList());
                }
                listRptKey = (List)mapTplId.get(keyRpt);
                listRptKey.add(nodeSource2);
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("reportDate"));
        return sic;
    }
}

