/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptKey;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CslTplKey {
    private String companyNumber = null;
    private RptPeriodTypeEnum periodType = null;
    private static List listInstances = new ArrayList();
    private static Map companyIndex = new HashMap();
    private static Map periodTypeIndex = new HashMap();

    private CslTplKey(String companyNumber, RptPeriodTypeEnum periodType) {
        this.companyNumber = companyNumber;
        this.periodType = periodType;
        listInstances.add(this);
        if (!companyIndex.containsKey(companyNumber)) {
            companyIndex.put(companyNumber, new HashSet());
        }
        ((Set)companyIndex.get(companyNumber)).add(this);
        if (!periodTypeIndex.containsKey(periodType)) {
            periodTypeIndex.put(periodType, new HashSet());
        }
        ((Set)periodTypeIndex.get(periodType)).add(this);
    }

    public static CslTplKey getInstance(String companyNumber, RptPeriodTypeEnum periodType) throws BOSException {
        if (companyNumber == null || periodType == null) {
            throw new BOSException("Company, period type cannot be null!");
        }
        CslTplKey result = CslTplKey.getKey(companyNumber, periodType);
        if (result == null) {
            result = new CslTplKey(companyNumber, periodType);
        }
        return result;
    }

    private static CslTplKey getKey(String companyNumber, RptPeriodTypeEnum periodType) {
        if (companyNumber == null || periodType == null) {
            throw new RuntimeException("Company, period type cannot be null!");
        }
        if (companyIndex.containsKey(companyNumber) && periodTypeIndex.containsKey(periodType)) {
            Set set;
            Set companySet = (Set)companyIndex.get(companyNumber);
            Set periodTypeSet = (Set)periodTypeIndex.get(periodType);
            if (companySet != null && periodTypeSet != null && (set = CslRptUtil.join(companySet, periodTypeSet)).size() == 1) {
                return (CslTplKey)set.iterator().next();
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CslTplKey) {
            CslTplKey key = (CslTplKey)obj;
            return this.getCompanyNumber().equals(key.getCompanyNumber()) && this.getPeriodType().equals((Object)key.getPeriodType());
        }
        return false;
    }

    public boolean equalsRpt(CslRptKey key) {
        if (key == null) {
            return false;
        }
        return this.getCompanyNumber().equals(key.getCompanyNumber()) && this.getPeriodType().equals((Object)key.getPeriodType());
    }

    public int hashCode() {
        return (this.companyNumber + this.periodType).hashCode();
    }

    public String toString() {
        return "<<Company:" + this.companyNumber + ", periodType:" + this.periodType + ">>";
    }

    public String getCompanyNumber() {
        return this.companyNumber;
    }

    public RptPeriodTypeEnum getPeriodType() {
        return this.periodType;
    }
}

