/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.CyConvtFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ICyConvt;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCyConvtRptListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptClientHelperUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CyConvtFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.DiffTableProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.util.MsgBoxForSpecial;
import com.kingdee.eas.fi.gr.dynamic.client.GroupMultiRptProcessUI;
import com.kingdee.eas.fi.gr.dynamic.client.MultiSumRptProcessUI;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.fast.CSLContextData;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.newrpt.CslMergeSoluFactory;
import com.kingdee.eas.fi.newrpt.CslMergeSoluInfo;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CyConvtRptListUI
extends AbstractCyConvtRptListUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(CyConvtRptListUI.class);
    CommonQueryDialog conditionDialog = null;
    CyConvtFilterUI conditionPanel = null;
    Map mapParams = null;
    private Object isSupportOtherDS;
    private boolean isSupport13Period;
    private boolean isMergeByFiscalPeriod = false;
    protected ICSLContext cslCtx = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    protected boolean isLoaded = false;
    protected String selectAll = null;
    private boolean isFromCslMerge = false;
    private OrgTreeInfo curOrgTreeInfo = null;
    private OrgUnitInfo curOrgUnitInfo = null;
    private OrgTreeCollection orgTreeColl = null;
    private boolean isOrgTreeCollInited = false;
    IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        CslReportInfo report = this.getReportInfo(id);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)0);
        if (this.isFromCslMerge) {
            uiContext.put((Object)"KEY_LINKOPENRPT_PARAM", (Object)true);
        }
        String processUI = null;
        processUI = report.getSourceType() == RptSrcTypeEnum.NORMAL || report.getSourceType() == RptSrcTypeEnum.COMMITREPORT || report.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT ? GroupRptProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.SUM || report.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT ? SumRptProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.DIFFTABLE ? DiffTableProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT ? GroupMultiRptProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT ? MultiSumRptProcessUI.class.getName() : CslRptProcessUI.class.getName()))));
        uiContext.put((Object)"KeyOrgTree", (Object)this.getCSLContext().getCurOrgBound());
        uiContext.put((Object)"isFromReportReceive", (Object)Boolean.TRUE);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(processUI, (Map)uiContext, null, OprtState.VIEW);
        window.getUIObject().setUITitle(CslRptUIUtil.getUITitle((VirtualSheetParamInfo)report, OprtState.VIEW));
        window.show();
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("orgBound") != null;
        if (this.isFromCslMerge) {
            int year = (Integer)this.getUIContext().get("year");
            int period = (Integer)this.getUIContext().get("period");
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.getUIContext().get("periodType");
            OrgTreeInfo orgBound = (OrgTreeInfo)this.getUIContext().get("orgBound");
            OrgUnitInfo orgUnit = (OrgUnitInfo)this.getUIContext().get("orgUnit");
            Date date = (Date)this.getUIContext().get("date");
            CurrencyInfo currency = null;
            this.cslCtx = new CSLContextData(DataCollectConstant.getActualDC(), orgBound, orgUnit, date, period, periodType, year, false, currency);
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected void refreshCSLContext() {
        OrgTreeInfo orgBound = (OrgTreeInfo)this.cmbOrgBound.getSelectedItem();
        OrgUnitInfo orgUnit = (OrgUnitInfo)this.pmptOrgUnit.getData();
        Date rptDate = (Date)this.dpDate.getValue();
        int period = this.spCurPeriod.getIntegerVlaue();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        int year = this.spCurYear.getIntegerVlaue();
        CurrencyInfo currency = null;
        if (this.cmbCurrency.getSelectedItem() instanceof CurrencyInfo) {
            currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        }
        this.cslCtx = new CSLContextData(DataCollectConstant.getActualDC(), orgBound, orgUnit, rptDate, period, periodType, year, false, currency);
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }

    protected void initWorkButton2() {
        this.btnLocate.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnAttachment.setVisible(false);
    }

    private void setCslContext2Server() throws BOSException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(OrgType.UnionDebt, this.getCSLContext().getCurOrgGroup());
        map.put("KEY_ORGTREE_INFO", this.getCSLContext().getCurOrgBound());
        map.put("KEY_DATACOLLECT_NUMBER", this.getCSLContext().getCurDataCollect().getNumber());
        IContextManager imanager = ContextManagerFactory.getRemoteInstance();
        imanager.setContext(map);
    }

    private void restoreCslContext2Server() throws BOSException {
        OrgUnitInfo curOrgGroup = null;
        OrgTreeInfo orgTree = null;
        String number = "";
        if (CSLContext.getInstance().isInitialized()) {
            curOrgGroup = CSLContext.getInstance().getCurOrgGroup();
            orgTree = CSLContext.getInstance().getCurOrgBound();
            number = CSLContext.getInstance().getCurDataCollect().getNumber();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(OrgType.UnionDebt, curOrgGroup);
        map.put("KEY_ORGTREE_INFO", orgTree);
        map.put("KEY_DATACOLLECT_NUMBER", number);
        IContextManager imanager = ContextManagerFactory.getRemoteInstance();
        imanager.setContext(map);
    }

    private void initYear(int value) {
        ChangeListener[] ls;
        if (value == -1) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            value = c.get(1);
        }
        for (ChangeListener listener : ls = (ChangeListener[])this.spCurYear.getListeners(ChangeListener.class)) {
            this.spCurYear.removeChangeListener(listener);
        }
        this.spCurYear.setModel((SpinnerModel)new SpinnerNumberModel(value, 1900, 2999, 1));
        for (ChangeListener listener : ls) {
            this.spCurYear.addChangeListener(listener);
        }
    }

    private void initPeriod(int value) {
        ChangeListener[] ls;
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (value == -1) {
            int[] yAndP = RPTDateUtil.getPeriod(new Date(), periodType);
            value = yAndP[1];
        }
        for (ChangeListener listener : ls = (ChangeListener[])this.spCurPeriod.getListeners(ChangeListener.class)) {
            this.spCurPeriod.removeChangeListener(listener);
        }
        int max = -1;
        max = periodType == RptPeriodTypeEnum.SEMIYEARLY ? 2 : (periodType == RptPeriodTypeEnum.QUARTERLY ? 4 : (periodType == RptPeriodTypeEnum.MONTHLY ? (this.isSupport13Period ? 13 : 12) : (periodType == RptPeriodTypeEnum.WEEKLY ? 53 : 366)));
        this.spCurPeriod.setModel((SpinnerModel)new SpinnerNumberModel(value, 1, max, 1));
        for (ChangeListener listener : ls) {
            this.spCurPeriod.addChangeListener(listener);
        }
    }

    private void initPeriodType(RptPeriodTypeEnum value) {
        ItemListener[] ls;
        int count;
        if (value == null) {
            value = RptPeriodTypeEnum.MONTHLY;
        }
        if ((count = this.cmbPeriodType.getItemCount()) == 0) {
            this.cmbPeriodType.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        }
        for (ItemListener listener : ls = (ItemListener[])this.cmbPeriodType.getListeners(ItemListener.class)) {
            this.cmbPeriodType.removeItemListener(listener);
        }
        this.cmbPeriodType.setSelectedItem((Object)value, false);
        for (ItemListener listener : ls) {
            this.cmbPeriodType.addItemListener(listener);
        }
    }

    private void initDate(Date value) {
        DataChangeListener[] ls;
        for (DataChangeListener listener : ls = (DataChangeListener[])this.dpDate.getListeners(DataChangeListener.class)) {
            this.dpDate.removeDataChangeListener(listener);
        }
        this.dpDate.setValue((Object)(value == null ? new Date() : value), false);
        for (DataChangeListener listener : ls) {
            this.dpDate.addDataChangeListener(listener);
        }
    }

    private void initOrgBound(final OrgTreeInfo value) {
        ItemListener[] ls;
        if (!this.isOrgTreeCollInited) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ItemListener[] ls;
                        CyConvtRptListUI.this.orgTreeColl = CslWorkTableUIUtil.getAllOrgTreeColl();
                        OrgTreeCollection curOrgTreeColl = CslWorkTableUIUtil.getOrgTreeColl((OrgTreeCollection)CyConvtRptListUI.this.orgTreeColl, (Date)((Date)CyConvtRptListUI.this.dpDate.getValue()));
                        for (ItemListener listener : ls = (ItemListener[])CyConvtRptListUI.this.cmbOrgBound.getListeners(ItemListener.class)) {
                            CyConvtRptListUI.this.cmbOrgBound.removeItemListener(listener);
                        }
                        CyConvtRptListUI.this.cmbOrgBound.addItems(curOrgTreeColl == null ? null : curOrgTreeColl.toArray());
                        for (ItemListener listener : ls) {
                            CyConvtRptListUI.this.cmbOrgBound.addItemListener(listener);
                        }
                        if (value != null) {
                            for (int i = 0; i < CyConvtRptListUI.this.cmbOrgBound.getItemCount(); ++i) {
                                if (!((OrgTreeInfo)CyConvtRptListUI.this.cmbOrgBound.getItemAt(i)).getNumber().equals(value.getNumber())) continue;
                                CyConvtRptListUI.this.cmbOrgBound.setSelectedIndex(i, false);
                                break;
                            }
                        }
                        CyConvtRptListUI.this.isOrgTreeCollInited = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)"getOrgTreeCollection error", (Throwable)e);
                    }
                    finally {
                        CyConvtRptListUI.this.isOrgTreeCollInited = true;
                    }
                }
            }.start();
        }
        for (ItemListener listener : ls = (ItemListener[])this.cmbOrgBound.getListeners(ItemListener.class)) {
            this.cmbOrgBound.removeItemListener(listener);
        }
        this.cmbOrgBound.removeAllItems();
        OrgTreeCollection curOrgTreeColl = CslWorkTableUIUtil.getOrgTreeColl((OrgTreeCollection)this.orgTreeColl, (Date)((Date)this.dpDate.getValue()));
        this.cmbOrgBound.addItems(curOrgTreeColl == null ? null : curOrgTreeColl.toArray());
        boolean isFound = false;
        for (int i = 0; i < this.cmbOrgBound.getItemCount(); ++i) {
            if (!((OrgTreeInfo)this.cmbOrgBound.getItemAt(i)).getNumber().equals(value.getNumber())) continue;
            this.cmbOrgBound.setSelectedIndex(i, false);
            isFound = true;
            break;
        }
        if (!isFound && this.isFromCslMerge) {
            this.cmbOrgBound.removeAllItems();
        }
        for (ItemListener listener : ls) {
            this.cmbOrgBound.addItemListener(listener);
        }
    }

    private void initOrgUnit(OrgUnitInfo value) {
        try {
            OrgTreeInfo orgTreeInfo = null;
            orgTreeInfo = !this.isOrgTreeCollInited ? this.getCSLContext().getCurOrgBound() : (OrgTreeInfo)this.cmbOrgBound.getSelectedItem();
            if (orgTreeInfo != null) {
                UnionF7Helper.UnionF7 f7 = UnionF7Helper.getUnionF7((IUIObject)this, (int)2);
                f7.setTreeID(orgTreeInfo.getId().toString());
                f7.filterUnitSql(UnionF7Helper.getUnionSQLByUserPKAndTreePK((IObjectPK)CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), (IObjectPK)CslRptUtil.getPK((IObjectValue)orgTreeInfo)));
                this.pmptOrgUnit.setSelector((KDPromptSelector)f7);
                if (this.isFromCslMerge && value == null) {
                    value = this.curOrgUnitInfo;
                }
                this.pmptOrgUnit.setData(value == null ? null : this.getOrgUnitByTreeAndUnit(orgTreeInfo.getId().toString(), value.getNumber()));
            } else {
                this.pmptOrgUnit.setData(null);
                this.pmptOrgUnit.setSelector(null);
                this.pmptOrgUnit.setEnabled(false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"initOrgUnit error", (Throwable)e);
            this.handUIException(e);
        }
    }

    private void initCurrency(CurrencyInfo currency) {
        if (this.cmbCurrency.getItemCount() <= 0) {
            this.cmbCurrency.addItem((Object)this.selectAll);
            CurrencyCollection c = null;
            try {
                c = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
                this.cmbCurrency.addItems(c.toArray());
            }
            catch (Exception e) {
                logger.error((Object)"initCurrency", (Throwable)e);
                this.handUIException(e);
            }
        }
        if (currency != null) {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                Object o = this.cmbCurrency.getItemAt(i);
                if (!(o instanceof CurrencyInfo) || !((CurrencyInfo)o).getNumber().equals(currency.getNumber())) continue;
                this.cmbCurrency.setSelectedItem(o);
                break;
            }
        } else {
            this.cmbCurrency.setSelectedIndex(0);
        }
    }

    private void initCslMergeSolu(String soluId) {
        this.cmbCslMergeSolu.addItem((Object)"");
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.setSelector(new SelectorItemCollection());
            view.getFilter().appendFilterItem("trackRecordCreator.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            view.getFilter().appendFilterItem("isFreezed", (Object)0);
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("periodType"));
            view.getSelector().add(new SelectorItemInfo("orgTree.id"));
            view.getSelector().add(new SelectorItemInfo("orgTree.name"));
            view.getSelector().add(new SelectorItemInfo("orgTree.number"));
            view.getSelector().add(new SelectorItemInfo("orgUnits.orgUnit.id"));
            view.getSelector().add(new SelectorItemInfo("orgUnits.orgUnit.name"));
            view.getSelector().add(new SelectorItemInfo("orgUnits.orgUnit.number"));
            view.getSelector().add(new SelectorItemInfo("currency.id"));
            view.getSelector().add(new SelectorItemInfo("currency.name"));
            view.getSelector().add(new SelectorItemInfo("currency.number"));
            CoreBaseCollection cbc = CslMergeSoluFactory.getRemoteInstance().getCollection(view);
            if (cbc != null) {
                int selectIndex = -1;
                for (int i = 0; i < cbc.size(); ++i) {
                    CslMergeSoluInfo info = (CslMergeSoluInfo)cbc.get(i);
                    if (!info.getId().toString().equals(soluId)) continue;
                    selectIndex = i + 1;
                }
                this.cmbCslMergeSolu.addItems(cbc.toArray());
                if (selectIndex > 0) {
                    this.cmbCslMergeSolu.setSelectedIndex(selectIndex, false);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"initCslMergeSolu", (Throwable)e);
            this.handUIException(e);
        }
    }

    private FullOrgUnitInfo getOrgUnitByTreeAndUnit(String treeId, String unitNumber) {
        if (!StringUtils.isEmpty((String)treeId) && !StringUtils.isEmpty((String)unitNumber)) {
            try {
                String permFilterSql = UnionF7Helper.getUnionSQLByUserPKAndTreePK((IObjectPK)CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), (IObjectPK)new ObjectStringPK(treeId));
                FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select id,name,number where number='" + unitNumber + "' and id in (" + permFilterSql + ")");
                return coll.get(0);
            }
            catch (BOSException e) {
                logger.error((Object)("getOrgUnitByTreeAndUnit:" + treeId + ":" + unitNumber), (Throwable)e);
            }
        }
        return null;
    }

    private void initHeadControl() throws Exception {
        if (this.isFromCslMerge) {
            this.cmbPeriodType.setEnabled(false);
            this.cmbCurrency.setEnabled(true);
            this.cmbCslMergeSolu.setEnabled(false);
            this.cmbOrgBound.setEnabled(false);
            this.pmptOrgUnit.setEnabled(false);
            this.pmptOrgUnit.setEditable(false);
            this.spCurPeriod.setEnabled(true);
            this.spCurYear.setEnabled(true);
            this.dpDate.setEnabled(true);
        } else {
            this.cmbPeriodType.setEnabled(false);
            this.cmbCslMergeSolu.setEnabled(false);
            this.cmbOrgBound.setEnabled(false);
            this.pmptOrgUnit.setEnabled(false);
            this.spCurPeriod.setEnabled(false);
            this.spCurYear.setEnabled(false);
            this.cmbCurrency.setEnabled(true);
            this.dpDate.setEnabled(false);
        }
        this.initCslMergeSolu(this.getUIContext().get("cslMergeSoluId") != null ? this.getUIContext().get("cslMergeSoluId").toString() : null);
        this.initPeriodType(this.getCSLContext().getCurRptPeriodType());
        this.initCurrency(this.getUIContext().get("currency") != null ? (CurrencyInfo)this.getUIContext().get("currency") : null);
        if (this.isFromCslMerge) {
            this.initCurrency(null);
        }
        this.initYear(this.getCSLContext().getCurRptYear());
        this.initPeriod(this.getCSLContext().getCurRptPeriod());
        this.initDate(this.getCSLContext().getCurReportDate());
        this.initOrgBound(this.getCSLContext().getCurOrgBound());
        this.initOrgUnit(this.getCSLContext().getCurOrgGroup());
        this.curOrgTreeInfo = (OrgTreeInfo)this.cmbOrgBound.getSelectedItem();
        this.curOrgUnitInfo = (FullOrgUnitInfo)this.pmptOrgUnit.getData();
        this.cmbCslMergeSolu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CyConvtRptListUI.this.isLoaded) {
                    CyConvtRptListUI.this.initPeriodType(CyConvtRptListUI.this.cmbCslMergeSolu.getSelectedItem() != null ? ((CslMergeSoluInfo)CyConvtRptListUI.this.cmbCslMergeSolu.getSelectedItem()).getPeriodType() : null);
                    CyConvtRptListUI.this.initOrgBound(CyConvtRptListUI.this.getDefaultOrgTree());
                    CyConvtRptListUI.this.initOrgUnit(CyConvtRptListUI.this.cmbCslMergeSolu.getSelectedItem() != null ? ((CslMergeSoluInfo)CyConvtRptListUI.this.cmbCslMergeSolu.getSelectedItem()).getOrgUnits().get(0).getOrgUnit() : null);
                    CyConvtRptListUI.this.initCurrency(CyConvtRptListUI.this.cmbCslMergeSolu.getSelectedItem() != null ? ((CslMergeSoluInfo)CyConvtRptListUI.this.cmbCslMergeSolu.getSelectedItem()).getCurrency() : null);
                }
            }
        });
        this.cmbPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CyConvtRptListUI.this.isLoaded) {
                    CyConvtRptListUI.this.initYear(RPTDateUtil.getPeriod((Date)CyConvtRptListUI.this.dpDate.getValue(), (RptPeriodTypeEnum)CyConvtRptListUI.this.cmbPeriodType.getSelectedItem())[0]);
                    CyConvtRptListUI.this.initPeriod(RPTDateUtil.getPeriod((Date)CyConvtRptListUI.this.dpDate.getValue(), (RptPeriodTypeEnum)CyConvtRptListUI.this.cmbPeriodType.getSelectedItem())[1]);
                }
            }
        });
        this.spCurYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CyConvtRptListUI.this.isLoaded) {
                    CyConvtRptListUI.this.initDate(CyConvtRptListUI.this.getDefaultDate());
                    CyConvtRptListUI.this.initOrgBound(CyConvtRptListUI.this.getDefaultOrgTree());
                    CyConvtRptListUI.this.initOrgUnit((OrgUnitInfo)CyConvtRptListUI.this.pmptOrgUnit.getValue());
                }
            }
        });
        this.spCurPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CyConvtRptListUI.this.isLoaded) {
                    CyConvtRptListUI.this.initDate(CyConvtRptListUI.this.getDefaultDate());
                    CyConvtRptListUI.this.initOrgBound(CyConvtRptListUI.this.getDefaultOrgTree());
                    CyConvtRptListUI.this.initOrgUnit((OrgUnitInfo)CyConvtRptListUI.this.pmptOrgUnit.getValue());
                }
            }
        });
        this.dpDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (CyConvtRptListUI.this.isLoaded) {
                    CyConvtRptListUI.this.initYear(RPTDateUtil.getPeriod((Date)CyConvtRptListUI.this.dpDate.getValue(), (RptPeriodTypeEnum)CyConvtRptListUI.this.cmbPeriodType.getSelectedItem())[0]);
                    CyConvtRptListUI.this.initPeriod(RPTDateUtil.getPeriod((Date)CyConvtRptListUI.this.dpDate.getValue(), (RptPeriodTypeEnum)CyConvtRptListUI.this.cmbPeriodType.getSelectedItem())[1]);
                    CyConvtRptListUI.this.initOrgBound(CyConvtRptListUI.this.getDefaultOrgTree());
                    CyConvtRptListUI.this.initOrgUnit((OrgUnitInfo)CyConvtRptListUI.this.pmptOrgUnit.getValue());
                }
            }
        });
        this.cmbOrgBound.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CyConvtRptListUI.this.isLoaded) {
                    CyConvtRptListUI.this.initOrgUnit((OrgUnitInfo)CyConvtRptListUI.this.pmptOrgUnit.getValue());
                }
            }
        });
    }

    private OrgTreeInfo getDefaultOrgTree() {
        Object obj = this.cmbCslMergeSolu.getSelectedItem();
        OrgTreeInfo tree = null;
        if (obj != null && obj instanceof CslMergeSoluInfo) {
            tree = ((CslMergeSoluInfo)this.cmbCslMergeSolu.getSelectedItem()).getOrgTree();
        }
        if (tree == null) {
            try {
                tree = this.getCSLContext().getCurOrgBound();
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        return tree;
    }

    private Date getDefaultDate() {
        return (Date)RPTDate13Util.getRptYearAndPeriodAndDate(this.spCurYear.getIntegerVlaue(), this.spCurPeriod.getIntegerVlaue(), ((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()).getValue(), 0, 0, this.isSupport13Period).get(2);
    }

    public CyConvtRptListUI() throws Exception {
        this.isSupport13Period = CslRptUtil.isSupport13Period(null);
        this.isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
        this.selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = null;
        try {
            dialog = this.getConditionDialog();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return dialog;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"RptForConvertQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            CslRptUIUtil.standardFilterUI(this.conditionDialog, this);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.gr.cslrpt.client.CyConvtRptListUI");
            this.conditionDialog.setTitle(this.getConditionPanel().getUITitle());
            this.conditionDialog.setHeight(495);
        }
        return this.conditionDialog;
    }

    public CyConvtFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CyConvtFilterUI();
            if (this.isFromCslMerge) {
                this.conditionPanel.getUIContext().put("cslCtx", this.getCSLContext());
            }
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        } else if (this.isFromCslMerge) {
            this.conditionPanel.refreshCSLContext(this.getCSLContext());
        }
        return this.conditionPanel;
    }

    public void onLoad() throws Exception {
        this.initCSLContext();
        this.menuItemView.setVisible(false);
        super.onLoad();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(false);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    CyConvtRptListUI.this.tblMain_afterDataFill(e);
                }
                catch (Exception exc) {
                    CyConvtRptListUI.this.handUIException(exc);
                }
            }
        });
        this.initMenu();
        this.tblMain_afterDataFill(null);
        if (this.getCSLContext().getCurPublishedStatus()) {
            this.rptArchive();
        }
        OrgTreeInfo orgBound = this.cslCtx.getCurOrgBound();
        OrgUnitInfo company = this.cslCtx.getCurOrgGroup();
        if (orgBound != null && orgBound.getName() != null) {
            this.txtOrgBound.setText(orgBound.getName());
        }
        this.comboBoxCompany.removeAllItems();
        if (company != null) {
            this.comboBoxCompany.addItem((Object)company);
        }
        CslRptClientHelperUI.setCruYearAndPeriod(this.cslCtx, this.spCurYear, this.spCurPeriod);
        if ("true".equals(this.isSupportOtherDS)) {
            this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(true);
        }
        this.initHeadControl();
        this.initWorkButton2();
        this.isLoaded = true;
    }

    protected void rptArchive() {
        this.btnAddNew.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemRemove.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.actionConvert.setEnabled(false);
        this.menuItemExportData.setEnabled(false);
        this.menuItemImportData.setEnabled(false);
        this.menuItemPublishReport.setEnabled(false);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(this.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.isFromCslMerge) {
            CSLContextHelper.update(o, (CoreUI)this);
        }
    }

    public void disposeUIWindow() {
        if (!this.isFromCslMerge) {
            CSLContextHelper.unRegistUIObject(this);
        }
        super.disposeUIWindow();
    }

    @Override
    public void actionConvert_actionPerformed(ActionEvent e) throws Exception {
        super.actionConvert_actionPerformed(e);
        this.mapParams.put("year", new Integer(this.cslCtx.getCurRptYear()));
        this.mapParams.put("period", new Integer(this.cslCtx.getCurRptPeriod()));
        this.mapParams.put("periodType", this.cslCtx.getCurRptPeriodType());
        if (this.tblMain.getRowCount() > 0) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"IF_START_CONVERT")) == 2) {
                return;
            }
            super.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CONVERTING_REPORT"));
            super.showMessage();
            int iCount = 0;
            ICyConvt cyConvert = CyConvtFactory.getRemoteInstance();
            CslReportInfo cslRptTarget = null;
            String strReportID = null;
            String strTargetCurrencyID = ((HashMap)this.mapParams.get("KEY_BASE")).get("KEY_BASE_TARGETCY").toString();
            ArrayList<String> lstReports = new ArrayList<String>();
            StringBuffer error = new StringBuffer();
            ICslReport iCslReport = CslReportFactory.getRemoteInstance();
            IReport iReport = ReportFactory.getRemoteInstance();
            HashSet<String> cslRptIdSet = new HashSet<String>();
            HashMap<String, CslReportInfo> cslRptInfoMap = new HashMap<String, CslReportInfo>();
            HashMap<String, ReportInfo> rptInfoMap = new HashMap<String, ReportInfo>();
            HashMap<String, CslReportInfo> cvtRptsInfoMap = new HashMap<String, CslReportInfo>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (StringUtils.isEmpty((String)this.tblMain.getCell(i, 0).getValue().toString()) || !Boolean.TRUE.equals(this.tblMain.getCell(i, 2).getValue())) continue;
                strReportID = this.tblMain.getCell(i, 0).getValue().toString();
                cslRptIdSet.add(strReportID);
            }
            String errorMsg = this.checkSumRptNotByName(cslRptIdSet);
            if (errorMsg.length() > 0) {
                error.append(CslRptUtil.getStringWithFormat("CONVTRPT_MUST_BE_SUM_BYNAME", new Object[]{" [" + errorMsg + "] "})).append("\n");
            }
            if (cslRptIdSet.size() > 0) {
                EntityViewInfo v = new EntityViewInfo();
                v.getSelector().add(new String("id"));
                v.getSelector().add(new String("number"));
                v.getSelector().add(new String("name"));
                v.getSelector().add(new String("committedstatus"));
                v.getSelector().add(new String("year"));
                v.getSelector().add(new String("period"));
                v.getSelector().add(new String("periodType"));
                v.getSelector().add(new String("template.id"));
                v.getSelector().add(new String("orgUnit.id"));
                v.getSelector().add(new String("currency.id"));
                v.getSelector().add(new String("sourceCurrency.id"));
                v.getSelector().add(new String("dataCollectNumber"));
                v.getSelector().add(new String("sourceType"));
                FilterInfo f = new FilterInfo();
                v.setFilter(f);
                f.getFilterItems().add(new FilterItemInfo("id", cslRptIdSet, CompareType.INCLUDE));
                CslReportCollection cslRpts = iCslReport.getCslReportCollection(v);
                for (int i = 0; i < cslRpts.size(); ++i) {
                    cslRptInfoMap.put(cslRpts.get(i).getId().toString(), cslRpts.get(i));
                }
                v = new EntityViewInfo();
                v.getSelector().add(new String("cslReport.id"));
                v.getSelector().add(new String("id"));
                v.getSelector().add(new String("sourceType"));
                f = new FilterInfo();
                v.setFilter(f);
                f.getFilterItems().add(new FilterItemInfo("cslReport.id", cslRptIdSet, CompareType.INCLUDE));
                ReportCollection reports = iReport.getReportCollection(v);
                for (int i = 0; i < reports.size(); ++i) {
                    rptInfoMap.put(reports.get(i).getCslReport().getId().toString(), reports.get(i));
                }
                CslReportCollection cvtReports = this.getTargetConvertReport(cslRptIdSet, strTargetCurrencyID, cslRptInfoMap);
                for (int i = 0; i < cvtReports.size(); ++i) {
                    cvtRptsInfoMap.put(cvtReports.get(i).getSourceRpt().getId().toString(), cvtReports.get(i));
                }
            }
            int iMsgBoxResult = 1000000;
            ICSLContext cslCtx = this.getCSLContext();
            this.mapParams.put("KEY_ORGTREE_INFO", cslCtx.getCurOrgBound());
            ArrayList<String> lstIds = new ArrayList<String>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (StringUtils.isEmpty((String)this.tblMain.getCell(i, 0).getValue().toString()) || !Boolean.TRUE.equals(this.tblMain.getCell(i, 2).getValue())) continue;
                lstReports.clear();
                strReportID = this.tblMain.getCell(i, 0).getValue().toString();
                CslReportInfo rpt = (CslReportInfo)cslRptInfoMap.get(strReportID);
                if (rpt == null) continue;
                if (strTargetCurrencyID != null && strTargetCurrencyID.equals(rpt.getSourceCurrency().getId().toString())) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"35_CyConvtRptListUI");
                    error.append(MessageFormat.format(msg, rpt.getName())).append("\u3002\n");
                    continue;
                }
                boolean isReport = rptInfoMap.containsKey(rpt.getId().toString());
                boolean isCommitted = rpt.getCommittedStatus().getValue() == 3;
                this.mapParams.put("KEY_ORGTREE_INFO", this.getCSLContext().getCurOrgBound());
                if (isCommitted || !isReport) {
                    if (iMsgBoxResult == 9999) {
                        lstIds.add(strReportID);
                        continue;
                    }
                    cslRptTarget = (CslReportInfo)cvtRptsInfoMap.get(strReportID);
                    lstReports.add(strReportID);
                    if (cslRptTarget != null) {
                        Object[] param = new Object[]{this.tblMain.getCell(i, 4).getValue(), this.tblMain.getCell(i, 5).getValue()};
                        if (iMsgBoxResult != 9999) {
                            iMsgBoxResult = MsgBoxForSpecial.showConfirm4a(CslRptUtil.getStringWithFormat("CyConvtRptConvertAskOverlay", param), "");
                        }
                        if (iMsgBoxResult == 0 || iMsgBoxResult == 9999) {
                            Map map = cyConvert.convertByReport(lstReports, this.mapParams);
                            error.append((String)map.get("Message"));
                            ++iCount;
                            continue;
                        }
                        if (iMsgBoxResult == 1) continue;
                        return;
                    }
                    Map map = cyConvert.convertByReport(lstReports, this.mapParams);
                    error.append((String)map.get("Message"));
                    ++iCount;
                    continue;
                }
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"36_CyConvtRptListUI");
                error.append(MessageFormat.format(msg, rpt.getNumber(), rpt.getName()));
                ++iCount;
            }
            if (null != lstIds && lstIds.size() > 0) {
                Map map = cyConvert.convertByReport(lstIds, this.mapParams);
                error.append((String)map.get("Message"));
                List reports = (List)map.get("reports");
                if (null != reports) {
                    iCount += reports.size();
                }
            }
            if (error.length() != 0) {
                String str = CslRptUtil.getString("Msg_Cyconvt_Title") + ":\n";
                UIContext uiCtx = new UIContext((Object)this);
                uiCtx.put((Object)"String", (Object)(str + error.toString()));
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SimpleNotePad.class.getName(), (Map)uiCtx, null);
                uiWindow.show();
                return;
            }
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CONVERTED_N_REPORTS"), String.valueOf(iCount));
            super.setMessageText(msg);
            super.showMessage();
            MsgBox.showInfo((String)msg);
            super.resetMessageText();
            super.resetMessageIcon();
            this.btnQueryData_actionPerformed(e);
        }
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (ConvertStatusEnum.BeforeConvert.toString().equals(this.tblMain.getRow(i).getCell("convertStatus").getValue().toString())) continue;
            this.tblMain.getRow(i).getCell("isSelected").setValue((Object)false);
            this.tblMain.getRow(i).getCell("isSelected").getStyleAttributes().setLocked(true);
        }
    }

    private void moveRowToTop(int curRowIndex) {
        IRow curRow = this.tblMain.getRow(curRowIndex);
        this.tblMain.removeRow(curRowIndex);
        this.tblMain.addRow(0, curRow);
    }

    private void initMenu() {
        this.btnConvert.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.menuItemSelectAll.setIcon(this.btnSelectAll.getIcon());
        this.menuItemClearAll.setIcon(this.btnClearAll.getIcon());
        this.menuItemConvert.setIcon(this.btnConvert.getIcon());
    }

    private boolean isDynamicReport(CslReportInfo report) {
        boolean isDynaReport = false;
        if (report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
            isDynaReport = true;
        }
        return isDynaReport;
    }

    private CslReportInfo getDynamicTargetConvertReport(String strSourceRptID, String strTargetCurrencyID, CslReportInfo report) {
        try {
            EntityViewInfo view;
            CoreBaseCollection clCslReport;
            ICslReport cslReport = CslReportFactory.getRemoteInstance();
            String sourceRptId = null;
            if (this.isDynamicReport(report)) {
                EntityViewInfo view2;
                CoreBaseCollection clCslReport2;
                StringBuffer whereSql = new StringBuffer(" select id where orgunit.id");
                whereSql.append("='").append(report.getOrgUnit().getId().toString()).append("'").append(" and year=").append(report.getYear()).append(" and period=").append(report.getPeriod()).append(" and periodtype=").append(report.getPeriodType().getValue()).append(" and template.id='").append(report.getTemplate().getId().toString()).append("'").append(" and currency.id='").append(report.getCurrency().getId().toString()).append("'").append(" and sourceCurrency.id='").append(report.getSourceCurrency().getId().toString()).append("'").append(" and dataCollectNumber='").append(report.getDataCollectNumber()).append("'").append(" and orgTree.id='").append(this.getCSLContext().getCurOrgBound().getId().toString()).append("'").append(" and adjustStatus=1 and isSaveAs=0");
                CslReportInfo adjustReport = null;
                try {
                    if (cslReport.exists(whereSql.toString())) {
                        adjustReport = cslReport.getCslReportInfo(whereSql.toString());
                    }
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                if (adjustReport != null && adjustReport.getId() != null && (clCslReport2 = cslReport.getCollection(view2 = this.getEntityViewInfo(sourceRptId = adjustReport.getId().toString(), strTargetCurrencyID))) != null && clCslReport2.getObject(0) != null) {
                    return (CslReportInfo)clCslReport2.getObject(0);
                }
            }
            if ((clCslReport = cslReport.getCollection(view = this.getEntityViewInfo(strSourceRptID, strTargetCurrencyID))) != null && clCslReport.getObject(0) != null) {
                return (CslReportInfo)clCslReport.getObject(0);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return null;
    }

    private EntityViewInfo getEntityViewInfo(String strSourceRptID, String strTargetCurrencyID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("auditedStatus"));
        view.getSelector().add(new SelectorItemInfo("sourceRpt.id"));
        filter.getFilterItems().add(new FilterItemInfo("sourceRpt", (Object)strSourceRptID));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)strTargetCurrencyID));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        return view;
    }

    private CslReportCollection getTargetConvertReport(HashSet strSourceRptID, String strTargetCurrencyID, HashMap cslReportMap) {
        HashSet commonRpt = new HashSet();
        HashSet<String> dynamicRpt = new HashSet<String>();
        CslReportCollection rpts = new CslReportCollection();
        for (Object id : strSourceRptID) {
            CslReportInfo csl = (CslReportInfo)cslReportMap.get(id.toString());
            if (csl == null) continue;
            dynamicRpt.add(id.toString());
        }
        try {
            ICslReport cslReport = CslReportFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.getSelector().add(new SelectorItemInfo("auditedStatus"));
            view.getSelector().add(new SelectorItemInfo("sourceRpt.id"));
            filter.getFilterItems().add(new FilterItemInfo("sourceRpt.id", commonRpt, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("currency", (Object)strTargetCurrencyID));
            filter.setMaskString("#0 and #1");
            view.setFilter(filter);
            rpts = cslReport.getCslReportCollection(view);
            Iterator itdyna = dynamicRpt.iterator();
            CslReportInfo dynaRpt = null;
            while (itdyna.hasNext()) {
                Object id = itdyna.next();
                CslReportInfo csl = (CslReportInfo)cslReportMap.get(id.toString());
                if (csl != null) {
                    dynaRpt = this.getDynamicTargetConvertReport(id.toString(), strTargetCurrencyID, csl);
                }
                if (dynaRpt == null) continue;
                rpts.add(dynaRpt);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return rpts;
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.selectOrClear(false);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.selectOrClear(true);
    }

    private void selectOrClear(boolean isSelect) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (!ConvertStatusEnum.BeforeConvert.toString().equals(this.tblMain.getRow(i).getCell("convertStatus").getValue().toString())) continue;
            this.tblMain.getRow(i).getCell("isSelected").setValue((Object)isSelect);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = CyConvtRptListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        QuerySolutionInfo querySolution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
        if (querySolution != null && querySolution.getSolutionType() != null && querySolution.getSolutionType().getValue() == "10") {
            if (this.getConditionDialog().show()) {
                this.getConditionPanel().refreshCSLContext(this.getCSLContext());
                this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
                this.mapParams = (HashMap)((CyConvtFilterUI)this.getConditionDialog().getUserPanel(0)).getParam();
            } else {
                SysUtil.abort();
            }
        } else {
            boolean isDefualtQuery = this.isPerformDefaultQuery(iQuery, queryName);
            if (!isDefualtQuery) {
                this.showConditionDialog();
            } else if (this.getConditionDialog().getWindow() == null) {
                this.getConditionDialog().init();
                CyConvtFilterUI ui = (CyConvtFilterUI)this.getConditionDialog().getUserPanel(0);
                this.mapParams = (HashMap)ui.getParam();
                if (this.mapParams != null && this.mapParams.containsKey("isOldSchm") && ((Boolean)this.mapParams.get("isOldSchm")).booleanValue()) {
                    this.showConditionDialog();
                } else {
                    this.mainQuery.setFilter(ui.getFilterInfo());
                    this.mainQuery = this.fixReportDate(this.mainQuery);
                }
            }
        }
        this.addVersionFilter(this.getMainQuery());
        this.tblMain.removeRows();
        String format = CslRptUIUtil.getNationalTimeFormatString();
        if (format != null) {
            this.tblMain.getColumn("year").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("period").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
        }
    }

    private void showConditionDialog() throws Exception {
        if (this.getConditionDialog().show()) {
            this.getConditionPanel().refreshCSLContext(this.getCSLContext());
            this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
            this.mapParams = (HashMap)((CyConvtFilterUI)this.getConditionDialog().getUserPanel(0)).getParam();
            this.tblMain.removeRows();
        } else {
            SysUtil.abort();
        }
    }

    protected EntityViewInfo fixReportDate(EntityViewInfo view) {
        Date date;
        FilterItemCollection col = view.getFilter().getFilterItems();
        try {
            date = this.getCSLContext().getCurReportDate();
        }
        catch (BOSException e) {
            return view;
        }
        for (int i = 0; i < col.size(); ++i) {
            FilterItemInfo info = col.get(i);
            if (!info.getPropertyName().equals("reportDate")) continue;
            info.setCompareValue((Object)date);
            Calendar worldTour = Calendar.getInstance();
            worldTour.setTime(date);
            worldTour.add(5, 1);
            date = worldTour.getTime();
        }
        return view;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public void refreshList() throws Exception {
        if (this.isFromCslMerge) {
            this.setCslContext2Server();
        }
        super.refreshList();
        if (this.isFromCslMerge) {
            this.restoreCslContext2Server();
        }
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    private String checkSumRptNotByName(HashSet cslRptIdSet) throws Exception {
        StringBuffer errorMsg = new StringBuffer();
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().add(new String("id"));
        v.getSelector().add(new String("name"));
        v.getSelector().add(new String("data"));
        v.getSelector().add(new String("dynaRptType"));
        FilterInfo f = new FilterInfo();
        v.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(12)));
        f.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(11)));
        f.getFilterItems().add(new FilterItemInfo("id", (Object)cslRptIdSet, CompareType.INCLUDE));
        String maskString = "(#0 or #1) and #2";
        f.setMaskString(maskString);
        CslReportCollection cslRpts = CslReportFactory.getRemoteInstance().getCslReportCollection(v);
        Iterator itr = cslRpts.iterator();
        block0: while (itr.hasNext()) {
            CslReportInfo cslRpt = (CslReportInfo)itr.next();
            int dynaRptType = cslRpt.getDynaRptType().getValue();
            String name = cslRpt.getName();
            Book book = cslRpt.getBook();
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                DynaSumMethodEnum method = DynamicTemplateUtility.getSheetSumMethod((Sheet)sheet);
                if (method == null || dynaRptType == 1 && method == DynaSumMethodEnum.SUM_BY_TEMPLATE || method == DynaSumMethodEnum.SUM_BY_NAME) continue;
                if (errorMsg.length() > 0) {
                    errorMsg.append(",");
                }
                errorMsg.append(name);
                cslRptIdSet.remove(cslRpt.getId().toString());
                continue block0;
            }
        }
        return errorMsg.toString();
    }

    @Override
    protected void btnQueryData_actionPerformed(ActionEvent e) throws Exception {
        if (this.pmptOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NoFindOrgGroup"));
            return;
        }
        this.refreshCSLContext();
        this.getConditionPanel().refreshCSLContext(this.getCSLContext());
        this.getConditionPanel().refreshRptDate(this.getCSLContext().getCurReportDate());
        this.getMainQuery().setFilter(this.getConditionPanel().getFilterInfo());
        if (this.mainQuery == null || this.mainQuery.getSorter() == null || this.mainQuery.getSorter().size() <= 0) {
            this.mainQuery.getSorter().add(new SorterItemInfo("TEMPLATE.ID"));
        }
        this.addVersionFilter(this.getMainQuery());
        this.tblMain.repaint();
        this.tblMain.removeRows();
    }

    public void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
        if (this.isFromCslMerge) {
            try {
                this.setCslContext2Server();
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
        if (this.isFromCslMerge) {
            try {
                this.restoreCslContext2Server();
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        if (StringUtils.isEmpty((String)reportID)) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Csl_NoReport")));
        }
        SelectorItemCollection sic = RptAutoWeaveUtil.getSelectorForSpecial();
        ICslReport iReport = CslReportFactory.getRemoteInstance();
        ObjectUuidPK objectPK = new ObjectUuidPK(BOSUuid.read((String)reportID));
        return iReport.getCslReportInfo((IObjectPK)objectPK, sic);
    }

    private void addVersionFilter(EntityViewInfo mainQuery) {
        FilterInfo filter = this.getMainQuery().getFilter();
        filter.getFilterItems().add(new FilterItemInfo(null, (Object)"SELECT 1 FROM T_CSL_SumrptAddedperPorty p WHERE p.FIsSupportGroup = 2 AND p.FReport = CSLREPORT.FId", CompareType.NOTEXISTS));
        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        boolean isOrderByTable;
        boolean bl = isOrderByTable = this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1;
        if (isOrderByTable && this.isFromCslMerge) {
            this.setCslContext2Server();
        }
        super.tblMain_tableClicked(e);
        if (isOrderByTable && this.isFromCslMerge) {
            this.restoreCslContext2Server();
        }
    }

    protected boolean isOrderPre() {
        return true;
    }
}

