/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.Checkage;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.CheckageDCEnum;
import com.kingdee.eas.fi.gr.cslrpt.DataCheckageEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DiffHandleStrategy;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationItemMapFactory;
import com.kingdee.eas.fi.gr.cslrpt.IInterCheck;
import com.kingdee.eas.fi.gr.cslrpt.IInterDataCheckage;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckException;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterDataCheckageFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterDataCheckageInfo;
import com.kingdee.eas.fi.gr.cslrpt.InterTradeClientUtils;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractDiffHandleEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.InterCheckNewListUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class DiffHandleEditUI
extends AbstractDiffHandleEditUI {
    List debitList = new ArrayList();
    List creditList = new ArrayList();
    private static final String TB_COMPANY = "company";
    private static final String TB_TARGET_COMPANY = "targetCompany";
    private static final String TB_ITEM_NUMBER = "itemNumber";
    private static final String TB_ITEM_NAME = "itemName";
    private static final String TB_DATAELEMENT = "dataelement";
    private static final String TB_DEBIT = "debit";
    private static final String TB_CREDIT = "credit";
    private static final String TB_VALID_DEBIT = "valiDebit";
    private static final String TB_VALID_CREDIT = "valiCredit";
    private static final String TB_DC = "dc";
    private static final String TB_COMPANYID = "companyId";
    private static final String TB_TARGETCOMPANYID = "targetCompanyId";
    private BigDecimal debitTotal = null;
    private BigDecimal creditTotal = null;
    private BigDecimal validDebitTotal = null;
    private BigDecimal validCreditTotal = null;
    private int isIncludeDiffItem = 0;
    private HashMap mapDiffItemNumbers = new HashMap();
    private IInterCheck iInterCheck = null;
    private IRowSet rs = null;
    private String currentId;
    private int currentIndex = 0;
    private Map companyMap = null;
    private List myID = null;
    private List companyIds = new ArrayList();
    private BigDecimal rawDiffValue = null;
    private BigDecimal diffValue = null;
    private boolean oneEqualsInputed = false;
    private BigDecimal oldValue = null;
    private String oldId = null;
    private String newId = null;
    private int iCurrencyPrecision = 0;
    private boolean bNeedReleaseLock = false;
    private static final Logger logger = Logger.getLogger(DiffHandleEditUI.class);
    private boolean isInit = false;
    private boolean isDo = true;
    private CheckageDCEnum templateCheckedParty = CheckageDCEnum.ALL;
    private String templetId = "";
    private String checkedParty;
    private int checkedStatus = 1;
    private boolean isByCompany = false;
    private int singleDC = 0;
    private int dc = 0;
    private boolean isSubmit = false;
    private boolean canCheckageNotBalance = false;

    public DiffHandleEditUI() throws Exception {
        this.initEntryTable();
        this.comboDiffMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DiffHandleEditUI.this.diffModeChangePerformed();
                }
            }
        });
    }

    public void onShow() throws Exception {
        if (this.getUIWindow() instanceof KDFrame) {
            ((KDFrame)this.getUIWindow()).setExtendedState(6);
        }
        super.onShow();
    }

    private void initEntryTable() {
        this.kdtEntries.checkParsed();
        ValueChangeListener v = new ValueChangeListener(this.comboDiffMode, this.kdtEntries, this.txtValidDebitTotal, this.txtValidCreditTotal);
        this.kdtEntries.addKDTPropertyChangeListener((KDTPropertyChangeListener)v);
        this.kdtEntries.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
                DiffHandleEditUI.this.oneEqualsInputed = true;
                int creditColIndex = DiffHandleEditUI.this.kdtEntries.getColumn(DiffHandleEditUI.TB_VALID_CREDIT).getColumnIndex();
                int debitColIndex = DiffHandleEditUI.this.kdtEntries.getColumn(DiffHandleEditUI.TB_VALID_DEBIT).getColumnIndex();
                if (creditColIndex == e.getColIndex() || debitColIndex == e.getColIndex()) {
                    Object oldValueObj = DiffHandleEditUI.this.kdtEntries.getCell(e.getRowIndex(), e.getColIndex()).getValue();
                    DiffHandleEditUI.this.oldValue = oldValueObj == null ? BigDecimal.ZERO : new BigDecimal(oldValueObj.toString());
                }
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                DiffHandleEditUI.this.tableValueChanged(e);
                DiffHandleEditUI.this.oneEqualsInputed = false;
                DiffHandleEditUI.this.oldValue = null;
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    public boolean destroyWindow() {
        this.releaseObjectLock();
        return super.destroyWindow();
    }

    private void restoreSelectedRow(Object owner, KDTSelectBlock sb) {
        if (this.isSubmit && sb != null) {
            Object keyValue;
            int rowIndex = sb.getTop();
            IRow row = ((InterCheckNewListUI)owner).tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            ICell cell = row.getCell("ID");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                Object selectedID = this.getUIContext().get("selectedID");
                if (selectedID != null) {
                    // empty if block
                }
                if (keyValue.toString().equals(selectedID.toString())) {
                    ((InterCheckNewListUI)owner).tblMain.getSelectManager().select(sb);
                    ((InterCheckNewListUI)owner).tblMain.getLayoutManager().scrollRowToShow(rowIndex);
                }
            }
        }
    }

    private void tableValueChanged(KDTEditEvent e) {
        boolean isFetchHand;
        BigDecimal validDebit_Total = new BigDecimal("0");
        BigDecimal validCredit_Total = new BigDecimal("0");
        int selectRow = e.getRowIndex();
        IRow sRow = this.kdtEntries.getRow(selectRow);
        if (e.getColIndex() == this.kdtEntries.getColumnIndex(TB_VALID_DEBIT) || e.getColIndex() == this.kdtEntries.getColumnIndex(TB_VALID_CREDIT)) {
            Object debitValue = sRow.getCell(TB_VALID_DEBIT).getValue();
            Object creditValue = sRow.getCell(TB_VALID_CREDIT).getValue();
            if (debitValue != null && debitValue.toString().length() != 0 && !this.checkValMoneyFormat(debitValue.toString())) {
                sRow.getCell(TB_VALID_DEBIT).setValue(null);
            }
            if (creditValue != null && creditValue.toString().length() != 0 && !this.checkValMoneyFormat(creditValue.toString())) {
                sRow.getCell(TB_VALID_CREDIT).setValue(null);
            }
        }
        if ((isFetchHand = this.comboDiffMode.getSelectedItem().equals((Object)DiffModeEnum.FetchHandCraft)) || this.singleDC == 1) {
            boolean isValidCredit;
            boolean isValidDebit = e.getColIndex() == this.kdtEntries.getColumnIndex(TB_VALID_DEBIT);
            boolean bl = isValidCredit = e.getColIndex() == this.kdtEntries.getColumnIndex(TB_VALID_CREDIT);
            if (isValidDebit || isValidCredit) {
                BigDecimal debit = null;
                BigDecimal credit = null;
                for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                    IRow row = this.kdtEntries.getRow(i);
                    try {
                        debit = row.getCell(TB_VALID_DEBIT).getValue() == null ? new BigDecimal("0") : new BigDecimal(row.getCell(TB_VALID_DEBIT).getValue().toString());
                        BigDecimal bigDecimal = credit = row.getCell(TB_VALID_CREDIT).getValue() == null ? new BigDecimal("0") : new BigDecimal(row.getCell(TB_VALID_CREDIT).getValue().toString());
                        if (isFetchHand && debit.compareTo(BigDecimal.ZERO) != 0 && credit.compareTo(BigDecimal.ZERO) != 0) {
                            debit = isValidDebit ? debit : BigDecimal.ZERO;
                            credit = isValidCredit ? credit : BigDecimal.ZERO;
                            this.kdtEntries.getRow(e.getRowIndex()).getCell(isValidDebit ? TB_VALID_CREDIT : TB_VALID_DEBIT).setValue((Object)new BigDecimal("0").setScale(this.iCurrencyPrecision, 4));
                        }
                        validDebit_Total = validDebit_Total.add(debit);
                        validCredit_Total = validCredit_Total.add(credit);
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.NumberFormatException"));
                    }
                }
            }
            this.txtValidDebitTotal.setValue((Object)validDebit_Total.setScale(this.iCurrencyPrecision, 4));
            this.txtValidCreditTotal.setValue((Object)validCredit_Total.setScale(this.iCurrencyPrecision, 4));
            this.txtConfirmDiffVal.setValue((Object)validDebit_Total.subtract(validCredit_Total).setScale(this.iCurrencyPrecision, 4));
        }
        if (e.getColIndex() == this.kdtEntries.getColumnIndex(TB_VALID_DEBIT) || e.getColIndex() == this.kdtEntries.getColumnIndex(TB_VALID_CREDIT)) {
            if (this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue() == null) {
                this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal("0").setScale(this.iCurrencyPrecision, 4));
            } else {
                try {
                    this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal(this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue().toString()).setScale(this.iCurrencyPrecision, 4));
                }
                catch (Exception e1) {
                    this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal("0").setScale(this.iCurrencyPrecision, 4));
                }
            }
        }
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        this.doPrecision();
    }

    private void doPrecision() {
        int iRowCount = this.kdtEntries.getRowCount();
        BigDecimal debit = null;
        BigDecimal credit = null;
        BigDecimal valiDebit = null;
        BigDecimal valiCredit = null;
        for (int i = 0; i < iRowCount; ++i) {
            debit = (BigDecimal)this.kdtEntries.getCell(i, TB_DEBIT).getValue();
            credit = (BigDecimal)this.kdtEntries.getCell(i, TB_CREDIT).getValue();
            valiDebit = (BigDecimal)this.kdtEntries.getCell(i, TB_VALID_DEBIT).getValue();
            valiCredit = (BigDecimal)this.kdtEntries.getCell(i, TB_VALID_CREDIT).getValue();
            if (this.iCurrencyPrecision == 0) {
                this.iCurrencyPrecision = 2;
            }
            if (debit != null) {
                debit = debit.setScale(this.iCurrencyPrecision, 4);
            }
            if (credit != null) {
                credit = credit.setScale(this.iCurrencyPrecision, 4);
            }
            if (valiDebit != null) {
                valiDebit = valiDebit.setScale(this.iCurrencyPrecision, 4);
            }
            if (valiCredit != null) {
                valiCredit = valiCredit.setScale(this.iCurrencyPrecision, 4);
            }
            this.kdtEntries.getCell(i, TB_DEBIT).setValue((Object)debit);
            this.kdtEntries.getCell(i, TB_CREDIT).setValue((Object)credit);
            this.kdtEntries.getCell(i, TB_VALID_DEBIT).setValue((Object)valiDebit);
            this.kdtEntries.getCell(i, TB_VALID_CREDIT).setValue((Object)valiCredit);
        }
    }

    private DiffModeEnum getDiffModeEnum(int diffMode) {
        DiffModeEnum diffEnum;
        switch (diffMode) {
            case 5: {
                diffEnum = DiffModeEnum.FetchAverage;
                break;
            }
            case 1: {
                diffEnum = DiffModeEnum.FetchBig;
                break;
            }
            case 4: {
                diffEnum = DiffModeEnum.FetchCredit;
                break;
            }
            case 3: {
                diffEnum = DiffModeEnum.FetchDebit;
                break;
            }
            case 10: {
                diffEnum = DiffModeEnum.FetchHandCraft;
                break;
            }
            case 2: {
                diffEnum = DiffModeEnum.FetchSmall;
                break;
            }
            case 6: {
                diffEnum = DiffModeEnum.FetchZero;
                break;
            }
            default: {
                diffEnum = DiffModeEnum.FetchHandCraft;
            }
        }
        return diffEnum;
    }

    private void initCheckageData() throws BOSException {
        if (this.iInterCheck == null) {
            this.iInterCheck = InterCheckFactory.getRemoteInstance();
        }
        IInterDataCheckage interData = InterDataCheckageFactory.getRemoteInstance();
        int rowIndex = 0;
        IRow row = null;
        try {
            ObjectUuidPK pk = new ObjectUuidPK(this.currentId);
            InterDataCheckageInfo info = interData.getInterDataCheckageInfo("select checkageConfirm,templet.id,templet.checkedParty,checkedParty.id,checkageConfirm where id='" + this.currentId + "'");
            if (info != null) {
                this.templetId = info.getTemplet().getId().toString();
                this.checkedParty = info.getCheckedParty() == null ? null : info.getCheckedParty().getId().toString();
                this.checkedStatus = info.getCheckageConfirm().getValue();
                if (info.getTemplet() != null) {
                    this.templateCheckedParty = info.getTemplet().getCheckedParty();
                }
            }
            this.rs = this.iInterCheck.getCheckageRecord(this.currentId, ElimTypeEnum.ComeAndGo);
            if (this.rs == null) {
                return;
            }
            this.resetControlValue();
            this.kdtEntries.removeRows();
            this.rs.beforeFirst();
            boolean first = true;
            this.companyMap = new HashMap();
            this.companyIds.clear();
            String strItemNumber = null;
            while (this.rs.next()) {
                ++rowIndex;
                if (this.rs.getInt("fdatasrctype") == 2) {
                    this.isIncludeDiffItem = 1;
                    strItemNumber = this.rs.getString("FItemNumber");
                    if (this.mapDiffItemNumbers == null) {
                        this.mapDiffItemNumbers = new HashMap();
                    }
                    if (strItemNumber != null && !this.mapDiffItemNumbers.containsKey(strItemNumber)) {
                        this.mapDiffItemNumbers.put(strItemNumber, strItemNumber);
                    }
                }
                if (first && this.rs.getString("FNumber") != null && this.rs.getString("fid") != null) {
                    first = false;
                    this.txtDescription.setText(this.rs.getString("FDescription"));
                    this.txtNumber.setText(this.rs.getString("FNumber"));
                    this.comboCheckedStatus.setSelectedItem((Object)CheckageConfirmEnum.getEnum(this.rs.getInt("FCheckedStatus")));
                    this.comboDiffMode.setSelectedItem((Object)this.getDiffModeEnum(this.rs.getInt("FDiffMode")));
                    this.isDo = true;
                    this.rawDiffValue = this.rs.getBigDecimal("FDiffValue") == null ? new BigDecimal("0") : this.rs.getBigDecimal("FDiffValue");
                    this.diffValue = this.rawDiffValue.abs();
                    this.companyMap.put(this.rs.getString("fcompanyName"), this.rs.getString("fcompanyid"));
                    this.companyMap.put(this.rs.getString("ftargetcompanyName"), this.rs.getString("ftargetcompanyid"));
                }
                this.companyMap.put(this.rs.getString("fitemname"), this.rs.getString("fitemid"));
                row = this.kdtEntries.addRow();
                row.getCell(TB_COMPANY).setValue((Object)this.rs.getString("FCompanyName"));
                row.getCell(TB_TARGET_COMPANY).setValue((Object)this.rs.getString("FTargetCompanyName"));
                row.getCell(TB_ITEM_NAME).setValue((Object)this.rs.getString("FItemName"));
                row.getCell(TB_ITEM_NUMBER).setValue((Object)this.rs.getString("FItemNumber"));
                row.getCell(TB_DATAELEMENT).setValue((Object)DataElementProvider.getDataElementInfo(this.rs.getInt("fdataelement")));
                row.getCell(TB_DEBIT).setValue((Object)this.rs.getBigDecimal("FDebit"));
                row.getCell(TB_CREDIT).setValue((Object)this.rs.getBigDecimal("FCredit"));
                row.getCell(TB_VALID_DEBIT).setValue((Object)this.rs.getBigDecimal("FValiDebit"));
                row.getCell(TB_VALID_CREDIT).setValue((Object)this.rs.getBigDecimal("FValiCredit"));
                row.getCell(TB_DC).setValue((Object)new Integer(this.rs.getInt("FDC")));
                row.getCell(TB_COMPANYID).setValue((Object)this.rs.getString("FCompanyId"));
                row.getCell(TB_TARGETCOMPANYID).setValue((Object)this.rs.getString("FTargetCompanyId"));
                String amount = null;
                String companyid = this.rs.getString("fcompanyid") + this.rs.getString("ftargetcompanyid");
                amount = this.rs.getBigDecimal("FDebit").compareTo(SysConstant.BIGZERO) > 0 ? "-" + this.rs.getBigDecimal("FDebit").setScale(10).toString() + TB_DEBIT : this.rs.getBigDecimal("FDebit").setScale(10).toString().replaceAll("-", "") + TB_DEBIT;
                if (this.rs.getBigDecimal("FDebit") != null && this.rs.getBigDecimal("FDebit").compareTo(SysConstant.BIGZERO) != 0) {
                    if (this.creditList.contains(this.rs.getBigDecimal("FDebit").setScale(10).toString() + TB_CREDIT)) {
                        this.creditList.remove(this.rs.getBigDecimal("FDebit").setScale(10).toString() + TB_CREDIT);
                    } else if (this.debitList.contains(amount)) {
                        this.debitList.remove(amount);
                    } else {
                        this.debitList.add(this.rs.getBigDecimal("FDebit").setScale(10).toString() + TB_DEBIT);
                    }
                    if (!this.companyIds.contains(companyid)) {
                        this.companyIds.add(companyid);
                    }
                }
                amount = this.rs.getBigDecimal("FCredit").compareTo(SysConstant.BIGZERO) > 0 ? "-" + this.rs.getBigDecimal("FCredit").setScale(10).toString() + TB_CREDIT : this.rs.getBigDecimal("FCredit").setScale(10).toString().replaceAll("-", "") + TB_CREDIT;
                if (this.rs.getBigDecimal("FCredit") == null || this.rs.getBigDecimal("FCredit").compareTo(SysConstant.BIGZERO) == 0) continue;
                if (this.debitList.contains(this.rs.getBigDecimal("FCredit").setScale(10).toString() + TB_DEBIT)) {
                    this.debitList.remove(this.rs.getBigDecimal("FCredit").setScale(10).toString() + TB_DEBIT);
                } else if (this.creditList.contains(amount)) {
                    this.creditList.remove(amount);
                } else {
                    this.creditList.add(this.rs.getBigDecimal("FCredit").setScale(10).toString() + TB_CREDIT);
                }
                if (this.companyIds.contains(companyid)) continue;
                this.companyIds.add(companyid);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.calcuTotalValue();
        this.enabledControl();
    }

    private void setCurrentIndex() {
        this.myID = (List)this.getUIContext().get("myID");
        if (this.myID == null) {
            this.currentIndex = 1;
            return;
        }
        int n = this.myID.size();
        for (int i = 0; i < n; ++i) {
            if (!this.currentId.equals(this.myID.get(i))) continue;
            this.currentIndex = ++i;
            return;
        }
        if (this.currentIndex == 0) {
            this.myID.add(0, this.currentId);
            this.currentIndex = 1;
        }
    }

    public void onLoad() throws Exception {
        this.isInit = true;
        this.canCheckageNotBalance = CSLParamUtil.canCheckOnNotBalance(null);
        super.onLoad();
        this.currentId = (String)this.getUIContext().get("ID");
        this.isByCompany = this.getUIContext().containsKey("isByCompany") ? (Boolean)this.getUIContext().get("isByCompany") : this.isByCompany;
        this.setCurrentIndex();
        this.initCheckageData();
        this.initSingleDC();
        this.kdtEntries.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    DiffHandleEditUI.this.tblMain_afterDataFill(e);
                }
                catch (Exception exc) {
                    DiffHandleEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.getActionMap().remove("Delete");
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnPrint.setVisible(false);
        this.txtNumber.setText("WL-" + this.txtNumber.getText());
        this.txtNumber.setEnabled(false);
        this.comboCheckedStatus.setEnabled(false);
        this.txtDiffValue.setEnabled(false);
        this.txtDebitTotal.setEnabled(false);
        this.txtCreditTotal.setEnabled(false);
        this.txtValidDebitTotal.setEnabled(false);
        this.txtValidCreditTotal.setEnabled(false);
        this.txtConfirmDiffVal.setEnabled(false);
        CslRptUIUtil.setRelationDiagramVisible((CoreUI)this);
        this.kdtEntries.getColumn(TB_COMPANY).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_TARGET_COMPANY).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_ITEM_NUMBER).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_ITEM_NAME).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_DEBIT).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_CREDIT).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_DATAELEMENT).getStyleAttributes().setLocked(true);
        if (this.editData.getDiffMode().equals((Object)DiffModeEnum.FetchHandCraft)) {
            this.kdtEntries.getColumn(TB_VALID_DEBIT).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_VALID_CREDIT).getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntries.getColumn(TB_VALID_DEBIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_VALID_CREDIT).getStyleAttributes().setLocked(true);
        }
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setSupportedEmpty(true);
        formatField.setPrecision(this.iCurrencyPrecision);
        KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kdtEntries.getColumn(TB_VALID_CREDIT).setEditor((ICellEditor)dcEditor);
        this.kdtEntries.getColumn(TB_VALID_DEBIT).setEditor((ICellEditor)dcEditor);
        this.checkHasAudited();
        this.hideUnuseableButtons();
        this.btnWorkFlowG.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.menuBiz.setVisible(false);
        this.isInit = false;
        KeyStroke ks = KeyStroke.getKeyStroke(61, 0);
        String strKey = "InterUI.EQUALS";
        this.getActionMap().put(strKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DiffHandleEditUI.this.setCellDiffValue();
                }
                catch (Exception e1) {
                    DiffHandleEditUI.this.handUIException(e1);
                }
            }
        });
        this.getInputMap(2).put(ks, strKey);
    }

    protected void setCellDiffValue() {
        boolean isHand = DiffModeEnum.FetchHandCraft.equals(this.comboDiffMode.getSelectedItem());
        if (isHand && this.oneEqualsInputed) {
            KDTSelectManager manager = this.kdtEntries.getSelectManager();
            int rowIndex = manager.getActiveRowIndex();
            int columnIndex = manager.getActiveColumnIndex();
            int creditColIndex = this.kdtEntries.getColumn(TB_VALID_CREDIT).getColumnIndex();
            int debitColIndex = this.kdtEntries.getColumn(TB_VALID_DEBIT).getColumnIndex();
            if (creditColIndex == columnIndex || debitColIndex == columnIndex) {
                BigDecimal diffVal = BigDecimal.ZERO;
                try {
                    diffVal = new BigDecimal(this.txtConfirmDiffVal.getValue().toString());
                }
                catch (Exception e) {
                    logger.error((Object)"get diff Value error", (Throwable)e);
                }
                BigDecimal setCellValue = debitColIndex == columnIndex ? this.oldValue.subtract(diffVal) : this.oldValue.add(diffVal);
                this.kdtEntries.getCell(rowIndex, columnIndex).setValue(null);
                this.kdtEntries.getCell(rowIndex, columnIndex).setValue((Object)setCellValue);
            }
            this.oneEqualsInputed = false;
        }
    }

    protected void hideUnuseableButtons() {
        this.btnAddNew.setVisible(false);
        this.btnAddLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnCopy.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionAddLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionCopy.setEnabled(false);
        this.btnPCVoucher.setVisible(false);
        this.btnDelPCVoucher.setVisible(false);
        this.btnSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.btnCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.btnCopyFrom.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.menuItemMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.menuItemNextPerson.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuItemSendMail.setVisible(false);
        this.menuItemCopy.setVisible(false);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.isDo = false;
        this.currentIndex = 1;
        this.currentId = (String)this.myID.get(this.currentIndex - 1);
        this.initCheckageData();
        this.enabledControl();
        this.checkHasAudited();
    }

    private void enabledControl() {
        int size = 0;
        size = this.myID.size();
        if (size == 1) {
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
            return;
        }
        if (this.currentIndex == size) {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        } else {
            this.actionNext.setEnabled(true);
            this.actionLast.setEnabled(true);
        }
        if (this.currentIndex == 1) {
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
        } else {
            this.actionFirst.setEnabled(true);
            this.actionPre.setEnabled(true);
        }
    }

    private void checkHasAudited() throws Exception {
        this.setEnableByChecked();
    }

    protected void setEnableByChecked() {
        boolean isCanOprtParty;
        if (this.rs == null) {
            return;
        }
        boolean bl = isCanOprtParty = StringUtils.isEmpty((String)this.checkedParty) ? true : SysContext.getSysContext().getCurrentOrgUnit().getId().toString().equals(this.checkedParty);
        if (this.checkedStatus == 2 || this.checkedStatus == 0 || !isCanOprtParty && this.isByCompany) {
            String message = null;
            if (this.checkedStatus == 2 || this.checkedStatus == 0) {
                message = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Msg_CantHdlAuditData");
            }
            if (!isCanOprtParty && this.isByCompany) {
                message = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.LoginOrgIsNotAuditParty");
            }
            MsgBox.showInfo((Component)((Object)this), (String)message);
            this.actionSubmit.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.comboDiffMode.setEnabled(false);
            this.txtDescription.setEnabled(false);
            this.kdtEntries.getColumn(TB_VALID_DEBIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_VALID_CREDIT).getStyleAttributes().setLocked(true);
        } else {
            this.releaseObjectLock();
            this.requestObjectLock();
        }
        if (this.getOprtState().equals("VIEW")) {
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("singleDC"));
        return sic;
    }

    private void releaseObjectLock() {
        if (this.oldId != null) {
            IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
            iMC.releaseObjIDForUpdate(this.oldId);
            logger.debug((Object)("release oldid :" + this.oldId));
        }
    }

    private void requestObjectLock() {
        this.newId = this.editData.getId().toString();
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        boolean bingo = iMC.requestObjIDForUpdate(this.newId, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        if (!bingo) {
            this.oldId = null;
            this.bNeedReleaseLock = false;
            logger.debug((Object)("request newid :" + this.newId + " FAIL!"));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Msg_CurrentRecordLocked"));
            this.actionSubmit.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.comboDiffMode.setEnabled(false);
            this.txtDescription.setEnabled(false);
        } else {
            this.oldId = this.newId;
            logger.debug((Object)("request newid :" + this.newId + " OK!"));
            this.bNeedReleaseLock = true;
            this.actionSubmit.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.comboDiffMode.setEnabled(true);
            this.txtDescription.setEnabled(true);
        }
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.isDo = false;
        this.currentIndex = this.myID.size();
        this.currentId = (String)this.myID.get(this.myID.size() - 1);
        this.initCheckageData();
        this.enabledControl();
        this.checkHasAudited();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.isDo = false;
        ++this.currentIndex;
        this.currentId = (String)this.myID.get(this.currentIndex - 1);
        this.initCheckageData();
        this.enabledControl();
        this.checkHasAudited();
    }

    private void calcuTotalValue() {
        if (this.rs == null) {
            return;
        }
        this.debitTotal = new BigDecimal("0");
        this.creditTotal = new BigDecimal("0");
        this.validDebitTotal = new BigDecimal("0");
        this.validCreditTotal = new BigDecimal("0");
        this.txtDiffValue.setPrecision(this.iCurrencyPrecision);
        try {
            this.rs.beforeFirst();
            while (this.rs.next()) {
                this.debitTotal = this.debitTotal.add(this.rs.getBigDecimal("FDebit"));
                this.creditTotal = this.creditTotal.add(this.rs.getBigDecimal("FCredit"));
                this.validDebitTotal = this.validDebitTotal.add(this.rs.getBigDecimal("FValiDebit"));
                this.validCreditTotal = this.validCreditTotal.add(this.rs.getBigDecimal("FValiCredit"));
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        this.txtDebitTotal.setPrecision(this.iCurrencyPrecision);
        this.txtCreditTotal.setPrecision(this.iCurrencyPrecision);
        this.txtValidDebitTotal.setPrecision(this.iCurrencyPrecision);
        this.txtValidCreditTotal.setPrecision(this.iCurrencyPrecision);
        this.txtDiffValue.setPrecision(this.iCurrencyPrecision);
        this.txtConfirmDiffVal.setPrecision(this.iCurrencyPrecision);
        this.txtDebitTotal.setValue((Object)this.debitTotal.setScale(this.iCurrencyPrecision, 4));
        this.txtCreditTotal.setValue((Object)this.creditTotal.setScale(this.iCurrencyPrecision, 4));
        this.txtValidDebitTotal.setValue((Object)this.validDebitTotal.setScale(this.iCurrencyPrecision, 4));
        this.txtValidCreditTotal.setValue((Object)this.validCreditTotal.setScale(this.iCurrencyPrecision, 4));
        this.txtDiffValue.setValue((Object)this.debitTotal.subtract(this.creditTotal).setScale(this.iCurrencyPrecision, 4));
        this.txtConfirmDiffVal.setValue((Object)this.validDebitTotal.subtract(this.validCreditTotal).setScale(this.iCurrencyPrecision, 4));
        this.rawDiffValue = this.debitTotal.subtract(this.creditTotal);
        this.diffValue = this.rawDiffValue.abs();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.isDo = false;
        --this.currentIndex;
        if (this.currentIndex <= 0) {
            this.currentIndex = 1;
        }
        this.currentId = (String)this.myID.get(this.currentIndex - 1);
        this.initCheckageData();
        this.enabledControl();
        this.checkHasAudited();
    }

    @Override
    public void loadFields() {
        this.loadCheckageFields();
        this.iCurrencyPrecision = Integer.parseInt(this.getUIContext().get("currency.precision").toString());
        if (this.editData == null) {
            return;
        }
        this.calcuTotalValue();
    }

    @Override
    public void storeFields() {
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.verifyInput(e);
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            boolean validCreditAmtGreaterZero;
            BigDecimal validDebitAmt = (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_VALID_DEBIT).getValue();
            BigDecimal validCreditAmt = (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_VALID_CREDIT).getValue();
            boolean validDebitAmtGreaterZero = validDebitAmt != null && validDebitAmt.signum() != 0;
            boolean bl = validCreditAmtGreaterZero = validCreditAmt != null && validCreditAmt.signum() != 0;
            if (!validDebitAmtGreaterZero || !validCreditAmtGreaterZero || validDebitAmt.compareTo(validCreditAmt) != 0) continue;
            throw new InterCheckException(InterCheckException.VDEBIT_VCREDIT_GREATER_ZERO_C, new Object[]{String.valueOf(i + 1)});
        }
        if (this.txtValidDebitTotal.getBigDecimalValue() != null && this.txtValidCreditTotal.getBigDecimalValue() != null && this.txtValidDebitTotal.getBigDecimalValue().compareTo(this.txtValidCreditTotal.getBigDecimalValue()) != 0) {
            if (this.canCheckageNotBalance) {
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CHECK_DEBIT_EQUALS_CREDIT"));
                if (result != 0) {
                    SysUtil.abort();
                }
            } else {
                throw new InterCheckException(InterCheckException.CHECK_DEBIT_EQUALS_CREDIT);
            }
        }
        Map checkageMap = this.getCheckageMap();
        Map param = (Map)this.getUIContext().get("param");
        Boolean isByCompany = (Boolean)this.getUIContext().get("isByCompany");
        checkageMap.put("isByCompany", isByCompany);
        Object errorList = null;
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(this.currentId);
        boolean ret = false;
        InterTradeClientUtils.checkedReceivedReport((Map<Object, Object>)param, list, ElimTypeEnum.ComeAndGo, CheckageConfirmEnum.Confirm);
        ret = this.iInterCheck.saveCheckageRecord(checkageMap, ElimTypeEnum.ComeAndGo);
        this.isSubmit = true;
        if (ret) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            if (StringUtils.isEmpty((String)this.checkedParty) || !isByCompany.booleanValue()) {
                this.comboCheckedStatus.setSelectedItem((Object)CheckageConfirmEnum.Confirm);
            } else {
                this.comboCheckedStatus.setSelectedItem((Object)CheckageConfirmEnum.Audit);
            }
            this.btnSubmit.setEnabled(false);
        }
        this.doPrecision();
        Object owner = this.getUIContext().get("Owner");
        if (owner instanceof InterCheckNewListUI) {
            HashSet<String> ids = new HashSet<String>();
            ids.add(this.currentId);
            ((InterCheckNewListUI)owner).refreshByIds(ids);
        }
    }

    private Map getCheckageMap() {
        HashMap<String, Object> checkageMap = new HashMap<String, Object>();
        HashMap entries = new HashMap();
        checkageMap.put("id", this.currentId);
        checkageMap.put("description", this.txtDescription.getText());
        checkageMap.put("diffMode", this.comboDiffMode.getSelectedItem());
        checkageMap.put("checkedParty", this.checkedParty);
        checkageMap.put("entries", entries);
        HashMap recordMap = new HashMap();
        HashMap<String, BigDecimal> moneyMap = null;
        BigDecimal zero = new BigDecimal("0");
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            BigDecimal debit = (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_DEBIT).getValue();
            BigDecimal credit = (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_CREDIT).getValue();
            BigDecimal validebit = (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_VALID_DEBIT).getValue();
            BigDecimal valicredit = (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_VALID_CREDIT).getValue();
            if (!(debit != null && debit.compareTo(zero) != 0 || credit != null && credit.compareTo(zero) != 0 || validebit != null && validebit.compareTo(zero) != 0) && (valicredit == null || valicredit.compareTo(zero) == 0)) continue;
            moneyMap = new HashMap<String, BigDecimal>();
            moneyMap.put(TB_DEBIT, debit.setScale(this.iCurrencyPrecision, 4));
            moneyMap.put(TB_CREDIT, credit.setScale(this.iCurrencyPrecision, 4));
            moneyMap.put(TB_VALID_DEBIT, validebit.setScale(this.iCurrencyPrecision, 4));
            moneyMap.put(TB_VALID_CREDIT, valicredit.setScale(this.iCurrencyPrecision, 4));
            recordMap.put((String)this.kdtEntries.getRow(i).getCell(TB_COMPANY).getValue() + "!" + (String)this.kdtEntries.getRow(i).getCell(TB_TARGET_COMPANY).getValue() + "!" + (String)this.kdtEntries.getRow(i).getCell(TB_ITEM_NUMBER).getValue() + "!" + ((DataElementInfo)this.kdtEntries.getRow(i).getCell(TB_DATAELEMENT).getValue()).getInterSeq(), moneyMap);
        }
        String sKey = null;
        try {
            this.rs.beforeFirst();
            boolean first = true;
            while (this.rs.next()) {
                if (first) {
                    first = false;
                    checkageMap.put("id", this.currentId);
                    checkageMap.put("diffmode", this.comboDiffMode.getSelectedItem());
                }
                if (!recordMap.containsKey(sKey = this.rs.getString("fcompanyname") + "!" + this.rs.getString("ftargetcompanyname") + "!" + this.rs.getString("fitemnumber") + "!" + this.rs.getString("fdataelement"))) continue;
                ((Map)recordMap.get(sKey)).put("companyid", this.rs.getString("fcompanyid") == null ? this.companyMap.get(this.rs.getString("fcompanyname")) : this.rs.getString("fcompanyid"));
                ((Map)recordMap.get(sKey)).put("targetcompanyid", this.rs.getString("ftargetcompanyid") == null ? this.companyMap.get(this.rs.getString("ftargetcompanyname")) : this.rs.getString("ftargetcompanyid"));
                ((Map)recordMap.get(sKey)).put("itemid", this.rs.getString("fitemid") == null ? this.companyMap.get(this.rs.getString("fitemname")) : this.rs.getString("fitemid"));
                ((Map)recordMap.get(sKey)).put("itemnumber", this.rs.getString("fitemnumber"));
                ((Map)recordMap.get(sKey)).put(TB_DATAELEMENT, new Integer(this.rs.getInt("fdataelement")));
            }
            Set keys = recordMap.keySet();
            Iterator it = keys.iterator();
            HashSet detail = new HashSet();
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                detail.add(recordMap.get(obj));
            }
            checkageMap.put("entries", detail);
        }
        catch (SQLException e1) {
            this.handUIException(e1);
        }
        return checkageMap;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InterDataCheckageFactory.getRemoteInstance();
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        DataCheckageEntryInfo lineInfo = (DataCheckageEntryInfo)obj;
        lineInfo.setValiDebit(row.getCell(TB_VALID_DEBIT).getValue() == null ? null : new BigDecimal(row.getCell(TB_VALID_DEBIT).getValue().toString()));
        lineInfo.setValiCredit(row.getCell(TB_VALID_CREDIT).getValue() == null ? null : new BigDecimal(row.getCell(TB_VALID_CREDIT).getValue().toString()));
    }

    private void loadCheckageFields() {
        if (this.rs == null) {
            return;
        }
        int rowIndex = 1;
        try {
            this.rs.beforeFirst();
            while (this.rs.next()) {
                this.kdtEntries.getRow(++rowIndex).getCell(TB_COMPANY).setValue((Object)this.rs.getString("FCompanyId"));
                this.kdtEntries.getRow(rowIndex).getCell(TB_TARGET_COMPANY).setValue((Object)this.rs.getString("FTargetCompanyId"));
                this.kdtEntries.getRow(rowIndex).getCell(TB_ITEM_NUMBER).setValue((Object)this.rs.getString("FItemNumber"));
                this.kdtEntries.getRow(rowIndex).getCell(TB_ITEM_NAME).setValue((Object)this.rs.getString("FItemName"));
                this.kdtEntries.getRow(rowIndex).getCell(TB_DEBIT).setValue((Object)this.rs.getBigDecimal("FDebit"));
                this.kdtEntries.getRow(rowIndex).getCell(TB_CREDIT).setValue((Object)this.rs.getBigDecimal("FCredit"));
                this.kdtEntries.getRow(rowIndex).getCell(TB_VALID_DEBIT).setValue((Object)this.rs.getBigDecimal("FValiDebit"));
                this.kdtEntries.getRow(rowIndex).getCell(TB_VALID_CREDIT).setValue((Object)this.rs.getBigDecimal("FValiCredit"));
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        DataCheckageEntryInfo lineInfo = (DataCheckageEntryInfo)obj;
        row.getCell(TB_COMPANY).setValue(lineInfo.getCompany() == null ? null : lineInfo.getCompany().getName());
        row.getCell(TB_TARGET_COMPANY).setValue(lineInfo.getTargetCompany() == null ? null : lineInfo.getTargetCompany().getName());
        row.getCell(TB_ITEM_NUMBER).setValue((Object)(lineInfo.getItem() == null ? null : lineInfo.getItem()));
        row.getCell(TB_ITEM_NAME).setValue(lineInfo.getItem() == null ? null : lineInfo.getItem().getName(this.getCurrentLocale()));
        row.getCell(TB_DEBIT).setValue((Object)lineInfo.getDebit());
        row.getCell(TB_CREDIT).setValue((Object)lineInfo.getCredit());
        row.getCell(TB_VALID_DEBIT).setValue((Object)lineInfo.getValiDebit());
        row.getCell(TB_VALID_CREDIT).setValue((Object)lineInfo.getValiCredit());
    }

    private Checkage getCheckage() {
        ArrayList entries = new ArrayList();
        BigDecimal debitAll = new BigDecimal("0");
        BigDecimal creditAll = new BigDecimal("0");
        boolean isSameCompany = false;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            String strItemNumber = row.getCell(TB_ITEM_NUMBER).getValue().toString();
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("itemnumber", strItemNumber);
            entry.put(TB_DC, row.getCell(TB_DC).getValue());
            entry.put("dataSrcType", this.mapDiffItemNumbers.containsKey(strItemNumber) ? new Integer(2) : new Integer(1));
            entry.put("isIncludeDiffItem", new Integer(this.isIncludeDiffItem));
            entry.put(TB_DEBIT, row.getCell(TB_DEBIT).getValue());
            entry.put(TB_CREDIT, row.getCell(TB_CREDIT).getValue());
            entry.put("validebit", row.getCell(TB_DEBIT).getValue());
            entry.put("valicredit", row.getCell(TB_CREDIT).getValue());
            entry.put("companyid", row.getCell(TB_COMPANYID).getValue());
            entry.put("targetcompanyid", row.getCell(TB_TARGETCOMPANYID).getValue());
            entry.put(TB_DATAELEMENT, row.getCell(TB_DATAELEMENT).getValue());
            entry.put("seq", new Integer(i + 1));
            entry.put(TB_DATAELEMENT, ((DataElementInfo)row.getCell(TB_DATAELEMENT).getValue()).getInterSeq());
            debitAll = debitAll.add(new BigDecimal(row.getCell(TB_DEBIT).getValue().toString()));
            creditAll = creditAll.add(new BigDecimal(row.getCell(TB_CREDIT).getValue().toString()));
            entries.add(entry);
            if (!row.getCell(TB_COMPANYID).getValue().equals(row.getCell(TB_TARGETCOMPANYID).getValue())) continue;
            isSameCompany = true;
        }
        Checkage checkage = new Checkage();
        checkage.setDebitTotal(debitAll);
        checkage.setCreditTotal(creditAll);
        BigDecimal diffValue = CslConstant.BGZERO;
        if (this.txtDebitTotal.getBigDecimalValue() != null && this.txtCreditTotal.getBigDecimalValue() != null) {
            diffValue = debitAll.subtract(creditAll);
        }
        checkage.setDiffValue(diffValue);
        checkage.setAbsDiffValue(diffValue.abs());
        DiffModeEnum diffMode = (DiffModeEnum)((Object)this.comboDiffMode.getSelectedItem());
        checkage.setDiffMode(diffMode.getValue());
        checkage.setSameCompany(isSameCompany);
        checkage.setEntries(entries);
        if (this.templateCheckedParty != null) {
            checkage.setCheckedParty(this.templateCheckedParty.getValue());
        }
        return checkage;
    }

    public void fillIntoTable(Checkage checkage) {
        this.fillDataIntoTable(checkage);
        this.setControlEditable(checkage);
    }

    private void setControlEditable(Checkage checkage) {
        boolean isEditable = checkage.getDiffMode() == 10;
        this.kdtEntries.getColumn(TB_VALID_DEBIT).getStyleAttributes().setLocked(!isEditable);
        this.kdtEntries.getColumn(TB_VALID_CREDIT).getStyleAttributes().setLocked(!isEditable);
    }

    private void fillDataIntoTable(Checkage checkage) {
        List entries = checkage.getEntries();
        BigDecimal debitTotal = CslConstant.BGZERO;
        BigDecimal creditTotal = CslConstant.BGZERO;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            Map entry = (Map)entries.get(i);
            int rowIndex = (Integer)entry.get("seq") - 1;
            IRow row = this.kdtEntries.getRow(rowIndex);
            row.getCell(TB_VALID_DEBIT).setValue(entry.get("validebit"));
            row.getCell(TB_VALID_CREDIT).setValue(entry.get("valicredit"));
            debitTotal = debitTotal.add(entry.get("validebit") == null ? CslConstant.BGZERO : (BigDecimal)entry.get("validebit"));
            creditTotal = creditTotal.add(entry.get("valicredit") == null ? CslConstant.BGZERO : (BigDecimal)entry.get("valicredit"));
        }
        this.txtValidDebitTotal.setValue((Object)debitTotal);
        this.txtValidCreditTotal.setValue((Object)creditTotal);
        this.txtConfirmDiffVal.setValue((Object)debitTotal.subtract(creditTotal));
    }

    private void diffModeChangePerformed() {
        if (!this.isDo) {
            Checkage checkage = new Checkage();
            DiffModeEnum diffMode = (DiffModeEnum)((Object)this.comboDiffMode.getSelectedItem());
            checkage.setDiffMode(diffMode.getValue());
            this.setControlEditable(checkage);
            return;
        }
        Checkage checkage = this.getCheckage();
        CoreBaseCollection cbaseColl = new CoreBaseCollection();
        try {
            StringBuffer itemSql = new StringBuffer("select");
            itemSql.append(" selfCompanyTtem.Id,selfCompanyTtem.Name,selfCompanyTtem.number,");
            itemSql.append(" otherCompanyTtem.Id,otherCompanyTtem.Name,otherCompanyTtem.number,");
            itemSql.append("elimTemple.id ");
            itemSql.append(" where elimTemple='").append(this.templetId).append("'");
            itemSql.append(" order by seq");
            cbaseColl = EliminationItemMapFactory.getRemoteInstance().getCollection(itemSql.toString());
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        DiffModeEnum diffMode = (DiffModeEnum)((Object)this.comboDiffMode.getSelectedItem());
        checkage.setCbaseColl(cbaseColl);
        DiffHandleStrategy strategy = new DiffHandleStrategy(diffMode.getValue(), checkage);
        strategy.execute();
        this.fillIntoTable(checkage);
    }

    protected void addLine(KDTable table) {
    }

    private void resetControlValue() {
        this.debitTotal = CslConstant.BGZERO;
        this.creditTotal = CslConstant.BGZERO;
        this.validDebitTotal = CslConstant.BGZERO;
        this.validCreditTotal = CslConstant.BGZERO;
        this.rawDiffValue = CslConstant.BGZERO;
        this.diffValue = CslConstant.BGZERO;
    }

    private void initSingleDC() throws Exception {
    }

    private boolean checkValMoneyFormat(String formulaString) {
        String pattern = "^[+-]?\\d+(\\.\\d+)?$";
        Pattern patt = Pattern.compile(pattern);
        Matcher matcher = patt.matcher(formulaString);
        return matcher.find();
    }

    class ValueChangeListener
    implements KDTPropertyChangeListener {
        private KDComboBox comboDiffMode = null;
        private KDTable kdtEntries = null;
        private KDFormattedTextField txtValidDebitTotal = null;
        private KDFormattedTextField txtValidCreditTotal = null;

        public ValueChangeListener(KDComboBox mode, KDTable table, KDFormattedTextField debit, KDFormattedTextField credit) {
            this.comboDiffMode = mode;
            this.kdtEntries = table;
            this.txtValidDebitTotal = debit;
            this.txtValidCreditTotal = credit;
        }

        public void propertyChange(KDTPropertyChangeEvent evt) {
            this.tableValueChanged(evt);
            int creditColIndex = this.kdtEntries.getColumn(DiffHandleEditUI.TB_VALID_CREDIT).getColumnIndex();
            int debitColIndex = this.kdtEntries.getColumn(DiffHandleEditUI.TB_VALID_DEBIT).getColumnIndex();
            if (creditColIndex == evt.getColIndex() || debitColIndex == evt.getColIndex()) {
                Object oldValueObj = this.kdtEntries.getCell(evt.getRowIndex(), evt.getColIndex()).getValue();
                DiffHandleEditUI.this.oldValue = oldValueObj == null ? BigDecimal.ZERO : new BigDecimal(oldValueObj.toString());
            }
        }

        private void tableValueChanged(KDTPropertyChangeEvent e) {
            BigDecimal validDebit_Total = new BigDecimal("0");
            BigDecimal validCredit_Total = new BigDecimal("0");
            if (DiffHandleEditUI.this.isInit) {
                return;
            }
            boolean isFetchHand = this.comboDiffMode.getSelectedItem().equals((Object)DiffModeEnum.FetchHandCraft);
            if (isFetchHand || DiffHandleEditUI.this.singleDC == 1) {
                boolean isValidCredit;
                boolean isValidDebit = e.getColIndex() == this.kdtEntries.getColumnIndex(DiffHandleEditUI.TB_VALID_DEBIT);
                boolean bl = isValidCredit = e.getColIndex() == this.kdtEntries.getColumnIndex(DiffHandleEditUI.TB_VALID_CREDIT);
                if (isValidDebit || isValidCredit) {
                    BigDecimal debit = null;
                    BigDecimal credit = null;
                    for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                        IRow row = this.kdtEntries.getRow(i);
                        debit = row.getCell(DiffHandleEditUI.TB_VALID_DEBIT).getValue() == null ? new BigDecimal("0") : new BigDecimal(row.getCell(DiffHandleEditUI.TB_VALID_DEBIT).getValue().toString());
                        BigDecimal bigDecimal = credit = row.getCell(DiffHandleEditUI.TB_VALID_CREDIT).getValue() == null ? new BigDecimal("0") : new BigDecimal(row.getCell(DiffHandleEditUI.TB_VALID_CREDIT).getValue().toString());
                        if (isFetchHand && debit.compareTo(BigDecimal.ZERO) != 0 && credit.compareTo(BigDecimal.ZERO) != 0) {
                            debit = isValidDebit ? debit : BigDecimal.ZERO;
                            credit = isValidCredit ? credit : BigDecimal.ZERO;
                            this.kdtEntries.getRow(e.getRowIndex()).getCell(isValidDebit ? DiffHandleEditUI.TB_VALID_CREDIT : DiffHandleEditUI.TB_VALID_DEBIT).setValue((Object)new BigDecimal("0").setScale(DiffHandleEditUI.this.iCurrencyPrecision, 4));
                        }
                        validDebit_Total = validDebit_Total.add(debit);
                        validCredit_Total = validCredit_Total.add(credit);
                    }
                }
                this.txtValidDebitTotal.setValue((Object)validDebit_Total.setScale(DiffHandleEditUI.this.iCurrencyPrecision, 4));
                this.txtValidCreditTotal.setValue((Object)validCredit_Total.setScale(DiffHandleEditUI.this.iCurrencyPrecision, 4));
            }
            if (e.getColIndex() == this.kdtEntries.getColumnIndex(DiffHandleEditUI.TB_VALID_DEBIT) || e.getColIndex() == this.kdtEntries.getColumnIndex(DiffHandleEditUI.TB_VALID_CREDIT)) {
                if (this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue() == null) {
                    this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal("0").setScale(DiffHandleEditUI.this.iCurrencyPrecision, 4));
                } else {
                    try {
                        this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal(this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue().toString()).setScale(DiffHandleEditUI.this.iCurrencyPrecision, 4));
                    }
                    catch (Exception e1) {
                        this.kdtEntries.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal("0").setScale(DiffHandleEditUI.this.iCurrencyPrecision, 4));
                    }
                }
            }
        }
    }
}

