/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IRPTInterItemData;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTExchItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTInterItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractDynaItemDataImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.MultiInterItemDataFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DynaItemDataImportUI
extends AbstractDynaItemDataImportUI {
    public static final String InterItemData = "INTERITEMDATA";
    public static final String ExchItemData = "EXCHITEMDATA";
    public static final String InvestItemData = "INVESTITEMDATA";
    public static final String MultiInterItemData = "MultiInterItemData";
    public static final String InterAndExchItemData = "INTERANDEXCHITEMDATA";
    private Map reportDatas;
    private String importType;
    private String currencyId;
    private Map params = new HashMap();
    boolean isDelete = false;
    protected OrgTreeInfo treeInfo = null;
    protected Integer year = null;
    protected Integer period = null;
    protected Integer periodType = null;
    protected OrgUnitInfo orgunit = null;
    boolean isOpenOnCompany = false;
    private boolean isCanceled = true;
    protected ICSLContext cslCtx = null;

    protected void initCSLContext() {
        this.cslCtx = CSLContextHelper.getCSLContext();
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCSLContext();
        this.tblMain.checkParsed();
        this.tblMain.setRefresh(false);
        this.loadReport();
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
        int rowCount = this.tblMain.getExpandedRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ICell cell = this.tblMain.getCell(i, "select");
            if (cell == null) continue;
            cell.getStyleAttributes().setLocked(false);
            cell.setValue((Object)Boolean.FALSE);
        }
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Object o;
                ICell cll;
                int n;
                IRow row;
                if (e.getKeyCode() == 32 && (row = DynaItemDataImportUI.this.tblMain.getRow(n = DynaItemDataImportUI.this.tblMain.getSelectManager().getActiveRowIndex())) != null && (cll = row.getCell("select")) != null && (o = cll.getValue()) != null && o instanceof Boolean) {
                    cll.setValue((Object)new Boolean((Boolean)o == false));
                }
            }
        });
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDeselectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.actionOk.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.actionSelectAll.setEnabled(true);
        this.actionDeslectAll.setEnabled(true);
        if (this.isDelete) {
            this.cbxCover.setVisible(false);
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"430_DynaItemDataImportUI"));
        } else {
            this.cbxCover.setSelected(true);
            this.cbxCover.setEnabled(false);
        }
        this.tblMain.getColumn("status").getStyleAttributes().setHided(true);
        CslRptUIUtil.addTableSelectedListener(this.tblMain, "select");
    }

    private void loadReport() throws BOSException, EASBizException {
        String tmp;
        this.currencyId = (String)this.getUIContext().get("KEY_CURRENCY_ID");
        this.importType = (String)this.getUIContext().get("KEY_DynaItemData_TYPE");
        int mergeMode = 100;
        if (this.getUIContext().get("KEY_ISCOMPANY") == null || !((Boolean)this.getUIContext().get("KEY_ISCOMPANY")).booleanValue()) {
            this.isOpenOnCompany = false;
            mergeMode = CslRptUtil.getMergeMode(null, this.getCSLContext().getCurOrgBound().getId().toString()).getValue();
            this.orgunit = this.getCSLContext().getCurOrgGroup();
            this.treeInfo = this.getCSLContext().getCurOrgBound();
            this.params.put("KeyOrgTree", this.getCSLContext().getCurOrgBound());
            this.params.put("KeyOrgUnit", this.getCSLContext().getCurOrgGroup());
            this.params.put("Year", new Integer(this.getCSLContext().getCurRptYear()));
            this.params.put("Period", new Integer(this.getCSLContext().getCurRptPeriod()));
            this.params.put("Day", this.getCSLContext().getCurReportDate());
            this.params.put("PeriodType", new Integer(this.getCSLContext().getCurRptPeriodType().getValue()));
            this.params.put("MERGETYPE", new Integer(mergeMode));
            this.params.put("KEY_CURRENCY_ID", this.currencyId);
        } else if (this.getUIContext().get("KEY_ISCOMPANY") != null && ((Boolean)this.getUIContext().get("KEY_ISCOMPANY")).booleanValue()) {
            this.isOpenOnCompany = true;
            if (this.getUIContext().get("orgTreeId") != null) {
                this.treeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("orgTreeId").toString())));
            }
            this.params.put("KeyOrgTree", this.treeInfo);
            this.orgunit = SysContext.getSysContext().getCurrentOrgUnit();
            this.year = (Integer)this.getUIContext().get("year");
            this.period = (Integer)this.getUIContext().get("period");
            this.periodType = (Integer)this.getUIContext().get("periodType");
            this.params.put("KeyOrgUnit", this.orgunit);
            this.params.put("Year", this.year);
            this.params.put("Period", this.period);
            this.params.put("PeriodType", this.periodType);
            this.params.put("MERGETYPE", new Integer(100));
            this.params.put("KEY_CURRENCY_ID", this.currencyId);
        }
        String dataCollectNumber = null;
        if (this.getCSLContext().getCurDataCollect() != null) {
            dataCollectNumber = this.getCSLContext().getCurDataCollect().getNumber();
        }
        if (dataCollectNumber != null) {
            this.params.put("dataCollectNumber", dataCollectNumber);
        } else {
            this.params.put("dataCollectNumber", "ACTUALDATA");
            dataCollectNumber = "ACTUALDATA";
        }
        Boolean b = (Boolean)this.getUIContext().get("isDelete");
        if (b != null) {
            this.isDelete = b;
        }
        StringBuffer ids = new StringBuffer();
        if (!this.isDelete) {
            this.params.put("ISGETREPORTIDS", new Boolean(true));
            if (this.importType.equals(InterItemData)) {
                this.reportDatas = RPTInterItemDataFactory.getRemoteInstance().getImportData(this.params);
            } else if (this.importType.equals(ExchItemData)) {
                this.reportDatas = RPTExchItemDataFactory.getRemoteInstance().getImportData(this.params);
            } else if (this.importType.equals(MultiInterItemData)) {
                this.reportDatas = MultiInterItemDataFactory.getRemoteInstance().getImportData(this.params);
            } else if (this.importType.equals(InterAndExchItemData)) {
                this.reportDatas = RPTInterItemDataFactory.getRemoteInstance().getImportData(this.params);
                Map reportDatas2 = RPTExchItemDataFactory.getRemoteInstance().getImportData(this.params);
                this.reportDatas.putAll(reportDatas2);
            } else {
                this.reportDatas = InvestItemDataFactory.getRemoteInstance().getImportData(this.params);
            }
            for (String reportId : this.reportDatas.keySet()) {
                ids.append("'").append(reportId).append("',");
            }
        } else {
            this.params.put("isOpenOnCompany", this.isOpenOnCompany);
            IRPTInterItemData iInterItemData = RPTInterItemDataFactory.getRemoteInstance();
            List itemData = this.getItemData(this.importType, iInterItemData, this.params);
            for (int i = 0; i < itemData.size(); ++i) {
                String reportId = (String)itemData.get(i);
                ids.append("'").append(reportId).append("',");
            }
        }
        if (StringUtils.isEmpty((String)(tmp = ids.toString()))) {
            return;
        }
        tmp = tmp.substring(0, tmp.length() - 1);
        CslReportCollection collection = CslReportFactory.getRemoteInstance().getCslReportCollection("select id, template.name,template.number,orgUnit.number,orgUnit.name,sourceCurrency.name, currency.name, periodType, committedStatus where id in (" + tmp + ") and datacollectnumber = '" + dataCollectNumber + "'");
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            CslReportInfo report = (CslReportInfo)iter.next();
            IRow row = this.tblMain.addRow();
            ICell cell = row.getCell("id");
            cell.setValue((Object)report.getId().toString());
            cell = row.getCell("templateName");
            cell.setValue((Object)report.getTemplate().getName());
            cell = row.getCell("templateNumber");
            cell.setValue((Object)report.getTemplate().getNumber());
            cell = row.getCell("companyNumber");
            cell.setValue((Object)report.getOrgUnit().getNumber());
            cell = row.getCell("companyName");
            cell.setValue((Object)report.getOrgUnit().getName());
            cell = row.getCell("sourceCurrency");
            cell.setValue((Object)report.getSourceCurrency().getName());
            cell = row.getCell("currency");
            cell.setValue((Object)report.getCurrency().getName());
            cell = row.getCell("periodType");
            cell.setValue((Object)report.getPeriodType().getAlias());
            cell = row.getCell("status");
            cell.setValue((Object)report.getCommittedStatus().getAlias());
        }
    }

    private List getItemData(String importType, IRPTInterItemData iInterItemData, Map params) throws EASBizException, BOSException {
        HashSet idSet = new HashSet();
        if (importType.equals(InterItemData)) {
            params.put("elimType", ElimTypeEnum.ComeAndGo);
        } else if (importType.equals(ExchItemData)) {
            params.put("elimType", ElimTypeEnum.exchange);
        } else if (importType.equals(MultiInterItemData)) {
            params.put("elimType", ElimTypeEnum.ComeAndGo);
            params.put("isMulti", Boolean.TRUE);
        } else {
            if (importType.equals(InterAndExchItemData)) {
                List li1 = this.getItemData(InterItemData, iInterItemData, params);
                List li2 = this.getItemData(ExchItemData, iInterItemData, params);
                li1 = li1 == null ? new ArrayList() : li1;
                li2 = li2 == null ? new ArrayList() : li2;
                li1.addAll(li2);
                return li1;
            }
            params.put("elimType", ElimTypeEnum.MAIN_INVEST);
        }
        return iInterItemData.getItemDataCollection(params);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        int size = this.tblMain.getRowCount();
        if (this.isDelete) {
            StringBuffer ids = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                Boolean b;
                IRow row = this.tblMain.getRow(i);
                Object value = row.getCell(0).getValue();
                if (!(value instanceof Boolean) || !(b = (Boolean)value).booleanValue()) continue;
                String reportId = (String)row.getCell("id").getValue();
                ids.append("'").append(reportId).append("',");
            }
            String tmp = ids.toString();
            if (StringUtils.isEmpty((String)tmp)) {
                this.destroyWindow();
                return;
            }
            tmp = tmp.substring(0, tmp.length() - 1);
            StringBuffer oql = new StringBuffer(" where report.id in (" + tmp + ")");
            boolean isOnlyImportDynaDataOfCurrentUnit = CSLParamUtil.isOnlyImportDynaDataOfCurrentUnit(null);
            if (isOnlyImportDynaDataOfCurrentUnit) {
                oql.append(" and importedGroup.number ='").append(this.orgunit.getNumber()).append("'");
            }
            if (this.treeInfo != null && this.treeInfo.getId() != null) {
                oql.append(" and orgBound.id='").append(this.treeInfo.getId().toString()).append("'");
            }
            String error = null;
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("elimType", (Object)ElimTypeEnum.ComeAndGo);
            p.put("reportIds", tmp);
            p.put("treeId", this.treeInfo.getId().toString());
            p.put("unitId", this.orgunit.getId().toString());
            p.put("sql", oql.toString());
            p.put("isOnlyImportDynaDataOfCurrentUnit", isOnlyImportDynaDataOfCurrentUnit);
            if (this.importType.equals(InterItemData) || this.importType.equals(ExchItemData)) {
                p.put("elimType", (Object)(this.importType.equals(InterItemData) ? ElimTypeEnum.ComeAndGo : ElimTypeEnum.exchange));
                Map result = RPTInterItemDataFactory.getRemoteInstance().deleteByRptIds(p);
                StringBuffer msg = (StringBuffer)result.get("msg");
                if (msg != null) {
                    error = msg.toString();
                }
            } else if (this.importType.equals(MultiInterItemData)) {
                MultiInterItemDataFactory.getRemoteInstance().delete(oql.toString());
            } else if (this.importType.equals(InterAndExchItemData)) {
                p.put("elimType", (Object)ElimTypeEnum.ComeAndGo);
                IRPTInterItemData iRPTInterItemData = RPTInterItemDataFactory.getRemoteInstance();
                Map result = iRPTInterItemData.deleteByRptIds(p);
                p.put("elimType", (Object)ElimTypeEnum.exchange);
                Map result2 = iRPTInterItemData.deleteByRptIds(p);
                StringBuffer msg = (StringBuffer)result.get("msg");
                StringBuffer msg2 = (StringBuffer)result2.get("msg");
                if (msg != null) {
                    error = msg.toString();
                }
                if (msg2 != null) {
                    error = !StringUtils.isEmpty((String)error) ? error + "\r\n" + msg2.toString() : msg2.toString();
                }
            } else {
                InvestItemDataFactory.getRemoteInstance().delete(oql.toString());
            }
            if (!StringUtils.isEmpty(error)) {
                UIContext ctx = new UIContext((Object)this);
                ctx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"866_DeleteTitle"));
                ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
                SimpleNotePad.showMessageByModel(ctx, error);
            }
            this.isCanceled = false;
        } else {
            String error;
            HashMap importDatas = new HashMap();
            for (int i = 0; i < size; ++i) {
                Boolean b;
                IRow row = this.tblMain.getRow(i);
                Object value = row.getCell(0).getValue();
                if (!(value instanceof Boolean) || !(b = (Boolean)value).booleanValue()) continue;
                String reportId = (String)row.getCell("id").getValue();
                importDatas.put(reportId, this.reportDatas.get(reportId));
            }
            if (importDatas == null || importDatas.size() <= 0) {
                this.destroyWindow();
                return;
            }
            this.params.put("ISGETREPORTIDS", new Boolean(false));
            if (this.importType.equals(InterItemData)) {
                error = RPTInterItemDataFactory.getRemoteInstance().importInterItemData(this.cbxCover.isSelected(), importDatas, this.params);
            } else if (this.importType.equals(ExchItemData)) {
                error = RPTExchItemDataFactory.getRemoteInstance().importExchItemData(this.cbxCover.isSelected(), importDatas, this.params);
            } else if (this.importType.equals(MultiInterItemData)) {
                error = MultiInterItemDataFactory.getRemoteInstance().importInterItemData(this.cbxCover.isSelected(), importDatas, this.params);
            } else if (this.importType.equals(InterAndExchItemData)) {
                error = RPTInterItemDataFactory.getRemoteInstance().importInterItemData(this.cbxCover.isSelected(), importDatas, this.params);
                error = error + RPTExchItemDataFactory.getRemoteInstance().importExchItemData(this.cbxCover.isSelected(), importDatas, this.params);
            } else {
                error = InvestItemDataFactory.getRemoteInstance().importInvestItemData(this.cbxCover.isSelected(), importDatas, this.params);
            }
            if (!StringUtils.isEmpty((String)error)) {
                UIContext ctx = new UIContext((Object)this);
                ctx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"431_DynaItemDataImportUI"));
                ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
                SimpleNotePad.showMessageByModel(ctx, error);
            }
            this.isCanceled = false;
        }
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isCanceled = true;
        this.destroyWindow();
    }

    @Override
    public void actionDeselectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeselectAll_actionPerformed(e);
        CslRptUtil.selectTable(this.tblMain, "select", Boolean.FALSE);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        CslRptUtil.selectTable(this.tblMain, "select", Boolean.TRUE);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        String queryContect = this.queryContent.getText();
        if (!StringUtils.isEmpty((String)queryContect)) {
            int curQueryType = this.queryType.getSelectedIndex();
            int colIndex1 = this.tblMain.getColumnIndex(curQueryType == 0 ? "templateNumber" : "companyNumber");
            int colIndex2 = this.tblMain.getColumnIndex(curQueryType == 0 ? "templateName" : "companyName");
            CslRptUIUtil.tableMainLocate(this.tblMain, queryContect, new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    public void actionDisplay_actionPerformed(ActionEvent e) throws Exception {
        CslRptUIUtil.tableSelectDisplay(this.tblMain, "select", this.btndisplay);
    }
}

