/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ElimDynaUIHelper {
    ElimDynaUIHelper() {
    }

    public static boolean isExistsDyitemElimnByEntrieID(String entryId, String orgTreeId, boolean isQueryBudget) {
        boolean isExistDyitem = false;
        HashMap<String, Object> cslParams = new HashMap<String, Object>();
        cslParams.put("entryId", entryId);
        try {
            cslParams.put("ISQUERYBUDGET", isQueryBudget);
            cslParams.put("KEY_CUR_ORGBOUND_ID", orgTreeId);
            isExistDyitem = ElimDynaItemEntryFactory.getRemoteInstance().isExistsDyitemElimnByEntrieID(cslParams);
        }
        catch (BOSException e) {
            isExistDyitem = false;
        }
        cslParams.clear();
        cslParams = null;
        return isExistDyitem;
    }

    public static List getExistDyItemsEntries(String elimTypes, ICSLContext context, KDTable tblMain, String key) throws Exception {
        HashMap<String, Object> cslContext = new HashMap<String, Object>();
        cslContext.put("KEY_CUR_ORGBOUND_ID", context.getCurOrgBound().getId().toString());
        cslContext.put("KEY_CUR_ORGBOUNDGROUP_ID", context.getCurOrgGroup().getId().toString());
        cslContext.put("Year", new Integer(context.getCurRptYear()));
        cslContext.put("Period", new Integer(context.getCurRptPeriod()));
        cslContext.put("PeriodType", new Integer(context.getCurRptPeriodType().getValue()));
        cslContext.put("ISQUERYBUDGET", context.isQueryBudget());
        cslContext.put("EntriesIds", ElimDynaUIHelper.getEntriesIds(tblMain, key));
        return ElimDynaItemEntryFactory.getRemoteInstance().getExistsDyItemElimns(cslContext, elimTypes, null);
    }

    public static List getExistDyItemsEntriesBySet(String elimTypes, ICSLContext context, Set set) throws Exception {
        HashMap<String, Object> cslContext = new HashMap<String, Object>();
        cslContext.put("KEY_CUR_ORGBOUND_ID", context.getCurOrgBound().getId().toString());
        cslContext.put("KEY_CUR_ORGBOUNDGROUP_ID", context.getCurOrgGroup().getId().toString());
        cslContext.put("Year", new Integer(context.getCurRptYear()));
        cslContext.put("Period", new Integer(context.getCurRptPeriod()));
        cslContext.put("PeriodType", new Integer(context.getCurRptPeriodType().getValue()));
        cslContext.put("ISQUERYBUDGET", context.isQueryBudget());
        cslContext.put("EntriesIds", set);
        return ElimDynaItemEntryFactory.getRemoteInstance().getExistsDyItemElimns(cslContext, elimTypes, null);
    }

    private static Set getEntriesIds(KDTable tblMain, String key) {
        HashSet<String> set = new HashSet<String>();
        if (tblMain != null && tblMain.getRowCount3() > 0) {
            for (int i = 0; i < tblMain.getRowCount3(); ++i) {
                set.add(tblMain.getRow(i).getCell(key).getValue().toString());
            }
        }
        return set;
    }
}

