/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestDataMaintainFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimInvestDataMaintainListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ElimInvestDataMaintainEditUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.util.CslGradeManageUtilClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ElimInvestDataMaintainListUI
extends AbstractElimInvestDataMaintainListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ElimInvestDataMaintainListUI.class);
    private OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();
    private boolean selfGradeOnly = false;

    public ElimInvestDataMaintainListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ElimInvestDataMaintainListUI.this.fillTable(e);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("honor").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("honorSum").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("unsharedProfit").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("surplusFound").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("accumulationFound").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("paidInCapital").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("treasuryShares").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("commonRiskReserve").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("foreignCurrencyTransDiff").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("accumulationFound").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("specialReserve").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("otherRITools").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("otherComplexProceeds").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblMain.getColumn("investEquity").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.actionLocate.setVisible(false);
        String format = CslRptUIUtil.getNationalDateFormatString();
        if (format != null) {
            this.tblMain.getColumn("investDate").getStyleAttributes().setNumberFormat(format);
        }
        this.tblMain.getColumn("otherItem").getStyleAttributes().setNumberFormat("%R-{#,##0.####}f");
        this.tblMain.getColumn("otherItem").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.addSeletedChangedListener();
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    ElimInvestDataMaintainListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    ElimInvestDataMaintainListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("creatorUnit").getValue().toString().equals(this.company.getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.allowModify(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"454_ElimInvestDataMaintainListUI"));
        super.actionEdit_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtilClient.judgeAndPromptSelectedRow((KDTable)this.tblMain, (int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (String)"creatorUnit", (String)this.company.getId().toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"455_ElimInvestDataMaintainListUI"), (String)"noeqCreateOrgRemove");
        super.actionRemove_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElimInvestDataMaintainFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ElimInvestDataMaintainEditUI.class.getName();
    }

    protected void setSortForQuery(SorterItemInfo sortItem, SorterItemInfo oldSortItem) throws Exception {
        if (!this.isRequireSortField(sortItem)) {
            super.setSortForQuery(sortItem, oldSortItem);
        } else {
            this.refresh(null);
        }
    }

    protected boolean isOrderPre() {
        return true;
    }

    protected ArrayList getSelectedIdValues() {
        return CslClientHelper.getSelectedConditionalIdValues(super.getSelectedIdValues(), this.tblMain, "creatorUnit", this.company.getId().toString(), this.getKeyFieldName(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"455_ElimInvestDataMaintainListUI"), true);
    }

    private boolean isRequireSortField(SorterItemInfo sortItem) {
        String field;
        if (sortItem == null) {
            return false;
        }
        if (this.mainQuery.getSorter() != null) {
            this.mainQuery.getSorter().clear();
        }
        if (!StringUtil.isEmptyString((String)(field = sortItem.getPropertyName()))) {
            if (field.indexOf("company.name") != -1) {
                this.mainQuery.getSorter().add(this.getCompanySortItemInfo());
                this.mainQuery.getSorter().add(this.getTargetCompanySortItemInfo());
                this.mainQuery.getSorter().add(this.getInvestDateSortItemInfo());
                return true;
            }
            if (field.indexOf("targetCompany.name") != -1) {
                this.mainQuery.getSorter().add(this.getTargetCompanySortItemInfo());
                this.mainQuery.getSorter().add(this.getCompanySortItemInfo());
                this.mainQuery.getSorter().add(this.getInvestDateSortItemInfo());
                return true;
            }
            return false;
        }
        return false;
    }

    private SorterItemInfo getInvestDateSortItemInfo() {
        SorterItemInfo dateSort = new SorterItemInfo("investdate");
        dateSort.setSortType(SortType.DESCEND);
        return dateSort;
    }

    private SorterItemInfo getCompanySortItemInfo() {
        SorterItemInfo dateSort = new SorterItemInfo("company.number");
        dateSort.setSortType(SortType.ASCEND);
        return dateSort;
    }

    private SorterItemInfo getTargetCompanySortItemInfo() {
        SorterItemInfo dateSort = new SorterItemInfo("targetCompany.number");
        dateSort.setSortType(SortType.ASCEND);
        return dateSort;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit != null && currentFIUnit.getBaseCurrency() != null) {
            try {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currentFIUnit.getBaseCurrency().getId().toString()));
                uiContext.put((Object)"unitCurrency", (Object)currencyInfo);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("creatorUnit").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    private boolean allowModify(String Msg) {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return false;
            }
            Object createUnit = row.getCell("creatorUnit").getValue();
            if (createUnit != null && createUnit.equals(this.company.getId().toString())) {
                return true;
            }
            MsgBox.showInfo((String)Msg);
            SysUtil.abort();
        }
        return false;
    }

    private void mergeTableRowSet() {
        int Ctop = 1;
        int Ttop = 1;
        int Cbottom = 1;
        int Tbottom = 1;
        KDTMergeManager mm = this.tblMain.getMergeManager();
        String previousdCom = "";
        String previousdTarg = "";
        String precreatorUnit = "";
        if (this.tblMain.getRow(1) == null) {
            return;
        }
        previousdCom = this.tblMain.getRow(1).getCell(0).getValue().toString();
        previousdTarg = this.tblMain.getRow(1).getCell(1).getValue().toString();
        precreatorUnit = this.tblMain.getRow(1).getCell("creatorUnit").getValue().toString();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 1; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            String company = (String)row.getCell(0).getValue();
            String targcompany = (String)row.getCell(1).getValue();
            String creatorUnit = this.tblMain.getRow(1).getCell("creatorUnit").getValue().toString();
            ++Cbottom;
            ++Tbottom;
            if (precreatorUnit != null && !creatorUnit.equals(creatorUnit)) {
                previousdCom = company;
                previousdTarg = targcompany;
                precreatorUnit = creatorUnit;
                Ctop = Cbottom;
                Ttop = Tbottom;
                continue;
            }
            if (company.equals(previousdCom)) {
                mm.mergeBlock(Ctop, 0, Cbottom, 0, 4);
            } else {
                previousdCom = company;
                Ctop = Cbottom;
            }
            if (company.equals(previousdCom) && targcompany.equals(previousdTarg)) {
                mm.mergeBlock(Ttop, 1, Tbottom, 1, 4);
                continue;
            }
            previousdTarg = targcompany;
            Ttop = Tbottom;
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return CslRptUtil.getCurrentChckPermOrgPk(action);
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtilClient cslGradeManageUtilClient = new CslGradeManageUtilClient();
        cslGradeManageUtilClient.updateMaintainTowOrgLocal("T_CSL_ElimInvestDataMaintain", "FTrackRecordCreatorID", "FCreatorUnit", super.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }
}

