/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimInvestRateQueryUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.F7QueryNoNumberHelp;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ElimInvestRateQueryUI
extends AbstractElimInvestRateQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ElimInvestRateQueryUI.class);
    private ICSLContext ctx = null;
    private OrgTreeInfo orgBound = null;
    private OrgUnitInfo orgUnit = null;

    public ElimInvestRateQueryUI() throws Exception {
        this.bizPromptBoxCompany = new F7QueryNoNumberHelp("unit.id");
        this.ctx = CSLContextHelper.getCSLContext();
        this.orgBound = this.ctx.getCurOrgBound();
        this.orgUnit = this.ctx.getCurOrgGroup();
        this.bizPromptBoxCompany.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object data = ElimInvestRateQueryUI.this.bizPromptBoxCompany.getData();
                if (data instanceof CompanyOrgUnitInfo) {
                    FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
                    CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)data;
                    orgUnit.setId(companyOrgUnitInfo.getId());
                    orgUnit.setNumber(companyOrgUnitInfo.getNumber());
                    orgUnit.setName(companyOrgUnitInfo.getName());
                    ElimInvestRateQueryUI.this.bizPromptBoxCompany.setData((Object)orgUnit);
                } else if (data instanceof OrgStructureInfo) {
                    ElimInvestRateQueryUI.this.bizPromptBoxCompany.setData((Object)((OrgStructureInfo)data).getUnit());
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPrmtCompany(this.bizPromptBoxCompany);
    }

    private void initPrmtCompany(KDBizPromptBox prompt) throws Exception {
        prompt.setQueryInfo("com.kingdee.eas.basedata.org.app.NewUnionTreeQuery");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        view.getSelector().add(new SelectorItemInfo("unit.number"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        view.setFilter(new FilterInfo());
        FilterItemCollection filterItems = view.getFilter().getFilterItems();
        filterItems.add(new FilterItemInfo("tree.id", (Object)this.ctx.getCurOrgBound().getId().toString()));
        filterItems.add(new FilterItemInfo("longNumber", (Object)(this.ctx.getCurOrgGroup().getLongNumber() + "%"), CompareType.LIKE));
        prompt.setEntityViewInfo(view);
        prompt.getQueryAgent().setSelectorCollection(view.getSelector());
        prompt.setEditFormat("$number$");
        prompt.setCommitFormat("$unit.number$");
        prompt.setDisplayFormat("$name$");
        UnionF7Helper.UnionF7 unionf7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
        unionf7.setTreeID(this.orgBound.getId().toString());
        unionf7.setRootUnitID(this.orgUnit.getId().toString());
        unionf7.setShowAssistantOrg(true);
        unionf7.setCheckedAssistantOrgChkBox(true);
        prompt.setSelector((KDPromptSelector)unionf7);
        prompt.setEditable(true);
    }

    public void clear() {
        super.clear();
        this.bizPromptBoxCompany.setData(null);
        this.datePickerStart.setValue(null);
        this.datePickerEnd.setValue(null);
        this.kdShowZero.setSelected(false);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        OrgUnitInfo company = (OrgUnitInfo)this.bizPromptBoxCompany.getData();
        Date startDate = this.datePickerStart.getSqlDate();
        Date endDate = this.datePickerEnd.getSqlDate();
        int maskCount = 0;
        StringBuffer maskString = new StringBuffer();
        if (company != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("targetCompany.id", (Object)company.getId().toString()));
            if (maskCount == 0) {
                maskString.append("#" + maskCount++);
            } else {
                maskString.append(" AND #" + maskCount++);
            }
        }
        if (startDate != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)startDate, CompareType.GREATER_EQUALS));
            if (maskCount == 0) {
                maskString.append("#" + maskCount++);
            } else {
                maskString.append(" AND #" + maskCount++);
            }
        }
        if (endDate != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)endDate, CompareType.LESS_EQUALS));
            if (maskCount == 0) {
                maskString.append("#" + maskCount++);
            } else {
                maskString.append(" AND #" + maskCount++);
            }
        }
        if (!this.kdShowZero.isSelected()) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("rate", (Object)new Integer(0), CompareType.NOTEQUALS));
            if (maskCount == 0) {
                maskString.append("#" + maskCount++);
            } else {
                maskString.append(" AND #" + maskCount++);
            }
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    public Component getFocusComponent() {
        return this.bizPromptBoxCompany;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        if (entityViewInfo == null || entityViewInfo.getFilter() == null || entityViewInfo.getFilter().getFilterItems().size() == 0) {
            this.kdShowZero.setSelected(true);
            return;
        }
        FilterItemInfo filterItemInfo = null;
        int rateCompareValue = -1;
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        int size = entityViewInfo.getFilter().getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            filterItemInfo = entityViewInfo.getFilter().getFilterItems().get(i);
            if (filterItemInfo.getCompareType().equals((Object)CompareType.GREATER_EQUALS) && filterItemInfo.getPropertyName().equals("date")) {
                startDate = (java.util.Date)filterItemInfo.getCompareValue();
                this.datePickerStart.setValue((Object)startDate);
                continue;
            }
            if (filterItemInfo.getCompareType().equals((Object)CompareType.LESS_EQUALS) && filterItemInfo.getPropertyName().equals("date")) {
                endDate = (java.util.Date)filterItemInfo.getCompareValue();
                this.datePickerEnd.setValue((Object)endDate);
                continue;
            }
            if (filterItemInfo.getPropertyName().equals("targetCompany.id")) {
                String targetCompanyId = (String)filterItemInfo.getCompareValue();
                if (targetCompanyId == null) continue;
                try {
                    FullOrgUnitInfo targetCompany = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(targetCompanyId));
                    this.bizPromptBoxCompany.setData((Object)targetCompany);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (!filterItemInfo.getPropertyName().equals("rate")) continue;
            rateCompareValue = (Integer)filterItemInfo.getCompareValue();
        }
        if (startDate == null) {
            this.datePickerStart.setValue(null);
        }
        if (endDate == null) {
            this.datePickerEnd.setValue(null);
        }
        this.kdShowZero.setSelected(rateCompareValue != 0);
    }

    public boolean verify() {
        Date startDate = this.datePickerStart.getSqlDate();
        Date endDate = this.datePickerEnd.getSqlDate();
        if (startDate != null && endDate != null && startDate.compareTo(endDate) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Date_Need_AfterStart"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

