/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRate;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimInvestRateStructureUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ElimInvestRateStructureUI
extends AbstractElimInvestRateStructureUI {
    private static final Logger logger = CoreUIObject.getLogger(ElimInvestRateStructureUI.class);
    private IElimInvestRate iElimInvestRate = null;
    private ICSLContext ctx = null;
    private static final int COMPANY = 1;
    private static final int TARGET_COMPANY = 2;
    private int currentPane;
    private int mergeType = 0;
    private boolean isIncludeChild = false;

    public ElimInvestRateStructureUI() throws Exception {
        this.init();
        this.iElimInvestRate = ElimInvestRateFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        Map thsiCtx = this.getUIContext();
        ListUI curObj = (ListUI)thsiCtx.get("Owner");
        Map uiContext = curObj.getUIContext();
        if (uiContext != null) {
            this.ctx = uiContext.containsKey("ctx") ? (ICSLContext)uiContext.get("ctx") : CSLContextHelper.getCSLContext();
            if (uiContext.containsKey("mergeType")) {
                this.mergeType = (Integer)uiContext.get("mergeType");
            }
            if (uiContext.containsKey("isIncludeChild")) {
                this.isIncludeChild = (Boolean)uiContext.get("isIncludeChild");
            }
        }
        super.onLoad();
        this.initTree();
    }

    private void init() throws Exception {
        this.tblShareholder.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                ElimInvestRateStructureUI.this.tblShareholder_doRequestRowSet(e);
            }
        });
        this.tblShareholder.putBindContents("mainQuery", new String[]{"id", "targetCompany.name", "rate", "description"});
        this.tblInvest.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                ElimInvestRateStructureUI.this.tblInvest_doRequestRowSet(e);
            }
        });
        this.tblInvest.putBindContents("mainQuery1", new String[]{"id", "company.name", "rate", "description"});
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected void initTree() throws Exception {
        DefaultTreeModel model = CslOrgTreeUtil.getCompanyF7TreeModel();
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)model.getRoot();
        DefaultTreeModel defultModel = new DefaultTreeModel((TreeNode)rootNode);
        this.treeOrg.setModel((TreeModel)defultModel);
        this.treeOrg.setSelectionNode(rootNode);
        this.treeOrg.expandAllNodes(true, (TreeNode)rootNode);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void execQuery() {
        this.tblShareholder.repaint();
        this.tblShareholder.removeRows();
        this.tblInvest.repaint();
        this.tblInvest.removeRows();
    }

    private Map getFilter() throws BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Date rptDate = this.ctx.getCurReportDate();
        param.put("rptDate", rptDate);
        String orgBoundId = this.ctx.getCurOrgBound().getId().toString();
        param.put("orgBoundId", orgBoundId);
        String orgUnitId = this.ctx.getCurOrgGroup().getId().toString();
        param.put("orgUnitId", orgUnitId);
        param.put("mergeType", this.mergeType);
        param.put("isIncludeChild", this.isIncludeChild);
        param.put("rptPeriodType", this.ctx.getCurRptPeriodType());
        param.put("rptYear", new Integer(this.ctx.getCurRptYear()));
        param.put("rptPeriod", new Integer(this.ctx.getCurRptPeriod()));
        DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.treeOrg.getLastSelectedPathComponent();
        if (currentNode == null) {
            return null;
        }
        Object company = currentNode.getUserObject();
        if (company == null || !(company instanceof OrgStructureInfo)) {
            return null;
        }
        param.put("companyId", ((OrgStructureInfo)company).getUnit().getId().toString());
        Object date = this.dpkEffectDate.getValue();
        if (date == null) {
            return null;
        }
        param.put("effectDate", this.dpkEffectDate.getSqlDate());
        return param;
    }

    @Override
    protected void tblShareholder_doRequestRowSet(RequestRowSetEvent e) {
        IRowSet rs = null;
        try {
            Map param = this.getFilter();
            if (null == param) {
                return;
            }
            rs = this.iElimInvestRate.getShareholderList(param);
        }
        catch (Exception e1) {
            super.handUIException((Throwable)e1);
        }
        e.setRowSet(rs);
        this.onGetRowSet(rs);
    }

    @Override
    protected void tblInvest_doRequestRowSet(RequestRowSetEvent e) {
        IRowSet rs = null;
        try {
            Map param = this.getFilter();
            if (null == param) {
                return;
            }
            rs = this.iElimInvestRate.getInvestCompanyList(param);
        }
        catch (Exception e1) {
            super.handUIException((Throwable)e1);
        }
        e.setRowSet(rs);
        this.onGetRowSet(rs);
    }

    @Override
    protected void kDTabbedPane1_stateChanged(ChangeEvent e) throws Exception {
        if (((KDTabbedPane)e.getSource()).getSelectedIndex() == 0) {
            this.setCurrentPane(1);
        } else {
            this.setCurrentPane(2);
        }
    }

    private void setCurrentPane(int currentPane) {
        this.currentPane = currentPane;
    }

    private int getCurrentPane() {
        return this.currentPane;
    }

    @Override
    protected void dpkEffectDate_dataChanged(DataChangeEvent e) throws Exception {
        this.execQuery();
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void treeOrg_valueChanged(TreeSelectionEvent e) throws Exception {
        this.execQuery();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
        this.execQuery();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.getCurrentPane() == 1) {
            this.preparePrintPage(this.tblShareholder);
            this.tblShareholder.getPrintManager().print();
        } else if (this.getCurrentPane() == 2) {
            this.preparePrintPage(this.tblInvest);
            this.tblInvest.getPrintManager().print();
        }
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        if (this.getCurrentPane() == 1) {
            this.tblShareholder.getPrintManager().printPreview();
        } else if (this.getCurrentPane() == 2) {
            this.tblInvest.getPrintManager().printPreview();
        }
    }
}

