/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationEntryCheckFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplateSelectF7Dialog;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Dimension;
import org.apache.log4j.Logger;

public class EliminationEntryCheckFilterUI
extends AbstractEliminationEntryCheckFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EliminationEntryCheckFilterUI.class);
    private boolean hasLoadInitData;
    CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private ICSLContext ctx = null;
    private ICurrency iCurrency = null;
    private String selectAll = null;

    public EliminationEntryCheckFilterUI() throws Exception {
        this.init();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
        this.pp.setString("orgBoundId", this.ctx.getCurOrgBound().getId().toString());
        this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
        this.pp.setInt("year", this.ctx.getCurRptYear());
        this.pp.setInt("period", this.ctx.getCurRptPeriod());
        this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
        this.pp.setString("rptDate", this.ctx.getCurReportDate().toLocaleString());
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.pp.setString("currencyId", currency.getId().toString());
        if (this.bizPrmtTemplate.getData() != null) {
            this.pp.setString("templateId", this.bizPrmtTemplate.getData().toString());
        }
    }

    private void fillDataToUI() throws EASBizException, BOSException {
        String currencyid = this.company.getBaseCurrency().getId().toString();
        if (this.pp.containsKey("currencyId")) {
            for (int j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(currencyid)) continue;
                this.comboCurrency.setSelectedIndex(j);
                break;
            }
        }
        TemplateSelectF7Dialog templateSelectF7Dialog = new TemplateSelectF7Dialog((IUIObject)this);
        this.bizPrmtTemplate.setSelector((KDPromptSelector)templateSelectF7Dialog);
        this.bizPrmtTemplate.setVisible(true);
        this.bizPrmtTemplate.setEditable(false);
        this.bizPrmtTemplate.setEnabled(true);
    }

    @Override
    public RptProperties getCustomCondition() {
        try {
            this.loadInitData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        this.bizPrmtTemplate.setValue((Object)ac.getString("templateId"));
        try {
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    @Override
    public CustomerParams getCustomerParams() {
        if (this.pp != null && this.pp.containsKey("tableName")) {
            this.pp.remove("tableName");
        }
        if (this.comboCurrency.getSelectedItem() != null) {
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            this.pp.setString("currencyId", currency.getId().toString());
        }
        if (this.bizPrmtTemplate.getData() != null) {
            this.pp.setString("tempalteid", this.bizPrmtTemplate.getData().toString());
        }
        return super.getCustomerParams();
    }

    @Override
    public Object getParam() {
        RptProperties condition = this.getCustomCondition();
        if (condition != null && condition.containsKey("tableName")) {
            condition.remove("tableName");
        }
        return condition;
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }

    public void clear() {
        String currencyid = this.company.getBaseCurrency().getId().toString();
        CurrencyInfo currencyInfo2 = null;
        try {
            currencyInfo2 = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
            this.comboCurrency.setSelectedItem((Object)currencyInfo2.getName());
            this.bizPrmtTemplate.setValue(null);
            this.pp.setString("currencyId", currencyInfo2.getId().toString());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void init() {
        this.ctx = CSLContextHelper.getCSLContext();
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.comboCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.bizPrmtTemplate.setQueryInfo(InvestTempletInfo.class.getName());
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        try {
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)this.ctx.getCurOrgBound().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem1 = new FilterItemInfo("orgUnit.id", (Object)this.ctx.getCurOrgGroup().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem2 = new FilterItemInfo("periodType", (Object)new Integer(this.ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("year", (Object)new Integer(this.ctx.getCurRptYear()), CompareType.EQUALS);
            FilterItemInfo filterItem4 = new FilterItemInfo("period", (Object)new Integer(this.ctx.getCurRptPeriod()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem3);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem4);
            sbFormula.append(" and #" + formulaIndex++);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (this.comboCurrency.getSelectedItem() != null && !this.comboCurrency.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        boolean isTargetCompanyMuti = false;
        block2: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                String currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.comboCurrency.setSelectedIndex(j);
                    continue block2;
                }
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("InvestTemplet.id")) continue;
            if (isTargetCompanyMuti) {
                this.bizPrmtTemplate.setData(null);
                continue;
            }
            String investTempletID = (String)filterItemInfo.getCompareValue();
            try {
                InvestTempletInfo investTempInfo = InvestTempletFactory.getRemoteInstance().getInvestTempletInfo((IObjectPK)new ObjectUuidPK(investTempletID));
                this.bizPrmtTemplate.setData((Object)investTempInfo);
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

