/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationItemSumFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class EliminationItemSumFilterUI
extends AbstractEliminationItemSumFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EliminationItemSumFilterUI.class);
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency;
    private IDataElement iDataElement;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    public void onLoad() throws Exception {
        this.initCSLContext();
        super.onLoad();
        this.init();
    }

    protected void init() throws Exception {
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.initCbxCurrency();
        this.initCbxElimType();
        this.initCbxDataElem();
    }

    private void initCbxCurrency() throws Exception {
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtRptItem, null);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        SorterItemInfo sortItem = new SorterItemInfo("number");
        sortItem.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortItem);
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.cbxCurrency.removeAllItems();
        String curFiCompanyBaseCurrency = null;
        CompanyOrgUnitInfo fiCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (fiCompany != null && fiCompany.getBaseCurrency() != null) {
            curFiCompanyBaseCurrency = fiCompany.getBaseCurrency().getId().toString();
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cbxCurrency.addItem((Object)currencyCollection.get(i));
                if (curFiCompanyBaseCurrency == null || !curFiCompanyBaseCurrency.equals(currencyCollection.get(i).getId().toString())) continue;
                this.cbxCurrency.setSelectedItem((Object)currencyCollection.get(i));
            }
        }
    }

    private void initCbxElimType() {
        this.cbxElimType.removeAllItems();
        this.cbxElimType.addItem((Object)this.selectAll);
        this.cbxElimType.addItem((Object)ValueTypeEnum.MONEY);
        this.cbxElimType.addItem((Object)ValueTypeEnum.QUANTITY);
        this.cbxElimType.setSelectedItem((Object)this.selectAll);
    }

    private void initCbxDataElem() {
        this.cbxDataElem.removeAllItems();
        this.cbxDataElem.addItem((Object)this.selectAll);
        CslClientHelper.initDataElementCombox(this.cbxDataElem, false, false, false);
        this.cbxDataElem.setSelectedItem((Object)this.selectAll);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.loadInitData();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void loadInitData() throws BOSException {
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
        this.pp.setString("rptOrgBoundId", this.getCSLContext().getCurOrgBound().getId().toString());
        this.pp.setString("rptOrgUnitId", this.getCSLContext().getCurOrgGroup().getId().toString());
        this.pp.setInt("elimYear", this.getCSLContext().getCurRptYear());
        this.pp.setInt("elimPeriod", this.getCSLContext().getCurRptPeriod());
        this.pp.setInt("periodType", this.getCSLContext().getCurRptPeriodType().getValue());
    }

    @Override
    public RptProperties getCustomCondition() {
        try {
            this.loadInitData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pp.remove("rptCurrencyId");
        this.pp.remove("itemElimValueType");
        this.pp.remove("itemDataElem");
        this.pp.remove("rptItemNumber");
        if (this.cbxCurrency.getSelectedItem() != null && this.cbxCurrency.getSelectedItem() != this.selectAll) {
            this.pp.setString("rptCurrencyId", ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString());
        }
        if (this.cbxElimType.getSelectedItem() != null && this.cbxElimType.getSelectedItem() != this.selectAll) {
            this.pp.setInt("itemElimValueType", ((ValueTypeEnum)((Object)this.cbxElimType.getSelectedItem())).getValue());
        }
        if (this.cbxDataElem.getSelectedItem() != null && this.cbxDataElem.getSelectedItem() != this.selectAll) {
            this.pp.setInt("itemDataElem", ((DataElementInfo)this.cbxDataElem.getSelectedItem()).getInterSeq());
        }
        if (this.bizPrmtRptItem.getValue() != null && this.bizPrmtRptItem.getValue() instanceof RPTItemInfo) {
            this.pp.setString("rptItemNumber", ((RPTItemInfo)this.bizPrmtRptItem.getValue()).getNumber());
        }
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        this.initCtrl(this.pp);
    }

    private void initCtrl(RptProperties pp) {
        Object currencyInfo;
        int j;
        if (pp.containsKey("rptCurrencyId")) {
            String currencyId = pp.getString("rptCurrencyId");
            for (j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                this.cbxCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (pp.containsKey("itemElimValueType")) {
            int elimValueType = Integer.parseInt(pp.getObject("itemElimValueType").toString());
            for (j = 1; j < this.cbxElimType.getItemCount(); ++j) {
                currencyInfo = (ValueTypeEnum)((Object)this.cbxElimType.getItemAt(j));
                if (currencyInfo.getValue() != elimValueType) continue;
                this.cbxElimType.setSelectedIndex(j);
                break;
            }
        }
        if (pp.containsKey("itemDataElem")) {
            int itemDataElem = Integer.parseInt(pp.getObject("itemDataElem").toString());
            for (j = 1; j < this.cbxDataElem.getItemCount(); ++j) {
                currencyInfo = (DataElementInfo)this.cbxDataElem.getItemAt(j);
                if (currencyInfo.getInterSeq() != itemDataElem) continue;
                this.cbxDataElem.setSelectedIndex(j);
                break;
            }
        }
        if (pp.containsKey("rptItemNumber")) {
            RPTItemInfo itemInfo = new RPTItemInfo();
            itemInfo.setNumber(pp.getString("rptItemNumber"));
            this.bizPrmtRptItem.setValue((Object)itemInfo);
        }
    }

    @Override
    public CustomerParams getCustomerParams() {
        return super.getCustomerParams();
    }

    @Override
    public Object getParam() {
        RptProperties condition = this.getCustomCondition();
        return condition;
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = null;
        if (filter == null) {
            filter = new FilterInfo();
        }
        Iterator it = this.pp.keySet().iterator();
        filter.getFilterItems().clear();
        while (it.hasNext()) {
            String key = (String)it.next();
            filter.getFilterItems().add(new FilterItemInfo(key, this.pp.getObject(key)));
        }
        return filter;
    }

    private void clearUI() {
        CurrencyInfo curFiCompanyBaseCurrency = null;
        CompanyOrgUnitInfo fiCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (fiCompany != null && fiCompany.getBaseCurrency() != null) {
            curFiCompanyBaseCurrency = fiCompany.getBaseCurrency();
        }
        if (curFiCompanyBaseCurrency != null) {
            this.cbxCurrency.setSelectedItem((Object)curFiCompanyBaseCurrency);
        } else {
            this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        }
        this.cbxDataElem.setSelectedItem((Object)this.selectAll);
        this.cbxElimType.setSelectedItem((Object)this.selectAll);
        this.bizPrmtRptItem.setData(null);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.clearUI();
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block5: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemElimValueType")) {
                this.cbxElimType.setSelectedItem((Object)ValueTypeEnum.getEnum(Integer.parseInt(filterItemInfo.getCompareValue().toString())));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemDataElem")) {
                try {
                    if (this.iDataElement == null) {
                        this.iDataElement = DataElementFactory.getRemoteInstance();
                    }
                    this.cbxDataElem.setSelectedItem((Object)this.iDataElement.getDataElementByInterSeq(Integer.parseInt(filterItemInfo.getCompareValue().toString())));
                }
                catch (EASBizException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)e);
                }
                catch (BOSException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("rptCurrencyId")) {
                String currencyId = filterItemInfo.getCompareValue().toString();
                for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block5;
                }
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("rptItemNumber")) continue;
            String itemNumber = filterItemInfo.getCompareValue().toString();
            try {
                RPTItemInfo rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo("select number, name where number = '" + itemNumber + "'");
                this.bizPrmtRptItem.setData((Object)rptItemInfo);
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

