/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSumFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationItemSumListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseConditionUI;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationItemSumFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.apache.log4j.Logger;

public class EliminationItemSumListUI
extends AbstractEliminationItemSumListUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(EliminationItemSumListUI.class);
    private static final int COMMAND_ORDER_FIRST = 1;
    private static final int COMMAND_ORDER_PRE = 2;
    private static final int COMMAND_ORDER_NEXT = 3;
    private static final int COMMAND_ORDER_LAST = 4;
    protected CslBaseConditionUI queryPanel = null;
    private int currencyIndex;
    private Map currencyId2Index = new HashMap();
    private ArrayList currencyInfoList = new ArrayList();
    private static String selectAll = null;
    private IDataElement iDataElement;
    protected Map dataElemColls = new HashMap(0);
    private Set currentElimEntryRange = new HashSet();
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    protected void initDataElemColls() throws BOSException {
        if (this.iDataElement == null) {
            this.iDataElement = DataElementFactory.getRemoteInstance();
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("isUsedElim", (Object)Boolean.TRUE));
        DataElementCollection dataElemColls = this.iDataElement.getDataElementCollection(view);
        DataElementInfo dataElemInfo = null;
        for (int i = 0; i < dataElemColls.size(); ++i) {
            dataElemInfo = dataElemColls.get(i);
            this.dataElemColls.put(new Integer(dataElemInfo.getInterSeq()), dataElemInfo);
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.initCSLContext();
        this.initTblMain();
        selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        this.actionQuery.setEnabled(true);
        this.actionRefresh.setEnabled(true);
        this.setQueryMetaDataPK(this.mainQueryPK);
        Map uiContext = this.getUIContext();
        if (uiContext.containsKey("rptCurrencyId")) {
            String currencyId = (String)uiContext.get("rptCurrencyId");
            if (this.pp == null) {
                this.pp = new RptProperties();
            }
            if (!StringUtils.isEmpty((String)currencyId)) {
                this.pp.setString("rptCurrencyId", currencyId);
            }
        }
        if (uiContext.containsKey("currentElimEntryRange")) {
            this.currentElimEntryRange = (Set)uiContext.get("currentElimEntryRange");
        }
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        super.onLoad();
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
    }

    private void initTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                IRow row = null;
                Object dataElem = null;
                Object elimType = null;
                BigDecimal itemCreditValue = null;
                BigDecimal itemDebitValue = null;
                try {
                    for (int j = 0; j < EliminationItemSumListUI.this.tblMain.getRowCount(); ++j) {
                        row = EliminationItemSumListUI.this.tblMain.getRow(j);
                        dataElem = row.getCell("itemDataElem").getValue();
                        elimType = row.getCell("itemElimValueType").getValue();
                        if (dataElem != null && dataElem instanceof Integer) {
                            if (EliminationItemSumListUI.this.dataElemColls.isEmpty()) {
                                EliminationItemSumListUI.this.initDataElemColls();
                            }
                            if (EliminationItemSumListUI.this.dataElemColls.containsKey(dataElem)) {
                                row.getCell("itemDataElem").setValue((Object)((DataElementInfo)EliminationItemSumListUI.this.dataElemColls.get(dataElem)).getName());
                            }
                        }
                        if (elimType != null && elimType instanceof Integer) {
                            row.getCell("itemElimValueType").setValue((Object)ValueTypeEnum.getEnum((Integer)elimType).getAlias());
                        }
                        itemDebitValue = (BigDecimal)row.getCell("itemDebit").getValue();
                        itemCreditValue = (BigDecimal)row.getCell("itemCredit").getValue();
                        if (itemDebitValue == null || itemDebitValue.compareTo(BigDecimal.valueOf(0L)) == 0) {
                            row.getCell("itemDebit").setValue(null);
                        }
                        if (itemCreditValue != null && itemCreditValue.compareTo(BigDecimal.valueOf(0L)) != 0) continue;
                        row.getCell("itemCredit").setValue(null);
                    }
                }
                catch (BOSException e1) {
                    EliminationItemSumListUI.this.handUIException(e1);
                }
            }
        });
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.enableExportExcel(this.tblMain);
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    @Override
    protected KDTable getPrintTable() {
        return this.tblMain;
    }

    @Override
    protected Variant getPrintVariant(String varName) {
        return null;
    }

    @Override
    public CslBaseConditionUI getQueryDialogUserPanel() {
        if (this.queryPanel == null) {
            try {
                this.queryPanel = new EliminationItemSumFilterUI();
                this.queryPanel.getUIContext().put("cslCtx", this.getCSLContext());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.queryPanel;
    }

    @Override
    public void query(Object condition) throws Exception {
        this.pp = (RptProperties)condition;
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
        super.doLayout();
        this.tblMain.removeRows();
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                this.mainQuery = this.parseQuery(new EntityViewInfo(), this.pp.toMap());
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    private void wrapRowSetData(IRowSet rowSet) throws BOSException {
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    private EntityViewInfo parseQuery(EntityViewInfo mainQuery, Map params) throws BOSException {
        if (mainQuery == null) {
            mainQuery = new EntityViewInfo();
        }
        if (mainQuery.getFilter() == null) {
            mainQuery.setFilter(new FilterInfo());
        }
        if (params == null || params.isEmpty()) {
            return mainQuery;
        }
        FilterInfo queryFilter = mainQuery.getFilter();
        Map.Entry whereExprEntry2 = null;
        for (Map.Entry whereExprEntry2 : params.entrySet()) {
            queryFilter.appendFilterItem((String)whereExprEntry2.getKey(), whereExprEntry2.getValue());
        }
        if (!this.currentElimEntryRange.isEmpty()) {
            queryFilter.getFilterItems().add(new FilterItemInfo("elimEntryId", (Object)this.currentElimEntryRange, CompareType.INCLUDE));
        }
        return mainQuery;
    }

    @Override
    public Object afterQueryConditionChange(Object condition) throws Exception {
        this.pp = (RptProperties)super.afterQueryConditionChange(condition);
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
        this.checkCurrencyList();
        String currencyId = this.pp.getString("rptCurrencyId");
        Integer currencyIndexInt = (Integer)this.currencyId2Index.get(currencyId);
        this.currencyIndex = -1;
        if (currencyId != null && currencyIndexInt != null) {
            this.currencyIndex = currencyIndexInt;
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else {
            this.currencyIndex = 0;
            this.pp.setString("rptCurrencyId", ((CurrencyInfo)this.currencyInfoList.get(this.currencyIndex)).getId().toString());
            this.setOrderBntStatus(this.currencyIndex);
        }
        if (this.currencyIndex != -1) {
            this.txtCurrency.setText(((CurrencyInfo)this.currencyInfoList.get(this.currencyIndex)).getName());
        }
        return this.pp;
    }

    private void checkCurrencyList() throws BOSException, EASBizException {
        if (this.currencyInfoList.isEmpty()) {
            CurrencyCollection currencies = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
            String currencyId = null;
            for (int i = 0; i < currencies.size(); ++i) {
                currencyId = currencies.get(i).getId().toString();
                this.currencyInfoList.add(currencies.get(i));
                this.currencyId2Index.put(currencyId, new Integer(i));
            }
        }
    }

    private void setOrderBntStatus(int currencyIndexPara) {
        boolean firstEnable = true;
        boolean lastEnable = true;
        if (currencyIndexPara <= 0) {
            firstEnable = false;
        }
        if (currencyIndexPara >= this.currencyInfoList.size() - 1 || currencyIndexPara == -1) {
            lastEnable = false;
        }
        this.btnFirst.setEnabled(firstEnable);
        this.btnPre.setEnabled(firstEnable);
        this.btnNext.setEnabled(lastEnable);
        this.btnLast.setEnabled(lastEnable);
    }

    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    @Override
    public IRptBase getInitRemoteInstance() throws BOSException {
        return InterCheckSumFactory.getRemoteInstance();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.isFromCslMerge) {
            CSLContextHelper.update(o, this);
        }
    }

    public boolean destroyWindow() {
        if (!this.isFromCslMerge) {
            CSLContextHelper.unRegistUIObject(this);
        }
        return super.destroyWindow();
    }

    @Override
    protected void btnFirst_actionPerformed(ActionEvent e) throws Exception {
        super.btnFirst_actionPerformed(e);
        this.queryByOrder(1);
    }

    @Override
    protected void btnLast_actionPerformed(ActionEvent e) throws Exception {
        super.btnLast_actionPerformed(e);
        this.queryByOrder(4);
    }

    @Override
    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        super.btnNext_actionPerformed(e);
        this.queryByOrder(3);
    }

    @Override
    protected void btnPre_actionPerformed(ActionEvent e) throws Exception {
        super.btnPre_actionPerformed(e);
        this.queryByOrder(2);
    }

    private void queryByOrder(int command) throws BOSException, EASBizException, Exception {
        this.checkCurrencyList();
        if (command == 1) {
            this.currencyIndex = 0;
        } else if (command == 2) {
            --this.currencyIndex;
            if (this.currencyIndex < 0 || this.currencyIndex > this.currencyInfoList.size() - 1) {
                this.currencyIndex = 0;
            }
        } else if (command == 3) {
            ++this.currencyIndex;
            if (this.currencyIndex > this.currencyInfoList.size() - 1 || this.currencyIndex < 0) {
                this.currencyIndex = this.currencyInfoList.size() - 1;
            }
        } else if (command == 4) {
            this.currencyIndex = this.currencyInfoList.size() - 1;
        } else {
            return;
        }
        if (this.currencyIndex != -1) {
            this.txtCurrency.setText(((CurrencyInfo)this.currencyInfoList.get(this.currencyIndex)).getName());
        }
        this.setOrderBntStatus(this.currencyIndex);
        this.pp.setString("rptCurrencyId", ((CurrencyInfo)this.currencyInfoList.get(this.currencyIndex)).getId().toString());
        this.query(this.pp);
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

