/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationModeListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationModeEditUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.util.CslGradeManageUtilClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EliminationModeListUI
extends AbstractEliminationModeListUI {
    private OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();
    private static final Logger logger = CoreUIObject.getLogger(EliminationModeListUI.class);
    private boolean selfGradeOnly = false;

    public EliminationModeListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                EliminationModeListUI.this.fillTable(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionQuery.setVisible(false);
        this.addSeletedChangedListener();
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    EliminationModeListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    EliminationModeListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("trackRecordCreatorid").getValue().toString().equals(this.company.getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EliminationModeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return EliminationModeEditUI.class.getName();
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.allowModify(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"454_ElimInvestDataMaintainListUI"));
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtilClient.judgeAndPromptSelectedRow((KDTable)this.tblMain, (int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (String)"trackRecordCreatorid", (String)this.company.getId().toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"455_ElimInvestDataMaintainListUI"), (String)"noeqCreateOrgRemove");
        super.actionRemove_actionPerformed(e);
    }

    private boolean allowModify(String Msg) {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return false;
            }
            Object createUnit = row.getCell("trackRecordCreatorid").getValue();
            if (createUnit != null && createUnit.equals(this.company.getId().toString())) {
                return true;
            }
            MsgBox.showInfo((String)Msg);
            SysUtil.abort();
        }
        return false;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return CslRptUtil.getCurrentChckPermOrgPk(action);
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_EliminationMode", (String)"FTrackRecordCreatorID", (ArrayList)this.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }
}

