/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.HisEliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IHisElimination;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItemDataService;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationSumDataLinkViewUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class EliminationSumDataLinkViewUI
extends AbstractEliminationSumDataLinkViewUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(EliminationSumDataLinkViewUI.class);
    List lstItemElimData = null;
    int iCurrencyPrecision;
    Map mapElimDataAndCol = null;
    private int isQueryBudget = 0;
    CurrencyInfo info = null;

    public void onLoad() throws Exception {
        if (this.getUIContext().get("cslCtx") != null) {
            this.isQueryBudget = (Integer)this.getUIContext().get("ISQUERYBUDGET");
            super.onLoad();
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.isQueryBudget = (Integer)this.getUIContext().get("ISQUERYBUDGET");
            super.onLoad();
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.lstItemElimData = (List)this.getUIContext().get("KEY_ELIM_DATA");
        this.iCurrencyPrecision = Integer.parseInt((String)this.getUIContext().get("KEY_CURRENCY_PRECISION"));
        if (this.iCurrencyPrecision == 0) {
            this.iCurrencyPrecision = 2;
        }
        this.kdtMain.checkParsed();
        this.initCurrencyInfo();
        ArrayList<String> list = new ArrayList<String>();
        list.add("elimDebitSum");
        list.add("elimCreditSum");
        this.initThousandPos(list);
        this.actionRefresh_actionPerformed(null);
        this.kdtMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    try {
                        EliminationSumDataLinkViewUI.this.actionLinkViewData_actionPerformed(null);
                    }
                    catch (Exception exc) {
                        EliminationSumDataLinkViewUI.this.handUIException(exc);
                    }
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int j;
        super.actionRefresh_actionPerformed(e);
        ArrayList params = new ArrayList(1);
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>(8);
        params.add(paramMap);
        paramMap.put("lstItemElimData", this.lstItemElimData);
        paramMap.put("mnsRptParamInfo", (List<Object>)this.getUIContext().get("mnsRptParamInfo"));
        paramMap.put("isSupportCrossMerger", (List<Object>)this.getUIContext().get("isSupportCrossMerger"));
        paramMap.put("DataElement", (List<Object>)this.getUIContext().get("DataElement"));
        paramMap.put("KEY_ORGTREE_INFO", (List<Object>)this.getUIContext().get("KEY_ORGTREE_INFO"));
        IRPTItemDataService rptItemDataService = RPTItemDataServiceFactory.getRemoteInstance();
        Map returnMap = rptItemDataService.getElimDataEntryByItem(params, (String)this.getUIContext().get("OrgTreeID"), (String)this.getUIContext().get("OrgUnitID"), (String)this.getUIContext().get("KEY_CURRENCY_ID"), ((RptPeriodTypeEnum)this.getUIContext().get("PeriodType")).getValue(), Integer.parseInt((String)this.getUIContext().get("Year")), Integer.parseInt((String)this.getUIContext().get("Period")), (String)this.getUIContext().get("KEY_DATACOLLECT_NUMBER"), this.isQueryBudget == 1);
        Map mapResult = (Map)returnMap.get("mapResult");
        Map map4ElimData = (Map)returnMap.get("map4ElimData");
        this.kdtMain.removeRows();
        if (this.kdtMain.getColumnCount() > 6) {
            j = 6;
            for (i = this.kdtMain.getColumnCount(); i >= j; --i) {
                this.kdtMain.removeColumn(i);
            }
        }
        this.mapElimDataAndCol = null;
        if (mapResult != null) {
            j = this.lstItemElimData.size();
            for (i = 0; i < j; ++i) {
                BigDecimal bgValue;
                Map mapData = (Map)this.lstItemElimData.get(i);
                String strItemNumber = (String)mapData.get("KEY_ITEM_NUMBER");
                String strItemName = (String)mapData.get("KEY_ITEM_NAME");
                String dataElementNumber = (String)mapData.get("DataElement");
                int valueType = (Integer)mapData.get("ValueType");
                IRow row = this.kdtMain.addRow();
                row.getCell("itemNumber").setValue((Object)strItemNumber);
                row.getCell("itemName").setValue((Object)strItemName);
                row.getCell("dataElement").setValue((Object)DataElementProvider.getDataElementName(dataElementNumber));
                row.getCell("valueType").setValue((Object)ValueTypeEnum.getEnum(valueType).getAlias());
                Map mapValue = (Map)mapData.get("KEY_ELIM_VALUE");
                if (mapValue.containsKey("KEY_ELIM_DEBIT")) {
                    bgValue = (BigDecimal)mapValue.get("KEY_ELIM_DEBIT");
                    BigDecimal elimDebitSum = bgValue.setScale(this.iCurrencyPrecision, 4);
                    row.getCell("elimDebitSum").setValue((Object)CslRptUIUtil.groupBigDecimal(elimDebitSum));
                }
                if (mapValue.containsKey("KEY_ELIM_CREDIT")) {
                    bgValue = (BigDecimal)mapValue.get("KEY_ELIM_CREDIT");
                    row.getCell("elimCreditSum").setValue((Object)CslRptUIUtil.groupBigDecimal(bgValue.setScale(this.iCurrencyPrecision, 4)));
                }
                if (mapValue.containsKey("KEY_ELIM_DATA") && map4ElimData != null) {
                    String keyCredit;
                    String keyDebit = strItemNumber + "$" + dataElementNumber + "$" + valueType + "$DebitSum";
                    if (map4ElimData.containsKey(keyDebit)) {
                        BigDecimal bgDebitSum = (BigDecimal)map4ElimData.get(keyDebit);
                        row.getCell("elimDebitSum").setValue((Object)bgDebitSum.setScale(this.iCurrencyPrecision, 4));
                    }
                    if (map4ElimData.containsKey(keyCredit = strItemNumber + "$" + dataElementNumber + "$" + valueType + "$CreditSum")) {
                        BigDecimal bgCreditSum = (BigDecimal)map4ElimData.get(keyCredit);
                        row.getCell("elimCreditSum").setValue((Object)bgCreditSum.setScale(this.iCurrencyPrecision, 4));
                    }
                }
                this.putElimEntryData(row, mapResult, strItemNumber, dataElementNumber, valueType);
            }
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPreview_actionPerformed(e);
        this.preparePrintPage(this.kdtMain);
        this.kdtMain.getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.kdtMain);
        this.kdtMain.getPrintManager().print();
    }

    private void initCurrencyInfo() throws BOSException {
        String currencyId;
        String string = currencyId = this.getUIContext().get("KEY_CURRENCY_ID") == null ? null : (String)this.getUIContext().get("KEY_CURRENCY_ID");
        if (currencyId == null) {
            return;
        }
        CurrencyCollection col = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select precision where id='" + currencyId + "'");
        if (col != null && col.size() > 0) {
            this.info = col.get(0);
        }
    }

    private void initThousandPos(ArrayList tblNameList) throws BOSException {
        if (this.info == null || tblNameList == null || tblNameList.size() == 0) {
            return;
        }
        String numberFmt = FMClientHelper.getNumberFtm((int)this.info.getPrecision());
        for (int i = 0; i < tblNameList.size(); ++i) {
            String colName = tblNameList.get(i).toString();
            if (this.kdtMain.getColumn(colName) == null) continue;
            this.kdtMain.getColumn(colName).getStyleAttributes().setNumberFormat(numberFmt);
        }
    }

    private void initThousandPos(Integer colIndex) throws BOSException {
        if (this.info == null || colIndex == null) {
            return;
        }
        String numberFmt = FMClientHelper.getNumberFtm((int)this.info.getPrecision());
        if (this.kdtMain.getColumn(colIndex.intValue()) != null) {
            this.kdtMain.getColumn(colIndex.intValue()).getStyleAttributes().setNumberFormat(numberFmt);
        }
    }

    private void putElimEntryData(IRow row, Map mapData, String itemNumber, String dataElementNumber, int valueType) throws BOSException {
        if (this.mapElimDataAndCol == null) {
            this.mapElimDataAndCol = new HashMap();
        }
        if (mapData.containsKey(itemNumber)) {
            Map mapDataElement = (Map)mapData.get(itemNumber);
            Map mapValueType = (Map)mapDataElement.get(String.valueOf(DataElementProvider.getDataElementInnerValue(dataElementNumber)));
            if (mapValueType == null) {
                return;
            }
            Map mapValue = (Map)mapValueType.get(String.valueOf(valueType));
            if (mapValue == null) {
                return;
            }
            for (String elimNumber : mapValue.keySet()) {
                if (!this.mapElimDataAndCol.containsKey(elimNumber)) {
                    IColumn col = this.kdtMain.addColumn();
                    col.setWidth(120);
                    col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    col.getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
                    this.mapElimDataAndCol.put(elimNumber, String.valueOf(col.getColumnIndex()));
                    this.kdtMain.getHeadRow(0).getCell(col.getColumnIndex()).setValue((Object)elimNumber);
                    if (col.getColumnIndex() >= 0) {
                        this.initThousandPos(new Integer(col.getColumnIndex()));
                    }
                }
                int iColIndex = Integer.parseInt((String)this.mapElimDataAndCol.get(elimNumber));
                BigDecimal bgValue = (BigDecimal)mapValue.get(elimNumber);
                row.getCell(iColIndex).setValue((Object)bgValue.setScale(this.iCurrencyPrecision, 4));
            }
        }
    }

    @Override
    public void actionLinkViewData_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkViewData_actionPerformed(e);
        int iColIndex = this.kdtMain.getSelectManager().getActiveColumnIndex();
        if (this.mapElimDataAndCol == null) {
            return;
        }
        int beginColIndex = this.kdtMain.getColumnCount() - this.mapElimDataAndCol.size();
        if (iColIndex < beginColIndex) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Select_ElimDataColumn_ForLinkView"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        String strID = this.getSelectedKeyValue(iColIndex);
        if (StringUtils.isEmpty((String)strID)) {
            return;
        }
        uiContext.put((Object)"ID", (Object)strID);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(this.isQueryBudget));
        if (this.getUIContext().get("KEY_LINKOPENRPT_PARAM") != null) {
            uiContext.put((Object)"KEY_LINKOPENRPT_PARAM", this.getUIContext().get("KEY_LINKOPENRPT_PARAM"));
        }
        uiContext.put((Object)"cslCtx", this.getUIContext().get("cslCtx"));
        uiContext.put((Object)"KEY_LINKOPENCSLREPORT_PARAM", (Object)new Boolean(true));
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.EliminationHandEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private String getElimNumber(String strElimNumber) throws Exception {
        if (strElimNumber.indexOf(")") < 0) {
            return strElimNumber;
        }
        StringBuffer sb = new StringBuffer(strElimNumber);
        int count = 0;
        boolean isHasAdded = false;
        for (int i = sb.length() - 1; i >= 0; --i) {
            char curChar = sb.charAt(i);
            if (curChar == ')') {
                isHasAdded = true;
                ++count;
                continue;
            }
            if (curChar != '(' || !isHasAdded || --count != 0) continue;
            return sb.substring(0, i);
        }
        return strElimNumber;
    }

    private String getSelectedKeyValue(int iColIndex) throws Exception {
        String strElimNumber = (String)this.kdtMain.getHead().getRow(0).getCell(iColIndex).getValue();
        strElimNumber = this.getElimNumber(strElimNumber);
        IElimination elim = EliminationFactory.getRemoteInstance();
        IHisElimination hisElim = HisEliminationFactory.getRemoteInstance();
        if (StringUtils.isEmpty((String)strElimNumber)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Elim_Number_IsEmpty"));
            return null;
        }
        StringBuffer strSql = new StringBuffer();
        strSql.append("where number = '" + strElimNumber + "'").append(" and orgBound = '").append((String)this.getUIContext().get("OrgTreeID")).append("'").append(" and orgUnit = '").append((String)this.getUIContext().get("OrgUnitID")).append("'").append(" and currency.id = '").append((String)this.getUIContext().get("KEY_CURRENCY_ID")).append("'").append(" and periodType = ").append(((RptPeriodTypeEnum)this.getUIContext().get("PeriodType")).getValue()).append(" and year = ").append(Integer.parseInt((String)this.getUIContext().get("Year"))).append(" and period = ").append(Integer.parseInt((String)this.getUIContext().get("Period"))).append(" and checkedStatus = ").append(2);
        BillBaseInfo info = null;
        info = this.isQueryBudget == 1 ? hisElim.getHisEliminationInfo(strSql.toString()) : elim.getEliminationInfo(strSql.toString());
        if (info == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Not_Found_ElimData"));
            return null;
        }
        return info.getId().toString();
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }
}

