/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.HisEliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.HisEliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.InvestDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationViewSumUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class EliminationViewSumUI
extends AbstractEliminationViewSumUI {
    private static final Logger logger = Logger.getLogger(EliminationViewSumUI.class);
    private static final int TB_ITEM_NUMBER = 0;
    private static final int TB_ITEM_NAME = 1;
    private static final int TB_DATAELEMENT = 2;
    private static final int TB_DEBIT = 3;
    private static final int TB_CREDIT = 4;
    private int isQueryBudget = 0;

    public EliminationViewSumUI() throws Exception {
        this.initHeadData();
    }

    private void initHeadData() throws Exception {
        this.comboPeriodType.setEditable(false);
        this.comboPeriodType.setSelectedItem((Object)CSLContextHelper.getCSLContext().getCurRptPeriodType());
        this.dateBizDate.setEditable(false);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        currencyCollection = iCurrency.getCurrencyCollection(viewInfo, true);
        if (currencyCollection != null && currencyCollection.size() > 0) {
            int size = currencyCollection.size();
            for (int i = 0; i < size; ++i) {
                this.comboCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("ISQUERYBUDGET") != null) {
            this.isQueryBudget = (Integer)this.getUIContext().get("ISQUERYBUDGET");
        }
        super.onLoad();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.hideUnuseableButtons();
            this.bindDataToTable(this.idList.getCurrentID());
        }
        if (this.isQueryBudget == 1) {
            this.setButtonsStatus();
        }
        this.menuBiz.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.comboPeriodType.setEditable(false);
        this.comboPeriodType.disable();
        this.comboCurrency.setEditable(false);
        this.comboCurrency.disable();
        this.comboValueType.setEditable(false);
        this.comboValueType.disable();
        this.comboValueType.removeItemAt(2);
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.menuTable1.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.isQueryBudget == 1) {
            block13: {
                try {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.idList.getCurrentID()));
                    HisEliminationInfo editData = (HisEliminationInfo)this.getBizInterface().getValue((IObjectPK)pk, this.getSelectors());
                    if (editData == null) {
                        return;
                    }
                    this.dateBizDate.setValue((Object)editData.getDate());
                    this.txtNumber.setText(editData.getNumber());
                    this.txtCompany.setText(editData.getOrgUnit().getName());
                    this.dateCreateTime.setValue((Object)editData.getCreateTime());
                    this.comboValueType.setSelectedItem((Object)editData.getValueType());
                    this.actionFirst.setEnabled(true);
                    if (editData.getCurrency() == null) break block13;
                    int itemCount = this.comboCurrency.getItemCount();
                    for (int i = 0; i < itemCount; ++i) {
                        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getItemAt(i);
                        if (!editData.getCurrency().getId().equals((Object)currency.getId())) continue;
                        this.comboCurrency.setSelectedIndex(i);
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"getValue_Exception", (Throwable)e);
                }
            }
            if (this.idList.isBegin()) {
                this.actionFirst.setEnabled(false);
                this.actionPre.setEnabled(false);
            } else {
                this.actionFirst.setEnabled(true);
                this.actionPre.setEnabled(true);
            }
            if (this.idList.isEnd()) {
                this.actionNext.setEnabled(false);
                this.actionLast.setEnabled(false);
            } else {
                this.actionNext.setEnabled(true);
                this.actionLast.setEnabled(true);
            }
        } else {
            if (this.editData == null) {
                return;
            }
            if (this.editData.getCurrency() != null) {
                int itemCount = this.comboCurrency.getItemCount();
                for (int i = 0; i < itemCount; ++i) {
                    CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getItemAt(i);
                    if (!this.editData.getCurrency().getId().equals((Object)currency.getId())) continue;
                    this.comboCurrency.setSelectedIndex(i);
                    break;
                }
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.isQueryBudget == 1) {
            return HisEliminationFactory.getRemoteInstance();
        }
        return EliminationFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (this.isQueryBudget == 0) {
            super.setDataObject(dataObject);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        String id = this.idList.getCurrentID();
        this.bindDataToTable(id);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        String id = this.idList.getCurrentID();
        this.bindDataToTable(id);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        String id = this.idList.getCurrentID();
        this.bindDataToTable(id);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        String id = this.idList.getCurrentID();
        this.bindDataToTable(id);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
    }

    private void bindDataToTable(String eliminationID) throws Exception {
        this.kdtEntries.removeRows();
        IInvestDataProvider iInvestDataProvider = InvestDataProviderFactory.getRemoteInstance();
        List list = iInvestDataProvider.getEliminationSumByCompany(eliminationID, this.isQueryBudget);
        if (list != null) {
            HashMap map = null;
            int rowCount = list.size();
            this.kdtEntries.addRows(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                map = (HashMap)list.get(i);
                IRow row = this.kdtEntries.getRow(i);
                row.getCell(0).setValue(map.get("number"));
                row.getCell(1).setValue(map.get("name"));
                row.getCell(2).setValue((Object)DataElementProvider.getDataElementInfo((Integer)map.get("dataelement")).getName());
                if (((BigDecimal)map.get("debit")).signum() != 0) {
                    row.getCell(3).setValue(map.get("debit"));
                }
                if (((BigDecimal)map.get("credit")).signum() == 0) continue;
                row.getCell(4).setValue(map.get("credit"));
            }
            this.setPrecision();
        }
    }

    private void setPrecision() {
        if (this.kdtEntries != null) {
            CurrencyInfo ci = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            StyleAttributes attrDebit = this.kdtEntries.getColumn(3).getStyleAttributes();
            attrDebit.setNumberFormat(CslRptUIUtil.getFmtStr(ci));
            attrDebit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            StyleAttributes attrCredit = this.kdtEntries.getColumn(4).getStyleAttributes();
            attrCredit.setNumberFormat(CslRptUIUtil.getFmtStr(ci));
            attrCredit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private void hideUnuseableButtons() {
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.btnCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.btnCopyFrom.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.menuItemCreateFrom.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.btnAddNew.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.btnEdit.setEnabled(false);
        this.menuItemEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.btnAddLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.menuItemAddLine.setVisible(false);
        this.menuItemInsertLine.setVisible(false);
        this.menuItemRemoveLine.setVisible(false);
        this.actionAddLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuItemViewDoProccess.setVisible(false);
        this.actionViewDoProccess.setEnabled(false);
        this.menuItemViewSubmitProccess.setVisible(false);
        this.actionViewSubmitProccess.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.menuItemRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.menuItemSubmit.setVisible(false);
        this.actionSubmit.setEnabled(false);
    }

    private void setButtonsStatus() {
        this.menuWorkflow.setVisible(false);
        this.menuTool.setVisible(false);
        this.menuTable1.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSubmit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.comboPeriodType.setEnabled(false);
        this.dateBizDate.setEnabled(false);
        this.txtNumber.setEnabled(false);
        this.dateCreateTime.setEnabled(false);
        this.comboCurrency.setEnabled(false);
        this.comboValueType.setEnabled(false);
        this.actionNextPerson.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.kdtEntries.setEnabled(false);
    }
}

