/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.bi.client.ItemContentProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.CheckageResponPartyEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalYearPeriodDateTmp;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.InterDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractExchCheckageFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class ExchCheckageFilterUI
extends AbstractExchCheckageFilterUI {
    private static final Logger logger = Logger.getLogger(ExchCheckageFilterUI.class);
    private boolean hasLoadInitData;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private IElimTemplet iElimTemplet = null;
    private CurrencyInfo bsCurrency = null;
    private int bsCurrency2;
    private FiscalYearPeriodDateTmp fiscalRefCtrl;
    List orgList = new ArrayList();
    private Map itemDataFilterUIInfo = null;
    private CurrencyCollection currencyCollection = null;
    protected OrgViewType orgViewType = OrgViewType.COMPANY;
    private static final String BLANK = "";
    private static final String EQUAL = "=";
    private static final String LESS_THAN = "<";
    private static final String MORE_THAN = ">";
    private static final String NOT_EQUAL = "<>";

    public ExchCheckageFilterUI() throws Exception {
    }

    public ExchCheckageFilterUI(OrgViewType orgViewType) throws Exception {
        this.orgViewType = orgViewType;
    }

    public void initComponent() throws Exception {
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.cmbCurrency.addItem((Object)this.selectAll);
        if (this.currencyCollection == null) {
            this.currencyCollection = (CurrencyCollection)this.getItemDataFilterUIInfo(null, false).get("currencyCollection");
        }
        if (this.currencyCollection != null && this.currencyCollection.size() > 0) {
            this.cmbCurrency.addItems(this.currencyCollection.toArray());
        }
        CompanyOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.bsCurrency = orgUnitInfo.getBaseCurrency();
        for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
            CurrencyInfo info;
            if (!(this.cmbCurrency.getItemAt(i) instanceof CurrencyInfo) || !(info = (CurrencyInfo)this.cmbCurrency.getItemAt(i)).getId().toString().equals(this.bsCurrency.getId().toString())) continue;
            this.bsCurrency = new CurrencyInfo();
            this.bsCurrency.setId(info.getId());
            this.bsCurrency.setNumber(info.getNumber());
            this.bsCurrency.setName(info.getName());
            this.cmbCurrency.setSelectedIndex(i);
            this.bsCurrency2 = i;
            break;
        }
        this.cmbCurrency.setSelectedItem((Object)this.bsCurrency);
        this.refreshOrgTree(true);
        if (this.iElimTemplet == null) {
            this.iElimTemplet = ElimTempletFactory.getRemoteInstance();
        }
        this.updateCmbTemplateByOrgBound();
        this.cmbConfirmStatus.addItem((Object)this.selectAll);
        this.cmbConfirmStatus.addItem((Object)CheckageConfirmEnum.Audit);
        this.cmbConfirmStatus.addItem((Object)CheckageConfirmEnum.Confirm);
        this.cmbConfirmStatus.addItem((Object)CheckageConfirmEnum.UnConfirm);
        this.cmbCheckedParty.addItems(CheckageResponPartyEnum.getEnumList().toArray());
        Iterator itor = RptPeriodTypeEnum.iterator();
        RptPeriodTypeEnum curItem = null;
        while (itor.hasNext()) {
            curItem = (RptPeriodTypeEnum)itor.next();
            this.cmbSourceType.addItem((Object)curItem);
        }
        this.cmbSourceType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        int[] defaultYearOrMonth = this.getCurrYearOrPeriod();
        this.spinYear.setValue((Object)new Integer(defaultYearOrMonth[0]));
        this.spinPeriod.setValue((Object)new Integer(defaultYearOrMonth[1]));
        this.spinYear.setEditable(true);
        this.spinPeriod.setEditable(true);
        this.cmbSourceType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExchCheckageFilterUI.this.refreshTimeInfo(ExchCheckageFilterUI.this.dpkDate.getSqlDate());
                ExchCheckageFilterUI.this.refresh13Period();
            }
        });
        this.dpkDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e != null && e.getNewValue() instanceof Date) {
                    ExchCheckageFilterUI.this.refreshTimeInfo((Date)e.getNewValue());
                    ExchCheckageFilterUI.this.refreshOrgTree(false);
                    ExchCheckageFilterUI.this.refresh13Period();
                }
            }
        });
        this.cmbOrgTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExchCheckageFilterUI.this.refreshCompany();
                try {
                    ExchCheckageFilterUI.this.updateCmbTemplateByOrgBound();
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                }
            }
        });
        try {
            boolean isMergeFiscalPeriod;
            this.initTimeCtrlValAndStatusByBaseOrgBound(true);
            boolean bl = isMergeFiscalPeriod = this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod();
            if (isMergeFiscalPeriod && this.pp != null && this.pp.containsKey("year") && this.pp.containsKey("period")) {
                this.spinYear.setValue((Object)new Integer(this.pp.getInt("year")));
                this.spinPeriod.setValue((Object)new Integer(this.pp.getInt("period")));
            } else if (!isMergeFiscalPeriod && this.pp != null) {
                this.dpkDate.setValue((Object)CslRptUIUtil.getRptDateFromProp(this.pp));
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)BLANK, (Throwable)e1);
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            logger.error((Object)BLANK, (Throwable)e1);
            this.handUIException(e1);
        }
        this.bizCompany.setRequired(false);
        Object[] compareArr = new String[]{BLANK, EQUAL, LESS_THAN, MORE_THAN, NOT_EQUAL};
        this.cbCompare.addItems(compareArr);
        this.cbCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExchCheckageFilterUI.BLANK.equals(ExchCheckageFilterUI.this.cbCompare.getSelectedItem().toString())) {
                    ExchCheckageFilterUI.this.txtValue.setValue(null);
                    ExchCheckageFilterUI.this.txtValue.setEnabled(false);
                } else {
                    ExchCheckageFilterUI.this.txtValue.setEnabled(true);
                }
            }
        });
        this.cbCompare.setSelectedItem((Object)BLANK);
        this.initRptItemF7();
    }

    private void initRptItemF7() throws UIException {
        this.rptItemF7.setEditable(false);
        this.rptItemF7.setSelectAllOnFocus(false);
        this.getUIContext().put("ItemGroup", RPTItemGroupEnum.TRADE);
        this.rptItemF7.setSelector((KDPromptSelector)new SortableChooser(new ItemContentProvider(){

            @Override
            public List getSelected() {
                return (List)ExchCheckageFilterUI.this.rptItemF7.getData();
            }
        }, new ItemLabelProvider(), (IUIObject)this));
    }

    private Map getItemDataFilterUIInfo(Date rptDate, boolean reQuery) {
        String key;
        if (this.itemDataFilterUIInfo == null) {
            this.itemDataFilterUIInfo = new HashMap();
        }
        if (rptDate == null) {
            Date date = new Date(System.currentTimeMillis());
            rptDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
        }
        if (!this.itemDataFilterUIInfo.containsKey(key = RPTDateUtil.getSimpleDateFormat(rptDate))) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("rptDate", rptDate);
            paramMap.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            paramMap.put("orgViewType", this.orgViewType);
            try {
                Map returnMap = InterDataProviderFactory.getRemoteInstance().getItemDataFilterInfo(paramMap);
                this.itemDataFilterUIInfo.put(key, returnMap);
                this.currencyCollection = (CurrencyCollection)returnMap.get("currencyCollection");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return (Map)this.itemDataFilterUIInfo.get(key);
    }

    private void updateCmbTemplateByOrgBound() throws BOSException {
        this.cmbTemplate.removeAllItems();
        this.cmbTemplate.addItem((Object)this.selectAll);
        ElimTempletCollection elimTempletCollection = null;
        if (this.cmbOrgTree.getSelectedIndex() != -1) {
            elimTempletCollection = this.getElimTempletForOrgBound(((OrgTreeInfo)this.cmbOrgTree.getSelectedItem()).getId().toString());
        }
        if (elimTempletCollection != null && elimTempletCollection.size() > 0) {
            this.cmbTemplate.addItems(elimTempletCollection.toArray());
        }
    }

    private ElimTempletCollection getElimTempletForOrgBound(String orgBoundId) throws BOSException {
        ElimTempletCollection elimTempletCollection = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select dispenseSrcID where sourceType=").append(2);
        sql.append(" and orgBound = '").append(orgBoundId).append("' ");
        TempletDispenseCollection disCol = TempletDispenseFactory.getRemoteInstance().getTempletDispenseCollection(sql.toString());
        if (disCol != null && disCol.size() > 0) {
            sql = new StringBuffer();
            sql.append("select * where elimGroup in (");
            for (int i = 0; i < disCol.size(); ++i) {
                sql.append("'").append(disCol.get(i).getDispenseSrcID().toString()).append("'").append(",");
            }
            sql.deleteCharAt(sql.length() - 1).append(")");
            sql.append(" and CheckedStatus = ").append(2);
            sql.append(" and elimType=").append(3);
            elimTempletCollection = ElimTempletFactory.getRemoteInstance().getElimTempletCollection(sql.toString());
        }
        return elimTempletCollection;
    }

    private void initTimeCtrlValAndStatusByBaseOrgBound(boolean isAddListener) throws BOSException, EASBizException {
        RptPeriodTypeEnum periodType;
        OrgTreeInfo choosedOrgTreeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
        if (choosedOrgTreeInfo == null) {
            return;
        }
        int[] currYearOrPeriod = this.getCurrYearOrPeriod();
        if (this.fiscalRefCtrl == null) {
            this.fiscalRefCtrl = new FiscalYearPeriodDateTmp(choosedOrgTreeInfo, this.cmbSourceType, this.dpkDate, this.spinYear, this.spinPeriod);
            this.fiscalRefCtrl.setComboOrgBound(this.cmbOrgTree, true, null);
        }
        if ((periodType = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem()) == null) {
            periodType = RptPeriodTypeEnum.MONTHLY;
            this.cmbSourceType.setSelectedItem((Object)periodType);
        }
        this.fiscalRefCtrl.initTimeCtrlValAndStatus(periodType, choosedOrgTreeInfo, currYearOrPeriod[0], currYearOrPeriod[1], (CoreUIObject)this, isAddListener, null);
    }

    private int[] getCurrYearOrPeriod() {
        Calendar ca = Calendar.getInstance();
        return new int[]{ca.get(1), ca.get(2) + 1};
    }

    private void refreshOrgTree(boolean isSelectBaseOrgTree) {
        int index = this.initCmbOrgTree(isSelectBaseOrgTree, null);
        this.refreshCompany();
        if (this.cmbOrgTree != null && this.cmbOrgTree.getSelectedIndex() != -1) {
            this.cmbOrgTree.setSelectedIndex(index);
        }
    }

    private int initCmbOrgTree(boolean isSelectBaseOrgTree, Date rptDate) {
        int index = 0;
        try {
            OrgTreeCollection collection;
            OrgTreeInfo prevSelectOrgTree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            if (rptDate == null) {
                rptDate = (Date)this.dpkDate.getValue();
            }
            if ((collection = (OrgTreeCollection)this.getItemDataFilterUIInfo(rptDate, false).get("orgTreeCollection")) == null) {
                return 0;
            }
            DefaultComboBoxModel<OrgTreeInfo> model = new DefaultComboBoxModel<OrgTreeInfo>();
            this.orgList.clear();
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                String seq = String.valueOf(i);
                OrgTreeInfo orgTreeInfo = collection.get(i);
                this.orgList.add(orgTreeInfo.getId().toString());
                this.orgList.add(seq);
                if (!isSelectBaseOrgTree && prevSelectOrgTree != null && orgTreeInfo.getNumber() != null && orgTreeInfo.getNumber().equals(prevSelectOrgTree.getNumber())) {
                    index = i;
                } else if (isSelectBaseOrgTree && this.getBasicTree(orgTreeInfo.getId().toString()) != null && this.getBasicTree(orgTreeInfo.getId().toString()).equalsIgnoreCase("true")) {
                    index = i;
                }
                model.addElement(orgTreeInfo);
            }
            this.cmbOrgTree.setModel(model);
        }
        catch (Exception e) {
            logger.error((Object)"getOrgTreeInfo_BOSException", (Throwable)e);
        }
        return index;
    }

    private String getBasicTree(String Fid) {
        OrgTreeInfo orgTree = null;
        String basic = null;
        if (orgTree == null) {
            try {
                orgTree = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo("select * where id ='" + Fid + "'");
                basic = orgTree.get("basic").toString();
            }
            catch (EASBizException e) {
                logger.error((Object)"getBasicTree_EASBizException", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"getBasicTree_BOSException", (Throwable)e);
            }
        }
        return basic;
    }

    private OrgTreeCollection sortOrgTree(OrgTreeCollection collection) {
        try {
            int n = collection.size();
            String[] ids = new String[n];
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < n; ++i) {
                ids[i] = collection.get(i).getId().toString();
                set.add(collection.get(i).getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("IsForBudget"));
            view.getSelector().add(new SelectorItemInfo("name"));
            SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
            sorterItemInfo.setSortType(SortType.ASCEND);
            view.getSorter().add(sorterItemInfo);
            view.setFilter(filter);
            collection = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"getOrgTreeCollection_BOSException", (Throwable)e);
        }
        return collection;
    }

    private void refreshCompany() {
        this.bizCompany.setValue(null);
        if (this.cmbOrgTree.getSelectedItem() != null) {
            this.bizCompany.setEnabled(true);
            OrgTreeInfo treeInfo = null;
            treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
            f7.setTreeID(treeInfo.getId().toString());
            f7.setNeedAddOrgRange(false);
            f7.setCtrlUnitPK(treeInfo.getCU());
            f7.setMultiSelect(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.bizCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            try {
                this.bizCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
            }
            catch (Exception e) {
                logger.error((Object)BLANK, (Throwable)e);
            }
            this.bizCompany.setSelector((KDPromptSelector)f7);
            this.bizCompany.setEditable(true);
        } else {
            this.bizCompany.setEnabled(false);
        }
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod()) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.spinYear.setValue((Object)new Integer(times.get(0).toString()));
        this.spinPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.dpkDate.setValue(times.get(2), false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.initComponent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.onMyLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
            OrgTreeInfo treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
            String requestId = orgUnitInfo.getId().toString();
            if (treeInfo != null && treeInfo.getId() != null) {
                this.pp.setString("treeId", treeInfo.getId().toString());
            }
            this.pp.setString("orgUnitId", requestId);
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.dpkDate.setValue((Object)preDate);
            String sDate = CslRptUIUtil.getNationalDateFormat().format((Date)this.dpkDate.getValue());
            Calendar ca = Calendar.getInstance();
            int year = ca.get(1);
            int month = ca.get(2) + 1 - 1;
            if (month == 0) {
                month = 12;
                --year;
                if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period()) {
                    month = 13;
                }
            }
            this.spinYear.setValue((Object)new Integer(year));
            this.spinPeriod.setValue((Object)new Integer(month));
            this.pp.setInt("year", year);
            this.pp.setInt("period", month);
            this.pp.setInt("periodType", 3);
            if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString())) {
                this.pp.setString("compare", this.cbCompare.getSelectedItem().toString());
                this.pp.setString("value", this.txtValue.getNumberValue().toString());
            }
        }
    }

    private void fillDataToUI() {
        boolean isMergeFiscalPeriod;
        String fromCurrencyId;
        this.clearUI();
        if (this.pp != null) {
            int periodType = 3;
            try {
                periodType = this.pp.getInt("periodType");
                this.cmbSourceType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)periodType));
            }
            catch (NullPointerException e) {
                this.cmbSourceType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
            }
        }
        if (this.pp.containsKey("fromCurrency") && (fromCurrencyId = this.pp.getString("fromCurrency")) != null) {
            for (int j = 1; j < this.cmbCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(fromCurrencyId)) continue;
                this.cmbCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("treeId") && this.pp.getObject("treeId") != null) {
            String treeId = (String)this.pp.getObject("treeId");
            if (this.orgList != null && this.orgList.size() > 0) {
                int i;
                boolean orgBoundBeSet = false;
                for (i = 0; i < this.orgList.size(); ++i) {
                    if (i % 2 != 0 || !this.orgList.get(i).toString().equals(treeId)) continue;
                    this.cmbOrgTree.setSelectedIndex(Integer.valueOf(this.orgList.get(i + 1).toString()).intValue());
                    orgBoundBeSet = true;
                }
                if (!orgBoundBeSet) {
                    this.initCmbOrgTree(false, CslRptUIUtil.getRptDateFromProp(this.pp));
                    for (i = 0; i < this.orgList.size(); ++i) {
                        if (i % 2 != 0 || !this.orgList.get(i).toString().equals(treeId)) continue;
                        this.cmbOrgTree.setSelectedIndex(Integer.valueOf(this.orgList.get(i + 1).toString()).intValue());
                    }
                }
            }
        }
        try {
            this.initTimeCtrlValAndStatusByBaseOrgBound(false);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        boolean bl = isMergeFiscalPeriod = this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod();
        if (isMergeFiscalPeriod && this.pp.containsKey("year") && this.pp.containsKey("period")) {
            this.spinYear.setValue((Object)new Integer(this.pp.getInt("year")));
            this.spinPeriod.setValue((Object)new Integer(this.pp.getInt("period")));
        } else if (!isMergeFiscalPeriod) {
            this.dpkDate.setValue((Object)CslRptUIUtil.getRptDateFromProp(this.pp));
            if (this.pp != null && this.pp.containsKey("period") && this.pp.getInt("period") == 13 && this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period() && this.pp.getInt("periodType") == 3) {
                this.spinPeriod.setValue((Object)new Integer(this.pp.getInt("period")));
            }
            if (this.pp.containsKey("treeId") && this.pp.getObject("treeId") != null) {
                String treeId = (String)this.pp.getObject("treeId");
                if (this.orgList != null && this.orgList.size() > 0) {
                    for (int i = 0; i < this.orgList.size(); ++i) {
                        if (i % 2 != 0 || !this.orgList.get(i).toString().equals(treeId)) continue;
                        this.cmbOrgTree.setSelectedIndex(Integer.valueOf(this.orgList.get(i + 1).toString()).intValue());
                    }
                }
            }
        }
        this.refreshCompany();
        if (this.pp.containsKey("templet")) {
            String templetId = this.pp.getString("templet");
            for (int k = 1; k < this.cmbTemplate.getItemCount(); ++k) {
                ElimTempletInfo templetInfo = (ElimTempletInfo)this.cmbTemplate.getItemAt(k);
                if (!templetInfo.getId().toString().equals(templetId)) continue;
                this.cmbTemplate.setSelectedIndex(k);
                break;
            }
        }
        if (this.pp.containsKey("targetCompany") && this.pp.getObject("targetCompany") != null) {
            String companyId = (String)this.pp.getObject("targetCompany");
            try {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.bizCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.pp.containsKey("confirmStatus")) {
            int status = this.pp.getInt("confirmStatus");
            this.cmbConfirmStatus.setSelectedItem((Object)CheckageConfirmEnum.getEnum(status));
        }
        if (this.pp.containsKey("compare")) {
            String compare = this.pp.getString("compare");
            for (int k = 1; k < this.cbCompare.getItemCount(); ++k) {
                String item = (String)this.cbCompare.getItemAt(k);
                if (!compare.equals(item)) continue;
                this.cbCompare.setSelectedIndex(k);
                break;
            }
        }
        if (this.pp.containsKey("value")) {
            BigDecimal newValue = new BigDecimal(this.pp.getString("value"));
            this.txtValue.setNumberValue((Number)newValue);
        }
        if (this.pp.containsKey("checkedParty")) {
            this.cmbCheckedParty.setSelectedItem((Object)CheckageResponPartyEnum.getEnum(this.pp.getInt("checkedParty")));
        }
        if (this.pp.containsKey("Items")) {
            String p = this.pp.getString("Items");
            try {
                this.rptItemF7.setData((Object)RptBiUtil.getRptItemCollection(Arrays.asList(p.split(","))));
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public RptProperties getCustomCondition() {
        OrgTreeInfo treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        String companyId = orgUnitInfo.getId().toString();
        String targetCompanyid = null;
        if (this.bizCompany.getValue() != null && !(this.bizCompany.getValue() instanceof String)) {
            targetCompanyid = ((OrgUnitInfo)this.bizCompany.getValue()).getId().toString();
        } else if (this.bizCompany.getValue() != null && this.bizCompany.getValue() instanceof String) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"340_CopyHisDataFilterUI"));
            SysUtil.abort();
        }
        if (treeInfo != null && treeInfo.getId() != null) {
            this.pp.setString("treeId", treeInfo.getId().toString());
        } else {
            this.pp.setString("treeId", null);
        }
        this.pp.setString("orgUnitId", companyId);
        this.pp.setInt("year", Integer.parseInt(this.spinYear.getValue().toString()));
        this.pp.setInt("period", Integer.parseInt(this.spinPeriod.getValue().toString()));
        this.pp.setInt("periodType", ((RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem()).getValue());
        this.pp.setString("company", companyId == null ? null : companyId);
        this.pp.setString("targetCompany", targetCompanyid == null ? null : targetCompanyid);
        this.pp.setString("templet", this.cmbTemplate.getSelectedIndex() == 0 ? null : ((ElimTempletInfo)this.cmbTemplate.getSelectedItem()).getId().toString());
        this.pp.setString("fromCurrency", this.cmbCurrency.getSelectedIndex() == 0 ? null : ((CurrencyInfo)this.cmbCurrency.getSelectedItem()).getId().toString());
        if (this.cmbConfirmStatus.getSelectedIndex() > 0) {
            this.pp.setInt("confirmStatus", ((CheckageConfirmEnum)((Object)this.cmbConfirmStatus.getSelectedItem())).getValue());
        } else {
            this.pp.remove("confirmStatus");
        }
        this.pp.setBoolean("isByCompany", new Boolean(true));
        if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString())) {
            this.pp.setString("compare", this.cbCompare.getSelectedItem().toString());
            this.pp.setString("value", this.txtValue.getNumberValue().toString());
        } else {
            this.pp.remove("compare");
            this.pp.remove("value");
        }
        this.pp.setInt("checkedParty", ((CheckageResponPartyEnum)((Object)this.cmbCheckedParty.getSelectedItem())).getValue());
        this.pp.setObject("Items", this.rptItemF7.getData());
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        this.fillDataToUI();
    }

    @Override
    public Object getParam() {
        return this.getCustomCondition();
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    @Override
    public CustomerParams getCustomerParams() {
        this.getCustomCondition();
        CustomerParams cp = new CustomerParams();
        if (this.pp.getString("company") != null && this.pp.getString("company") != null) {
            cp.addCustomerParam("company", this.pp.getString("company").toString());
        }
        if (this.pp.getString("fromCurrency") != null && this.pp.getString("fromCurrency") != null) {
            cp.addCustomerParam("fromCurrency", this.pp.getString("fromCurrency").toString());
        }
        if (this.pp.getString("templet") != null && this.pp.getString("templet") != null) {
            cp.addCustomerParam("templet", this.pp.getString("templet").toString());
        }
        if (this.pp.getString("treeId") != null && this.pp.getString("treeId") != null) {
            cp.addCustomerParam("treeId", this.pp.getString("treeId").toString());
        }
        if (this.pp.getString("orgUnitId") != null && this.pp.getString("orgUnitId") != null) {
            cp.addCustomerParam("orgUnitId", this.pp.getString("orgUnitId").toString());
        }
        if (this.pp.containsKey("confirmStatus")) {
            cp.addCustomerParam("confirmStatus", String.valueOf(this.pp.getInt("confirmStatus")));
        }
        cp.addCustomerParam("year", String.valueOf(this.pp.getInt("year")));
        cp.addCustomerParam("period", String.valueOf(this.pp.getInt("period")));
        cp.addCustomerParam("periodType", String.valueOf(this.pp.getInt("periodType")));
        cp.addCustomerParam("targetCompany", this.pp.getString("targetCompany"));
        if (this.pp.containsKey("compare")) {
            cp.addCustomerParam("compare", this.pp.getString("compare"));
            cp.addCustomerParam("value", this.pp.getString("value"));
        }
        if (this.pp.containsKey("Items")) {
            cp.addCustomerParam("Items", this.getCollectionNumbers((List)this.rptItemF7.getData()));
        }
        cp.addCustomerParam("checkedParty", BLANK + ((CheckageResponPartyEnum)((Object)this.cmbCheckedParty.getSelectedItem())).getValue());
        return cp;
    }

    private String getCollectionNumbers(List l) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; l != null && i < l.size(); ++i) {
            CoreBaseInfo info = (CoreBaseInfo)l.get(i);
            sb.append(',').append(info.get("number"));
        }
        return sb.length() < 1 ? null : sb.toString();
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        RptProperties condition = new RptProperties();
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("company") != null) {
            condition.setString("company", cp.getCustomerParam("company"));
        }
        if (cp.getCustomerParam("targetCompany") != null) {
            condition.setString("targetCompany", cp.getCustomerParam("targetCompany"));
        }
        if (cp.getCustomerParam("fromCurrency") != null) {
            condition.setString("fromCurrency", cp.getCustomerParam("fromCurrency"));
        }
        if (cp.getCustomerParam("templet") != null) {
            condition.setString("templet", cp.getCustomerParam("templet"));
        }
        if (cp.getCustomerParam("treeId") != null) {
            condition.setString("treeId", cp.getCustomerParam("treeId"));
        }
        if (cp.getCustomerParam("orgUnitId") != null) {
            condition.setString("orgUnitId", cp.getCustomerParam("orgUnitId"));
        }
        if (cp.getCustomerParam("year") != null && !cp.getCustomerParam("year").equals(BLANK)) {
            condition.setInt("year", new Integer(cp.getCustomerParam("year")));
        }
        if (cp.getCustomerParam("period") != null && !cp.getCustomerParam("period").equals(BLANK)) {
            condition.setInt("period", new Integer(cp.getCustomerParam("period")));
        }
        if (cp.getCustomerParam("periodType") != null && !cp.getCustomerParam("periodType").equals(BLANK)) {
            condition.setInt("periodType", new Integer(cp.getCustomerParam("periodType")));
        }
        if (cp.getCustomerParam("confirmStatus") != null) {
            condition.setInt("confirmStatus", cp.getInt("confirmStatus"));
        }
        if (cp.getCustomerParam("compare") != null) {
            condition.setString("compare", cp.getCustomerParam("compare"));
            condition.setString("value", cp.getCustomerParam("value"));
        }
        if (cp.getCustomerParam("Items") != null) {
            condition.setString("Items", cp.getCustomerParam("Items"));
        }
        this.setCustomCondition(condition);
    }

    private void clearUI() {
        this.bizCompany.setValue(null);
        this.cmbCurrency.setSelectedItem((Object)this.bsCurrency);
        this.cmbTemplate.setSelectedItem((Object)this.selectAll);
        this.cmbConfirmStatus.setSelectedIndex(0);
        this.cmbCheckedParty.setSelectedIndex(0);
        this.rptItemF7.setValue(null);
        if (this.cmbOrgTree.getSelectedIndex() != -1) {
            this.cmbOrgTree.setSelectedIndex(0);
        }
        if (this.cbCompare.getSelectedIndex() != -1) {
            this.txtValue.setNumberValue(null);
            this.cbCompare.setSelectedIndex(0);
        }
    }

    public void clear() {
        super.clear();
        this.clearUI();
        this.pp = null;
        try {
            this.loadInitData();
            this.fillDataToUI();
            this.cmbSourceType.setSelectedIndex(2);
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.dpkDate.setValue((Object)preDate);
            this.cmbCurrency.setSelectedIndex(this.bsCurrency2);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean verify() {
        if (null == this.dpkDate.getValue()) {
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.dpkDate.setValue((Object)preDate);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"780_PKDATE_IS_NOT_NULL"));
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString()) && this.txtValue.getNumberValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource.893_InterCheckageConditionUI"));
            return false;
        }
        return true;
    }

    public Dimension getSize() {
        return new Dimension(325, 320);
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        if (OrgViewType.COMPANY.equals((Object)this.orgViewType)) {
            return new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "ExchCheckageFilterUI");
        }
        return new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "MExchCheckageFilterUI");
    }

    private void refresh13Period() {
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period()) {
            int periodType = 0;
            if (BLANK.equals(this.cmbSourceType.getSelectedItem()) || this.cmbSourceType.getSelectedItem() == null) {
                periodType = 0;
            } else {
                RptPeriodTypeEnum rptPeriodTypeEnum = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem();
                int n = periodType = rptPeriodTypeEnum == null ? 0 : rptPeriodTypeEnum.getValue();
            }
            if (3 == periodType && RPTDateUtil.isYearLastPeriod((Date)this.dpkDate.getValue(), RptPeriodTypeEnum.MONTHLY)) {
                this.spinPeriod.setEnabled(true);
                CslRptUIUtil.setSpineRange(this.spinPeriod, 12, 13);
            } else {
                this.spinPeriod.setEnabled(false);
                CslRptUIUtil.setSpineRange(this.spinPeriod, 0, 365);
            }
        }
    }
}

