/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeOfShareCollection;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeOfShareFactory;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeOfShareInfo;
import com.kingdee.eas.fi.gr.cslrpt.IExportSchemeOfShare;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractExportShemeShareListUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExportShemeShareListUI
extends AbstractExportShemeShareListUI {
    private static final Logger logger = CoreUIObject.getLogger(ExportShemeShareListUI.class);
    private ArrayList IDList = null;
    private HashMap shareMap = null;
    public FilterInfo defaultFilterInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.defaultFilterInfo = this.getMainQuery().getFilter();
    }

    protected void init() {
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
        this.IDList = (ArrayList)this.getUIContext().get("keyList");
        this.getShareMap();
        this.btnShare.setEnabled(true);
        this.btnShare.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnSearch.setEnabled(true);
        this.user.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InputPrompt"));
        this.user.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ExportShemeShareListUI.this.user.getText().equals(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InputPrompt"))) {
                    ExportShemeShareListUI.this.user.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ExportShemeShareListUI.this.user.getText().equals("")) {
                    ExportShemeShareListUI.this.user.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InputPrompt"));
                }
            }
        });
    }

    private void getShareMap() {
        if (this.IDList == null || this.IDList.size() < 1) {
            return;
        }
        if (this.shareMap == null) {
            this.shareMap = new HashMap();
        }
        HashSet set = new HashSet(this.IDList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scheme", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ExportSchemeOfShareCollection collection = null;
        try {
            collection = ExportSchemeOfShareFactory.getRemoteInstance().getExportSchemeOfShareCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"getShareMap()", (Throwable)e);
        }
        if (collection == null || collection.size() < 1) {
            return;
        }
        for (int i = 0; i < collection.size(); ++i) {
            ExportSchemeOfShareInfo info = collection.get(i);
            if (info == null || info.getShareUser() == null || info.getScheme() == null) continue;
            String user = info.getShareUser().toString();
            String sheme = info.getScheme().toString();
            HashSet<String> IDset = (HashSet<String>)this.shareMap.get(sheme);
            if (IDset == null) {
                IDset = new HashSet<String>();
                this.shareMap.put(sheme, IDset);
            }
            IDset.add(user);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ExportSchemeOfShareFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnShare.setEnabled(true);
        this.btnAttachment.setVisible(false);
        this.btnSelectAll.setEnabled(false);
        this.btnSelectNo.setEnabled(true);
    }

    @Override
    public void actionSelectNo_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)new Boolean(false));
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() != 0 && e.getClickCount() == 2 && e.getRowIndex() > -1) {
            IRow row = this.tblMain.getRow(e.getRowIndex());
            if (row == null) {
                return;
            }
            Boolean value = (Boolean)row.getCell("select").getValue();
            this.tblMain.getRow(e.getRowIndex()).getCell("select").setValue((Object)new Boolean(value == false));
        }
    }

    public ArrayList getSelectID() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                String id;
                Object value = this.tblMain.getRow(i).getCell("select").getValue();
                if (value == null || !value.equals(new Boolean(true)) || list.contains(id = this.tblMain.getRow(i).getCell("id").getValue().toString())) continue;
                list.add(id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getSelectID()", (Throwable)e);
        }
        return list;
    }

    @Override
    public void actionShare_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectID();
        if (list.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NoSelect"));
            SysUtil.abort();
        }
        CoreBaseCollection col = new CoreBaseCollection();
        try {
            HashMap tempMap = (HashMap)this.shareMap.clone();
            for (int i = 0; i < this.IDList.size(); ++i) {
                for (int j = 0; j < list.size(); ++j) {
                    ExportSchemeOfShareInfo info = new ExportSchemeOfShareInfo();
                    String shemeID = (String)this.IDList.get(i);
                    String userID = (String)list.get(j);
                    if (tempMap != null && tempMap.containsKey(shemeID) && ((HashSet)tempMap.get(shemeID)).contains(userID)) continue;
                    if (tempMap != null && tempMap.containsKey(shemeID)) {
                        ((HashSet)tempMap.get(shemeID)).add(userID);
                    } else if (tempMap != null && !tempMap.containsKey(shemeID)) {
                        HashSet<String> tempSet = new HashSet<String>();
                        tempSet.add(userID);
                        tempMap.put(shemeID, tempSet);
                    }
                    info.setScheme(BOSUuid.read((String)shemeID));
                    info.setShareUser(BOSUuid.read((String)userID));
                    col.add((CoreBaseInfo)info);
                }
            }
            if (col.size() > 0) {
                ((IExportSchemeOfShare)this.getBizInterface()).submit(col);
                this.shareMap = tempMap;
            }
        }
        catch (Exception e2) {
            logger.error((Object)"actionShare_actionPerformed", (Throwable)e2);
        }
        this.showSuccess(true);
    }

    protected void showSuccess(boolean isShare) {
        this.SuccessMsg.setBackground(SHOW_MESSAGE_FG_DEFAULT);
        this.SuccessMsg.setIcon(SHOW_MESSAGE_ICON_DEFAULT);
        this.SuccessMsg.setOpaque(true);
        this.SuccessMsg.repaint();
        if (isShare) {
            this.SuccessMsg.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareSuccess"));
        } else {
            this.SuccessMsg.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"UnShareSuccess"));
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 3; ++i) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ExportShemeShareListUI.this.SuccessMsg.setBackground(CoreUI.SHOW_MESSAGE_FG_DEFAULT);
                                ExportShemeShareListUI.this.SuccessMsg.setOpaque(true);
                                ExportShemeShareListUI.this.SuccessMsg.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ExportShemeShareListUI.this.SuccessMsg.setBackground(CoreUI.SHOW_MESSAGE_FG_DEFAULT);
                                ExportShemeShareListUI.this.SuccessMsg.setOpaque(false);
                                ExportShemeShareListUI.this.SuccessMsg.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    ExportShemeShareListUI.this.SuccessMsg.setBackground(CoreUI.SHOW_MESSAGE_FG_DEFAULT);
                    ExportShemeShareListUI.this.SuccessMsg.setOpaque(true);
                    ExportShemeShareListUI.this.SuccessMsg.repaint();
                    Thread.sleep(1000L);
                    ExportShemeShareListUI.this.SuccessMsg.setOpaque(false);
                    ExportShemeShareListUI.this.SuccessMsg.setIcon(null);
                    ExportShemeShareListUI.this.SuccessMsg.setText(null);
                    ExportShemeShareListUI.this.SuccessMsg.repaint();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    logger.error((Object)e);
                }
            }
        }).start();
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        if (!this.user.getText().isEmpty()) {
            FilterInfo filterInfo = this.getQueryFilterInfo();
            this.getMainQuery().setFilter(filterInfo);
            this.refreshList();
        }
    }

    protected FilterInfo getQueryFilterInfo() {
        String message = this.user.getText();
        if (message.isEmpty() || message.equals(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InputPrompt"))) {
            if (this.defaultFilterInfo != null) {
                return this.defaultFilterInfo;
            }
            return new FilterInfo();
        }
        FilterInfo filterInfo = new FilterInfo();
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem1 = new FilterItemInfo("number", (Object)("%" + message + "%"), CompareType.LIKE);
        FilterItemInfo filterItem2 = new FilterItemInfo("name", (Object)("%" + message + "%"), CompareType.LIKE);
        filterInfo.getFilterItems().add(filterItem1);
        sbFormula.append(" #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem2);
        sbFormula.append(" or #" + formulaIndex++);
        filterInfo.setMaskString(sbFormula.toString());
        return filterInfo;
    }

    protected String getEditUIName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return new FilterInfo();
    }
}

