/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractFilterByTemplateUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class FilterByTemplateUI
extends AbstractFilterByTemplateUI {
    Map allTmp = new HashMap();
    List tmpIds = new ArrayList();
    List rightIds = new ArrayList();
    boolean result = false;
    final String nameTxt = CslRptUtil.getCommonString("name");
    final String numberTxt = CslRptUtil.getCommonString("number");

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.allTmp = (Map)this.getUIContext().get("allTmp");
        this.tmpIds = (List)this.getUIContext().get("tmpIds");
        this.createControl();
        this.initTemplate();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void initTemplate() {
        this.tblLeft.getStyleAttributes().setLocked(true);
        this.tblLeft.getSelectManager().setSelectMode(10);
        this.tblRight.getStyleAttributes().setLocked(true);
        this.tblRight.getSelectManager().setSelectMode(10);
        this.tblLeft.checkParsed();
        this.tblRight.checkParsed();
        this.fillTable(this.tblLeft, this.tmpIds);
    }

    private void fillTable(KDTable table, List tmpIds) {
        table.removeRows();
        Map tmpInfo = null;
        IRow row = null;
        ArrayList<Map> list = new ArrayList<Map>();
        for (int i = 0; i < tmpIds.size(); ++i) {
            list.add((Map)this.allTmp.get(tmpIds.get(i)));
        }
        String sortPropertyName = "number";
        Collections.sort(list, new Comparator<Map>(){

            @Override
            public int compare(Map o1, Map o2) {
                Object k1 = o1.get("number");
                Object k2 = o2.get("number");
                if (k1 != null && k2 != null) {
                    if (k1 instanceof Comparable) {
                        return ((Comparable)k1).compareTo(k2);
                    }
                } else {
                    if (k1 == null && k2 == null) {
                        return 0;
                    }
                    if (k1 == null) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < tmpIds.size(); ++i) {
            tmpInfo = (Map)this.allTmp.get(tmpIds.get(i));
            row = table.addRow();
            row.setUserObject(tmpIds.get(i));
            row.getCell("templateId").setValue(tmpInfo.get("templateId"));
            row.getCell("name").setValue(tmpInfo.get("name"));
            row.getCell("number").setValue(tmpInfo.get("number"));
            row.getCell("sourceType").setValue(tmpInfo.get("sourceType"));
            row.getCell("versionNumber").setValue(tmpInfo.get("versionNumber"));
        }
    }

    private void filter() {
        this.setLeftTable();
        String text = this.filterStringTxt.getText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        int rowCount = this.tblLeft.getRowCount();
        String filter = this.filterItemComb.getSelectedItem().toString();
        String value = null;
        IRow row = null;
        ArrayList<Object> okIds = new ArrayList<Object>();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblLeft.getRow(i);
            if (this.numberTxt.equals(filter)) {
                value = (String)row.getCell("number").getValue();
            } else if (this.nameTxt.equals(filter)) {
                value = (String)row.getCell("name").getValue();
            }
            if (StringUtils.isEmpty((String)value) || value.indexOf(text) < 0) continue;
            okIds.add(row.getUserObject());
        }
        this.tblLeft.removeRows();
        if (okIds.size() > 0) {
            this.fillTable(this.tblLeft, okIds);
        }
    }

    private void moveAllRight() {
        this.tblLeft.removeRows();
        this.rightIds.clear();
        this.fillTable(this.tblRight, this.tmpIds);
        this.rightIds.addAll(this.tmpIds);
    }

    private void moveAllLeft() {
        this.tblRight.removeRows();
        this.rightIds.clear();
        this.fillTable(this.tblLeft, this.tmpIds);
    }

    private void moveRight() {
        IRow[] leftsel = this.getTableSelection(this.tblLeft);
        if (leftsel.length == 0) {
            return;
        }
        Object o = null;
        for (int i = 0; i < leftsel.length; ++i) {
            o = leftsel[i].getUserObject();
            this.rightIds.add(o);
            this.tblRight.addRow(this.tblRight.getRowCount(), leftsel[i]);
        }
        this.setLeftTable();
    }

    private void moveLeft() {
        IRow[] rightsel = this.getTableSelection(this.tblRight);
        if (rightsel.length == 0) {
            return;
        }
        Object o = null;
        for (int i = rightsel.length - 1; i >= 0; --i) {
            o = rightsel[i].getUserObject();
            this.rightIds.remove(o);
            this.tblRight.removeRow(rightsel[i].getRowIndex());
        }
        this.setLeftTable();
    }

    private void setLeftTable() {
        ArrayList leftIds = new ArrayList();
        for (int i = 0; i < this.tmpIds.size(); ++i) {
            if (this.rightIds.contains(this.tmpIds.get(i))) continue;
            leftIds.add(this.tmpIds.get(i));
        }
        this.fillTable(this.tblLeft, leftIds);
    }

    private void createControl() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("LEFT".equals(e.getActionCommand())) {
                    FilterByTemplateUI.this.moveLeft();
                } else if ("RIGHT".equals(e.getActionCommand())) {
                    FilterByTemplateUI.this.moveRight();
                } else if ("ALL_LEFT".equals(e.getActionCommand())) {
                    FilterByTemplateUI.this.moveAllLeft();
                } else if ("ALL_RIGHT".equals(e.getActionCommand())) {
                    FilterByTemplateUI.this.moveAllRight();
                } else if ("OK".equals(e.getActionCommand())) {
                    FilterByTemplateUI.this.result = true;
                    FilterByTemplateUI.this.getUIWindow().close();
                } else if ("CANCEL".equals(e.getActionCommand())) {
                    FilterByTemplateUI.this.result = false;
                    FilterByTemplateUI.this.getUIWindow().close();
                } else if ("FILTER".equals(e.getActionCommand())) {
                    FilterByTemplateUI.this.filter();
                }
            }
        };
        this.filterItemComb.addItem((Object)this.numberTxt);
        this.filterItemComb.addItem((Object)this.nameTxt);
        this.setButtonAction((JButton)this.ntbl, action);
        this.setButtonAction((JButton)this.ntbl, action);
        this.setButtonAction((JButton)this.ntbr, action);
        this.setButtonAction((JButton)this.btnalll, action);
        this.setButtonAction((JButton)this.ntballr, action);
        this.setButtonAction((JButton)this.btnOK, action);
        this.setButtonAction((JButton)this.btnCancel, action);
        this.setButtonAction((JButton)this.filterBtn, action);
        this.ntbr.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.ntbl.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnalll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.ntballr.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.filterBtn.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.ntbl.setActionCommand("LEFT");
        this.ntbr.setActionCommand("RIGHT");
        this.btnalll.setActionCommand("ALL_LEFT");
        this.ntballr.setActionCommand("ALL_RIGHT");
        this.btnOK.setActionCommand("OK");
        this.btnCancel.setActionCommand("CANCEL");
        this.filterBtn.setActionCommand("FILTER");
    }

    private void setButtonAction(JButton btn, Action act) {
        String t1 = btn.getText();
        String t2 = btn.getToolTipText();
        Icon i = btn.getIcon();
        btn.setAction(act);
        btn.setText(t1);
        btn.setToolTipText(t2);
        btn.setIcon(i);
    }

    private IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    rows.add(tbl.getRow(j));
                }
                break;
            }
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            int bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int row = smallLine; row <= bigLine; ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    public List getSelectTemplates() {
        return this.rightIds;
    }

    public boolean isOK() {
        return this.result;
    }
}

