/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemBusinessFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaProcessFactory;
import com.kingdee.eas.fi.gr.cslrpt.IAutoItemBusinessFacade;
import com.kingdee.eas.fi.gr.cslrpt.SingleDataUpdateWayEnum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IsRunningForFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.DateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractFormulaCalcExecGuideUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.cslrpt.client.util.mutex.MutexLock;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class FormulaCalcExecGuideUI
extends AbstractFormulaCalcExecGuideUI {
    private static final Logger logger = CoreUIObject.getLogger(FormulaCalcExecGuideUI.class);
    private boolean isSupport13Period = false;
    private Integer[] countMonth = new Integer[12];
    private Integer[] countWeek = new Integer[52];
    private Integer[] countQuarterly = new Integer[4];
    private Integer[] countSemiyYear = new Integer[2];
    private final MutexLock executeCalcLock;

    public FormulaCalcExecGuideUI() throws Exception {
        this.initialRelatedParam();
        this.executeCalcLock = new MutexLock("ExecuteCalc", "ActionExecuteCalc", this.getMessageHandler(), ResourceDebugUtil.res("scheme.is.running.cannot.execute"), logger);
    }

    private void initialRelatedParam() {
        int i;
        this.isSupport13Period = CslRptUtil.isSupport13Period(null);
        int monthCount = 12;
        if (this.isSupport13Period) {
            this.countMonth = new Integer[13];
            monthCount = 13;
        }
        for (i = 0; i < monthCount; ++i) {
            this.countMonth[i] = i + 1;
        }
        for (i = 0; i < 52; ++i) {
            this.countWeek[i] = i + 1;
        }
        for (i = 0; i < 4; ++i) {
            this.countQuarterly[i] = i + 1;
        }
        for (i = 0; i < 2; ++i) {
            this.countSemiyYear[i] = i + 1;
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.setYearAndPeriod();
        this.initialCombox();
        this.initDataUpdateWay();
        this.initKDLabelContainer();
    }

    private void initKDLabelContainer() throws Exception {
        if (this.txtYear.getEditor() != null && this.txtYear.getEditor() instanceof JSpinner.NumberEditor && ((JSpinner.NumberEditor)this.txtYear.getEditor()).getTextField() != null) {
            ((JSpinner.NumberEditor)this.txtYear.getEditor()).getTextField().setHorizontalAlignment(2);
        }
        if (this.comboPeriod.getEditor() != null && this.comboPeriod.getEditor() instanceof JSpinner.NumberEditor && ((JSpinner.NumberEditor)this.comboPeriod.getEditor()).getTextField() != null) {
            ((JSpinner.NumberEditor)this.comboPeriod.getEditor()).getTextField().setHorizontalAlignment(2);
        }
        ArrayList<Component[]> componentList = new ArrayList<Component[]>();
        componentList.add(new Component[]{this.contYear});
        componentList.add(new Component[]{this.labelPeriod});
        componentList.add(new Component[]{this.labCurrency});
        componentList.add(new Component[]{this.kDLabelContainer1});
        componentList.add(new Component[]{this.kDSeparator2});
        componentList.add(new Component[]{this.btnConform, this.btnCancel});
        RptNewUIUtil.handleHideComponentsByVertical(componentList);
        Rectangle uiRent = this.getBounds();
        uiRent.height = this.btnConform.getBounds().y - this.labDate.getBounds().y + 60;
        this.setBounds(uiRent);
    }

    private void moveUpKDLabelContainer(List<KDLabelContainer> containList, int index) throws Exception {
        int conainY;
        KDLabelContainer contain = containList.get(index);
        Rectangle rectangle = null;
        int preConainY = conainY = contain.getBounds().y;
        KDLabelContainer tmpContain = null;
        for (int i = index + 1; i < containList.size(); ++i) {
            tmpContain = containList.get(i);
            rectangle = tmpContain.getBounds();
            conainY = rectangle.y;
            rectangle.y = preConainY;
            preConainY = conainY;
            tmpContain.setBounds(rectangle);
        }
    }

    private void initDataUpdateWay() {
        Iterator itor = SingleDataUpdateWayEnum.iterator();
        SingleDataUpdateWayEnum curItem = null;
        while (itor.hasNext()) {
            curItem = (SingleDataUpdateWayEnum)((Object)itor.next());
            this.dataUpdateWay.addItem((Object)curItem);
        }
        this.dataUpdateWay.setSelectedItem((Object)SingleDataUpdateWayEnum.ADD);
    }

    private void initialCombox() {
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
    }

    private void setYearAndPeriod() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.getUIContext().get("periodType");
        this.setYearAndPeriodByPeriodType(periodType);
    }

    private void setYearAndPeriodByPeriodType(RptPeriodTypeEnum periodType) {
        this.initalYear();
        switch (periodType.getValue()) {
            case 1: {
                this.initialDailyYearAndPeriod();
                break;
            }
            case 2: {
                this.initialWeeklyYearAndPeriod();
                break;
            }
            case 3: {
                this.initialMONTHLYYearAndPeriod();
                break;
            }
            case 4: {
                this.initialQuarterlyYearAndPeriod();
                break;
            }
            case 5: {
                this.initialSemiyYearlyYearAndPeriod();
                break;
            }
            case 6: {
                this.initialYearTypeYearAndPeriod();
            }
        }
    }

    private void initalYear() {
        Calendar calenda = Calendar.getInstance();
        int year = calenda.get(1);
        this.txtYear.setValue((Object)year);
        this.txtYear.setModel((SpinnerModel)this.getSpinnerNumberModel(year, 1900, 2199, 1));
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    private void initialSemiyYearlyYearAndPeriod() {
        Calendar calenda = Calendar.getInstance();
        int year = calenda.get(1);
        int period = calenda.get(2);
        CslRptUIUtil.setSpineRange(this.comboPeriod, this.countSemiyYear[0], this.countSemiyYear[this.countSemiyYear.length - 1]);
        int semiYearly = 0;
        semiYearly = ++period >= 1 && period <= 6 ? 1 : 2;
        if (--semiYearly == 0) {
            semiYearly = 2;
            --year;
        }
        this.txtYear.setValue((Object)year);
        this.comboPeriod.setValue((Object)semiYearly);
    }

    private void initialQuarterlyYearAndPeriod() {
        Calendar calenda = Calendar.getInstance();
        int year = calenda.get(1);
        int period = calenda.get(2);
        CslRptUIUtil.setSpineRange(this.comboPeriod, this.countQuarterly[0], this.countQuarterly[this.countQuarterly.length - 1]);
        int quarterly = 0;
        if (++period >= 1 && period <= 3) {
            quarterly = 1;
        } else if (period >= 4 && period <= 6) {
            quarterly = 2;
        } else if (period >= 7 && period <= 9) {
            quarterly = 3;
        } else if (period >= 10 && period <= 12) {
            quarterly = 4;
        }
        if (--quarterly == 0) {
            quarterly = 4;
            --year;
        }
        this.txtYear.setValue((Object)year);
        this.comboPeriod.setValue((Object)quarterly);
    }

    private void initialMONTHLYYearAndPeriod() {
        Calendar calenda = Calendar.getInstance();
        int period = calenda.get(2);
        CslRptUIUtil.setSpineRange(this.comboPeriod, this.countMonth[0], this.countMonth[this.countMonth.length - 1]);
        period = calenda.get(2) + 1;
        this.comboPeriod.setValue((Object)period);
        int year = calenda.get(1);
        this.txtYear.setValue((Object)year);
    }

    private void initialWeeklyYearAndPeriod() {
        this.dpkDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                int[] yearAndPeriod;
                if (FormulaCalcExecGuideUI.this.dpkDate.getValue() != null && FormulaCalcExecGuideUI.this.dpkDate.getValue() instanceof Date && (yearAndPeriod = DateUtil.getCurrentYearPeriod(RptPeriodTypeEnum.WEEKLY, (Date)FormulaCalcExecGuideUI.this.dpkDate.getValue(), 0, 0)) != null && yearAndPeriod.length == 2) {
                    FormulaCalcExecGuideUI.this.txtYear.setValue((Object)yearAndPeriod[0]);
                    FormulaCalcExecGuideUI.this.comboPeriod.setValue((Object)yearAndPeriod[1]);
                }
            }
        });
        this.initialDailyYearAndPeriod();
        this.contYear.setVisible(true);
        this.labelPeriod.setVisible(true);
        this.contYear.setEnabled(false);
        this.labelPeriod.setEnabled(false);
        int offset = this.labelPeriod.getBounds().y - this.contYear.getBounds().y;
        Rectangle rect = null;
        for (Component component : this.getComponents()) {
            if (component.equals(this.labDate)) continue;
            rect = component.getBounds();
            rect.y += offset;
            component.setBounds(rect);
        }
    }

    private void initialDailyYearAndPeriod() {
        Calendar calenda = Calendar.getInstance();
        this.contYear.setVisible(false);
        this.labelPeriod.setVisible(false);
        this.labDate.setVisible(true);
        calenda.add(5, -1);
        this.dpkDate.setValue((Object)calenda.getTime());
    }

    private void initialYearTypeYearAndPeriod() {
        this.labelPeriod.setVisible(false);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnConform_actionPerformed(ActionEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            this.getMessageHandler().show(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"54_ItemAnalysisFilterUI"));
            return;
        }
        BOSUuid bosUuid = (BOSUuid)this.getUIContext().get("bosUuid");
        final Uuid mutexId = this.executeCalcLock.lock(bosUuid);
        if (mutexId == null) {
            this.executeCalcLock.showError();
            return;
        }
        final FormulaCalcContextInfo formulaCalcContext = this.buildFormulaCalcContext(bosUuid);
        if (new IsRunningForFormulaCalcContext(new DBHandler(null)).is(formulaCalcContext)) {
            this.getMessageHandler().show(ResourceDebugUtil.res("scheme.is.running.cannot.execute"));
            return;
        }
        final String executeTaskId = Uuid.randomUUID().toString();
        this.deleteFormulaProcess(formulaCalcContext);
        Thread calcThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new DBHandler(null).get(IAutoItemBusinessFacade.class).calculate(formulaCalcContext, executeTaskId);
                    if (formulaCalcContext.isIsDoCheckAfterCalc()) {
                        FormulaCalcExecGuideUI.this.check(formulaCalcContext);
                    }
                }
                catch (AutoItemException e1) {
                    if (AutoItemException.CHECKDUPLICATED.getCode().equals(e1.getSubCode())) {
                        FormulaCalcExecGuideUI.this.getMessageHandler().show(ResourceDebugUtil.res("scheme.is.running.cannot.execute"));
                    }
                    logger.warn((Object)"", (Throwable)((Object)e1));
                }
                catch (EASBizException e2) {
                    logger.error((Object)"", (Throwable)e2);
                }
                catch (BOSException e3) {
                    logger.error((Object)"", (Throwable)e3);
                }
                finally {
                    FormulaCalcExecGuideUI.this.executeCalcLock.unLock(mutexId);
                }
            }
        });
        calcThread.start();
        this.getUIContext().put("isConfirm", true);
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.getUIContext().put("executeCurrency", currency);
        this.btnCancel_actionPerformed(e);
    }

    private void deleteFormulaProcess(FormulaCalcContextInfo formulaCalcContext) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection col = filter.getFilterItems();
        col.add(new FilterItemInfo("context", (Object)formulaCalcContext.getId().toString()));
        FormulaProcessFactory.getRemoteInstance().delete(filter);
        FormulaCalcLogFactory.getRemoteInstance().delete(filter);
    }

    private FormulaCalcContextInfo buildFormulaCalcContext(BOSUuid bosUuid) {
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        this.setCurrency(formulaCalcContext);
        this.setYearAndPeriod(formulaCalcContext);
        this.setDataUpdateWay(formulaCalcContext);
        formulaCalcContext.setId(bosUuid);
        formulaCalcContext.put("rptautoweave_isfromui", null);
        return formulaCalcContext;
    }

    private void setDataUpdateWay(FormulaCalcContextInfo formulaCalcContext) {
        formulaCalcContext.setDataUpdateType((SingleDataUpdateWayEnum)((Object)this.dataUpdateWay.getSelectedItem()));
    }

    private void setYearAndPeriod(FormulaCalcContextInfo formulaCalcContext) {
        int year = Integer.valueOf(this.txtYear.getValue().toString());
        int period = 0;
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.getUIContext().get("periodType");
        switch (periodType.getValue()) {
            case 1: {
                Date date = (Date)this.dpkDate.getValue();
                Calendar calenda = Calendar.getInstance();
                calenda.setTime(date);
                year = calenda.get(1);
                period = calenda.get(6);
                break;
            }
            case 2: {
                Date datewk = (Date)this.dpkDate.getValue();
                Calendar calendawk = Calendar.getInstance();
                calendawk.setTime(datewk);
                year = calendawk.get(1);
                period = calendawk.get(3);
                break;
            }
            case 6: {
                period = 1;
                break;
            }
            default: {
                period = Integer.valueOf(this.comboPeriod.getValue().toString());
            }
        }
        formulaCalcContext.setYear(year);
        formulaCalcContext.setExeYear(year);
        formulaCalcContext.setPeriod(period);
        formulaCalcContext.setExePeriod(period);
    }

    private FormulaCalcContextInfo setCurrency(FormulaCalcContextInfo formulaCalcContext) {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        formulaCalcContext.setCurrentCurrency(currency);
        return formulaCalcContext;
    }

    protected void check(FormulaCalcContextInfo currentInfo) throws BOSException, EASBizException, UIException {
        String report = AutoItemBusinessFacadeFactory.getRemoteInstance().checkItemValue(currentInfo);
        if ("".equals(report)) {
            report = ResourceDebugUtil.res("check.is.passed");
        }
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)currentInfo.getId());
        ctx.put((Object)"String", (Object)report);
        ctx.put((Object)"reportSystem", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ShowEditorPanelUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }
}

