/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractFormulaCalcQueryGuideUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class FormulaCalcQueryGuideUI
extends AbstractFormulaCalcQueryGuideUI {
    private static final Logger logger = CoreUIObject.getLogger(FormulaCalcQueryGuideUI.class);
    private boolean isSupport13Period = false;
    private Integer[] countMonth = new Integer[12];
    private Integer[] countWeek = new Integer[52];
    private Integer[] countQuarterly = new Integer[4];
    private Integer[] countSemiyYear = new Integer[2];

    public FormulaCalcQueryGuideUI() throws Exception {
        this.initialRelatedParam();
    }

    private void initialRelatedParam() {
        int i;
        this.isSupport13Period = CslRptUtil.isSupport13Period(null);
        int monthCount = 12;
        if (this.isSupport13Period) {
            this.countMonth = new Integer[13];
            monthCount = 13;
        }
        for (i = 0; i < monthCount; ++i) {
            this.countMonth[i] = i + 1;
        }
        for (i = 0; i < 52; ++i) {
            this.countWeek[i] = i + 1;
        }
        for (i = 0; i < 4; ++i) {
            this.countQuarterly[i] = i + 1;
        }
        for (i = 0; i < 2; ++i) {
            this.countSemiyYear[i] = i + 1;
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.setYearAndPeriod();
        this.initialCombox();
        if (this.txtYear.getEditor() != null && this.txtYear.getEditor() instanceof JSpinner.NumberEditor && ((JSpinner.NumberEditor)this.txtYear.getEditor()).getTextField() != null) {
            ((JSpinner.NumberEditor)this.txtYear.getEditor()).getTextField().setHorizontalAlignment(2);
        }
        if (this.comboPeriod.getEditor() != null && this.comboPeriod.getEditor() instanceof JSpinner.NumberEditor && ((JSpinner.NumberEditor)this.comboPeriod.getEditor()).getTextField() != null) {
            ((JSpinner.NumberEditor)this.comboPeriod.getEditor()).getTextField().setHorizontalAlignment(2);
        }
        ArrayList<Component[]> componentList = new ArrayList<Component[]>();
        componentList.add(new Component[]{this.contYear});
        componentList.add(new Component[]{this.labelPeriod});
        componentList.add(new Component[]{this.labCurrency});
        componentList.add(new Component[]{this.kDSeparator2});
        componentList.add(new Component[]{this.btnConform, this.btnCancel});
        RptNewUIUtil.handleHideComponentsByVertical(componentList);
        Rectangle uiRent = this.getBounds();
        uiRent.height = this.btnConform.getBounds().y - this.contYear.getBounds().y + 60;
        this.setBounds(uiRent);
    }

    private void initialCombox() {
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        if (formulaCalcContext.getCurrentCurrency() != null) {
            if (formulaCalcContext.getCurrentCurrency().getId() != null) {
                CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, formulaCalcContext.getCurrentCurrency().getId().toString(), false);
            }
        } else {
            CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
        }
    }

    private void setYearAndPeriod() {
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        RptPeriodTypeEnum periodType = formulaCalcContext.getPeriodType();
        this.setYearAndPeriodByPeriodType(periodType);
    }

    private void setYearAndPeriodByPeriodType(RptPeriodTypeEnum periodType) {
        this.initalYear();
        switch (periodType.getValue()) {
            case 1: {
                this.initialDailyYearAndPeriod();
                break;
            }
            case 2: {
                this.initialWeeklyYearAndPeriod();
                break;
            }
            case 3: {
                this.initialMONTHLYYearAndPeriod();
                break;
            }
            case 4: {
                this.initialQuarterlyYearAndPeriod();
                break;
            }
            case 5: {
                this.initialSemiyYearlyYearAndPeriod();
                break;
            }
            case 6: {
                this.initialYearTypeYearAndPeriod();
            }
        }
    }

    private void initalYear() {
        Calendar calenda = Calendar.getInstance();
        int year = calenda.get(1);
        this.txtYear.setValue((Object)year);
        this.txtYear.setModel((SpinnerModel)this.getSpinnerNumberModel(year, 1900, 2199, 1));
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    private void initialSemiyYearlyYearAndPeriod() {
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        Calendar calenda = Calendar.getInstance();
        int year = calenda.get(1);
        int period = calenda.get(2);
        CslRptUIUtil.setSpineRange(this.comboPeriod, this.countSemiyYear[0], this.countSemiyYear[this.countSemiyYear.length - 1]);
        int semiYearly = 0;
        semiYearly = ++period >= 1 && period <= 6 ? 1 : 2;
        if (--semiYearly == 0) {
            semiYearly = 2;
            --year;
        }
        this.txtYear.setValue((Object)formulaCalcContext.getExeYear());
        this.comboPeriod.setValue((Object)formulaCalcContext.getExePeriod());
    }

    private void initialQuarterlyYearAndPeriod() {
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        Calendar calenda = Calendar.getInstance();
        int year = calenda.get(1);
        int period = calenda.get(2);
        CslRptUIUtil.setSpineRange(this.comboPeriod, this.countQuarterly[0], this.countQuarterly[this.countQuarterly.length - 1]);
        int quarterly = 0;
        if (++period >= 1 && period <= 3) {
            quarterly = 1;
        } else if (period >= 4 && period <= 6) {
            quarterly = 2;
        } else if (period >= 7 && period <= 9) {
            quarterly = 3;
        } else if (period >= 10 && period <= 12) {
            quarterly = 4;
        }
        if (--quarterly == 0) {
            quarterly = 4;
            --year;
        }
        this.txtYear.setValue((Object)formulaCalcContext.getExeYear());
        this.comboPeriod.setValue((Object)formulaCalcContext.getExePeriod());
    }

    private void initialMONTHLYYearAndPeriod() {
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        CslRptUIUtil.setSpineRange(this.comboPeriod, this.countMonth[0], this.countMonth[this.countMonth.length - 1]);
        this.txtYear.setValue((Object)formulaCalcContext.getExeYear());
        this.comboPeriod.setValue((Object)formulaCalcContext.getExePeriod());
    }

    private void initialWeeklyYearAndPeriod() {
        Calendar calenda = Calendar.getInstance();
        this.contYear.setVisible(false);
        this.labelPeriod.setVisible(false);
        this.labDate.setVisible(true);
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        calenda.add(1, formulaCalcContext.getExeYear() - calenda.get(1));
        calenda.add(3, formulaCalcContext.getExePeriod() - calenda.get(3));
        this.dpkDate.setValue((Object)calenda.getTime());
    }

    private void initialDailyYearAndPeriod() {
        Calendar calenda = Calendar.getInstance();
        this.contYear.setVisible(false);
        this.labelPeriod.setVisible(false);
        this.labDate.setVisible(true);
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        calenda.add(1, formulaCalcContext.getExeYear() - calenda.get(1));
        calenda.add(6, formulaCalcContext.getExePeriod() - calenda.get(6));
        this.dpkDate.setValue((Object)calenda.getTime());
    }

    private void initialYearTypeYearAndPeriod() {
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        this.labelPeriod.setVisible(false);
        this.txtYear.setValue((Object)formulaCalcContext.getExeYear());
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnConform_actionPerformed(ActionEvent e) throws Exception {
        FormulaCalcContextInfo formulaCalcContext = this.buildFormulaCalcContext();
        this.getUIContext().put("isConfirm", true);
        this.getUIContext().put("formulaCalcContext", formulaCalcContext);
        this.btnCancel_actionPerformed(e);
    }

    private FormulaCalcContextInfo buildFormulaCalcContext() {
        FormulaCalcContextInfo formulaCalcContext = (FormulaCalcContextInfo)this.getUIContext().get("formulaCalcContext");
        this.setCurrency(formulaCalcContext);
        this.setYearAndPeriod(formulaCalcContext);
        formulaCalcContext.put("rptautoweave_isfromui", null);
        return formulaCalcContext;
    }

    private void setYearAndPeriod(FormulaCalcContextInfo formulaCalcContext) {
        int year = Integer.valueOf(this.txtYear.getValue().toString());
        int period = 0;
        RptPeriodTypeEnum periodType = formulaCalcContext.getPeriodType();
        switch (periodType.getValue()) {
            case 1: {
                Date date = (Date)this.dpkDate.getValue();
                Calendar calenda = Calendar.getInstance();
                calenda.setTime(date);
                year = calenda.get(1);
                period = calenda.get(6);
                break;
            }
            case 2: {
                Date datewk = (Date)this.dpkDate.getValue();
                Calendar calendawk = Calendar.getInstance();
                calendawk.setTime(datewk);
                year = calendawk.get(1);
                period = calendawk.get(3);
                break;
            }
            case 6: {
                period = 0;
                break;
            }
            default: {
                period = Integer.valueOf(this.comboPeriod.getValue().toString());
            }
        }
        formulaCalcContext.setYear(year);
        formulaCalcContext.setExeYear(year);
        formulaCalcContext.setPeriod(period);
        formulaCalcContext.setExePeriod(period);
    }

    private FormulaCalcContextInfo setCurrency(FormulaCalcContextInfo formulaCalcContext) {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        formulaCalcContext.setCurrentCurrency(currency);
        return formulaCalcContext;
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }
}

