/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.FormulaProcessCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaProcessFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.AutoItemLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.FormulaCalcSimpleReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.EmptyLogThread;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.DateUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractFormulaCalcReportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.NeedRefreshable;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.TemplateCompanyTreeTableNodeEntity;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.UIParamForNonCompared;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.SetTreeTable;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FormulaCalcReportUI
extends AbstractFormulaCalcReportUI
implements NeedRefreshable {
    private static final long serialVersionUID = 8192750907175682420L;
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FormulaCalcReportUI.class);
    private static final Logger logger = CoreUIObject.getLogger(FormulaCalcReportUI.class);
    private Timer timer = new Timer();
    private String executeTaskId = "auto";
    private final long timeOutLong = 36000000L;

    public FormulaCalcReportUI() throws Exception {
        this.log.checkParsed(false);
        this.log.getStyleAttributes().setLocked(true);
        this.log.getSelectManager().setSelectMode(10);
        if (this.getMainStatusBar() != null && this.getMainStatusBar().getStatusBar() != null) {
            this.getMainStatusBar().getStatusBar().setVisible(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.statement.setText(ResourceDebugUtil.res("wait.to.show.log"));
        new SetTreeTable(false).exec(this.log, "template", null, null);
        this.log.getHead().getRow(0).getCell(0).setValue((Object)"");
        this.log.getColumn("flag").setRenderer((IBasicRender)new IconRender());
        this.log.getColumn("detail").setRenderer((IBasicRender)new CompsiteRender());
        this.freshData();
    }

    public void freshData() {
        this.executeTaskId = (String)this.getUIContextParam("executeTaskId", true);
        this.processor.setValue(0);
        this.log.removeRows();
        this.timer.cancel();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){
            private long startTime = System.currentTimeMillis();

            @Override
            public void run() {
                if (!FormulaCalcReportUI.this.passChecked(this.startTime)) {
                    this.cancel();
                    return;
                }
                try {
                    FormulaCalcReportUI.this.collectAndFillDetailReport();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }, 10L, 1000L);
    }

    private boolean passChecked(long startTime) {
        boolean result = true;
        Map uiContext = this.getUIContext();
        if (!uiContext.containsKey("calcContext")) {
            result = false;
        }
        if (this.processor.getValue() >= 100) {
            result = false;
        }
        if ((System.currentTimeMillis() - startTime) / 36000000L != 0L) {
            result = false;
        }
        return result;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected Object getUIContextParam(Object paramName, boolean isParamForUI) {
        if (isParamForUI) {
            UIParamForNonCompared paramForUI = (UIParamForNonCompared)this.getUIContext().get(UIParamForNonCompared.class);
            if (paramForUI == null) {
                return null;
            }
            return paramForUI.get(paramName);
        }
        return this.getUIContext().get(paramName);
    }

    protected void collectAndFillDetailReport() throws BOSException, EASBizException {
        FormulaCalcContextInfo currentFormulaCalcContext = (FormulaCalcContextInfo)this.getUIContextParam("calcContext", false);
        AutoItemLog logDao = new AutoItemLog(new DBHandler(null), currentFormulaCalcContext, this.executeTaskId, new EmptyLogThread());
        FormulaCalcSimpleReport report = logDao.getReport(false);
        List<FormulaCalcLogInfo> logs = report.detailFormat(true);
        int[] yearAndPeriod = FastMergeUtil.getLastCalcYearAndPeriod(null, currentFormulaCalcContext.getId().toString());
        if (yearAndPeriod == null) {
            yearAndPeriod = DateUtil.getCurrentYearPeriod(currentFormulaCalcContext.getPeriodType(), null, currentFormulaCalcContext.getOffYear(), currentFormulaCalcContext.getOffPeriod());
        }
        String currencyName = "";
        if (currentFormulaCalcContext.getCurrentCurrency() != null) {
            currencyName = currentFormulaCalcContext.getCurrentCurrency().getName();
        }
        this.formulaCalc.setText(currentFormulaCalcContext.getName() + MessageFormat.format(ResourceDebugUtil.res("information.of.year.period.and.currency.with.format"), currentFormulaCalcContext.getExeYear() + "", currentFormulaCalcContext.getExePeriod(), currencyName));
        this.processor.setValue(this.getProcess(currentFormulaCalcContext));
        if (report.totalProcessPercent() == 100) {
            this.processor.setValue(report.totalProcessPercent());
        }
        this.statement.setText(report.simpleFormat());
        boolean hasLoaded = report.totalProcessPercent() == 100;
        TemplateCompanyTreeTableNodeEntity treeCellValue = null;
        IRow row = null;
        boolean newRow = false;
        int size = logs.size();
        for (int i = 0; i < size; ++i) {
            newRow = this.log.getRow(i) == null;
            row = this.log.getRow(i) == null ? this.log.addRow() : this.log.getRow(i);
            if (logs.get(i).getTemplate() != null && !StringUtils.isEmpty((String)logs.get(i).getTemplate().getName()) || logs.get(i).getCompany() != null && !StringUtils.isEmpty((String)logs.get(i).getCompany().getName())) {
                treeCellValue = new TemplateCompanyTreeTableNodeEntity(logs.get(i).getTemplate(), (OrgUnitInfo)logs.get(i).getCompany());
                row.getCell("template").setValue((Object)treeCellValue);
                row.getCell("template").setUserObject((Object)treeCellValue);
                if (logs.get(i).getCompany() == null && logs.get(i).containsKey("processing")) {
                    if (newRow) {
                        // empty if block
                    }
                    treeCellValue.setText(logs.get(i).getTemplate().getName() + MessageFormat.format(ResourceDebugUtil.res("number.of.right.and.wrong.with.format"), logs.get(i).get("failureNum") + "", logs.get(i).get("successNum") + ""));
                    treeCellValue.setHasLoaded(hasLoaded);
                    row.getCell("detail").setValue(null);
                } else {
                    row.getCell("detail").setValue((Object)logs.get(i).getDescription());
                    if (newRow) {
                        // empty if block
                    }
                }
            }
            row.getCell("flag").setValue((Object)logs.get(i).getStatus());
        }
    }

    private int getProcess(FormulaCalcContextInfo currentFormulaCalcContext) throws BOSException {
        int totalNum;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection col = filter.getFilterItems();
        col.add(new FilterItemInfo("context", (Object)currentFormulaCalcContext.getId()));
        view.setFilter(filter);
        FormulaProcessCollection formulaProcessCollection = FormulaProcessFactory.getRemoteInstance().getFormulaProcessCollection(view);
        if (formulaProcessCollection == null || formulaProcessCollection.size() == 0) {
            return 0;
        }
        int finishedNum = formulaProcessCollection.get(0).getFinishedNum();
        int process = (int)Math.ceil(100.0 * (double)finishedNum / (double)(totalNum = formulaProcessCollection.get(0).getTotalNum()));
        if (process >= 100) {
            return 99;
        }
        return process;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean destroyWindow() {
        this.timer.cancel();
        boolean destroyWindow = super.destroyWindow();
        return destroyWindow;
    }

    @Override
    public boolean isNeed() {
        String executeTaskIdForNew = (String)this.getUIContextParam("executeTaskId", true);
        if (executeTaskIdForNew == null || this.executeTaskId == null) {
            return false;
        }
        return !executeTaskIdForNew.equals(this.executeTaskId);
    }

    @Override
    public void toRefresh() {
        this.freshData();
    }

    private static class CompsiteRender
    implements IBasicRender {
        public void draw(Graphics graphics, Shape clip, Object value, Style cellStyle) {
            if (value instanceof Integer) {
                new ProgressBarRender().draw(graphics, clip, value, cellStyle);
            } else if ("SUCCESS".equals(value)) {
                new IconRender().draw(graphics, clip, value, cellStyle);
            } else if (value instanceof String) {
                new TextRender().draw(graphics, clip, (String)value, cellStyle);
            }
        }
    }

    private static class IconRender
    extends KDLabel
    implements IBasicRender {
        public IconRender() {
            this.setHorizontalAlignment(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object value, Style cellStyle) {
            if (FormulaCalcLogStatus.SUCCESS.equals(value)) {
                this.setIcon(EASResource.getIcon((String)"imgTable_success"));
            } else if (FormulaCalcLogStatus.FAILURE.equals(value)) {
                this.setIcon(EASResource.getIcon((String)"imgTable_failure"));
            } else if (FormulaCalcLogStatus.PARTFAILURE.equals(value)) {
                this.setIcon(EASResource.getIcon((String)"imgTable_high"));
            } else {
                this.setIcon(null);
            }
            Rectangle rect = clip.getBounds();
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }

        protected void printComponent(Graphics g) {
            super.printComponent(g);
            g.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }

    private static class ProgressBarRender
    extends KDProgressBar
    implements IBasicRender {
        public ProgressBarRender() {
            this.setStringPainted(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if (object instanceof Integer) {
                this.setValue((Integer)object);
            }
            Rectangle rect = clip.getBounds();
            rect.x -= 3;
            rect.width += 6;
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }
    }
}

