/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FormulaDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractFormulaDispenseListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaDispenseEditUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.util.CslGradeManageUtilClient;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FormulaDispenseListUI
extends AbstractFormulaDispenseListUI
implements KDTDataFillListener {
    private OrgUnitInfo company = null;
    private static final Logger logger = CoreUIObject.getLogger(FormulaDispenseListUI.class);
    private String selectAll = "";
    private boolean selfGradeOnly = false;

    public FormulaDispenseListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this);
        this.company = SysContext.getSysContext().getCurrentOrgUnit();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                FormulaDispenseListUI.this.fillTable(e);
            }
        });
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    private boolean allowModify(String Msg) {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return false;
            }
            Object createUnit = row.getCell("trackRecordCreatorid").getValue();
            if (createUnit != null && createUnit.equals(this.company.getId().toString())) {
                return true;
            }
            MsgBox.showInfo((String)Msg);
            SysUtil.abort();
        }
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initKdBox();
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    private void initKdBox() {
        this.btnDispenseFormula.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemDispenseFormula.setEnabled(true);
        this.menuItemDispenseFormula.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.cmbFormulaType.addItem((Object)this.selectAll);
        this.cmbFormulaType.addItem((Object)FormulaTypeEnum.BETWEENRPTITEM);
        this.cmbFormulaType.addItem((Object)FormulaTypeEnum.ITEMEXCEPTION);
        this.cmbFormulaType.setSelectedItem((Object)this.selectAll);
        this.btnFind.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.cmbTempateType.addItem((Object)this.selectAll);
        Iterator iter = RptTmpTypeEnum.iterator();
        while (iter.hasNext()) {
            RptTmpTypeEnum type = (RptTmpTypeEnum)iter.next();
            if (type.getValue() == 1 || type.getValue() == 14 || type.getValue() == 4 || type.getValue() == 2 || type.getValue() == 12 || type.getValue() == 8 || type.getValue() == 16 || type.getValue() == 20 || type.getValue() == 19) continue;
            this.cmbTempateType.addItem((Object)type);
        }
        this.cmbTempateType.setSelectedItem((Object)this.selectAll);
        this.btnDispenseFormula.setEnabled(true);
    }

    protected void displayFormulaContent(KDTDataRequestEvent e) throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        HashSet<String> numberSet1 = new HashSet<String>();
        HashSet<String> numberSet2 = new HashSet<String>();
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null || row.getCell(5) == null || row.getCell(4) == null) continue;
            BizEnumValueInfo type = (BizEnumValueInfo)row.getCell(4).getValue();
            if (type.getInt() == 1) {
                numberSet1.add(row.getCell(5).getValue().toString());
                continue;
            }
            if (type.getInt() != 2) continue;
            numberSet2.add(row.getCell(5).getValue().toString());
        }
        HashMap<String, RPTItemCheckFormulaInfo> rptItems = new HashMap<String, RPTItemCheckFormulaInfo>();
        if (numberSet1.size() > 0) {
            EntityViewInfo v = new EntityViewInfo();
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            v.getSelector().add(new String("lFormula"));
            v.getSelector().add(new String("operateSymbol"));
            v.getSelector().add(new String("rFormula"));
            v.getSelector().add(new String("number"));
            f.getFilterItems().add(new FilterItemInfo("number", numberSet1, CompareType.INCLUDE));
            RPTItemCheckFormulaCollection result = RPTItemCheckFormulaFactory.getRemoteInstance().getRPTItemCheckFormulaCollection(v);
            for (int j = 0; j < result.size(); ++j) {
                rptItems.put(result.get(j).getNumber(), result.get(j));
            }
        }
        HashMap<String, RPTItemDiffIndexInfo> diffIdxs = new HashMap<String, RPTItemDiffIndexInfo>();
        if (numberSet2.size() > 0) {
            EntityViewInfo v = new EntityViewInfo();
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            v.getSelector().add(new String("formula"));
            v.getSelector().add(new String("operateSymbol"));
            v.getSelector().add(new String("diffIndexType"));
            v.getSelector().add(new String("defaultStandValue"));
            v.getSelector().add(new String("number"));
            f.getFilterItems().add(new FilterItemInfo("number", numberSet2, CompareType.INCLUDE));
            RPTItemDiffIndexCollection result = RPTItemDiffIndexFactory.getRemoteInstance().getRPTItemDiffIndexCollection(v);
            for (int j = 0; j < result.size(); ++j) {
                diffIdxs.put(result.get(j).getNumber(), result.get(j));
            }
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            RPTItemDiffIndexInfo info;
            if (this.tblMain.getRow(i).getCell(5) == null || this.tblMain.getRow(i).getCell(4) == null) continue;
            BizEnumValueInfo type = (BizEnumValueInfo)this.tblMain.getRow(i).getCell(4).getValue();
            if (type.getInt() == 1) {
                RPTItemCheckFormulaInfo rptItemInfo = (RPTItemCheckFormulaInfo)rptItems.get(this.tblMain.getRow(i).getCell(5).getValue().toString());
                if (rptItemInfo == null) continue;
                StringBuffer value = new StringBuffer();
                value.append(rptItemInfo.getLFormula());
                value.append((Object)rptItemInfo.getOperateSymbol());
                value.append(rptItemInfo.getRFormula());
                this.tblMain.getRow(i).getCell(8).setValue((Object)value);
                continue;
            }
            if (type.getInt() != 2 || (info = (RPTItemDiffIndexInfo)diffIdxs.get(this.tblMain.getRow(i).getCell(5).getValue().toString())) == null) continue;
            StringBuffer value = new StringBuffer();
            value.append(info.getFormula());
            value.append((Object)info.getOperateSymbol());
            value.append((Object)info.getDiffIndexType());
            value.append(info.getDefaultStandValue());
            this.tblMain.getRow(i).getCell(8).setValue((Object)value);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.allowModify(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"454_ElimInvestDataMaintainListUI"));
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        String pk = this.getSelectedKeyValue();
        uiContext.put((Object)"PK", (Object)pk);
        Object obj = this.getTemplateNumber();
        Object templateType = this.getTemplateType();
        uiContext.put((Object)"TemplateNumber", obj);
        uiContext.put((Object)"TemplateType", templateType);
        uiContext.put((Object)"IsEdit", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaDispenseEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.doRefresh(uiWindow);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtilClient.judgeAndPromptSelectedRow((KDTable)this.tblMain, (int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (String)"trackRecordCreatorid", (String)this.company.getId().toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"455_ElimInvestDataMaintainListUI"), (String)"noeqCreateOrgRemove");
        super.actionRemove_actionPerformed(e);
    }

    public Object getTemplateNumber() {
        Object templateNumber;
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        selectBlock = this.tblMain.getSelectManager().get(0);
        int rowNum = selectBlock.getTop();
        Object obj = templateNumber = this.tblMain.getRow(rowNum).getCell(1).getValue();
        return obj;
    }

    public Object getTemplateType() {
        Object templateType;
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        selectBlock = this.tblMain.getSelectManager().get(0);
        int rowNum = selectBlock.getTop();
        Object obj = templateType = this.tblMain.getRow(rowNum).getCell(3).getValue();
        return obj;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void actionFind_actionPerformed(ActionEvent e) throws Exception {
        super.actionFind_actionPerformed(e);
        FilterInfo filter = new FilterInfo();
        StringBuffer s = new StringBuffer();
        int index = 0;
        if (!this.txtTemplateNumber.getText().equals("")) {
            FilterItemInfo filterItem0 = new FilterItemInfo("templateNumber", (Object)("%" + this.txtTemplateNumber.getText() + "%"), CompareType.LIKE);
            filter.getFilterItems().add(filterItem0);
            if (s.length() != 0) {
                s.append(" and ");
                s.append("#");
                s.append(index++);
            } else {
                s.append("#");
                s.append(index++);
            }
        }
        if (!this.txtTemplateName.getText().equals("")) {
            FilterItemInfo filterItem1 = new FilterItemInfo("templateName", (Object)("%" + this.txtTemplateName.getText() + "%"), CompareType.LIKE);
            filter.getFilterItems().add(filterItem1);
            if (s.length() != 0) {
                s.append(" and ");
                s.append("#");
                s.append(index++);
            } else {
                s.append("#");
                s.append(index++);
            }
        }
        if (!this.cmbTempateType.getSelectedItem().equals("")) {
            int type = ((RptTmpTypeEnum)this.cmbTempateType.getSelectedItem()).getValue();
            FilterItemInfo filterItem2 = new FilterItemInfo("templateType", (Object)new Integer(type), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem2);
            if (s.length() != 0) {
                s.append(" and ");
                s.append("#");
                s.append(index++);
            } else {
                s.append("#");
                s.append(index++);
            }
        }
        if (!this.cmbFormulaType.getSelectedItem().equals("")) {
            int type = ((FormulaTypeEnum)((Object)this.cmbFormulaType.getSelectedItem())).getValue();
            FilterItemInfo filterItem3 = new FilterItemInfo("formulaType", (Object)new Integer(type), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem3);
            if (s.length() != 0) {
                s.append(" and ");
                s.append("#");
                s.append(index++);
            } else {
                s.append("#");
                s.append(index++);
            }
        }
        if (!this.txtFormulaNumber.getText().equals("")) {
            FilterItemInfo filterItem4 = new FilterItemInfo("formulaNumber", (Object)("%" + this.txtFormulaNumber.getText() + "%"), CompareType.LIKE);
            filter.getFilterItems().add(filterItem4);
            if (s.length() != 0) {
                s.append(" and ");
                s.append("#");
                s.append(index++);
            } else {
                s.append("#");
                s.append(index++);
            }
        }
        if (!this.txtFormulaName.getText().equals("")) {
            FilterItemInfo filterItem5 = new FilterItemInfo("formulaName", (Object)("%" + this.txtFormulaName.getText() + "%"), CompareType.LIKE);
            filter.getFilterItems().add(filterItem5);
            if (s.length() != 0) {
                s.append(" and ");
                s.append("#");
                s.append(index++);
            } else {
                s.append("#");
                s.append(index++);
            }
        }
        filter.setMaskString(s.toString());
        if (!filter.getMaskString().equals("")) {
            this.mainQuery.setFilter(filter);
            this.changeFilterByFlag();
            this.tblMain.removeRows();
        } else {
            this.mainQuery = new EntityViewInfo();
            this.changeFilterByFlag();
            this.tblMain.removeRows();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.actionFind_actionPerformed(e);
    }

    @Override
    public void actionDispense_actionPerformed(ActionEvent e) throws Exception {
        super.actionDispense_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"IsEdit", (Object)Boolean.FALSE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaDispenseEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.doRefresh(uiWindow);
    }

    protected final boolean doRefresh(IUIWindow uiWindow) {
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        IUIWindow iuw = uiWindow;
        WindowAdapter listenerForEditWindow = null;
        listenerForEditWindow = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                try {
                    FormulaDispenseListUI.this.actionRefresh_actionPerformed(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        window.addWindowListener(listenerForEditWindow);
        return false;
    }

    protected String[] getLocateNames() {
        String[] s = new String[]{"templateNumber", "templateName"};
        return s;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FormulaDispenseFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void afterDataFill(KDTDataRequestEvent e) {
        try {
            this.displayFormulaContent(e);
        }
        catch (EASBizException e1) {
            logger.error((Object)"displayFormulaContent_EASBizException", (Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"displayFormulaContent_BOSException", (Throwable)e1);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.initQuery();
        this.tblMain.removeRows();
    }

    private void initQuery() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return CslRptUtil.getCurrentChckPermOrgPk(action);
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_FormulaDispense", (String)"FTrackRecordCreatorID", (ArrayList)this.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }
}

