/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataYearInit;
import com.kingdee.eas.fi.gr.cslrpt.IRPTDataService;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.TablePreferHelperYearInit;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractGenerateNextYearInitDataListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class GenerateNextYearInitDataListUI
extends AbstractGenerateNextYearInitDataListUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(GenerateNextYearInitDataListUI.class);
    private ICSLContext cslContext = null;
    private String dataCollect = null;
    private boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
    private PeriodCollection periods = null;
    protected String COL_SELECT = "select";
    protected String COL_ITEM_NUMBER = "item.number";
    protected String COL_ITEM_NAME = "item.name";
    protected String COL_CURRENCY_NAME = "currency.name";
    protected String COL_CURRENCY_NUMBER = "currency.number";
    protected String COL_SOURCECURRENCY_NAME = "sourceCurrency.name";
    protected String COL_SOURCECURRENCY_NUMBER = "sourceCurrency.number";
    protected String COL_YEAR = "year";
    protected String COL_PERIOD = "period";
    protected String COL_DEBITFORMULA = "debit";
    protected String COL_CREDITFORMULA = "credit";
    protected String COL_VALUETYPE = "valueType";
    protected String COL_DATAELEMENT = "datatype";
    protected String COL_ADJUSTSTATUS = "adjusted";
    protected String COL_DATACOLLECT = "dataCollect";
    protected boolean isSimpleShow = false;
    protected boolean is13Period = CslRptUtil.isSupport13Period(null);
    protected boolean isLoaded = false;

    protected void initHelper() {
        if (this.tHelper != null) {
            return;
        }
        this.tHelperPrint = this.tHelper = new TablePreferHelperYearInit(this);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnGenerate.setIcon(EASResource.getIcon((String)"imgTbtn_deliverto"));
        this.btnEditYearInit.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnEditYearInitForCslEdit.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.miGenerate.setIcon(EASResource.getIcon((String)"imgTbtn_deliverto"));
        this.miEditYearInit.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.miEditYearInitForCslEdit.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.miSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.miClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.miRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnEditYearInit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"501_GenerateNextYearInitDataListUI"));
        this.btnEditYearInit.setVisible(false);
        this.miEditYearInit.setVisible(false);
        this.btnEditYearInitForCslEdit.setVisible(false);
        this.miEditYearInitForCslEdit.setVisible(false);
    }

    public void onLoad() throws Exception {
        Object isSupportOtherDS;
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.cslContext = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
        super.onLoad();
        RptPeriodTypeEnum periodType = this.cslContext.getCurRptPeriodType();
        int period = this.cslContext.getCurRptPeriod();
        if (periodType != RptPeriodTypeEnum.MONTHLY || period < 12) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"827_Only_EndPeriod_Generate"));
            SysUtil.abort();
        }
        this.dataCollect = this.cslContext.getCurDataCollect().getNumber();
        if (this.dataCollect.equals("BUDGETDATA")) {
            this.btnGenerate.setEnabled(false);
            this.miGenerate.setEnabled(false);
        }
        if (this.isMergeByFiscalPeriod && this.periods == null) {
            this.periods = FiscalPeriodHelper.getPeriodCollection(null, this.cslContext.getCurOrgBound());
        }
        if (!FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, this.cslContext.getCurRptPeriodType()) || this.periods == null) {
            this.actionGenerate.setEnabled(RPTDateUtil.isYearLastPeriod(this.cslContext.getCurReportDate(), this.cslContext.getCurRptPeriodType()));
        } else {
            boolean isGeneratePeriod = FiscalPeriodHelper.isGeneratePeriod(this.periods, this.cslContext.getCurRptYear(), this.cslContext.getCurRptPeriod(), this.cslContext.getCurRptPeriodType(), this.isMergeByFiscalPeriod);
            this.actionGenerate.setEnabled(isGeneratePeriod);
        }
        this.txtOrgTree.setText(this.cslContext.getCurOrgBound().getName());
        this.txtOrgUnit.setText(this.cslContext.getCurOrgGroup().getName());
        if (this.getUIContext().get("year") != null) {
            this.txtYear.setText(this.getUIContext().get("year").toString());
        } else {
            this.txtYear.setText(String.valueOf(this.cslContext.getCurRptYear()));
        }
        this.cmbPeriod.addItem((Object)new Integer(12));
        if (this.is13Period || this.isMergeByFiscalPeriod) {
            this.cmbPeriod.addItem((Object)new Integer(13));
        } else {
            this.cmbPeriod.setEnabled(false);
        }
        this.cmbPeriod.setSelectedIndex(0, false);
        this.kdtMain.checkParsed();
        Object obj = this.getUIContext().get("simpleShow");
        if (obj != null && obj instanceof Boolean) {
            this.isSimpleShow = true;
        }
        this.kdtMain.getColumn(this.COL_CURRENCY_NUMBER).setWidth(0);
        this.kdtMain.getColumn(this.COL_SOURCECURRENCY_NUMBER).setWidth(0);
        if (this.isSimpleShow) {
            this.btnEditYearInit.setVisible(false);
            this.btnEditYearInitForCslEdit.setVisible(false);
            this.kdtMain.getColumn(this.COL_YEAR).setWidth(35);
            this.kdtMain.getColumn(this.COL_PERIOD).setWidth(25);
            this.kdtMain.getColumn(this.COL_CURRENCY_NAME).setWidth(70);
            this.kdtMain.getColumn(this.COL_SOURCECURRENCY_NAME).setWidth(70);
            this.kdtMain.getColumn(this.COL_VALUETYPE).setWidth(48);
        }
        this.kdtMain.getStyleAttributes().setLocked(true);
        this.kdtMain.getColumn(0).getStyleAttributes().setLocked(false);
        this.combAdjustStatus.removeItem((Object)AdjustStatusEnum.CALIADJUSTED);
        this.combAdjustStatus.setSelectedItem((Object)AdjustStatusEnum.ADJUSTED);
        this.queryDataToTable();
        if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
            this.rptArchive();
        }
        if (CSLContextHelper.getCSLContext().isQueryBudget()) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("budgetHisQueryNotAllow"));
            SysUtil.abort();
        }
        if ("true".equals(isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS"))) {
            this.kdtMain.getColumn("dataCollect").getStyleAttributes().setHided(false);
        } else {
            this.kdtMain.getColumn("dataCollect").getStyleAttributes().setHided(true);
        }
        this.selectOrClear(true);
        this.isLoaded = true;
    }

    protected void rptArchive() {
        this.actionGenerate.setEnabled(false);
        this.actionEditYearInit.setEnabled(false);
        this.actionEditYearInitForCslEdit.setEnabled(false);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        KDCheckBox chkSelect = new KDCheckBox();
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JCheckBox)chkSelect);
        this.kdtMain.getColumn(this.COL_SELECT).setEditor((ICellEditor)itemEditor);
        this.kdtMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.selectOrClear(false);
    }

    @Override
    public void actionEditYearInit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditYearInit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ItemDataYearInitCommEditUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private Map getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        try {
            param.put("orgtreeid", ctx.getCurOrgBound().getId().toString());
            param.put("orgunitid", ctx.getCurOrgGroup().getId().toString());
            param.put("periodtype", ctx.getCurRptPeriodType());
            param.put("year", new Integer(ctx.getCurRptYear()));
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        return param;
    }

    @Override
    public void actionGenerate_actionPerformed(ActionEvent e) throws Exception {
        int iCount;
        super.actionGenerate_actionPerformed(e);
        if (CslRptUIUtil.getSelectedRows(this.kdtMain, this.kdtMain.getColumnIndex(this.COL_SELECT)) > 0) {
            iCount = 0;
            IItemDataYearInit itemDataYearInit = ItemDataYearInitFactory.getRemoteInstance();
            String orgBound = this.cslContext.getCurOrgBound().getId().toString();
            String orgGroup = this.cslContext.getCurOrgGroup().getId().toString();
            Integer period = new Integer(this.cslContext.getCurRptPeriod());
            String res = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"confirmTransfer");
            String msg = MessageFormat.format(res, this.cmbPeriod.getSelectedItem());
            if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) == 2) {
                return;
            }
            super.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"GENERATING_ROWS"));
            super.showMessage();
            ArrayList lstParams = new ArrayList();
            for (int i = 0; i < this.kdtMain.getRowCount(); ++i) {
                if (!((Boolean)this.kdtMain.getCell(i, this.COL_SELECT).getValue()).booleanValue()) continue;
                HashMap<String, Object> mapRow = new HashMap<String, Object>();
                mapRow.put("ItemNumber", this.kdtMain.getCell(i, this.COL_ITEM_NUMBER).getValue().toString());
                mapRow.put("CurrencyNumber", this.kdtMain.getCell(i, this.COL_CURRENCY_NUMBER).getValue().toString());
                mapRow.put("SourceCurrencyNumber", this.kdtMain.getCell(i, this.COL_SOURCECURRENCY_NUMBER).getValue().toString());
                mapRow.put("Year", this.kdtMain.getCell(i, this.COL_YEAR).getValue());
                mapRow.put("Debit", this.kdtMain.getCell(i, this.COL_DEBITFORMULA).getValue());
                mapRow.put("Credit", this.kdtMain.getCell(i, this.COL_CREDITFORMULA).getValue());
                mapRow.put("DataElement", new Integer(5));
                mapRow.put("ValueType", this.getIntValueType((String)this.kdtMain.getCell(i, "valueType").getValue()));
                mapRow.put("dataCollect_ACTUALDATA", DataCollectConstant.getActualDC());
                mapRow.put("dataCollect_BUDGETDATA", DataCollectConstant.getBudgetDC());
                mapRow.put("Period", period);
                mapRow.put("PeriodType", this.cslContext.getCurRptPeriodType());
                lstParams.add(mapRow);
                ++iCount;
            }
            itemDataYearInit.geneRateNextYearInitData(orgBound, orgGroup, lstParams);
            Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
            boolean isCreateBUDGETDATA = true;
            if ("true".equals(isSupportOtherDS)) {
                RptPeriodTypeEnum periodTypeEnum = this.cslContext.getCurRptPeriodType();
                if (this.is13Period && periodTypeEnum != null && period != null && period == 13 && periodTypeEnum.getValue() == 3) {
                    isCreateBUDGETDATA = false;
                }
            } else {
                isCreateBUDGETDATA = false;
            }
            if (this.isMergeByFiscalPeriod) {
                isCreateBUDGETDATA = false;
            }
        } else {
            String res = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"plsSelectRowForTans");
            MsgBox.showInfo((String)res);
            return;
        }
        MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"GENERATED_N_ROWSDATA2"), String.valueOf(iCount)));
        super.resetMessageText();
        super.resetMessageIcon();
    }

    private Object getIntValueType(String value) {
        if (value == null) {
            return new Integer(1);
        }
        Locale uiLocale = SysContext.getSysContext().getLocale();
        Iterator it = ValueTypeEnum.iterator();
        ValueTypeEnum valueType = null;
        while (it.hasNext()) {
            valueType = (ValueTypeEnum)((Object)it.next());
            if (!valueType.getAlias(uiLocale).equals(value)) continue;
            return new Integer(valueType.getValue());
        }
        return new Integer(1);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.queryDataToTable();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.selectOrClear(true);
    }

    private void selectOrClear(boolean isSelect) {
        for (int i = 0; i < this.kdtMain.getRowCount(); ++i) {
            this.kdtMain.getRow(i).getCell("select").setValue((Object)isSelect);
        }
    }

    protected void queryDataToTable() throws EASBizException, BOSException {
        if (!this.btnGenerate.isEnabled()) {
            return;
        }
        ArrayList result = null;
        ItemDataCondition condition = new ItemDataCondition();
        HashMap<String, Object> extCondition = new HashMap<String, Object>();
        IRPTDataService dataService = RPTDataServiceFactory.getRemoteInstance();
        this.cslContext = CSLContextHelper.getCSLContext();
        condition.setOrgTreeId(this.cslContext.getCurOrgBound().getId().toString());
        ArrayList<String> lstCompany = new ArrayList<String>();
        lstCompany.add(this.cslContext.getCurOrgGroup().getId().toString());
        condition.setOrgUnit(lstCompany);
        condition.setCommitStatus(3);
        boolean isAdjusted = ((AdjustStatusEnum)((Object)this.combAdjustStatus.getSelectedItem())).equals((Object)AdjustStatusEnum.ADJUSTED);
        condition.setIsAdjusted(isAdjusted);
        condition.setRptPeriodType(this.cslContext.getCurRptPeriodType().getValue());
        int curRptYear = Integer.valueOf(this.txtYear.getText());
        int curRptPeriod = (Integer)this.cmbPeriod.getSelectedItem();
        condition.setRptYearStart(curRptYear);
        condition.setRptPeriodStart(curRptPeriod);
        condition.setRptYearEnd(curRptYear);
        condition.setRptPeriodEnd(curRptPeriod);
        condition.setDataSource(3);
        condition.setDataElement(4);
        condition.setIsAllowAmountZero(true);
        condition.setValueType(-1);
        condition.setDataCollectNumber(this.dataCollect);
        extCondition.put("isShowSum", false);
        extCondition.put("dataType", new Integer(0));
        extCondition.put("currencyName", CslRptUtil.getString("CslRptItemDataNameAll"));
        extCondition.put("excludeAdjust", Boolean.TRUE);
        extCondition.put("excludeElim", Boolean.TRUE);
        extCondition.put("dataCollectNumber", CSLContextHelper.getCSLContext().getCurDataCollect().getNumber());
        extCondition.put("KEY_ORGUNIT_INFO", CSLContextHelper.getCSLContext().getCurOrgGroup());
        extCondition.put("isYearInit", true);
        ArrayList obj = dataService.getItemData(condition, extCondition);
        this.kdtMain.setRefresh(false);
        this.kdtMain.removeRows();
        result = obj;
        if (result != null && result.size() > 0) {
            int iSize = result.size();
            for (int i = 0; i < iSize; ++i) {
                IRow tmpRow = this.kdtMain.addRow();
                Object[] row = (Object[])result.get(i);
                tmpRow.getCell(this.COL_SELECT).setValue((Object)Boolean.FALSE);
                tmpRow.getCell(this.COL_ITEM_NUMBER).setValue(row[2]);
                tmpRow.getCell(this.COL_ITEM_NAME).setValue(row[3]);
                tmpRow.getCell(this.COL_CURRENCY_NUMBER).setValue(row[6]);
                tmpRow.getCell(this.COL_CURRENCY_NAME).setValue(row[7]);
                tmpRow.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue(row[4]);
                tmpRow.getCell(this.COL_SOURCECURRENCY_NAME).setValue(row[5]);
                tmpRow.getCell(this.COL_YEAR).setValue(row[8]);
                tmpRow.getCell(this.COL_PERIOD).setValue(row[9]);
                tmpRow.getCell(this.COL_DEBITFORMULA).setValue(row[11]);
                tmpRow.getCell(this.COL_CREDITFORMULA).setValue(row[12]);
                tmpRow.getCell(this.COL_DATAELEMENT).setValue(row[16]);
                tmpRow.getCell(this.COL_VALUETYPE).setValue(row[14]);
                tmpRow.getCell(this.COL_ADJUSTSTATUS).setValue((Object)(isAdjusted ? AdjustStatusEnum.ADJUSTED : AdjustStatusEnum.BEFOREADJUST));
                tmpRow.getCell(this.COL_DATACOLLECT).setValue(row[15]);
            }
        }
        this.kdtMain.setRefresh(true);
        this.kdtMain.reLayoutAndPaint();
        this.kdtMain.repaint();
    }

    @Override
    public void actionEditYearInitForCslEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditYearInitForCslEdit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ItemDataYearInitCslRptEditUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    @Override
    protected void combAdjustStatus_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        this.queryDataToTable();
    }

    @Override
    protected void cmbPeriod_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        if (e.getStateChange() == 1) {
            this.queryDataToTable();
        }
    }
}

