/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractGenerateNextYearInitDataUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenerateNextYearInitDataUI
extends AbstractGenerateNextYearInitDataUI {
    private static final Logger logger = CoreUIObject.getLogger(GenerateNextYearInitDataUI.class);
    private List reportIDList = null;
    private GroupRptProcessUI parentGroupRptProcessUI = null;
    private boolean isBuildByParentGroupRptProcessUI = false;
    private Integer rptSourceType = null;
    private static final String COL_SELECTED = "selectedColumn";
    private static final String COL_RPTITEM_NUMBER = "rptItemNumberColumn";
    private static final String COL_RPTITEM_NAME = "rptItemNameColumn";
    private static final String COL_SRCCURRENCY = "srcCurrency";
    private static final String COL_CURRENCY = "currencyColumn";
    private static final String COL_YEAR = "yearColumn";
    private static final String COL_PERIOD = "periodColumn";
    private static final String COL_CREDIT = "creditColumn";
    private static final String COL_DEBIT = "debitColumn";
    private static final String COL_DATA_ELEMENT = "dataElementColumn";
    private static final String COL_VALUE_TYPE = "valueTypeColumn";
    private static final String COL_ORGTREE = "orgTreeColumn";
    private Map<String, List<String>> nextYearOrgUnitMap;

    public GenerateNextYearInitDataUI() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"GenerateNextYearInitData_Frame_Title"));
        this.txtCompany.setEditable(false);
        this.txtPeriod.setEditable(false);
        this.txtYear.setEditable(false);
    }

    public void onLoad() throws Exception {
        Object parentUI;
        String period;
        String year;
        super.onLoad();
        this.reportIDList = (List)this.getUIContext().get("ReportIDList");
        String companyDisplayName = (String)this.getUIContext().get("CompanyDisplayName");
        if (companyDisplayName == null) {
            companyDisplayName = "";
        }
        if ((year = (String)this.getUIContext().get("Year")) == null || year.equals("")) {
            year = null;
        }
        if ((period = (String)this.getUIContext().get("Period")) == null || period.equals("")) {
            period = null;
        }
        if ((parentUI = this.getUIContext().get("ParentUI")) != null) {
            if (parentUI instanceof GroupRptProcessUI) {
                this.isBuildByParentGroupRptProcessUI = true;
                this.parentGroupRptProcessUI = (GroupRptProcessUI)parentUI;
            } else {
                this.isBuildByParentGroupRptProcessUI = false;
            }
        }
        this.rptSourceType = (Integer)this.getUIContext().get("RptSourceType");
        this.txtCompany.setText(companyDisplayName);
        if (year != null && period != null) {
            this.txtYear.setText(year);
            this.txtPeriod.setText(period);
        }
        this.refreshTable();
        this.setAllRowSelected(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.selectAllKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.discardAllKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.freshKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    @Override
    protected void selectAllKDWorkButton_actionPerformed(ActionEvent e) throws Exception {
        super.selectAllKDWorkButton_actionPerformed(e);
        this.setAllRowSelected(true);
    }

    @Override
    protected void discardAllKDWorkButton_actionPerformed(ActionEvent e) throws Exception {
        super.discardAllKDWorkButton_actionPerformed(e);
        this.setAllRowSelected(false);
    }

    @Override
    protected void freshKDWorkButton_actionPerformed(ActionEvent e) throws Exception {
        super.freshKDWorkButton_actionPerformed(e);
        this.discardAllKDWorkButton_actionPerformed(e);
    }

    @Override
    protected void generateNextYearInitDataKDWorkButton_actionPerformed(ActionEvent e) throws Exception {
        super.generateNextYearInitDataKDWorkButton_actionPerformed(e);
        if (this.reportIDList != null && this.reportIDList.size() > 0) {
            ArrayList<HashMap> selectedRptItemList = new ArrayList<HashMap>();
            HashMap itemDataYearInitHashMap = null;
            int rowCount = this.rptItemKDTable.getRowCount();
            IRow tableRow = null;
            Object userObject = null;
            ArrayList valueList = null;
            HashMap valueMap = null;
            HashMap orgUnitMap = new HashMap();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                tableRow = this.rptItemKDTable.getRow(rowIndex);
                if (!((Boolean)tableRow.getCell(COL_SELECTED).getValue()).booleanValue() || (userObject = tableRow.getCell(COL_RPTITEM_NUMBER).getUserObject()) == null || !(userObject instanceof ArrayList)) continue;
                valueList = (ArrayList)userObject;
                int valueMapCount = valueList.size();
                for (int valueMapIndex = 0; valueMapIndex < valueMapCount; ++valueMapIndex) {
                    valueMap = (HashMap)valueList.get(valueMapIndex);
                    itemDataYearInitHashMap = this.getItemDataYearInitHashMap(valueMap, tableRow);
                    selectedRptItemList.add(itemDataYearInitHashMap);
                }
            }
            if (selectedRptItemList.size() <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"GenerateNextYearInitData_Dialog_SelectRptItem"));
                return;
            }
            String strPeriod = (String)this.getUIContext().get("Period");
            Integer period = new Integer(strPeriod);
            String res = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"confirmTransfer");
            String msg = MessageFormat.format(res, period);
            int confirm2 = MsgBox.showConfirm2((Component)((Object)this), (String)msg);
            if (confirm2 == 2) {
                return;
            }
            boolean isOk = MaintainYearInitDataFacadeFactory.getRemoteInstance().updateItemDataYearInit(selectedRptItemList);
            if (isOk) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"GenerateNextYearInitData_Dialog_ConverSuccess"));
            }
        }
    }

    private HashMap getItemDataYearInitHashMap(HashMap valueMap, IRow tableRow) throws BOSException {
        boolean isCommitRpt;
        HashMap<String, Object> itemDataYearInitHashMap = new HashMap<String, Object>();
        boolean bl = isCommitRpt = this.rptSourceType == 7 || this.rptSourceType == 1;
        if (isCommitRpt) {
            if (CSLContextHelper.getCSLContext() == null || CSLContextHelper.getCSLContext().getCurOrgBound() == null) {
                itemDataYearInitHashMap.put("DataCollect", valueMap.get("DataCollect"));
            } else {
                itemDataYearInitHashMap.put("DataCollect", CSLContextHelper.getCSLContext().getCurDataCollect());
            }
            itemDataYearInitHashMap.put("OrgTreeID", null);
            itemDataYearInitHashMap.put("OrgTreeNumber", null);
        } else {
            itemDataYearInitHashMap.put("OrgTreeID", valueMap.get("OrgTreeID"));
            itemDataYearInitHashMap.put("OrgTreeNumber", valueMap.get("OrgTreeNumber"));
        }
        itemDataYearInitHashMap.put("OrgUnitNumber", valueMap.get("OrgUnitNumber"));
        itemDataYearInitHashMap.put("OrgUnitID", valueMap.get("OrgUnitID"));
        itemDataYearInitHashMap.put("Year", new Integer((Integer)valueMap.get("Year") + 1));
        itemDataYearInitHashMap.put("RptSourceType", valueMap.get("RptSourceType"));
        itemDataYearInitHashMap.put("Period", new Integer((Integer)valueMap.get("Period")));
        itemDataYearInitHashMap.put("RptItemID", valueMap.get("RptItemID"));
        itemDataYearInitHashMap.put("CurrencyID", valueMap.get("CurrencyID"));
        itemDataYearInitHashMap.put("srcCurrencyId", valueMap.get("srcCurrencyId"));
        itemDataYearInitHashMap.put("DataElement", valueMap.get("DataElement"));
        itemDataYearInitHashMap.put("ValueType", valueMap.get("ValueType"));
        itemDataYearInitHashMap.put("Debit", tableRow.getCell(COL_DEBIT).getValue());
        itemDataYearInitHashMap.put("Credit", tableRow.getCell(COL_CREDIT).getValue());
        itemDataYearInitHashMap.put("CurrentUserID", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        itemDataYearInitHashMap.put("ControlUnitID", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        itemDataYearInitHashMap.put("MergeType", this.isManageMerge() ? 1 : 0);
        return itemDataYearInitHashMap;
    }

    private void getnextYearOrgTree(Object orgTreeID, Integer nextYear) {
        String oldTreeId = (String)orgTreeID;
        List<String> list = this.nextYearOrgUnitMap.get(oldTreeId);
        if (list == null) {
            StringBuilder stringBuilder = new StringBuilder();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    private void setAllRowSelected(boolean selected) {
        int rowCount = this.rptItemKDTable.getRowCount();
        IRow currentRow = null;
        for (int i = 0; i < rowCount; ++i) {
            currentRow = this.rptItemKDTable.getRow(i);
            if (currentRow == null) continue;
            currentRow.getCell(COL_SELECTED).setValue((Object)new Boolean(selected));
        }
    }

    private void refreshTable() throws Exception {
        if (this.isBuildByParentGroupRptProcessUI) {
            this.buildTableByParentGroupRptProcessUI();
        } else {
            this.buildTableByReportIDList();
        }
        this.setAllRowSelected(false);
    }

    private void setTableStatus() {
        this.rptItemKDTable.checkParsed();
        this.rptItemKDTable.getColumn(COL_SELECTED).getStyleAttributes().setLocked(false);
        this.rptItemKDTable.getColumn(COL_RPTITEM_NUMBER).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_RPTITEM_NAME).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_SRCCURRENCY).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_CURRENCY).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_YEAR).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_CREDIT).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_DEBIT).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_DATA_ELEMENT).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_VALUE_TYPE).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_ORGTREE).getStyleAttributes().setLocked(true);
        if (this.rptSourceType == 1) {
            this.rptItemKDTable.getColumn(COL_ORGTREE).getStyleAttributes().setHided(true);
        }
    }

    private void buildTableByParentGroupRptProcessUI() throws Exception {
        this.setTableStatus();
        if (this.reportIDList != null && this.reportIDList.size() == 1 && this.parentGroupRptProcessUI != null) {
            String reportID = (String)this.reportIDList.get(0);
            if (reportID == null || reportID.equals("")) {
                return;
            }
            List valueList = MaintainYearInitDataFacadeFactory.getRemoteInstance().getRptItemInfoByReportID(reportID, 4);
            if (valueList != null) {
                this.rptItemKDTable.setRefresh(false);
                this.rptItemKDTable.removeRows();
                Iterator valueIt = valueList.iterator();
                HashMap valueMap = null;
                BigDecimal value = null;
                Book book = this.parentGroupRptProcessUI.getBook();
                Map<String, BigDecimal> reportValue = this.getReportSetToTable(book);
                if (reportValue == null || reportValue.size() == 0) {
                    return;
                }
                while (valueIt.hasNext()) {
                    value = null;
                    valueMap = (HashMap)valueIt.next();
                    Sheet sheet = this.parentGroupRptProcessUI.getBook().getSheetByID((String)valueMap.get("RptItemSheetID"));
                    if (sheet == null) continue;
                    String key = (String)valueMap.get("RptItemNumber") + valueMap.get("ValueType");
                    value = reportValue.get(key);
                    if ((Integer)valueMap.get("RptItemDC") == 1) {
                        this.buildTableRow(valueMap, value, null);
                    }
                    if ((Integer)valueMap.get("RptItemDC") != 0) continue;
                    this.buildTableRow(valueMap, null, value);
                }
                this.rptItemKDTable.setRefresh(true);
                this.rptItemKDTable.repaint();
            }
        }
    }

    private Map<String, BigDecimal> getReportSetToTable(Book book) {
        HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
        Sheet sheet = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            BookProperties bookProperties;
            ReportVariables reVariables;
            sheet = book.getSheet(s);
            if (sheet == null || (reVariables = (bookProperties = BookProperties.loadFromBook((Book)book)).getVariables()).getIntValue("SheetClass", sheet.getSheetName(), 1) != 1) continue;
            int maxRowIndex = sheet.getMaxRowIndex() + 1;
            int maxColIndex = sheet.getMaxColIndex() + 1;
            Cell cell = null;
            ItemFormula rptF = null;
            Object valueObject = null;
            BigDecimal value = null;
            for (int i = 0; i < maxRowIndex; ++i) {
                for (int j = 0; j < maxColIndex; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (cell == null || (rptF = (ItemFormula)cell.getUserObjectValue("ITEM")) == null || !"ENDBALANCE".equalsIgnoreCase(rptF.getDataElementNumber()) || cell.getValue() == null) continue;
                    valueObject = cell.getValue().getValue();
                    if (valueObject instanceof BigDecimal) {
                        value = (BigDecimal)valueObject;
                    } else if (valueObject instanceof String) {
                        if (StringUtils.isEmpty((String)((String)valueObject))) {
                            value = null;
                        } else {
                            try {
                                value = new BigDecimal(((String)valueObject).trim());
                            }
                            catch (NumberFormatException e) {
                                value = null;
                            }
                        }
                    } else {
                        value = null;
                    }
                    valueMap.put(rptF.getItemNumber() + rptF.getValueType(), value);
                }
            }
        }
        return valueMap;
    }

    private void buildTableByReportIDList() throws Exception {
        this.setTableStatus();
        if (this.reportIDList != null) {
            List valueList = MaintainYearInitDataFacadeFactory.getRemoteInstance().getRptItemInfoByReportIDList(this.reportIDList, 4);
            if (valueList == null) {
                return;
            }
            HashMap<String, Book> kdfMap = new HashMap<String, Book>();
            HashMap<String, Map<String, BigDecimal>> reportDataMap = new HashMap<String, Map<String, BigDecimal>>();
            CslReportInfo info = null;
            Book kdf = null;
            Iterator reportIDIt = this.reportIDList.iterator();
            Book book = null;
            while (reportIDIt.hasNext()) {
                String reportID = (String)reportIDIt.next();
                info = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectUuidPK(reportID));
                book = info.getBook();
                kdfMap.put(reportID, book);
                reportDataMap.put(reportID, this.getReportSetToTable(book));
            }
            reportIDIt = null;
            this.rptItemKDTable.setRefresh(false);
            this.rptItemKDTable.removeRows();
            Iterator valueIt = valueList.iterator();
            HashMap valueMap = null;
            BigDecimal value = null;
            Map oneReportValue = null;
            while (valueIt.hasNext()) {
                Sheet sheetByID;
                value = null;
                valueMap = (HashMap)valueIt.next();
                kdf = (Book)kdfMap.get(valueMap.get("ReportID"));
                oneReportValue = (Map)reportDataMap.get(valueMap.get("ReportID"));
                if (oneReportValue == null || oneReportValue.size() == 0 || (sheetByID = kdf.getSheetByID((String)valueMap.get("RptItemSheetID"))) == null) continue;
                String key = (String)valueMap.get("RptItemNumber") + valueMap.get("ValueType");
                value = (BigDecimal)oneReportValue.get(key);
                if ((Integer)valueMap.get("RptItemDC") == 1) {
                    this.buildTableRow(valueMap, value, null);
                }
                if ((Integer)valueMap.get("RptItemDC") != 0) continue;
                this.buildTableRow(valueMap, null, value);
            }
            this.rptItemKDTable.setRefresh(true);
            this.rptItemKDTable.repaint();
        }
    }

    private void buildTableRow(HashMap valueMap, BigDecimal debitValue, BigDecimal creditValue) throws Exception {
        String currentRptItemNumber = (String)valueMap.get("RptItemNumber");
        if (currentRptItemNumber == null || currentRptItemNumber.equals("")) {
            return;
        }
        int rowCount = this.rptItemKDTable.getRowCount();
        IRow row = null;
        ArrayList<HashMap> valueList = null;
        int valueType = (Integer)valueMap.get("ValueType");
        for (int i = 0; i < rowCount; ++i) {
            row = this.rptItemKDTable.getRow(i);
            if (!currentRptItemNumber.equals(row.getCell(COL_RPTITEM_NUMBER).getValue()) || !ValueTypeEnum.getEnum(valueType).getAlias().equals(row.getCell(COL_VALUE_TYPE).getValue())) continue;
            String tempStr = (String)row.getCell(COL_ORGTREE).getValue();
            if (this.rptSourceType == 7) {
                row.getCell(COL_ORGTREE).setValue((Object)(tempStr + "/" + valueMap.get("OrgTreeName")));
            }
            valueList = (ArrayList<HashMap>)row.getCell(COL_RPTITEM_NUMBER).getUserObject();
            valueList.add(valueMap);
            return;
        }
        row = this.rptItemKDTable.addRow();
        row.getCell(COL_SELECTED).setValue((Object)new Boolean(false));
        row.getCell(COL_RPTITEM_NUMBER).setValue(valueMap.get("RptItemNumber"));
        row.getCell(COL_RPTITEM_NAME).setValue(valueMap.get("RptItemName"));
        row.getCell(COL_SRCCURRENCY).setValue(valueMap.get("srcCurrencyName"));
        row.getCell(COL_CURRENCY).setValue(valueMap.get("CurrencyName"));
        row.getCell(COL_YEAR).setValue(valueMap.get("Year"));
        row.getCell(COL_PERIOD).setValue(valueMap.get("Period"));
        row.getCell(COL_CREDIT).setValue((Object)creditValue);
        row.getCell(COL_DEBIT).setValue((Object)debitValue);
        row.getCell(COL_DATA_ELEMENT).setValue((Object)DataElementProvider.getDataElementName((Integer)valueMap.get("DataElement")));
        row.getCell(COL_VALUE_TYPE).setValue((Object)ValueTypeEnum.getEnum((Integer)valueMap.get("ValueType")).getAlias());
        if (this.rptSourceType == 1) {
            if (CSLContextHelper.getCSLContext() == null || CSLContextHelper.getCSLContext().getCurOrgBound() == null) {
                row.getCell(COL_ORGTREE).setValue(valueMap.get("OrgTreeName"));
            } else {
                row.getCell(COL_ORGTREE).setValue((Object)CSLContextHelper.getCSLContext().getCurOrgBound().getName());
            }
        }
        if (this.rptSourceType == 7 || this.rptSourceType == 34) {
            row.getCell(COL_ORGTREE).setValue(valueMap.get("OrgTreeName"));
        }
        valueList = new ArrayList<HashMap>();
        valueList.add(valueMap);
        row.getCell(COL_RPTITEM_NUMBER).setUserObject(valueList);
    }

    protected boolean isManageMerge() {
        return false;
    }
}

