/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimRelaOrgTree;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RecordTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractImportAdjustForBudgetUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class ImportAdjustForBudgetUI
extends AbstractImportAdjustForBudgetUI
implements ICSLContextUI {
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private OrgTreeInfo orgTreeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    private Boolean select = true;
    private Boolean unSelect = false;
    IElimRelaOrgTree iElimRela = ElimRelaOrgTreeFactory.getRemoteInstance();
    private ArrayList selectedImportedIdList = new ArrayList();
    private Map importedAdjustRela = new HashMap();
    private HashMap msgMap = new HashMap();
    private List auditedRecord = new ArrayList();

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNo.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnRefreshValue.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.orgTreeInfo = this.ctx.getCurOrgBound();
            this.year = this.ctx.getCurRptYear();
            this.period = this.ctx.getCurRptPeriod();
            this.orgUnitInfo = this.ctx.getCurOrgGroup();
            this.periodType = this.ctx.getCurRptPeriodType();
        } else {
            SysUtil.abort();
        }
        this.initOrgTree();
        this.initYearAndPeriod();
    }

    private void initOrgTree() throws BOSException {
        String oql = "select id, number, name, basic where type = 8 and status = 1 and id <> '" + this.orgTreeInfo.getId().toString() + "' order by number";
        OrgTreeCollection col = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(oql);
        int selected = 0;
        for (int i = 0; i < col.size(); ++i) {
            OrgTreeInfo tree = col.get(i);
            if (tree.isBasic()) {
                selected = i;
            }
            this.cmbOrgTree.addItem((Object)tree);
        }
        this.cmbOrgTree.setSelectedIndex(selected);
    }

    private void initYearAndPeriod() {
        int max;
        SpinnerNumberModel yearModel = new SpinnerNumberModel(this.year, 1, 4000, 1);
        this.spiStartYear.setModel((SpinnerModel)yearModel);
        yearModel = new SpinnerNumberModel(this.year, 1, 4000, 1);
        this.spiEndYear.setModel((SpinnerModel)yearModel);
        switch (this.periodType.getValue()) {
            case 1: {
                max = 366;
                break;
            }
            case 2: {
                max = 52;
                break;
            }
            case 3: {
                max = "true".equalsIgnoreCase(String.valueOf(CslRptUtil.isSupport13Period(null))) ? 13 : 12;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 6: {
                max = 1;
                break;
            }
            default: {
                max = 12;
            }
        }
        SpinnerNumberModel periodModel = new SpinnerNumberModel(this.period, 1, max, 1);
        this.spiStartPeriod.setModel((SpinnerModel)periodModel);
        periodModel = new SpinnerNumberModel(this.period, 1, max, 1);
        this.spiEndPeriod.setModel((SpinnerModel)periodModel);
    }

    private void addAdjustRecordToTable(KDTable table) {
        table.removeRows();
        try {
            OrgTreeInfo tree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            IAdjust iAdjust = AdjustFactory.getRemoteInstance();
            AdjustCollection list = iAdjust.getAdjustInOtherTree(tree.getId().toString(), this.orgTreeInfo.getId().toString(), this.orgUnitInfo.getId().toString(), this.spiStartYear.getIntegerVlaue(), this.spiStartPeriod.getIntegerVlaue(), this.spiEndYear.getIntegerVlaue(), this.spiEndPeriod.getIntegerVlaue(), this.periodType.getValue());
            AdjustInfo info = null;
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    info = list.get(i);
                    IRow r = table.addRow();
                    r.getCell(0).setValue((Object)info.getId().toString());
                    r.getCell(1).setValue((Object)false);
                    r.getCell(2).setValue((Object)info.getOrgUnit().getName());
                    r.getCell(3).setValue((Object)info.getAdjustMode().getName());
                    r.getCell(4).setValue((Object)info.getNumber());
                    r.getCell(5).setValue((Object)(info.getYear() + ""));
                    r.getCell(6).setValue((Object)(info.getPeriod() + ""));
                    r.getCell("isFixed").setValue((Object)info.getIsFixed());
                    if (info.getSourceCurrency() != null) {
                        r.getCell("sourceCurrency").setValue((Object)info.getSourceCurrency().getName());
                    }
                    if (info.getCurrency() != null) {
                        r.getCell("currency").setValue((Object)info.getCurrency().getName());
                    }
                    this.isImportBefore(r);
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    @Override
    public void okAction_actionPerformed(ActionEvent e) throws Exception {
        super.okAction_actionPerformed(e);
        boolean hasCodeRule = false;
        String orgID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        AdjustInfo caller = new AdjustInfo();
        ArrayList selectIdList = this.getSelectedIDs();
        IAdjust iAdjust = AdjustFactory.getRemoteInstance();
        boolean isCover = this.showMsg(selectIdList);
        if (isCover) {
            for (int i = 0; i < this.selectedImportedIdList.size(); ++i) {
                String oldId = (String)this.selectedImportedIdList.get(i);
                String newId = (String)this.importedAdjustRela.get(oldId);
                try {
                    iAdjust.delete((IObjectPK)new ObjectStringPK(newId));
                    continue;
                }
                catch (Exception ex) {
                    selectIdList.remove(oldId);
                }
            }
        } else {
            this.destroyWindow();
            return;
        }
        AdjustInfo info = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        hasCodeRule = iCodingRuleManager.isExist((IObjectValue)caller, orgID);
        AdjustEntryCollection collection = null;
        String treeId = this.orgTreeInfo.getId().toString();
        Date adjustdate = RPTDate13Util.getPeriodLastDate(this.year, this.period, this.periodType);
        if (selectIdList != null && selectIdList.size() > 0) {
            for (int i = 0; i < selectIdList.size(); ++i) {
                String tempStr = null;
                tempStr = selectIdList.get(i).toString();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("entries.*"));
                selector.add(new SelectorItemInfo("entries.item.id"));
                selector.add(new SelectorItemInfo("entries.item.number"));
                selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
                selector.add(new SelectorItemInfo("entries.company.number"));
                info = iAdjust.getAdjustInfo((IObjectPK)new ObjectUuidPK(tempStr), selector);
                info.setId(null);
                info.setAuditDate(null);
                info.setAuditor(null);
                info.setOrgBound(this.orgTreeInfo);
                info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                info.setYear(this.year);
                info.setPeriod(this.period);
                info.setDate(adjustdate);
                if (hasCodeRule) {
                    info.setNumber(null);
                    info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, orgID));
                } else {
                    info.setNumber(iAdjust.getAutoNumber(treeId, this.year, this.period, this.periodType.getValue()));
                }
                collection = info.getEntries();
                if (collection != null && collection.size() > 0) {
                    for (int j = 0; j < collection.size(); ++j) {
                        collection.get(j).setId(null);
                        collection.get(j).setAdjust(null);
                    }
                }
                IObjectPK pk = iAdjust.submit((CoreBaseInfo)info);
                this.addNewElimRelaOrgTree(tempStr, pk.toString());
            }
        }
        this.destroyWindow();
    }

    private void addNewElimRelaOrgTree(String oldId, String newId) throws BOSException, EASBizException {
        ElimRelaOrgTreeInfo info = new ElimRelaOrgTreeInfo();
        info.setElimId(oldId);
        info.setOrgTreeId(this.orgTreeInfo.getId().toString());
        info.setCurrentElimId(newId);
        info.setRecordType(RecordTypeEnum.BUDGET_ADJUST);
        this.iElimRela.addnew(info);
    }

    private ArrayList getSelectedIDs() {
        this.selectedImportedIdList.clear();
        ArrayList<String> list = new ArrayList<String>();
        int rowCount = 0;
        for (int i = 0; i < this.tblAdjustRecord.getExpandedRowCount(); ++i) {
            IRow row = this.tblAdjustRecord.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(1).getValue())) continue;
            ++rowCount;
            String id = (String)row.getCell(0).getValue();
            if (this.auditedRecord.contains(id)) continue;
            if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport").equals(row.getCell("isImportBefore").getValue().toString()) && !this.selectedImportedIdList.contains(id)) {
                this.selectedImportedIdList.add(id);
            }
            if (list.contains(id)) continue;
            list.add(id);
        }
        if (rowCount == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return list;
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    @Override
    public void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblAdjustRecord.getRowCount(); ++i) {
            this.tblAdjustRecord.getRow(i).getCell(1).setValue((Object)this.select);
        }
    }

    @Override
    public void btnSelectNo_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblAdjustRecord.getRowCount(); ++i) {
            this.tblAdjustRecord.getRow(i).getCell(1).setValue((Object)this.unSelect);
        }
    }

    public boolean destroyWindow() {
        CSLContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    private void isImportBefore(IRow row) {
        String id = row.getCell("id").getValue().toString();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("elimId", id);
        param.put("orgTreeId", this.orgTreeInfo.getId().toString());
        param.put("recordType", (Object)RecordTypeEnum.BUDGET_ADJUST);
        param.put("year", new Integer(this.year));
        param.put("period", new Integer(this.period));
        boolean exists = true;
        try {
            Boolean isAudited;
            param.put("dataCollectNumber", this.ctx.getCurDataCollect().getNumber());
            Map resultMap = this.iElimRela.existsRecord(param);
            if (resultMap.containsKey("msg")) {
                this.msgMap.put(id, resultMap.get("msg"));
            }
            if ((isAudited = (Boolean)resultMap.get("isAudited")) != null && isAudited.booleanValue()) {
                this.auditedRecord.add(id);
            }
            if (exists = resultMap.get("isImportBefore") != null && (Boolean)resultMap.get("isImportBefore") != false) {
                row.getCell("isImportBefore").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport"));
                String importedId = (String)resultMap.get("importedId");
                this.importedAdjustRela.put(id, importedId);
            } else {
                row.getCell("isImportBefore").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport"));
            }
        }
        catch (EASBizException e) {
            super.handleControlException();
        }
        catch (BOSException e) {
            super.handleControlException();
        }
    }

    private boolean showMsg(ArrayList idList) {
        StringBuffer s = new StringBuffer();
        if (this.msgMap.size() > 0 && idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                if (!this.msgMap.containsKey(idList.get(i).toString())) continue;
                s.append(this.msgMap.get(idList.get(i).toString()));
            }
        }
        if (s.toString().length() > 0) {
            int select = MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"531_ImportAdjustForBudgetUI"), (String)s.toString());
            return 0 == select;
        }
        return true;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.selectedImportedIdList.clear();
        this.importedAdjustRela.clear();
        this.tblAdjustRecord.checkParsed();
        this.addAdjustRecordToTable(this.tblAdjustRecord);
    }
}

