/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractImportAdjustRecordUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AdjustListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class ImportAdjustRecordUI
extends AbstractImportAdjustRecordUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportAdjustRecordUI.class);
    private OrgTreeInfo orgTreeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    private Boolean select = true;
    private Boolean unSelect = false;
    private boolean isSupportOtherDS = CSLParamUtil.isSupportOtherDS(null);
    private boolean first = true;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNo.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    public void onLoad() throws Exception {
        this.initCSLContext();
        super.onLoad();
        this.initAdjustMode();
        this.orgTreeInfo = this.getCSLContext().getCurOrgBound();
        this.year = this.getCSLContext().getCurRptYear();
        this.period = this.getCSLContext().getCurRptPeriod();
        this.orgUnitInfo = this.getCSLContext().getCurOrgGroup();
        this.periodType = this.getCSLContext().getCurRptPeriodType();
        this.tblAdjustRecord.checkParsed();
        this.addAdjustRecordToTable(this.tblAdjustRecord);
        this.tblAdjustRecord.getColumn("dcName").getStyleAttributes().setHided(!this.isSupportOtherDS);
        this.first = false;
        this.tblAdjustRecord.getStyleAttributes().setLocked(true);
        this.tblAdjustRecord.getColumn("select").getStyleAttributes().setLocked(false);
    }

    private void initAdjustMode() throws Exception {
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.cmbAdjustMode.addItem((Object)this.selectAll);
        this.cmbAdjustMode.setSelectedIndex(0);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        CslGradeManageUtil.filterAdjustModeGradeManage(null, (EntityViewInfo)viewInfo, null);
        AdjustModeCollection adjustModeCollection = AdjustModeFactory.getRemoteInstance().getAdjustModeCollection(viewInfo);
        if (adjustModeCollection != null) {
            for (int i = 0; i < adjustModeCollection.size(); ++i) {
                this.cmbAdjustMode.addItem((Object)adjustModeCollection.get(i));
            }
        }
    }

    private void addAdjustRecordToTable(KDTable table) {
        table.removeRows();
        try {
            boolean isForBudegt = false;
            if (this.orgTreeInfo != null) {
                isForBudegt = this.orgTreeInfo.isIsForBudget();
            }
            IAdjust iAdjust = AdjustFactory.getRemoteInstance();
            String adjustModeId = null;
            if (!this.selectAll.equals(this.cmbAdjustMode.getSelectedItem())) {
                adjustModeId = "".equals(this.cmbAdjustMode.getSelectedItem()) ? "NULL" : "'" + ((AdjustModeInfo)this.cmbAdjustMode.getSelectedItem()).getId().toString() + "'";
            }
            boolean isFromAdjustWorkTable = this.getUIContext().get("AdjustWorkTableImportRecord") != null;
            boolean isFromAdjustCompany = this.getUIContext().get("AdjustCompanyImportRecord") != null;
            AdjustCollection list = (AdjustCollection)iAdjust.getAdjustRecordByBasicBoundNew(this.period, this.year, this.periodType.getValue(), this.orgTreeInfo.getId().toString(), this.orgUnitInfo.getId().toString(), isForBudegt, adjustModeId, isFromAdjustWorkTable, isFromAdjustCompany);
            AdjustInfo info = null;
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    info = list.get(i);
                    if (info.getEntries() == null || info.getEntries().size() <= 0) continue;
                    for (int j = 0; j < info.getEntries().size(); ++j) {
                        IRow r = table.addRow();
                        r.getCell("id").setValue((Object)info.getId().toString());
                        r.getCell("select").setValue((Object)false);
                        r.getCell("number").setValue((Object)info.getNumber());
                        r.getCell("summary").setValue((Object)info.getEntries().get(j).getSummary());
                        if (info.getAdjustMode() != null) {
                            r.getCell("adjustMode").setValue((Object)info.getAdjustMode().getName());
                        } else {
                            r.getCell("adjustMode").setValue((Object)"");
                        }
                        r.getCell("company.name").setValue((Object)info.getOrgUnit().getName());
                        r.getCell("item.number").setValue((Object)info.getEntries().get(j).getItem().getNumber());
                        r.getCell("item.name").setValue((Object)info.getEntries().get(j).getItem().getName());
                        r.getCell("dataElement").setValue((Object)DataElementProvider.getDataElementInfo(info.getEntries().get(j).getDataElement()));
                        r.getCell("debit").setValue((Object)info.getEntries().get(j).getDebit());
                        r.getCell("credit").setValue((Object)info.getEntries().get(j).getCredit());
                        r.getCell("isFixed").setValue((Object)info.getIsFixed());
                        r.getCell("customNumber").setValue((Object)info.getCustomNumber());
                        r.getCell("dcName").setValue((Object)info.getDataCollect().getName());
                        if (info.getSourceCurrency() != null) {
                            r.getCell("sourceCurrency").setValue((Object)info.getSourceCurrency().getName());
                        }
                        if (info.getCurrency() != null) {
                            r.getCell("currency").setValue((Object)info.getCurrency().getName());
                            r.getCell("currency.precision").setValue((Object)new Integer(info.getCurrency().getPrecision()));
                        }
                        if (info.getCustomNumber() == null) continue;
                        r.getCell("customNumber").setValue((Object)info.getCustomNumber());
                    }
                }
            }
            if (table.getRowCount() != 0) {
                this.setPrecision(table);
                this.groupTableRow(table);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    private void setPrecision(KDTable table) {
        int iCurrencyPrecision = 0;
        BigDecimal bgAmount = null;
        int rowCount = table.getExpandedRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = table.getRow(i);
            iCurrencyPrecision = (Integer)row.getCell("currency.precision").getValue();
            if (iCurrencyPrecision < 0) {
                iCurrencyPrecision = 2;
            }
            BigDecimal bigDecimal = bgAmount = row.getCell("debit") == null ? BigDecimal.valueOf(0L) : (BigDecimal)row.getCell("debit").getValue();
            if (bgAmount == null || bgAmount.compareTo(BigDecimal.valueOf(0L)) == 0) {
                row.getCell("debit").setValue(null);
            } else {
                bgAmount = bgAmount.setScale(iCurrencyPrecision, 4);
                row.getCell("debit").setValue((Object)bgAmount);
            }
            BigDecimal bigDecimal2 = bgAmount = row.getCell("credit") == null ? BigDecimal.valueOf(0L) : (BigDecimal)row.getCell("credit").getValue();
            if (bgAmount == null || bgAmount.compareTo(BigDecimal.valueOf(0L)) == 0) {
                row.getCell("credit").setValue(null);
            } else {
                bgAmount = bgAmount.setScale(iCurrencyPrecision, 4);
                row.getCell("credit").setValue((Object)bgAmount);
            }
            ICell cell = table.getCell(i, "select");
            if (cell == null) continue;
            cell.getStyleAttributes().setLocked(false);
            cell.setValue((Object)Boolean.FALSE);
        }
    }

    private void groupTableRow(KDTable table) {
        int size = table.getRowCount();
        int top = 0;
        int bottom = 0;
        KDTMergeManager mm = table.getMergeManager();
        String previousdId = "";
        if (table.getRowCount() > 0) {
            previousdId = table.getRow(0).getCell("number").getValue().toString();
        }
        int mergeMode = 4;
        for (int i = 0; i < size; ++i) {
            IRow row = table.getRow(i);
            String number = (String)row.getCell("number").getValue();
            if (number.equalsIgnoreCase(previousdId)) {
                ++bottom;
                if (i != size - 1) continue;
                mm.mergeBlock(top, 0, bottom - 1, 0, mergeMode);
                mm.mergeBlock(top, 1, bottom - 1, 1, mergeMode);
                mm.mergeBlock(top, 2, bottom - 1, 2, mergeMode);
                mm.mergeBlock(top, 3, bottom - 1, 3, mergeMode);
                mm.mergeBlock(top, 5, bottom - 1, 5, mergeMode);
                continue;
            }
            mm.mergeBlock(top, 0, bottom - 1, 0, mergeMode);
            mm.mergeBlock(top, 1, bottom - 1, 1, mergeMode);
            mm.mergeBlock(top, 2, bottom - 1, 2, mergeMode);
            mm.mergeBlock(top, 3, bottom - 1, 3, mergeMode);
            mm.mergeBlock(top, 5, bottom - 1, 5, mergeMode);
            previousdId = number;
            top = bottom++;
            if (i != size - 1) continue;
            mm.mergeBlock(top, 0, bottom - 1, 0, mergeMode);
            mm.mergeBlock(top, 1, bottom - 1, 1, mergeMode);
            mm.mergeBlock(top, 2, bottom - 1, 2, mergeMode);
            mm.mergeBlock(top, 3, bottom - 1, 3, mergeMode);
            mm.mergeBlock(top, 5, bottom - 1, 5, mergeMode);
        }
    }

    @Override
    public void okAction_actionPerformed(ActionEvent e) throws Exception {
        super.okAction_actionPerformed(e);
        int count1 = this.tblAdjustRecord.getRowCount();
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<String, Boolean> selMap = new HashMap<String, Boolean>();
        boolean select = false;
        for (int i = 0; i < count1; ++i) {
            IRow curRow = this.tblAdjustRecord.getRow(i);
            String id = (String)curRow.getCell("id").getValue();
            if (!selMap.containsKey(id)) {
                boolean sel = (Boolean)curRow.getCell("select").getValue();
                selMap.put(id, sel);
                select = sel;
            } else {
                select = (Boolean)selMap.get(id);
            }
            if (!select || ids.contains(id)) continue;
            ids.add(id);
        }
        RptProperties rptProperties = new RptProperties();
        if (this.getUIContext().get("basic") != null && this.getUIContext().get("basic").equals("yes")) {
            rptProperties.setBoolean("isbasicimport", true);
        }
        rptProperties.setString("orgTreeID", this.getCSLContext().getCurOrgBound().getId().toString());
        rptProperties.setString("orgUnitId", this.getCSLContext().getCurOrgGroup().getId().toString());
        rptProperties.setInt("year", this.getCSLContext().getCurRptYear());
        rptProperties.setInt("period", this.getCSLContext().getCurRptPeriod());
        rptProperties.setInt("periodType", this.getCSLContext().getCurRptPeriodType().getValue());
        rptProperties.setObject("KEY_ORGTREE_INFO", this.getCSLContext().getCurOrgBound());
        rptProperties.setObject("KEY_ORGUNIT_INFO", this.getCSLContext().getCurOrgGroup());
        Map result = AdjustFactory.getRemoteInstance().doImportAdjustRecords(ids, rptProperties, this.getCSLContext().getCurDataCollect());
        if (result.get("message") != null) {
            String msg = String.valueOf(result.get("message"));
            this.showFailMessage(msg);
        }
        try {
            if (this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner") instanceof AdjustListUI) {
                ((AdjustListUI)this.getUIContext().get("Owner")).refresh(e);
            }
        }
        catch (Exception e1) {
            logger.error((Object)"okAction_actionPerformed", (Throwable)e1);
        }
        this.destroyWindow();
    }

    private void showFailMessage(String msg) {
        if (msg != null && msg.length() > 0) {
            try {
                UIContext uiCtx = new UIContext((Object)this);
                uiCtx.put((Object)"String", (Object)msg.toString());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                logger.error((Object)"showEditorPanelUI: ", (Throwable)e);
            }
        }
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.isFromCslMerge) {
            CSLContextHelper.update(o, this);
        }
    }

    @Override
    public void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblAdjustRecord.getRowCount(); ++i) {
            this.tblAdjustRecord.getRow(i).getCell(1).setValue((Object)this.select);
        }
    }

    @Override
    public void btnSelectNo_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblAdjustRecord.getRowCount(); ++i) {
            this.tblAdjustRecord.getRow(i).getCell(1).setValue((Object)this.unSelect);
        }
    }

    public boolean destroyWindow() {
        if (!this.isFromCslMerge) {
            CSLContextHelper.unRegistUIObject(this);
        }
        return super.destroyWindow();
    }

    @Override
    protected void cmbAdjustMode_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.first && e.getStateChange() == 1) {
            this.addAdjustRecordToTable(this.tblAdjustRecord);
        }
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

