/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInterCheckSumFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Dimension;

public class InterCheckSumFilterUI
extends AbstractInterCheckSumFilterUI {
    private boolean hasLoadInitData;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
        this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
        this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
        this.pp.setInt("year", this.ctx.getCurRptYear());
        this.pp.setInt("period", this.ctx.getCurRptPeriod());
        this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
    }

    private void fillDataToUI() throws EASBizException, BOSException {
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
        f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
        f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
        f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
        f7.setMultiSelect(false);
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
        this.prmtCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
        this.prmtCompany.setSelector((KDPromptSelector)f7);
        this.prmtCompany.setEditable(true);
        this.prmtCompany.setRequired(true);
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setDisplayFormat("$name$");
        this.cmbCurrency.removeAllItems();
        CurrencyCollection currencies = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        this.cmbCurrency.addItems(currencies.toArray());
        this.cmbCurrency.setSelectedIndex(0);
        if (this.pp.containsKey("currencyId")) {
            String currencyId = this.pp.getString("currencyId");
            for (int j = 1; j < this.cmbCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                this.cmbCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("theCompanyId")) {
            String companyId = this.pp.getString("theCompanyId");
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            this.prmtCompany.setData((Object)companyInfo);
        }
        if (this.pp.containsKey("showZeroDiff")) {
            this.chkShowZeroDiff.setSelected(this.pp.getBoolean("showZeroDiff"));
        } else {
            this.chkShowZeroDiff.setSelected(false);
        }
    }

    @Override
    public RptProperties getCustomCondition() {
        try {
            this.loadInitData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.cmbCurrency.getSelectedIndex() > 0) {
            CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
            this.pp.setString("currencyId", currency.getId().toString());
        } else {
            this.pp.setString("currencyId", "all");
        }
        CoreBaseInfo info = (CoreBaseInfo)this.prmtCompany.getData();
        if (info != null) {
            this.pp.setString("theCompanyId", info.getId().toString());
        } else {
            this.pp.remove("theCompanyId");
        }
        this.pp.setBoolean("showZeroDiff", new Boolean(this.chkShowZeroDiff.isSelected()));
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        try {
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    @Override
    public CustomerParams getCustomerParams() {
        if (this.pp != null && this.pp.containsKey("tableName")) {
            this.pp.remove("tableName");
        }
        return super.getCustomerParams();
    }

    @Override
    public Object getParam() {
        RptProperties condition = this.getCustomCondition();
        if (condition != null && condition.containsKey("tableName")) {
            condition.remove("tableName");
        }
        return condition;
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }

    public void clear() {
        this.prmtCompany.setValue(null);
        this.cmbCurrency.setSelectedIndex(0);
        this.chkShowZeroDiff.setSelected(false);
    }
}

